/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.reflect;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.BoundedReferenceType;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeFactory;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.TypeVariableReferenceType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.internal.tools.PointcutExpressionImpl;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.reflect.Java15AnnotationFinder;
import org.aspectj.weaver.reflect.ReflectionBasedReferenceTypeDelegate;
import org.aspectj.weaver.reflect.ReflectionBasedResolvedMemberImpl;
import org.aspectj.weaver.tools.PointcutParameter;
import org.aspectj.weaver.tools.PointcutParser;

public class Java15ReflectionBasedReferenceTypeDelegate
extends ReflectionBasedReferenceTypeDelegate {
    private AjType myType;
    private ResolvedType[] annotations;
    private ResolvedMember[] pointcuts;
    private ResolvedMember[] methods;
    private ResolvedMember[] fields;
    private TypeVariable[] typeVariables;
    private ResolvedType superclass;
    private ResolvedType[] superInterfaces;
    private String genericSignature = null;
    private Java15AnnotationFinder annotationFinder = new Java15AnnotationFinder();

    public void initialize(ReferenceType aType, Class aClass, World aWorld) {
        super.initialize(aType, aClass, aWorld);
        this.myType = AjTypeSystem.getAjType(aClass);
    }

    public ReferenceType buildGenericType() {
        return (ReferenceType)UnresolvedType.forGenericTypeVariables(this.getResolvedTypeX().getSignature(), this.getTypeVariables()).resolve(this.getWorld());
    }

    public AnnotationX[] getAnnotations() {
        throw new UnsupportedOperationException("getAnnotations on Java15ReflectionBasedReferenceTypeDelegate is not implemented yet");
    }

    public ResolvedType[] getAnnotationTypes() {
        if (this.annotations == null) {
            this.annotations = this.annotationFinder.getAnnotations(this.getBaseClass(), this.getWorld());
        }
        return this.annotations;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        ResolvedType[] myAnns = this.getAnnotationTypes();
        ResolvedType toLookFor = ofType.resolve(this.getWorld());
        for (int i = 0; i < myAnns.length; ++i) {
            if (myAnns[i] != toLookFor) continue;
            return true;
        }
        return false;
    }

    public ResolvedMember[] getDeclaredFields() {
        if (this.fields == null) {
            Field[] reflectFields = this.myType.getDeclaredFields();
            this.fields = new ResolvedMember[reflectFields.length];
            for (int i = 0; i < reflectFields.length; ++i) {
                this.fields[i] = this.createGenericFieldMember(reflectFields[i]);
            }
        }
        return this.fields;
    }

    public String getDeclaredGenericSignature() {
        if (this.genericSignature != null || this.isGeneric()) {
            // empty if block
        }
        return this.genericSignature;
    }

    public ResolvedType[] getDeclaredInterfaces() {
        if (this.superInterfaces == null) {
            Type[] genericInterfaces = this.getBaseClass().getGenericInterfaces();
            this.superInterfaces = this.fromTypes(genericInterfaces);
        }
        return this.superInterfaces;
    }

    public ResolvedType getSuperclass() {
        if (this.superclass == null) {
            this.superclass = this.fromType(this.getBaseClass().getGenericSuperclass());
        }
        return this.superclass;
    }

    public TypeVariable[] getTypeVariables() {
        if (this.typeVariables == null) {
            java.lang.reflect.TypeVariable<Class<T>>[] tVars = this.getBaseClass().getTypeParameters();
            this.typeVariables = new TypeVariable[tVars.length];
            for (int i = 0; i < tVars.length; ++i) {
                this.typeVariables[i] = ((TypeVariableReferenceType)this.fromType(tVars[i])).getTypeVariable();
            }
        }
        return this.typeVariables;
    }

    public ResolvedMember[] getDeclaredMethods() {
        if (this.methods == null) {
            int i;
            Method[] reflectMethods = this.myType.getDeclaredMethods();
            Constructor[] reflectCons = this.myType.getDeclaredConstructors();
            this.methods = new ResolvedMember[reflectMethods.length + reflectCons.length];
            for (i = 0; i < reflectMethods.length; ++i) {
                this.methods[i] = this.createGenericMethodMember(reflectMethods[i]);
            }
            for (i = 0; i < reflectCons.length; ++i) {
                this.methods[i + reflectMethods.length] = this.createGenericConstructorMember(reflectCons[i]);
            }
        }
        return this.methods;
    }

    private ResolvedMember createGenericMethodMember(Method forMethod) {
        ReflectionBasedResolvedMemberImpl ret = new ReflectionBasedResolvedMemberImpl(Member.METHOD, (UnresolvedType)this.getResolvedTypeX(), forMethod.getModifiers(), (UnresolvedType)this.fromType(forMethod.getGenericReturnType()), forMethod.getName(), (UnresolvedType[])this.fromTypes(forMethod.getGenericParameterTypes()), (UnresolvedType[])this.fromTypes(forMethod.getGenericExceptionTypes()), forMethod);
        return ret;
    }

    private ResolvedMember createGenericConstructorMember(Constructor forConstructor) {
        ReflectionBasedResolvedMemberImpl ret = new ReflectionBasedResolvedMemberImpl(Member.METHOD, (UnresolvedType)this.getResolvedTypeX(), forConstructor.getModifiers(), (UnresolvedType)this.getResolvedTypeX(), "init", (UnresolvedType[])this.fromTypes(forConstructor.getGenericParameterTypes()), (UnresolvedType[])this.fromTypes(forConstructor.getGenericExceptionTypes()), forConstructor);
        return ret;
    }

    private ResolvedMember createGenericFieldMember(Field forField) {
        return new ReflectionBasedResolvedMemberImpl(Member.FIELD, (UnresolvedType)this.getResolvedTypeX(), forField.getModifiers(), (UnresolvedType)this.fromType(forField.getGenericType()), forField.getName(), new UnresolvedType[0], forField);
    }

    public ResolvedMember[] getDeclaredPointcuts() {
        if (this.pointcuts == null) {
            org.aspectj.lang.reflect.Pointcut[] pcs = this.myType.getDeclaredPointcuts();
            this.pointcuts = new ResolvedMember[pcs.length];
            PointcutParser parser = new PointcutParser();
            for (int i = 0; i < pcs.length; ++i) {
                AjType<?>[] ptypes = pcs[i].getParameterTypes();
                String[] pnames = pcs[i].getParameterNames();
                if (pnames.length != ptypes.length) {
                    throw new IllegalStateException("Required parameter names not available when parsing pointcut " + pcs[i].getName() + " in type " + this.getResolvedTypeX().getName());
                }
                PointcutParameter[] parameters = new PointcutParameter[ptypes.length];
                for (int j = 0; j < parameters.length; ++j) {
                    parameters[j] = parser.createPointcutParameter(pnames[j], ptypes[j].getJavaClass());
                }
                String pcExpr = pcs[i].getPointcutExpression().toString();
                PointcutExpressionImpl pEx = (PointcutExpressionImpl)parser.parsePointcutExpression(pcExpr, this.getBaseClass(), parameters);
                Pointcut pc = pEx.getUnderlyingPointcut();
                UnresolvedType[] weaverPTypes = new UnresolvedType[ptypes.length];
                for (int j = 0; j < weaverPTypes.length; ++j) {
                    weaverPTypes[j] = UnresolvedType.forName(ptypes[j].getName());
                }
                this.pointcuts[i] = new ResolvedPointcutDefinition(this.getResolvedTypeX(), pcs[i].getModifiers(), pcs[i].getName(), weaverPTypes, pc);
            }
        }
        return this.pointcuts;
    }

    public boolean isAnnotation() {
        return this.getBaseClass().isAnnotation();
    }

    public boolean isAnnotationStyleAspect() {
        return this.getBaseClass().isAnnotationPresent(Aspect.class);
    }

    public boolean isAnnotationWithRuntimeRetention() {
        if (!this.isAnnotation()) {
            return false;
        }
        if (this.getBaseClass().isAnnotationPresent(Retention.class)) {
            Retention retention = this.getBaseClass().getAnnotation(Retention.class);
            RetentionPolicy policy = retention.value();
            return policy == RetentionPolicy.RUNTIME;
        }
        return false;
    }

    public boolean isAspect() {
        return this.myType.isAspect();
    }

    public boolean isEnum() {
        return this.getBaseClass().isEnum();
    }

    public boolean isGeneric() {
        return this.getBaseClass().getTypeParameters().length > 0;
    }

    private ResolvedType fromType(Type aType) {
        if (aType instanceof Class) {
            return this.getWorld().resolve(((Class)aType).getName());
        }
        if (aType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)aType;
            ResolvedType baseType = this.fromType(pt.getRawType());
            Type[] args = pt.getActualTypeArguments();
            UnresolvedType[] resolvedArgs = this.fromTypes(args);
            return TypeFactory.createParameterizedType(baseType, resolvedArgs, this.getWorld());
        }
        if (aType instanceof java.lang.reflect.TypeVariable) {
            java.lang.reflect.TypeVariable tv = (java.lang.reflect.TypeVariable)aType;
            Type[] bounds = tv.getBounds();
            ResolvedType[] resBounds = this.fromTypes(bounds);
            ResolvedType upperBound = resBounds[0];
            UnresolvedType[] additionalBounds = new ResolvedType[]{};
            if (resBounds.length > 1) {
                additionalBounds = new ResolvedType[resBounds.length - 1];
                System.arraycopy(resBounds, 1, additionalBounds, 0, additionalBounds.length);
            }
            TypeVariable rt_tv = new TypeVariable(tv.getName(), upperBound, additionalBounds);
            return new TypeVariableReferenceType(rt_tv, this.getWorld());
        }
        if (aType instanceof WildcardType) {
            WildcardType wildType = (WildcardType)aType;
            Type[] lowerBounds = wildType.getLowerBounds();
            Type[] upperBounds = wildType.getUpperBounds();
            ResolvedType bound = null;
            boolean isExtends = lowerBounds.length == 0;
            bound = isExtends ? this.fromType(upperBounds[0]) : this.fromType(lowerBounds[0]);
            return new BoundedReferenceType((ReferenceType)bound, isExtends, this.getWorld());
        }
        if (aType instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)aType;
            Type componentType = gt.getGenericComponentType();
            UnresolvedType.makeArray(this.fromType(componentType), 1);
        }
        return ResolvedType.MISSING;
    }

    private ResolvedType[] fromTypes(Type[] types) {
        ResolvedType[] ret = new ResolvedType[types.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.fromType(types[i]);
        }
        return ret;
    }

    public boolean isAnonymous() {
        return this.myClass.isAnonymousClass();
    }
}

