/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.Pointcut;

public class ResolvedPointcutDefinition
extends ResolvedMemberImpl {
    private Pointcut pointcut;
    public static final ResolvedPointcutDefinition DUMMY = new ResolvedPointcutDefinition(UnresolvedType.OBJECT, 0, "missing", UnresolvedType.NONE, Pointcut.makeMatchesNothing(Pointcut.RESOLVED));

    public ResolvedPointcutDefinition(UnresolvedType declaringType, int modifiers, String name, UnresolvedType[] parameterTypes, Pointcut pointcut) {
        this(declaringType, modifiers, name, parameterTypes, ResolvedType.VOID, pointcut);
    }

    public ResolvedPointcutDefinition(UnresolvedType declaringType, int modifiers, String name, UnresolvedType[] parameterTypes, UnresolvedType returnType, Pointcut pointcut) {
        super(Member.POINTCUT, declaringType, modifiers, returnType, name, parameterTypes);
        this.pointcut = pointcut;
        this.checkedExceptions = UnresolvedType.NONE;
    }

    public void write(DataOutputStream s) throws IOException {
        this.getDeclaringType().write(s);
        s.writeInt(this.getModifiers());
        s.writeUTF(this.getName());
        UnresolvedType.writeArray(this.getParameterTypes(), s);
        this.pointcut.write(s);
    }

    public static ResolvedPointcutDefinition read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        ResolvedPointcutDefinition rpd = new ResolvedPointcutDefinition(UnresolvedType.read(s), s.readInt(), s.readUTF(), UnresolvedType.readArray(s), Pointcut.read(s, context));
        rpd.setSourceContext(context);
        return rpd;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("pointcut ");
        buf.append(this.getDeclaringType() == null ? "<nullDeclaringType>" : this.getDeclaringType().getName());
        buf.append(".");
        buf.append(this.getName());
        buf.append("(");
        for (int i = 0; i < this.getParameterTypes().length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getParameterTypes()[i].toString());
        }
        buf.append(")");
        return buf.toString();
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public boolean isAjSynthetic() {
        return true;
    }

    public ResolvedMemberImpl parameterizedWith(UnresolvedType[] typeParameters, ResolvedType newDeclaringType, boolean isParameterized) {
        return this;
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }
}

