/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariableReference;
import org.aspectj.weaver.TypeVariableReferenceType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNodeVisitor;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;
import org.aspectj.weaver.patterns.WildTypePattern;

public class ExactTypePattern
extends TypePattern {
    protected UnresolvedType type;
    public static final Map primitiveTypesMap = new HashMap();
    public static final Map boxedPrimitivesMap;
    private static final Map boxedTypesMap;
    private static final byte EXACT_VERSION = 1;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public ExactTypePattern(UnresolvedType type, boolean includeSubtypes, boolean isVarArgs) {
        super(includeSubtypes, isVarArgs);
        this.type = type;
    }

    public boolean isArray() {
        return this.type.isArray();
    }

    protected boolean couldEverMatchSameTypesAs(TypePattern other) {
        WildTypePattern owtp;
        String yourSimpleNamePrefix;
        if (super.couldEverMatchSameTypesAs(other)) {
            return true;
        }
        UnresolvedType otherType = other.getExactType();
        if (!ResolvedType.isMissing(otherType)) {
            return this.type.equals(otherType);
        }
        if (other instanceof WildTypePattern && (yourSimpleNamePrefix = (owtp = (WildTypePattern)other).getNamePatterns()[0].maybeGetSimpleName()) != null) {
            return this.type.getName().startsWith(yourSimpleNamePrefix);
        }
        return true;
    }

    protected boolean matchesExactly(ResolvedType matchType) {
        boolean typeMatch = this.type.equals(matchType);
        if (!typeMatch && (matchType.isParameterizedType() || matchType.isGenericType())) {
            typeMatch = this.type.equals(matchType.getRawType());
        }
        if (!typeMatch && matchType.isTypeVariableReference()) {
            typeMatch = this.matchesTypeVariable((TypeVariableReferenceType)matchType);
        }
        this.annotationPattern.resolve(matchType.getWorld());
        boolean annMatch = this.annotationPattern.matches(matchType).alwaysTrue();
        return typeMatch && annMatch;
    }

    private boolean matchesTypeVariable(TypeVariableReferenceType matchType) {
        return false;
    }

    protected boolean matchesExactly(ResolvedType matchType, ResolvedType annotatedType) {
        boolean typeMatch = this.type.equals(matchType);
        if (!typeMatch && (matchType.isParameterizedType() || matchType.isGenericType())) {
            typeMatch = this.type.equals(matchType.getRawType());
        }
        if (!typeMatch && matchType.isTypeVariableReference()) {
            typeMatch = this.matchesTypeVariable((TypeVariableReferenceType)matchType);
        }
        this.annotationPattern.resolve(matchType.getWorld());
        boolean annMatch = this.annotationPattern.matches(annotatedType).alwaysTrue();
        return typeMatch && annMatch;
    }

    public UnresolvedType getType() {
        return this.type;
    }

    public FuzzyBoolean matchesInstanceof(ResolvedType matchType) {
        if (this.type.equals(UnresolvedType.OBJECT)) {
            return FuzzyBoolean.YES.and(this.annotationPattern.matches(matchType));
        }
        if (this.type.resolve(matchType.getWorld()).isAssignableFrom(matchType)) {
            return FuzzyBoolean.YES.and(this.annotationPattern.matches(matchType));
        }
        if (this.type.isPrimitiveType()) {
            return FuzzyBoolean.NO;
        }
        return matchType.isCoerceableFrom(this.type.resolve(matchType.getWorld())) ? FuzzyBoolean.MAYBE : FuzzyBoolean.NO;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExactTypePattern)) {
            return false;
        }
        if (other instanceof BindingTypePattern) {
            return false;
        }
        ExactTypePattern o = (ExactTypePattern)other;
        if (this.includeSubtypes != o.includeSubtypes) {
            return false;
        }
        if (this.isVarArgs != o.isVarArgs) {
            return false;
        }
        if (!this.typeParameters.equals(o.typeParameters)) {
            return false;
        }
        return o.type.equals(this.type) && o.annotationPattern.equals(this.annotationPattern);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.type.hashCode();
        result = 37 * result + new Boolean(this.includeSubtypes).hashCode();
        result = 37 * result + new Boolean(this.isVarArgs).hashCode();
        result = 37 * result + this.typeParameters.hashCode();
        result = 37 * result + this.annotationPattern.hashCode();
        return result;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeByte(2);
        out.writeByte(1);
        this.type.write(out);
        out.writeBoolean(this.includeSubtypes);
        out.writeBoolean(this.isVarArgs);
        this.annotationPattern.write(out);
        this.typeParameters.write(out);
        this.writeLocation(out);
    }

    public static TypePattern read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        if (s.getMajorVersion() >= AjAttribute.WeaverVersionInfo.WEAVER_VERSION_MAJOR_AJ150) {
            return ExactTypePattern.readTypePattern150(s, context);
        }
        return ExactTypePattern.readTypePatternOldStyle(s, context);
    }

    public static TypePattern readTypePattern150(VersionedDataInputStream s, ISourceContext context) throws IOException {
        byte version = s.readByte();
        if (version > 1) {
            throw new BCException("ExactTypePattern was written by a more recent version of AspectJ");
        }
        ExactTypePattern ret = new ExactTypePattern(UnresolvedType.read(s), s.readBoolean(), s.readBoolean());
        ret.setAnnotationTypePattern(AnnotationTypePattern.read(s, context));
        ret.setTypeParameters(TypePatternList.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public static TypePattern readTypePatternOldStyle(DataInputStream s, ISourceContext context) throws IOException {
        ExactTypePattern ret = new ExactTypePattern(UnresolvedType.read(s), s.readBoolean(), false);
        ret.readLocation(context, s);
        return ret;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.annotationPattern != AnnotationTypePattern.ANY) {
            buff.append('(');
            buff.append(this.annotationPattern.toString());
            buff.append(' ');
        }
        String typeString = this.type.toString();
        if (this.isVarArgs) {
            typeString = typeString.substring(0, typeString.lastIndexOf(91));
        }
        buff.append(typeString);
        if (this.includeSubtypes) {
            buff.append('+');
        }
        if (this.isVarArgs) {
            buff.append("...");
        }
        if (this.annotationPattern != AnnotationTypePattern.ANY) {
            buff.append(')');
        }
        return buff.toString();
    }

    public TypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding, boolean requireExactType) {
        throw new BCException("trying to re-resolve");
    }

    public TypePattern parameterizeWith(Map typeVariableMap) {
        UnresolvedType newType = this.type;
        if (this.type.isTypeVariableReference()) {
            TypeVariableReference t = (TypeVariableReference)((Object)this.type);
            String key = t.getTypeVariable().getName();
            if (typeVariableMap.containsKey(key)) {
                newType = (UnresolvedType)typeVariableMap.get(key);
            }
        } else if (this.type.isParameterizedType()) {
            newType = this.type.parameterize(typeVariableMap);
        }
        ExactTypePattern ret = new ExactTypePattern(newType, this.includeSubtypes, this.isVarArgs);
        ret.annotationPattern = this.annotationPattern.parameterizeWith(typeVariableMap);
        ret.copyLocationFrom(this);
        return ret;
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitiveTypesMap.put("int", Integer.TYPE);
        primitiveTypesMap.put("short", Short.TYPE);
        primitiveTypesMap.put("long", Long.TYPE);
        primitiveTypesMap.put("byte", Byte.TYPE);
        primitiveTypesMap.put("char", Character.TYPE);
        primitiveTypesMap.put("float", Float.TYPE);
        primitiveTypesMap.put("double", Double.TYPE);
        boxedPrimitivesMap = new HashMap();
        boxedPrimitivesMap.put("java.lang.Integer", class$java$lang$Integer == null ? (class$java$lang$Integer = ExactTypePattern.class$("java.lang.Integer")) : class$java$lang$Integer);
        boxedPrimitivesMap.put("java.lang.Short", class$java$lang$Short == null ? (class$java$lang$Short = ExactTypePattern.class$("java.lang.Short")) : class$java$lang$Short);
        boxedPrimitivesMap.put("java.lang.Long", class$java$lang$Long == null ? (class$java$lang$Long = ExactTypePattern.class$("java.lang.Long")) : class$java$lang$Long);
        boxedPrimitivesMap.put("java.lang.Byte", class$java$lang$Byte == null ? (class$java$lang$Byte = ExactTypePattern.class$("java.lang.Byte")) : class$java$lang$Byte);
        boxedPrimitivesMap.put("java.lang.Character", class$java$lang$Character == null ? (class$java$lang$Character = ExactTypePattern.class$("java.lang.Character")) : class$java$lang$Character);
        boxedPrimitivesMap.put("java.lang.Float", class$java$lang$Float == null ? (class$java$lang$Float = ExactTypePattern.class$("java.lang.Float")) : class$java$lang$Float);
        boxedPrimitivesMap.put("java.lang.Double", class$java$lang$Double == null ? (class$java$lang$Double = ExactTypePattern.class$("java.lang.Double")) : class$java$lang$Double);
        boxedTypesMap = new HashMap();
        boxedTypesMap.put("int", class$java$lang$Integer == null ? (class$java$lang$Integer = ExactTypePattern.class$("java.lang.Integer")) : class$java$lang$Integer);
        boxedTypesMap.put("short", class$java$lang$Short == null ? (class$java$lang$Short = ExactTypePattern.class$("java.lang.Short")) : class$java$lang$Short);
        boxedTypesMap.put("long", class$java$lang$Long == null ? (class$java$lang$Long = ExactTypePattern.class$("java.lang.Long")) : class$java$lang$Long);
        boxedTypesMap.put("byte", class$java$lang$Byte == null ? (class$java$lang$Byte = ExactTypePattern.class$("java.lang.Byte")) : class$java$lang$Byte);
        boxedTypesMap.put("char", class$java$lang$Character == null ? (class$java$lang$Character = ExactTypePattern.class$("java.lang.Character")) : class$java$lang$Character);
        boxedTypesMap.put("float", class$java$lang$Float == null ? (class$java$lang$Float = ExactTypePattern.class$("java.lang.Float")) : class$java$lang$Float);
        boxedTypesMap.put("double", class$java$lang$Double == null ? (class$java$lang$Double = ExactTypePattern.class$("java.lang.Double")) : class$java$lang$Double);
    }
}

