/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.aspectj.org.eclipse.jdt.core.IBuffer;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaModelStatus;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.dom.AST;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.ASTParser;
import org.aspectj.org.eclipse.jdt.core.dom.ASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.EnumDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.aspectj.org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelOperation;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.aspectj.org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;

public class SortElementsOperation
extends JavaModelOperation {
    Comparator comparator;
    int[] positions;
    int apiLevel;

    public SortElementsOperation(int level, IJavaElement[] elements, int[] positions, Comparator comparator) {
        super(elements);
        this.comparator = comparator;
        this.positions = positions;
        this.apiLevel = level;
    }

    protected int getMainAmountOfWork() {
        return this.elementsToProcess.length;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        try {
            this.beginTask(Messages.operation_sortelements, this.getMainAmountOfWork());
            CompilationUnit copy = (CompilationUnit)this.elementsToProcess[0];
            ICompilationUnit unit = copy.getPrimary();
            IBuffer buffer = copy.getBuffer();
            if (buffer == null) {
                Object var6_4 = null;
                this.done();
                return;
            }
            char[] bufferContents = buffer.getCharacters();
            String result = this.processElement(unit, bufferContents);
            if (!CharOperation.equals(result.toCharArray(), bufferContents)) {
                copy.getBuffer().setContents(result);
            }
            this.worked(1);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.done();
            throw throwable;
        }
        {
            Object var6_6 = null;
            this.done();
            return;
        }
    }

    private String processElement(ICompilationUnit unit, char[] source) {
        int max;
        int i;
        boolean needPositionsMapping;
        CompilerOptions options = new CompilerOptions(unit.getJavaProject().getOptions(true));
        ASTParser parser = ASTParser.newParser(this.apiLevel);
        parser.setCompilerOptions(options.getMap());
        parser.setSource(source);
        parser.setKind(8);
        parser.setResolveBindings(false);
        org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit domUnit = (org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit)parser.createAST(null);
        domUnit.accept(new ASTVisitor(){

            public boolean visit(org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit compilationUnit) {
                List types = compilationUnit.types();
                Iterator iter = types.iterator();
                while (iter.hasNext()) {
                    AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)iter.next();
                    typeDeclaration.setProperty("relativeOrder", new Integer(typeDeclaration.getStartPosition()));
                }
                return true;
            }

            public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
                List bodyDeclarations = annotationTypeDeclaration.bodyDeclarations();
                Iterator iter = bodyDeclarations.iterator();
                while (iter.hasNext()) {
                    BodyDeclaration bodyDeclaration = (BodyDeclaration)iter.next();
                    bodyDeclaration.setProperty("relativeOrder", new Integer(bodyDeclaration.getStartPosition()));
                }
                return true;
            }

            public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
                List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
                Iterator iter = bodyDeclarations.iterator();
                while (iter.hasNext()) {
                    BodyDeclaration bodyDeclaration = (BodyDeclaration)iter.next();
                    bodyDeclaration.setProperty("relativeOrder", new Integer(bodyDeclaration.getStartPosition()));
                }
                return true;
            }

            public boolean visit(TypeDeclaration typeDeclaration) {
                List bodyDeclarations = typeDeclaration.bodyDeclarations();
                Iterator iter = bodyDeclarations.iterator();
                while (iter.hasNext()) {
                    BodyDeclaration bodyDeclaration = (BodyDeclaration)iter.next();
                    bodyDeclaration.setProperty("relativeOrder", new Integer(bodyDeclaration.getStartPosition()));
                }
                return true;
            }

            public boolean visit(EnumDeclaration enumDeclaration) {
                List bodyDeclarations = enumDeclaration.bodyDeclarations();
                Iterator iter = bodyDeclarations.iterator();
                while (iter.hasNext()) {
                    BodyDeclaration bodyDeclaration = (BodyDeclaration)iter.next();
                    bodyDeclaration.setProperty("relativeOrder", new Integer(bodyDeclaration.getStartPosition()));
                }
                List enumConstants = enumDeclaration.enumConstants();
                Iterator iter2 = enumConstants.iterator();
                while (iter2.hasNext()) {
                    EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)iter2.next();
                    enumConstantDeclaration.setProperty("relativeOrder", new Integer(enumConstantDeclaration.getStartPosition()));
                }
                return true;
            }
        });
        AST localAst = domUnit.getAST();
        final ASTRewrite rewriter = ASTRewrite.create(localAst);
        RangeMarker[] markers = null;
        boolean bl = needPositionsMapping = this.positions != null;
        if (needPositionsMapping) {
            markers = new RangeMarker[this.positions.length];
            int i2 = 0;
            while (i2 < this.positions.length) {
                markers[i2] = new RangeMarker(this.positions[i2], 0);
                ++i2;
            }
        }
        String generatedSource = new String(source);
        Document document = new Document(generatedSource);
        domUnit.accept(new ASTVisitor(){

            public boolean visit(org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit compilationUnit) {
                ListRewrite listRewrite = rewriter.getListRewrite(compilationUnit, org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit.TYPES_PROPERTY);
                List types = compilationUnit.types();
                int length = types.size();
                if (length > 1) {
                    ArrayList myCopy = new ArrayList();
                    myCopy.addAll(types);
                    Collections.sort(myCopy, SortElementsOperation.this.comparator);
                    int i = 0;
                    while (i < length) {
                        listRewrite.replace((ASTNode)types.get(i), rewriter.createMoveTarget((ASTNode)myCopy.get(i)), null);
                        ++i;
                    }
                }
                return true;
            }

            public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
                ListRewrite listRewrite = rewriter.getListRewrite(annotationTypeDeclaration, AnnotationTypeDeclaration.BODY_DECLARATIONS_PROPERTY);
                List bodyDeclarations = annotationTypeDeclaration.bodyDeclarations();
                int length = bodyDeclarations.size();
                if (length > 1) {
                    ArrayList myCopy = new ArrayList();
                    myCopy.addAll(bodyDeclarations);
                    Collections.sort(myCopy, SortElementsOperation.this.comparator);
                    int i = 0;
                    while (i < length) {
                        listRewrite.replace((ASTNode)bodyDeclarations.get(i), rewriter.createMoveTarget((ASTNode)myCopy.get(i)), null);
                        ++i;
                    }
                }
                return true;
            }

            public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
                ListRewrite listRewrite = rewriter.getListRewrite(anonymousClassDeclaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
                List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
                int length = bodyDeclarations.size();
                if (length > 1) {
                    ArrayList myCopy = new ArrayList();
                    myCopy.addAll(bodyDeclarations);
                    Collections.sort(myCopy, SortElementsOperation.this.comparator);
                    int i = 0;
                    while (i < length) {
                        listRewrite.replace((ASTNode)bodyDeclarations.get(i), rewriter.createMoveTarget((ASTNode)myCopy.get(i)), null);
                        ++i;
                    }
                }
                return true;
            }

            public boolean visit(TypeDeclaration typeDeclaration) {
                ListRewrite listRewrite = rewriter.getListRewrite(typeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
                List bodyDeclarations = typeDeclaration.bodyDeclarations();
                int length = bodyDeclarations.size();
                if (length > 1) {
                    ArrayList myCopy = new ArrayList();
                    myCopy.addAll(bodyDeclarations);
                    Collections.sort(myCopy, SortElementsOperation.this.comparator);
                    int i = 0;
                    while (i < length) {
                        listRewrite.replace((ASTNode)bodyDeclarations.get(i), rewriter.createMoveTarget((ASTNode)myCopy.get(i)), null);
                        ++i;
                    }
                }
                return true;
            }

            public boolean visit(EnumDeclaration enumDeclaration) {
                ListRewrite listRewrite = rewriter.getListRewrite(enumDeclaration, EnumDeclaration.BODY_DECLARATIONS_PROPERTY);
                List bodyDeclarations = enumDeclaration.bodyDeclarations();
                int length = bodyDeclarations.size();
                if (length > 1) {
                    ArrayList myCopy = new ArrayList();
                    myCopy.addAll(bodyDeclarations);
                    Collections.sort(myCopy, SortElementsOperation.this.comparator);
                    int i = 0;
                    while (i < length) {
                        listRewrite.replace((ASTNode)bodyDeclarations.get(i), rewriter.createMoveTarget((ASTNode)myCopy.get(i)), null);
                        ++i;
                    }
                }
                listRewrite = rewriter.getListRewrite(enumDeclaration, EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
                List enumConstants = enumDeclaration.enumConstants();
                length = enumConstants.size();
                if (length > 1) {
                    ArrayList myCopy = new ArrayList();
                    myCopy.addAll(enumConstants);
                    Collections.sort(myCopy, SortElementsOperation.this.comparator);
                    int i = 0;
                    while (i < length) {
                        listRewrite.replace((ASTNode)enumConstants.get(i), rewriter.createMoveTarget((ASTNode)myCopy.get(i)), null);
                        ++i;
                    }
                }
                return true;
            }
        });
        TextEdit edits = rewriter.rewriteAST((IDocument)document, null);
        if (needPositionsMapping) {
            i = 0;
            max = markers.length;
            while (i < max) {
                SortElementsOperation.insert(edits, markers[i]);
                ++i;
            }
        }
        try {
            edits.apply((IDocument)document, 2);
            generatedSource = document.get();
            if (needPositionsMapping) {
                i = 0;
                max = markers.length;
                while (i < max) {
                    this.positions[i] = markers[i].getOffset();
                    ++i;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return generatedSource;
    }

    public IJavaModelStatus verify() {
        if (this.elementsToProcess.length != 1) {
            return new JavaModelStatus(968);
        }
        if (this.elementsToProcess[0] == null) {
            return new JavaModelStatus(968);
        }
        if (!(this.elementsToProcess[0] instanceof ICompilationUnit) || !((ICompilationUnit)this.elementsToProcess[0]).isWorkingCopy()) {
            return new JavaModelStatus(967, this.elementsToProcess[0]);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static void insert(TextEdit parent, TextEdit edit) {
        TextEdit child;
        if (!parent.hasChildren()) {
            parent.addChild(edit);
            return;
        }
        TextEdit[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            if (SortElementsOperation.covers(child, edit)) {
                SortElementsOperation.insert(child, edit);
                return;
            }
            ++i;
        }
        i = children.length - 1;
        while (i >= 0) {
            child = children[i];
            if (SortElementsOperation.covers(edit, child)) {
                parent.removeChild(i);
                edit.addChild(child);
            }
            --i;
        }
        parent.addChild(edit);
    }

    private static boolean covers(TextEdit thisEdit, TextEdit otherEdit) {
        if (thisEdit.getLength() == 0) {
            return false;
        }
        int thisOffset = thisEdit.getOffset();
        int thisEnd = thisEdit.getExclusiveEnd();
        if (otherEdit.getLength() == 0) {
            int otherOffset = otherEdit.getOffset();
            return thisOffset <= otherOffset && otherOffset < thisEnd;
        }
        int otherOffset = otherEdit.getOffset();
        int otherEnd = otherEdit.getExclusiveEnd();
        return thisOffset <= otherOffset && otherEnd <= thisEnd;
    }
}

