/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.codegen;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;

public class FieldNameAndTypeCache {
    public FieldBinding[] keyTable;
    public int[] valueTable;
    int elementSize = 0;
    int threshold;

    public FieldNameAndTypeCache() {
        this(13);
    }

    public FieldNameAndTypeCache(int initialCapacity) {
        this.threshold = (int)((float)initialCapacity * 0.66f);
        this.keyTable = new FieldBinding[initialCapacity];
        this.valueTable = new int[initialCapacity];
    }

    public void clear() {
        int i = this.keyTable.length;
        while (--i >= 0) {
            this.keyTable[i] = null;
            this.valueTable[i] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(FieldBinding key) {
        int index = this.hashCode(key);
        while (this.keyTable[index] != null) {
            if (this.equalsForNameAndType(this.keyTable[index], key)) {
                return true;
            }
            index = (index + 1) % this.keyTable.length;
        }
        return false;
    }

    public boolean equalsForNameAndType(FieldBinding field1, FieldBinding field2) {
        return field1.type == field2.type && CharOperation.equals(field1.name, field2.name);
    }

    public int get(FieldBinding key) {
        int index = this.hashCode(key);
        while (this.keyTable[index] != null) {
            if (this.equalsForNameAndType(this.keyTable[index], key)) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return -1;
    }

    public int hashCode(FieldBinding key) {
        return (CharOperation.hashCode(key.name) + key.type.hashCode() & Integer.MAX_VALUE) % this.keyTable.length;
    }

    public int put(FieldBinding key, int value) {
        int index = this.hashCode(key);
        while (this.keyTable[index] != null) {
            if (this.equalsForNameAndType(this.keyTable[index], key)) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    private void rehash() {
        FieldNameAndTypeCache newHashtable = new FieldNameAndTypeCache(this.keyTable.length * 2);
        int i = this.keyTable.length;
        while (--i >= 0) {
            if (this.keyTable[i] == null) continue;
            newHashtable.put(this.keyTable[i], this.valueTable[i]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        int max = this.size();
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        int i = 0;
        while (i < max) {
            if (this.keyTable[i] != null) {
                buf.append(this.keyTable[i]).append("->").append(this.valueTable[i]);
            }
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }
}

