/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.MessageWriter;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.IClassFileProvider;
import org.aspectj.weaver.IWeaveRequestor;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.aspectj.weaver.tools.GeneratedClassHandler;
import org.aspectj.weaver.tools.WeavingClassLoader;

public class WeavingAdaptor {
    public static final String WEAVING_ADAPTOR_VERBOSE = "aj.weaving.verbose";
    public static final String SHOW_WEAVE_INFO_PROPERTY = "org.aspectj.weaver.showWeaveInfo";
    protected boolean enabled = true;
    protected boolean verbose = WeavingAdaptor.getVerbose();
    protected BcelWorld bcelWorld;
    protected BcelWeaver weaver;
    private IMessageHandler messageHandler;
    private WeavingAdaptorMessageHandler messageHolder;
    protected GeneratedClassHandler generatedClassHandler;
    protected Map generatedClasses = new HashMap();

    protected WeavingAdaptor() {
        this.createMessageHandler();
    }

    public WeavingAdaptor(WeavingClassLoader loader) {
        this.generatedClassHandler = loader;
        this.init(this.getFullClassPath((ClassLoader)((Object)loader)), this.getFullAspectPath((ClassLoader)((Object)loader)));
    }

    public WeavingAdaptor(GeneratedClassHandler handler, URL[] classURLs, URL[] aspectURLs) {
        this.generatedClassHandler = handler;
        this.init(FileUtil.makeClasspath(classURLs), FileUtil.makeClasspath(aspectURLs));
    }

    private List getFullClassPath(ClassLoader loader) {
        LinkedList list = new LinkedList();
        while (loader != null) {
            if (loader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                list.addAll(0, FileUtil.makeClasspath(urls));
            } else {
                this.warn("cannot determine classpath");
            }
            loader = loader.getParent();
        }
        list.addAll(0, WeavingAdaptor.makeClasspath(System.getProperty("sun.boot.class.path")));
        return list;
    }

    private List getFullAspectPath(ClassLoader loader) {
        LinkedList list = new LinkedList();
        while (loader != null) {
            if (loader instanceof WeavingClassLoader) {
                URL[] urls = ((WeavingClassLoader)((Object)loader)).getAspectURLs();
                list.addAll(0, FileUtil.makeClasspath(urls));
            }
            loader = loader.getParent();
        }
        return list;
    }

    private static boolean getVerbose() {
        return Boolean.getBoolean(WEAVING_ADAPTOR_VERBOSE);
    }

    private void init(List classPath, List aspectPath) {
        this.createMessageHandler();
        this.info("using classpath: " + classPath);
        this.info("using aspectpath: " + aspectPath);
        this.bcelWorld = new BcelWorld(classPath, this.messageHandler, null);
        this.bcelWorld.setXnoInline(false);
        this.bcelWorld.getLint().loadDefaultProperties();
        if (LangUtil.is15VMOrGreater()) {
            this.bcelWorld.setBehaveInJava5Way(true);
        }
        this.weaver = new BcelWeaver(this.bcelWorld);
        this.registerAspectLibraries(aspectPath);
    }

    private void createMessageHandler() {
        this.messageHolder = new WeavingAdaptorMessageHandler(new PrintWriter(System.err));
        this.messageHandler = this.messageHolder;
        if (this.verbose) {
            this.messageHandler.dontIgnore(IMessage.INFO);
        }
        if (Boolean.getBoolean(SHOW_WEAVE_INFO_PROPERTY)) {
            this.messageHandler.dontIgnore(IMessage.WEAVEINFO);
        }
        this.info("AspectJ Weaver Version 1.5.2a built on Friday Aug 18, 2006 at 18:40:31 GMT");
    }

    protected IMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    protected void setMessageHandler(IMessageHandler mh) {
        if (this.messageHolder != null) {
            this.messageHolder.flushMessages();
            this.messageHolder = null;
        }
        this.messageHandler = mh;
        this.bcelWorld.setMessageHandler(mh);
    }

    public void addURL(URL url) {
        File libFile = new File(url.getPath());
        try {
            this.weaver.addLibraryJarFile(libFile);
        }
        catch (IOException ex) {
            this.warn("bad library: '" + libFile + "'");
        }
    }

    public byte[] weaveClass(String name, byte[] bytes) throws IOException {
        if (this.enabled) {
            if (this.shouldWeave(name, bytes)) {
                this.info("weaving '" + name + "'");
                bytes = this.getWovenBytes(name, bytes);
            } else if (this.shouldWeaveAnnotationStyleAspect(name, bytes)) {
                this.info("weaving '" + name + "'");
                bytes = this.getAtAspectJAspectBytes(name, bytes);
            } else {
                this.info("not weaving '" + name + "'");
            }
        }
        return bytes;
    }

    private boolean shouldWeave(String name, byte[] bytes) {
        boolean b = !this.generatedClasses.containsKey(name = name.replace('/', '.')) && this.shouldWeaveName(name);
        return b && this.accept(name, bytes);
    }

    protected boolean accept(String name, byte[] bytes) {
        return true;
    }

    protected boolean shouldDump(String name, boolean before) {
        return false;
    }

    private boolean shouldWeaveName(String name) {
        boolean should = !name.startsWith("org.aspectj.") && !name.startsWith("java.") && !name.startsWith("javax.") && !name.startsWith("sun.reflect.");
        return should;
    }

    private boolean shouldWeaveAnnotationStyleAspect(String name, byte[] bytes) {
        return this.bcelWorld.isAnnotationStyleAspect(name, bytes);
    }

    private byte[] getWovenBytes(String name, byte[] bytes) throws IOException {
        WeavingClassFileProvider wcp = new WeavingClassFileProvider(name, bytes);
        this.weaver.weave(wcp);
        return wcp.getBytes();
    }

    private byte[] getAtAspectJAspectBytes(String name, byte[] bytes) throws IOException {
        WeavingClassFileProvider wcp = new WeavingClassFileProvider(name, bytes);
        wcp.setApplyAtAspectJMungersOnly();
        this.weaver.weave(wcp);
        return wcp.getBytes();
    }

    private void registerAspectLibraries(List aspectPath) {
        Iterator i = aspectPath.iterator();
        while (i.hasNext()) {
            String libName = (String)i.next();
            this.addAspectLibrary(libName);
        }
        this.weaver.prepareForWeave();
    }

    private void addAspectLibrary(String aspectLibraryName) {
        File aspectLibrary = new File(aspectLibraryName);
        if (aspectLibrary.isDirectory() || FileUtil.isZipFile(aspectLibrary)) {
            try {
                this.info("adding aspect library: '" + aspectLibrary + "'");
                this.weaver.addLibraryJarFile(aspectLibrary);
            }
            catch (IOException ex) {
                this.error("exception adding aspect library: '" + ex + "'");
            }
        } else {
            this.error("bad aspect library: '" + aspectLibrary + "'");
        }
    }

    private static List makeClasspath(String cp) {
        ArrayList<String> ret = new ArrayList<String>();
        if (cp != null) {
            StringTokenizer tok = new StringTokenizer(cp, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                ret.add(tok.nextToken());
            }
        }
        return ret;
    }

    protected boolean info(String message) {
        return MessageUtil.info(this.messageHandler, message);
    }

    protected boolean warn(String message) {
        return MessageUtil.warn(this.messageHandler, message);
    }

    protected boolean warn(String message, Throwable th) {
        return this.messageHandler.handleMessage(new Message(message, IMessage.WARNING, th, null));
    }

    protected boolean error(String message) {
        return MessageUtil.error(this.messageHandler, message);
    }

    protected void dump(String name, byte[] b, boolean before) {
        String className;
        String dirName = "_ajdump";
        if (before) {
            dirName = dirName + File.separator + "_before";
        }
        File dir = (className = name.replace('.', '/')).indexOf(47) > 0 ? new File(dirName + File.separator + className.substring(0, className.lastIndexOf(47))) : new File(dirName);
        dir.mkdirs();
        String fileName = dirName + File.separator + className + ".class";
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            os.write(b);
            os.close();
        }
        catch (IOException ex) {
            this.warn("unable to dump class " + name + " in directory " + dirName, ex);
        }
    }

    private class WeavingClassFileProvider
    implements IClassFileProvider {
        private UnwovenClassFile unwovenClass;
        private List unwovenClasses = new ArrayList();
        private UnwovenClassFile wovenClass;
        private boolean isApplyAtAspectJMungersOnly = false;
        private BcelObjectType delegate;

        public WeavingClassFileProvider(String name, byte[] bytes) {
            this.unwovenClass = new UnwovenClassFile(name, bytes);
            this.unwovenClasses.add(this.unwovenClass);
            if (WeavingAdaptor.this.shouldDump(name.replace('/', '.'), true)) {
                WeavingAdaptor.this.dump(name, bytes, true);
            }
            this.delegate = WeavingAdaptor.this.bcelWorld.addSourceObjectType(this.unwovenClass.getJavaClass());
        }

        public void setApplyAtAspectJMungersOnly() {
            this.isApplyAtAspectJMungersOnly = true;
        }

        public boolean isApplyAtAspectJMungersOnly() {
            return this.isApplyAtAspectJMungersOnly;
        }

        public byte[] getBytes() {
            if (this.wovenClass != null) {
                return this.wovenClass.getBytes();
            }
            return this.unwovenClass.getBytes();
        }

        public Iterator getClassFileIterator() {
            return this.unwovenClasses.iterator();
        }

        public IWeaveRequestor getRequestor() {
            return new IWeaveRequestor(){

                public void acceptResult(UnwovenClassFile result) {
                    if (WeavingClassFileProvider.this.wovenClass == null) {
                        WeavingClassFileProvider.this.wovenClass = result;
                        String name = result.getClassName();
                        if (WeavingAdaptor.this.shouldDump(name.replace('/', '.'), false)) {
                            WeavingAdaptor.this.dump(name, result.getBytes(), false);
                        }
                    } else {
                        String className = result.getClassName();
                        ((WeavingClassFileProvider)WeavingClassFileProvider.this).WeavingAdaptor.this.generatedClasses.put(className, result);
                        ((WeavingClassFileProvider)WeavingClassFileProvider.this).WeavingAdaptor.this.generatedClasses.put(WeavingClassFileProvider.this.wovenClass.getClassName(), result);
                        ((WeavingClassFileProvider)WeavingClassFileProvider.this).WeavingAdaptor.this.generatedClassHandler.acceptClass(className, result.getBytes());
                    }
                }

                public void processingReweavableState() {
                }

                public void addingTypeMungers() {
                }

                public void weavingAspects() {
                }

                public void weavingClasses() {
                }

                public void weaveCompleted() {
                    if (WeavingClassFileProvider.this.delegate != null) {
                        WeavingClassFileProvider.this.delegate.weavingCompleted();
                    }
                    ResolvedType.resetPrimitives();
                }
            };
        }
    }

    protected class WeavingAdaptorMessageHandler
    extends MessageWriter {
        private Set ignoring = new HashSet();
        private IMessage.Kind failKind;
        private boolean accumulating = true;
        private List messages = new ArrayList();

        public WeavingAdaptorMessageHandler(PrintWriter writer) {
            super(writer, true);
            this.ignore(IMessage.WEAVEINFO);
            this.ignore(IMessage.INFO);
            this.failKind = IMessage.ERROR;
        }

        public boolean handleMessage(IMessage message) throws AbortException {
            this.addMessage(message);
            boolean result = super.handleMessage(message);
            if (0 <= message.getKind().compareTo(this.failKind)) {
                throw new AbortException(message);
            }
            return true;
        }

        public boolean isIgnoring(IMessage.Kind kind) {
            return null != kind && this.ignoring.contains(kind);
        }

        public void ignore(IMessage.Kind kind) {
            if (null != kind && !this.ignoring.contains(kind)) {
                this.ignoring.add(kind);
            }
        }

        public void dontIgnore(IMessage.Kind kind) {
            if (null != kind) {
                this.ignoring.remove(kind);
                if (kind.equals(IMessage.INFO)) {
                    this.accumulating = false;
                }
            }
        }

        private void addMessage(IMessage message) {
            if (this.accumulating && this.isIgnoring(message.getKind())) {
                this.messages.add(message);
            }
        }

        public void flushMessages() {
            Iterator iter = this.messages.iterator();
            while (iter.hasNext()) {
                IMessage message = (IMessage)iter.next();
                super.handleMessage(message);
            }
            this.accumulating = false;
            this.messages.clear();
        }
    }
}

