/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.asm.IRelationship;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.WeaveMessage;
import org.aspectj.util.PartialOrder;
import org.aspectj.util.TypeSafeEnum;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AsmRelationshipProvider;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.Var;
import org.aspectj.weaver.bcel.BcelAdvice;

public abstract class Shadow {
    private static int nextShadowID = 100;
    private final Kind kind;
    private final Member signature;
    private Member matchingSignature;
    private ResolvedMember resolvedSignature;
    protected final Shadow enclosingShadow;
    protected List mungers = Collections.EMPTY_LIST;
    public int shadowId = nextShadowID++;
    public static final Kind MethodCall = new Kind("method-call", 1, true);
    public static final Kind ConstructorCall = new Kind("constructor-call", 2, true);
    public static final Kind MethodExecution = new Kind("method-execution", 3, false);
    public static final Kind ConstructorExecution = new Kind("constructor-execution", 4, false);
    public static final Kind FieldGet = new Kind("field-get", 5, true);
    public static final Kind FieldSet = new Kind("field-set", 6, true);
    public static final Kind StaticInitialization = new Kind("staticinitialization", 7, false);
    public static final Kind PreInitialization = new Kind("preinitialization", 8, false);
    public static final Kind AdviceExecution = new Kind("adviceexecution", 9, false);
    public static final Kind Initialization = new Kind("initialization", 10, false);
    public static final Kind ExceptionHandler = new Kind("exception-handler", 11, true);
    public static final int MethodCallBit = 2;
    public static final int ConstructorCallBit = 4;
    public static final int MethodExecutionBit = 8;
    public static final int ConstructorExecutionBit = 16;
    public static final int FieldGetBit = 32;
    public static final int FieldSetBit = 64;
    public static final int StaticInitializationBit = 128;
    public static final int PreInitializationBit = 256;
    public static final int AdviceExecutionBit = 512;
    public static final int InitializationBit = 1024;
    public static final int ExceptionHandlerBit = 2048;
    public static final int MAX_SHADOW_KIND = 11;
    public static final Kind[] SHADOW_KINDS = new Kind[]{MethodCall, ConstructorCall, MethodExecution, ConstructorExecution, FieldGet, FieldSet, StaticInitialization, PreInitialization, AdviceExecution, Initialization, ExceptionHandler};
    public static final int ALL_SHADOW_KINDS_BITS = 4094;
    public static final int NO_SHADOW_KINDS_BITS = 0;

    protected Shadow(Kind kind, Member signature, Shadow enclosingShadow) {
        this.kind = kind;
        this.signature = signature;
        this.enclosingShadow = enclosingShadow;
    }

    public abstract World getIWorld();

    public List getMungers() {
        return this.mungers;
    }

    public final boolean hasThis() {
        if (this.getKind().neverHasThis()) {
            return false;
        }
        if (this.getKind().isEnclosingKind()) {
            return !this.getSignature().isStatic();
        }
        if (this.enclosingShadow == null) {
            return false;
        }
        return this.enclosingShadow.hasThis();
    }

    public final UnresolvedType getThisType() {
        if (!this.hasThis()) {
            throw new IllegalStateException("no this");
        }
        if (this.getKind().isEnclosingKind()) {
            return this.getSignature().getDeclaringType();
        }
        return this.enclosingShadow.getThisType();
    }

    public abstract Var getThisVar();

    public final boolean hasTarget() {
        if (this.getKind().neverHasTarget()) {
            return false;
        }
        if (this.getKind().isTargetSameAsThis()) {
            return this.hasThis();
        }
        return !this.getSignature().isStatic();
    }

    public final UnresolvedType getTargetType() {
        if (!this.hasTarget()) {
            throw new IllegalStateException("no target");
        }
        return this.getSignature().getDeclaringType();
    }

    public abstract Var getTargetVar();

    public UnresolvedType[] getArgTypes() {
        if (this.getKind() == FieldSet) {
            return new UnresolvedType[]{this.getSignature().getReturnType()};
        }
        return this.getSignature().getParameterTypes();
    }

    public boolean isShadowForArrayConstructionJoinpoint() {
        return this.getKind() == ConstructorCall && this.signature.getDeclaringType().isArray();
    }

    public ResolvedType[] getArgumentTypesForArrayConstructionShadow() {
        String s = this.signature.getDeclaringType().getSignature();
        int pos = s.indexOf("[");
        int dims = 1;
        while (pos < s.length()) {
            if (++pos >= s.length()) continue;
            dims += s.charAt(pos) == '[' ? 1 : 0;
        }
        if (dims == 1) {
            return new ResolvedType[]{ResolvedType.INT};
        }
        ResolvedType[] someInts = new ResolvedType[dims];
        for (int i = 0; i < dims; ++i) {
            someInts[i] = ResolvedType.INT;
        }
        return someInts;
    }

    public UnresolvedType[] getGenericArgTypes() {
        if (this.isShadowForArrayConstructionJoinpoint()) {
            return this.getArgumentTypesForArrayConstructionShadow();
        }
        if (this.getKind() == FieldSet) {
            return new UnresolvedType[]{this.getResolvedSignature().getGenericReturnType()};
        }
        return this.getResolvedSignature().getGenericParameterTypes();
    }

    public UnresolvedType getArgType(int arg) {
        if (this.getKind() == FieldSet) {
            return this.getSignature().getReturnType();
        }
        return this.getSignature().getParameterTypes()[arg];
    }

    public int getArgCount() {
        if (this.getKind() == FieldSet) {
            return 1;
        }
        return this.getSignature().getParameterTypes().length;
    }

    public abstract UnresolvedType getEnclosingType();

    public abstract Var getArgVar(int var1);

    public abstract Var getThisJoinPointVar();

    public abstract Var getThisJoinPointStaticPartVar();

    public abstract Var getThisEnclosingJoinPointStaticPartVar();

    public abstract Var getKindedAnnotationVar(UnresolvedType var1);

    public abstract Var getWithinAnnotationVar(UnresolvedType var1);

    public abstract Var getWithinCodeAnnotationVar(UnresolvedType var1);

    public abstract Var getThisAnnotationVar(UnresolvedType var1);

    public abstract Var getTargetAnnotationVar(UnresolvedType var1);

    public abstract Var getArgAnnotationVar(int var1, UnresolvedType var2);

    public abstract Member getEnclosingCodeSignature();

    public Kind getKind() {
        return this.kind;
    }

    public Member getSignature() {
        return this.signature;
    }

    public Member getMatchingSignature() {
        return this.matchingSignature != null ? this.matchingSignature : this.signature;
    }

    public void setMatchingSignature(Member member) {
        this.matchingSignature = member;
    }

    public ResolvedMember getResolvedSignature() {
        if (this.resolvedSignature == null) {
            this.resolvedSignature = this.signature.resolve(this.getIWorld());
        }
        return this.resolvedSignature;
    }

    public UnresolvedType getReturnType() {
        if (this.kind == ConstructorCall) {
            return this.getSignature().getDeclaringType();
        }
        if (this.kind == FieldSet) {
            return ResolvedType.VOID;
        }
        return this.getResolvedSignature().getGenericReturnType();
    }

    public static int howMany(int i) {
        int count = 0;
        for (int j = 0; j < SHADOW_KINDS.length; ++j) {
            if ((i & Shadow.SHADOW_KINDS[j].bit) == 0) continue;
            ++count;
        }
        return count;
    }

    protected boolean checkMunger(ShadowMunger munger) {
        if (munger.mustCheckExceptions()) {
            Iterator i = munger.getThrownExceptions().iterator();
            while (i.hasNext()) {
                if (this.checkCanThrow(munger, (ResolvedType)i.next())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkCanThrow(ShadowMunger munger, ResolvedType resolvedTypeX) {
        if (this.getKind() == ExceptionHandler) {
            return true;
        }
        if (!this.isDeclaredException(resolvedTypeX, this.getSignature())) {
            this.getIWorld().showMessage(IMessage.ERROR, WeaverMessages.format("cantThrowChecked", resolvedTypeX, this), this.getSourceLocation(), munger.getSourceLocation());
        }
        return true;
    }

    private boolean isDeclaredException(ResolvedType resolvedTypeX, Member member) {
        ResolvedType[] excs = this.getIWorld().resolve(member.getExceptions(this.getIWorld()));
        int len = excs.length;
        for (int i = 0; i < len; ++i) {
            if (!excs[i].isAssignableFrom(resolvedTypeX)) continue;
            return true;
        }
        return false;
    }

    public void addMunger(ShadowMunger munger) {
        if (this.checkMunger(munger)) {
            if (this.mungers == Collections.EMPTY_LIST) {
                this.mungers = new ArrayList();
            }
            this.mungers.add(munger);
        }
    }

    public final void implement() {
        this.sortMungers();
        if (this.mungers == null) {
            return;
        }
        this.prepareForMungers();
        this.implementMungers();
    }

    private void sortMungers() {
        List sorted = PartialOrder.sort(this.mungers);
        this.possiblyReportUnorderedAdvice(sorted);
        if (sorted == null) {
            Iterator i = this.mungers.iterator();
            while (i.hasNext()) {
                ShadowMunger m = (ShadowMunger)i.next();
                this.getIWorld().getMessageHandler().handleMessage(MessageUtil.error(WeaverMessages.format("circularDependency", this), m.getSourceLocation()));
            }
        }
        this.mungers = sorted;
    }

    private void possiblyReportUnorderedAdvice(List sorted) {
        if (sorted != null && this.getIWorld().getLint().unorderedAdviceAtShadow.isEnabled() && this.mungers.size() > 1) {
            HashSet<String> clashingAspects = new HashSet<String>();
            int max = this.mungers.size();
            for (int i = max - 1; i >= 0; --i) {
                for (int j = 0; j < i; ++j) {
                    Integer order;
                    Object a = this.mungers.get(i);
                    Object b = this.mungers.get(j);
                    if (!(a instanceof BcelAdvice) || !(b instanceof BcelAdvice)) continue;
                    BcelAdvice adviceA = (BcelAdvice)a;
                    BcelAdvice adviceB = (BcelAdvice)b;
                    if (adviceA.concreteAspect.equals(adviceB.concreteAspect)) continue;
                    AdviceKind adviceKindA = adviceA.getKind();
                    AdviceKind adviceKindB = adviceB.getKind();
                    if (adviceKindA.getKey() >= 6 || adviceKindB.getKey() >= 6 || adviceKindA.getPrecedence() != adviceKindB.getPrecedence() || (order = this.getIWorld().getPrecedenceIfAny(adviceA.concreteAspect, adviceB.concreteAspect)) == null || !order.equals(new Integer(0))) continue;
                    String key = adviceA.getDeclaringAspect() + ":" + adviceB.getDeclaringAspect();
                    String possibleExistingKey = adviceB.getDeclaringAspect() + ":" + adviceA.getDeclaringAspect();
                    if (clashingAspects.contains(possibleExistingKey)) continue;
                    clashingAspects.add(key);
                }
            }
            Iterator iter = clashingAspects.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                String aspect1 = element.substring(0, element.indexOf(":"));
                String aspect2 = element.substring(element.indexOf(":") + 1);
                this.getIWorld().getLint().unorderedAdviceAtShadow.signal(new String[]{this.toString(), aspect1, aspect2}, this.getSourceLocation(), null);
            }
        }
    }

    protected void prepareForMungers() {
        throw new RuntimeException("Generic shadows cannot be prepared");
    }

    private String beautifyLocation(ISourceLocation isl) {
        StringBuffer nice = new StringBuffer();
        if (isl == null || isl.getSourceFile() == null || isl.getSourceFile().getName().indexOf("no debug info available") != -1) {
            nice.append("no debug info available");
        } else {
            int takeFrom = isl.getSourceFile().getPath().lastIndexOf(47);
            if (takeFrom == -1) {
                takeFrom = isl.getSourceFile().getPath().lastIndexOf(92);
            }
            nice.append(isl.getSourceFile().getPath().substring(takeFrom + 1));
            if (isl.getLine() != 0) {
                nice.append(":").append(isl.getLine());
            }
        }
        return nice.toString();
    }

    private void reportWeavingMessage(ShadowMunger munger) {
        Advice advice = (Advice)munger;
        AdviceKind aKind = advice.getKind();
        if (aKind == null || advice.getConcreteAspect() == null) {
            return;
        }
        if (!(aKind.equals(AdviceKind.Before) || aKind.equals(AdviceKind.After) || aKind.equals(AdviceKind.AfterReturning) || aKind.equals(AdviceKind.AfterThrowing) || aKind.equals(AdviceKind.Around) || aKind.equals(AdviceKind.Softener))) {
            return;
        }
        String description = advice.getKind().toString();
        String advisedType = this.getEnclosingType().getName();
        String advisingType = advice.getConcreteAspect().getName();
        WeaveMessage msg = null;
        if (advice.getKind().equals(AdviceKind.Softener)) {
            msg = WeaveMessage.constructWeavingMessage(WeaveMessage.WEAVEMESSAGE_SOFTENS, new String[]{advisedType, this.beautifyLocation(this.getSourceLocation()), advisingType, this.beautifyLocation(munger.getSourceLocation())}, advisedType, advisingType);
        } else {
            boolean runtimeTest = ((BcelAdvice)advice).hasDynamicTests();
            String joinPointDescription = this.toString();
            msg = WeaveMessage.constructWeavingMessage(WeaveMessage.WEAVEMESSAGE_ADVISES, new String[]{joinPointDescription, advisedType, this.beautifyLocation(this.getSourceLocation()), description, advisingType, this.beautifyLocation(munger.getSourceLocation()), runtimeTest ? " [with runtime test]" : ""}, advisedType, advisingType);
        }
        this.getIWorld().getMessageHandler().handleMessage(msg);
    }

    public IRelationship.Kind determineRelKind(ShadowMunger munger) {
        AdviceKind ak = ((Advice)munger).getKind();
        if (ak.getKey() == AdviceKind.Before.getKey()) {
            return IRelationship.Kind.ADVICE_BEFORE;
        }
        if (ak.getKey() == AdviceKind.After.getKey()) {
            return IRelationship.Kind.ADVICE_AFTER;
        }
        if (ak.getKey() == AdviceKind.AfterThrowing.getKey()) {
            return IRelationship.Kind.ADVICE_AFTERTHROWING;
        }
        if (ak.getKey() == AdviceKind.AfterReturning.getKey()) {
            return IRelationship.Kind.ADVICE_AFTERRETURNING;
        }
        if (ak.getKey() == AdviceKind.Around.getKey()) {
            return IRelationship.Kind.ADVICE_AROUND;
        }
        if (ak.getKey() == AdviceKind.CflowEntry.getKey() || ak.getKey() == AdviceKind.CflowBelowEntry.getKey() || ak.getKey() == AdviceKind.InterInitializer.getKey() || ak.getKey() == AdviceKind.PerCflowEntry.getKey() || ak.getKey() == AdviceKind.PerCflowBelowEntry.getKey() || ak.getKey() == AdviceKind.PerThisEntry.getKey() || ak.getKey() == AdviceKind.PerTargetEntry.getKey() || ak.getKey() == AdviceKind.Softener.getKey() || ak.getKey() == AdviceKind.PerTypeWithinEntry.getKey()) {
            return null;
        }
        throw new RuntimeException("Shadow.determineRelKind: What the hell is it? " + ak);
    }

    private void implementMungers() {
        World world = this.getIWorld();
        Iterator iter = this.mungers.iterator();
        while (iter.hasNext()) {
            ShadowMunger munger = (ShadowMunger)iter.next();
            munger.implementOn(this);
            if (world.getCrossReferenceHandler() != null) {
                world.getCrossReferenceHandler().addCrossReference(munger.getSourceLocation(), this.getSourceLocation(), this.determineRelKind(munger), ((BcelAdvice)munger).hasDynamicTests());
            }
            if (!this.getIWorld().getMessageHandler().isIgnoring(IMessage.WEAVEINFO)) {
                this.reportWeavingMessage(munger);
            }
            if (world.getModel() == null) continue;
            AsmRelationshipProvider.getDefault().adviceMunger(world.getModel(), this, munger);
        }
    }

    public String makeReflectiveFactoryString() {
        return null;
    }

    public abstract ISourceLocation getSourceLocation();

    public String toString() {
        return this.getKind() + "(" + this.getSignature() + ")";
    }

    public String toResolvedString(World world) {
        return this.getKind() + "(" + world.resolve(this.getSignature()).toGenericString() + ")";
    }

    public static Set toSet(int i) {
        HashSet<Kind> results = new HashSet<Kind>();
        for (int j = 0; j < SHADOW_KINDS.length; ++j) {
            Kind k = SHADOW_KINDS[j];
            if (!k.isSet(i)) continue;
            results.add(k);
        }
        return results;
    }

    public static final class Kind
    extends TypeSafeEnum {
        public int bit;
        private static final int hasReturnValueFlag = 558;
        private static final int isEnclosingKindFlag = 1688;
        private static final int isTargetSameAsThisFlag = 1944;
        private static final int neverHasTargetFlag = 2436;
        private static final int neverHasThisFlag = 384;

        public Kind(String name, int key, boolean argsOnStack) {
            super(name, key);
            this.bit = 1 << key;
        }

        public String toLegalJavaIdentifier() {
            return this.getName().replace('-', '_');
        }

        public boolean argsOnStack() {
            return !this.isTargetSameAsThis();
        }

        public boolean allowsExtraction() {
            return true;
        }

        public boolean isSet(int i) {
            return (i & this.bit) != 0;
        }

        public boolean hasHighPriorityExceptions() {
            return !this.isTargetSameAsThis();
        }

        public boolean hasReturnValue() {
            return (this.bit & 0x22E) != 0;
        }

        public boolean isEnclosingKind() {
            return (this.bit & 0x698) != 0;
        }

        public boolean isTargetSameAsThis() {
            return (this.bit & 0x798) != 0;
        }

        public boolean neverHasTarget() {
            return (this.bit & 0x984) != 0;
        }

        public boolean neverHasThis() {
            return (this.bit & 0x180) != 0;
        }

        public String getSimpleName() {
            int dash = this.getName().lastIndexOf(45);
            if (dash == -1) {
                return this.getName();
            }
            return this.getName().substring(dash + 1);
        }

        public static Kind read(DataInputStream s) throws IOException {
            byte key = s.readByte();
            switch (key) {
                case 1: {
                    return MethodCall;
                }
                case 2: {
                    return ConstructorCall;
                }
                case 3: {
                    return MethodExecution;
                }
                case 4: {
                    return ConstructorExecution;
                }
                case 5: {
                    return FieldGet;
                }
                case 6: {
                    return FieldSet;
                }
                case 7: {
                    return StaticInitialization;
                }
                case 8: {
                    return PreInitialization;
                }
                case 9: {
                    return AdviceExecution;
                }
                case 10: {
                    return Initialization;
                }
                case 11: {
                    return ExceptionHandler;
                }
            }
            throw new BCException("unknown kind: " + key);
        }
    }
}

