/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.aspectj.util.TypeSafeEnum;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

public interface Member {
    public static final Member[] NONE = new Member[0];
    public static final Kind METHOD = new Kind("METHOD", 1);
    public static final Kind FIELD = new Kind("FIELD", 2);
    public static final Kind CONSTRUCTOR = new Kind("CONSTRUCTOR", 3);
    public static final Kind STATIC_INITIALIZATION = new Kind("STATIC_INITIALIZATION", 4);
    public static final Kind POINTCUT = new Kind("POINTCUT", 5);
    public static final Kind ADVICE = new Kind("ADVICE", 6);
    public static final Kind HANDLER = new Kind("HANDLER", 7);

    public ResolvedMember resolve(World var1);

    public int compareTo(Object var1);

    public String toLongString();

    public Kind getKind();

    public UnresolvedType getDeclaringType();

    public UnresolvedType getReturnType();

    public UnresolvedType getGenericReturnType();

    public UnresolvedType getType();

    public String getName();

    public UnresolvedType[] getParameterTypes();

    public String getSignature();

    public Iterator getJoinPointSignatures(World var1);

    public int getArity();

    public String getParameterSignature();

    public boolean isCompatibleWith(Member var1);

    public int getModifiers(World var1);

    public int getModifiers();

    public UnresolvedType[] getExceptions(World var1);

    public boolean isProtected(World var1);

    public boolean isStatic(World var1);

    public boolean isStrict(World var1);

    public boolean isStatic();

    public boolean isInterface();

    public boolean isPrivate();

    public boolean canBeParameterized();

    public int getCallsiteModifiers();

    public String getExtractableName();

    public boolean hasAnnotation(UnresolvedType var1);

    public ResolvedType[] getAnnotationTypes();

    public AnnotationX[] getAnnotations();

    public Collection getDeclaringTypes(World var1);

    public String getSignatureMakerName();

    public String getSignatureType();

    public String getSignatureString(World var1);

    public String[] getParameterNames(World var1);

    public static class Kind
    extends TypeSafeEnum {
        public Kind(String name, int key) {
            super(name, key);
        }

        public static Kind read(DataInputStream s) throws IOException {
            byte key = s.readByte();
            switch (key) {
                case 1: {
                    return METHOD;
                }
                case 2: {
                    return FIELD;
                }
                case 3: {
                    return CONSTRUCTOR;
                }
                case 4: {
                    return STATIC_INITIALIZATION;
                }
                case 5: {
                    return POINTCUT;
                }
                case 6: {
                    return ADVICE;
                }
                case 7: {
                    return HANDLER;
                }
            }
            throw new BCException("weird kind " + key);
        }
    }
}

