/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.weaver.CrosscuttingMembers;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.CflowPointcut;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.IVerificationRequired;

public class CrosscuttingMembersSet {
    private World world;
    private Map members = new HashMap();
    private List shadowMungers = null;
    private List typeMungers = null;
    private List lateTypeMungers = null;
    private List declareSofts = null;
    private List declareParents = null;
    private List declareAnnotationOnTypes = null;
    private List declareAnnotationOnFields = null;
    private List declareAnnotationOnMethods = null;
    private List declareDominates = null;
    private boolean changedSinceLastReset = false;
    private List verificationList = null;

    public CrosscuttingMembersSet(World world) {
        this.world = world;
    }

    public boolean addOrReplaceAspect(ResolvedType aspectType) {
        return this.addOrReplaceAspect(aspectType, true);
    }

    public boolean addOrReplaceAspect(ResolvedType aspectType, boolean careAboutShadowMungers) {
        boolean change = false;
        CrosscuttingMembers xcut = (CrosscuttingMembers)this.members.get(aspectType);
        if (xcut == null) {
            this.members.put(aspectType, aspectType.collectCrosscuttingMembers());
            this.clearCaches();
            CflowPointcut.clearCaches(aspectType);
            change = true;
        } else if (xcut.replaceWith(aspectType.collectCrosscuttingMembers(), careAboutShadowMungers)) {
            this.clearCaches();
            CflowPointcut.clearCaches(aspectType);
            change = true;
        } else {
            if (careAboutShadowMungers) {
                this.shadowMungers = null;
            }
            change = false;
        }
        if (aspectType.isAbstract()) {
            boolean ancestorChange = this.addOrReplaceDescendantsOf(aspectType, careAboutShadowMungers);
            change = change || ancestorChange;
        }
        this.changedSinceLastReset = this.changedSinceLastReset || change;
        return change;
    }

    private boolean addOrReplaceDescendantsOf(ResolvedType aspectType, boolean careAboutShadowMungers) {
        Set knownAspects = this.members.keySet();
        HashSet<ResolvedType> toBeReplaced = new HashSet<ResolvedType>();
        Iterator it = knownAspects.iterator();
        while (it.hasNext()) {
            ResolvedType candidateDescendant = (ResolvedType)it.next();
            if (candidateDescendant == aspectType || !aspectType.isAssignableFrom(candidateDescendant)) continue;
            toBeReplaced.add(candidateDescendant);
        }
        boolean change = false;
        Iterator it2 = toBeReplaced.iterator();
        while (it2.hasNext()) {
            ResolvedType next = (ResolvedType)it2.next();
            boolean thisChange = this.addOrReplaceAspect(next, careAboutShadowMungers);
            change = change || thisChange;
        }
        return change;
    }

    public void addAdviceLikeDeclares(ResolvedType aspectType) {
        CrosscuttingMembers xcut = (CrosscuttingMembers)this.members.get(aspectType);
        xcut.addDeclares(aspectType.collectDeclares(true));
    }

    public boolean deleteAspect(UnresolvedType aspectType) {
        boolean isAspect = this.members.remove(aspectType) != null;
        this.clearCaches();
        return isAspect;
    }

    public boolean containsAspect(UnresolvedType aspectType) {
        return this.members.containsKey(aspectType);
    }

    public void addFixedCrosscuttingMembers(ResolvedType aspectType) {
        this.members.put(aspectType, aspectType.crosscuttingMembers);
        this.clearCaches();
    }

    private void clearCaches() {
        this.shadowMungers = null;
        this.typeMungers = null;
        this.lateTypeMungers = null;
        this.declareSofts = null;
        this.declareParents = null;
        this.declareAnnotationOnFields = null;
        this.declareAnnotationOnMethods = null;
        this.declareAnnotationOnTypes = null;
        this.declareDominates = null;
    }

    public List getShadowMungers() {
        if (this.shadowMungers == null) {
            ArrayList ret = new ArrayList();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getShadowMungers());
            }
            this.shadowMungers = ret;
        }
        return this.shadowMungers;
    }

    public List getTypeMungers() {
        if (this.typeMungers == null) {
            ArrayList ret = new ArrayList();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getTypeMungers());
            }
            this.typeMungers = ret;
        }
        return this.typeMungers;
    }

    public List getLateTypeMungers() {
        if (this.lateTypeMungers == null) {
            ArrayList ret = new ArrayList();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getLateTypeMungers());
            }
            this.lateTypeMungers = ret;
        }
        return this.lateTypeMungers;
    }

    public List getDeclareSofts() {
        if (this.declareSofts == null) {
            HashSet ret = new HashSet();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getDeclareSofts());
            }
            this.declareSofts = new ArrayList();
            this.declareSofts.addAll(ret);
        }
        return this.declareSofts;
    }

    public List getDeclareParents() {
        if (this.declareParents == null) {
            HashSet ret = new HashSet();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getDeclareParents());
            }
            this.declareParents = new ArrayList();
            this.declareParents.addAll(ret);
        }
        return this.declareParents;
    }

    public List getDeclareAnnotationOnTypes() {
        if (this.declareAnnotationOnTypes == null) {
            HashSet ret = new HashSet();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getDeclareAnnotationOnTypes());
            }
            this.declareAnnotationOnTypes = new ArrayList();
            this.declareAnnotationOnTypes.addAll(ret);
        }
        return this.declareAnnotationOnTypes;
    }

    public List getDeclareAnnotationOnFields() {
        if (this.declareAnnotationOnFields == null) {
            HashSet ret = new HashSet();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getDeclareAnnotationOnFields());
            }
            this.declareAnnotationOnFields = new ArrayList();
            this.declareAnnotationOnFields.addAll(ret);
        }
        return this.declareAnnotationOnFields;
    }

    public List getDeclareAnnotationOnMethods() {
        if (this.declareAnnotationOnMethods == null) {
            HashSet ret = new HashSet();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getDeclareAnnotationOnMethods());
            }
            this.declareAnnotationOnMethods = new ArrayList();
            this.declareAnnotationOnMethods.addAll(ret);
        }
        return this.declareAnnotationOnMethods;
    }

    public List getDeclareDominates() {
        if (this.declareDominates == null) {
            ArrayList ret = new ArrayList();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getDeclareDominates());
            }
            this.declareDominates = ret;
        }
        return this.declareDominates;
    }

    public ResolvedType findAspectDeclaringParents(DeclareParents p) {
        Set keys = this.members.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            ResolvedType element = (ResolvedType)iter.next();
            Iterator i = ((CrosscuttingMembers)this.members.get(element)).getDeclareParents().iterator();
            while (i.hasNext()) {
                DeclareParents dp = (DeclareParents)i.next();
                if (!dp.equals(p)) continue;
                return element;
            }
        }
        return null;
    }

    public void reset() {
        this.verificationList = null;
        this.changedSinceLastReset = false;
    }

    public boolean hasChangedSinceLastReset() {
        return this.changedSinceLastReset;
    }

    public void recordNecessaryCheck(IVerificationRequired verification) {
        if (this.verificationList == null) {
            this.verificationList = new ArrayList();
        }
        this.verificationList.add(verification);
    }

    public void verify() {
        if (this.verificationList == null) {
            return;
        }
        Iterator iter = this.verificationList.iterator();
        while (iter.hasNext()) {
            IVerificationRequired element = (IVerificationRequired)iter.next();
            element.verify();
        }
        this.verificationList = null;
    }
}

