/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.aspectj.ajdt.internal.compiler.lookup.OwningClassSupportForMethodBindings;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.IAttribute;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Messages;
import org.aspectj.runtime.internal.AroundClosure;

public class ClassFile
implements AttributeNamesConstants,
CompilerModifiers,
TypeConstants,
TypeIds {
    public static final int INITIAL_CONTENTS_SIZE = 400;
    public static final int INITIAL_HEADER_SIZE = 1500;
    public static final int INNER_CLASSES_SIZE = 5;
    public CodeStream codeStream;
    public ConstantPool constantPool;
    public int constantPoolOffset;
    public byte[] contents;
    public int contentsOffset;
    protected boolean creatingProblemType;
    public ClassFile enclosingClassFile;
    public byte[] header;
    public int headerOffset;
    public ReferenceBinding[] innerClassesBindings;
    public int methodCount;
    public int methodCountOffset;
    public int numberOfInnerClasses;
    public boolean ownSharedArrays = false;
    public int produceDebugAttributes;
    public SourceTypeBinding referenceBinding;
    public long targetJDK;
    public List extraAttributes = new ArrayList(1);

    public static String buildAllDirectoriesInto(String outputPath, String relativeFileName) throws IOException {
        File f;
        char fileSeparatorChar = File.separatorChar;
        String fileSeparator = File.separator;
        if ((outputPath = outputPath.replace('/', fileSeparatorChar)).endsWith(fileSeparator)) {
            outputPath = outputPath.substring(0, outputPath.length() - 1);
        }
        if ((f = new File(outputPath)).exists()) {
            if (!f.isDirectory()) {
                System.out.println(Messages.bind(Messages.output_isFile, f.getAbsolutePath()));
                throw new IOException(Messages.output_isFileNotDirectory);
            }
        } else if (!f.mkdirs()) {
            System.out.println(Messages.bind(Messages.output_dirName, f.getAbsolutePath()));
            throw new IOException(Messages.output_notValidAll);
        }
        StringBuffer outDir = new StringBuffer(outputPath);
        outDir.append(fileSeparator);
        StringTokenizer tokenizer = new StringTokenizer(relativeFileName, fileSeparator);
        String token = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            f = new File(outDir.append(token).append(fileSeparator).toString());
            if (!f.exists() && !f.mkdir()) {
                System.out.println(Messages.bind(Messages.output_fileName, f.getName()));
                throw new IOException(Messages.output_notValid);
            }
            token = tokenizer.nextToken();
        }
        return outDir.append(token).toString();
    }

    public static void createProblemType(TypeDeclaration typeDeclaration, CompilationResult unitResult) {
        int max;
        int i;
        FieldBinding[] fields;
        SourceTypeBinding typeBinding = typeDeclaration.binding;
        ClassFile classFile = new ClassFile(typeBinding, null, true);
        if (typeBinding.isMemberType()) {
            classFile.recordEnclosingTypeAttributes(typeBinding);
        }
        if ((fields = typeBinding.fields) != null && fields != TypeConstants.NoFields) {
            int i2 = 0;
            int max2 = fields.length;
            while (i2 < max2) {
                if (fields[i2].constant() == null) {
                    FieldReference.getConstantFor(fields[i2], null, false, null);
                }
                ++i2;
            }
            classFile.addFieldInfos();
        } else {
            classFile.contents[classFile.contentsOffset++] = 0;
            classFile.contents[classFile.contentsOffset++] = 0;
        }
        classFile.setForMethodInfos();
        MethodBinding[] methods = typeBinding.methods;
        AbstractMethodDeclaration[] methodDeclarations = typeDeclaration.methods;
        int maxMethodDecl = methodDeclarations == null ? 0 : methodDeclarations.length;
        IProblem[] problems = unitResult.getErrors();
        if (problems == null) {
            problems = new IProblem[]{};
        }
        int problemsLength = problems.length;
        IProblem[] problemsCopy = new IProblem[problemsLength];
        System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
        if (methods != null) {
            int j;
            MethodBinding methodBinding;
            if (typeBinding.isInterface()) {
                classFile.addProblemClinit(problemsCopy);
                i = 0;
                max = methods.length;
                while (i < max) {
                    methodBinding = methods[i];
                    if (methodBinding != null) {
                        j = 0;
                        while (j < maxMethodDecl) {
                            if (methodDeclarations[j] != null && methodDeclarations[j].binding == methods[i]) {
                                if (methodBinding.isConstructor()) break;
                                classFile.addAbstractMethod(methodDeclarations[j], methodBinding);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                i = 0;
                max = methods.length;
                while (i < max) {
                    methodBinding = methods[i];
                    if (methodBinding != null) {
                        j = 0;
                        while (j < maxMethodDecl) {
                            if (methodDeclarations[j] != null && methodDeclarations[j].binding == methods[i]) {
                                AbstractMethodDeclaration methodDecl = methodDeclarations[j];
                                if (methodDecl.isConstructor()) {
                                    classFile.addProblemConstructor(methodDecl, methodBinding, problemsCopy);
                                    break;
                                }
                                classFile.addProblemMethod(methodDecl, methodBinding, problemsCopy);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            classFile.addDefaultAbstractMethods();
        }
        if (typeDeclaration.memberTypes != null) {
            i = 0;
            max = typeDeclaration.memberTypes.length;
            while (i < max) {
                TypeDeclaration memberType = typeDeclaration.memberTypes[i];
                if (memberType.binding != null) {
                    classFile.recordNestedMemberAttribute(memberType.binding);
                    ClassFile.createProblemType(memberType, unitResult);
                }
                ++i;
            }
        }
        classFile.addAttributes();
        unitResult.record(typeBinding.constantPoolName(), classFile);
    }

    public static final int searchLineNumber(int[] startLineIndexes, int position) {
        int length = startLineIndexes.length;
        if (length == 0) {
            return 1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = (g + d) / 2;
            if (position < startLineIndexes[m]) {
                d = m - 1;
                continue;
            }
            if (position > startLineIndexes[m]) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < startLineIndexes[m]) {
            return m + 1;
        }
        return m + 2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeToDisk(boolean generatePackagesStructure, String outputPath, String relativeFileName, byte[] contents) throws IOException {
        Object var5_5;
        BufferedOutputStream output = null;
        if (generatePackagesStructure) {
            output = new BufferedOutputStream(new FileOutputStream(new File(ClassFile.buildAllDirectoriesInto(outputPath, relativeFileName))));
        } else {
            String fileName = null;
            char fileSeparatorChar = File.separatorChar;
            String fileSeparator = File.separator;
            outputPath = outputPath.replace('/', fileSeparatorChar);
            int indexOfPackageSeparator = relativeFileName.lastIndexOf(fileSeparatorChar);
            if (indexOfPackageSeparator == -1) {
                fileName = outputPath.endsWith(fileSeparator) ? String.valueOf(outputPath) + relativeFileName : String.valueOf(outputPath) + fileSeparator + relativeFileName;
            } else {
                int length = relativeFileName.length();
                fileName = outputPath.endsWith(fileSeparator) ? String.valueOf(outputPath) + relativeFileName.substring(indexOfPackageSeparator + 1, length) : String.valueOf(outputPath) + fileSeparator + relativeFileName.substring(indexOfPackageSeparator + 1, length);
            }
            output = new BufferedOutputStream(new FileOutputStream(new File(fileName)));
        }
        try {
            output.write(contents);
        }
        catch (Throwable throwable) {
            var5_5 = null;
            output.flush();
            output.close();
            throw throwable;
        }
        {
            var5_5 = null;
        }
        output.flush();
        output.close();
    }

    public ClassFile() {
    }

    public ClassFile(SourceTypeBinding aType, ClassFile enclosingClassFile, boolean creatingProblemType) {
        this.referenceBinding = aType;
        this.initByteArrays();
        this.header[this.headerOffset++] = -54;
        this.header[this.headerOffset++] = -2;
        this.header[this.headerOffset++] = -70;
        this.header[this.headerOffset++] = -66;
        CompilerOptions options = aType.scope.compilerOptions();
        this.targetJDK = options.targetJDK;
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 8);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 0);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 24);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 16);
        this.constantPoolOffset = this.headerOffset;
        this.headerOffset += 2;
        this.constantPool = new ConstantPool(this);
        int accessFlags = aType.getAccessFlags();
        if (aType.isPrivate()) {
            accessFlags &= 0xFFFFFFFE;
        }
        if (aType.isProtected()) {
            accessFlags |= 1;
        }
        accessFlags &= 0xFFFFF6D1;
        if (!aType.isInterface()) {
            accessFlags |= 0x20;
        }
        this.enclosingClassFile = enclosingClassFile;
        this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
        this.contents[this.contentsOffset++] = (byte)accessFlags;
        int classNameIndex = this.constantPool.literalIndexForType(aType.constantPoolName());
        this.contents[this.contentsOffset++] = (byte)(classNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)classNameIndex;
        ReferenceBinding superclass = null;
        superclass = aType.originalSuperclass != null ? aType.originalSuperclass : aType.superclass;
        int superclassNameIndex = aType.isInterface() ? this.constantPool.literalIndexForType(ConstantPool.JavaLangObjectConstantPoolName) : (superclass == null ? 0 : this.constantPool.literalIndexForType(superclass.constantPoolName()));
        this.contents[this.contentsOffset++] = (byte)(superclassNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)superclassNameIndex;
        ReferenceBinding[] superInterfacesBinding = null;
        superInterfacesBinding = aType.originalSuperInterfaces != null ? aType.originalSuperInterfaces : aType.superInterfaces();
        int interfacesCount = superInterfacesBinding.length;
        this.contents[this.contentsOffset++] = (byte)(interfacesCount >> 8);
        this.contents[this.contentsOffset++] = (byte)interfacesCount;
        int i = 0;
        while (i < interfacesCount) {
            int interfaceIndex = this.constantPool.literalIndexForType(superInterfacesBinding[i].constantPoolName());
            this.contents[this.contentsOffset++] = (byte)(interfaceIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)interfaceIndex;
            ++i;
        }
        this.produceDebugAttributes = options.produceDebugAttributes;
        this.innerClassesBindings = new ReferenceBinding[5];
        this.creatingProblemType = creatingProblemType;
        this.codeStream = new CodeStream(this, this.targetJDK);
        ClassFile outermostClassFile = this.outerMostEnclosingClassFile();
        this.codeStream.maxFieldCount = this == outermostClassFile ? aType.scope.referenceType().maxFieldCount : outermostClassFile.codeStream.maxFieldCount;
    }

    public void addAbstractMethod(AbstractMethodDeclaration method, MethodBinding methodBinding) {
        methodBinding.modifiers = 1025;
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        this.completeMethodInfo(methodAttributeOffset, attributeNumber);
    }

    public void addAttributes() {
        TypeDeclaration typeDeclaration;
        char[] genericSignature;
        this.contents[this.methodCountOffset++] = (byte)(this.methodCount >> 8);
        this.contents[this.methodCountOffset] = (byte)this.methodCount;
        int attributeNumber = 0;
        int attributeOffset = this.contentsOffset;
        this.contentsOffset += 2;
        if ((this.produceDebugAttributes & 1) != 0) {
            String fullFileName = new String(this.referenceBinding.scope.referenceCompilationUnit().getFileName());
            int lastIndex = (fullFileName = fullFileName.replace('\\', '/')).lastIndexOf(47);
            if (lastIndex != -1) {
                fullFileName = fullFileName.substring(lastIndex + 1, fullFileName.length());
            }
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int sourceAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SourceName);
            this.contents[this.contentsOffset++] = (byte)(sourceAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)sourceAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            int fileNameIndex = this.constantPool.literalIndex(fullFileName.toCharArray());
            this.contents[this.contentsOffset++] = (byte)(fileNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)fileNameIndex;
            ++attributeNumber;
        }
        if (this.referenceBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int deprecatedAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(deprecatedAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)deprecatedAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributeNumber;
        }
        if (this.numberOfInnerClasses != 0) {
            int exSize = 8 * this.numberOfInnerClasses + 8;
            if (exSize + this.contentsOffset >= this.contents.length) {
                this.resizeContents(exSize);
            }
            int attributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.InnerClassName);
            this.contents[this.contentsOffset++] = (byte)(attributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)attributeNameIndex;
            int value = (this.numberOfInnerClasses << 3) + 2;
            this.contents[this.contentsOffset++] = (byte)(value >> 24);
            this.contents[this.contentsOffset++] = (byte)(value >> 16);
            this.contents[this.contentsOffset++] = (byte)(value >> 8);
            this.contents[this.contentsOffset++] = (byte)value;
            this.contents[this.contentsOffset++] = (byte)(this.numberOfInnerClasses >> 8);
            this.contents[this.contentsOffset++] = (byte)this.numberOfInnerClasses;
            int i = 0;
            while (i < this.numberOfInnerClasses) {
                ReferenceBinding innerClass = this.innerClassesBindings[i];
                int accessFlags = innerClass.getAccessFlags();
                int innerClassIndex = this.constantPool.literalIndexForType(innerClass.constantPoolName());
                this.contents[this.contentsOffset++] = (byte)(innerClassIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)innerClassIndex;
                if (innerClass.isMemberType()) {
                    int outerClassIndex = this.constantPool.literalIndexForType(innerClass.enclosingType().constantPoolName());
                    this.contents[this.contentsOffset++] = (byte)(outerClassIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)outerClassIndex;
                } else {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                }
                if (!innerClass.isAnonymousType()) {
                    int nameIndex = this.constantPool.literalIndex(innerClass.sourceName());
                    this.contents[this.contentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)nameIndex;
                } else {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                }
                if (innerClass.isAnonymousType()) {
                    accessFlags |= 2;
                } else if (innerClass.isLocalType() && !innerClass.isMemberType()) {
                    accessFlags |= 2;
                } else if (innerClass.isMemberType() && innerClass.isInterface()) {
                    accessFlags |= 8;
                }
                this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
                this.contents[this.contentsOffset++] = (byte)accessFlags;
                ++i;
            }
            ++attributeNumber;
        }
        if ((genericSignature = this.referenceBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int signatureAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(signatureAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)signatureAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            int signatureIndex = this.constantPool.literalIndex(genericSignature);
            this.contents[this.contentsOffset++] = (byte)(signatureIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)signatureIndex;
            ++attributeNumber;
        }
        if (this.targetJDK >= 0x310000L && this.referenceBinding.isNestedType() && !this.referenceBinding.isMemberType()) {
            MethodBinding methodBinding;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            int enclosingMethodAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.EnclosingMethodName);
            this.contents[this.contentsOffset++] = (byte)(enclosingMethodAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)enclosingMethodAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 4;
            int enclosingTypeIndex = this.constantPool.literalIndexForType(this.referenceBinding.enclosingType().constantPoolName());
            this.contents[this.contentsOffset++] = (byte)(enclosingTypeIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)enclosingTypeIndex;
            byte methodIndexByte1 = 0;
            byte methodIndexByte2 = 0;
            if (this.referenceBinding instanceof LocalTypeBinding && (methodBinding = ((LocalTypeBinding)this.referenceBinding).enclosingMethod) != null) {
                int enclosingMethodIndex = this.constantPool.literalIndexForMethod(methodBinding.selector, methodBinding.signature());
                methodIndexByte1 = (byte)(enclosingMethodIndex >> 8);
                methodIndexByte2 = (byte)enclosingMethodIndex;
            }
            this.contents[this.contentsOffset++] = methodIndexByte1;
            this.contents[this.contentsOffset++] = methodIndexByte2;
            ++attributeNumber;
        }
        if (this.targetJDK >= 0x310000L && !this.creatingProblemType && (typeDeclaration = this.referenceBinding.scope.referenceContext) != null) {
            Annotation[] annotations = typeDeclaration.originalAnnotations;
            if (annotations == null) {
                annotations = typeDeclaration.annotations;
            }
            if (annotations != null) {
                attributeNumber += this.generateRuntimeAnnotations(annotations);
            }
        }
        if (this.extraAttributes != null) {
            int i = 0;
            int len = this.extraAttributes.size();
            while (i < len) {
                IAttribute attribute = (IAttribute)this.extraAttributes.get(i);
                short nameIndex = (short)this.constantPool.literalIndex(attribute.getNameChars());
                this.writeToContents(attribute.getAllBytes(nameIndex));
                ++attributeNumber;
                ++i;
            }
        }
        if (attributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[attributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[attributeOffset] = (byte)attributeNumber;
        this.header = this.constantPool.poolContent;
        this.headerOffset = this.constantPool.currentOffset;
        int constantPoolCount = this.constantPool.currentIndex;
        this.header[this.constantPoolOffset++] = (byte)(constantPoolCount >> 8);
        this.header[this.constantPoolOffset] = (byte)constantPoolCount;
    }

    public void addDefaultAbstractMethods() {
        MethodBinding[] defaultAbstractMethods = this.referenceBinding.getDefaultAbstractMethods();
        int i = 0;
        int max = defaultAbstractMethods.length;
        while (i < max) {
            this.generateMethodInfoHeader(defaultAbstractMethods[i]);
            int methodAttributeOffset = this.contentsOffset;
            int attributeNumber = this.generateMethodInfoAttribute(defaultAbstractMethods[i]);
            this.completeMethodInfo(methodAttributeOffset, attributeNumber);
            ++i;
        }
    }

    private int addFieldAttributes(FieldBinding fieldBinding, int fieldAttributeOffset) {
        Annotation[] annotations;
        FieldDeclaration fieldDeclaration;
        char[] genericSignature;
        int attributesNumber = 0;
        if (fieldBinding.isConstantValue()) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int constantValueNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.ConstantValueName);
            this.contents[this.contentsOffset++] = (byte)(constantValueNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)constantValueNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            ++attributesNumber;
            Constant fieldConstant = fieldBinding.constant();
            switch (fieldConstant.typeID()) {
                case 5: {
                    int booleanValueIndex = this.constantPool.literalIndex(fieldConstant.booleanValue() ? 1 : 0);
                    this.contents[this.contentsOffset++] = (byte)(booleanValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)booleanValueIndex;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    int integerValueIndex = this.constantPool.literalIndex(fieldConstant.intValue());
                    this.contents[this.contentsOffset++] = (byte)(integerValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)integerValueIndex;
                    break;
                }
                case 9: {
                    int floatValueIndex = this.constantPool.literalIndex(fieldConstant.floatValue());
                    this.contents[this.contentsOffset++] = (byte)(floatValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)floatValueIndex;
                    break;
                }
                case 8: {
                    int doubleValueIndex = this.constantPool.literalIndex(fieldConstant.doubleValue());
                    this.contents[this.contentsOffset++] = (byte)(doubleValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)doubleValueIndex;
                    break;
                }
                case 7: {
                    int longValueIndex = this.constantPool.literalIndex(fieldConstant.longValue());
                    this.contents[this.contentsOffset++] = (byte)(longValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)longValueIndex;
                    break;
                }
                case 11: {
                    int stringValueIndex = this.constantPool.literalIndex(((StringConstant)fieldConstant).stringValue());
                    if (stringValueIndex == -1) {
                        if (!this.creatingProblemType) {
                            TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                            FieldDeclaration[] fieldDecls = typeDeclaration.fields;
                            int i = 0;
                            int max = fieldDecls.length;
                            while (i < max) {
                                if (fieldDecls[i].binding == fieldBinding) {
                                    typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(fieldDecls[i]);
                                }
                                ++i;
                            }
                            break;
                        }
                        this.contentsOffset = fieldAttributeOffset;
                        break;
                    }
                    this.contents[this.contentsOffset++] = (byte)(stringValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)stringValueIndex;
                }
            }
        }
        if (this.targetJDK < 0x310000L && fieldBinding.isSynthetic()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int syntheticAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
            this.contents[this.contentsOffset++] = (byte)(syntheticAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)syntheticAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributesNumber;
        }
        if (fieldBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int deprecatedAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(deprecatedAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)deprecatedAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributesNumber;
        }
        if ((genericSignature = fieldBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int signatureAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(signatureAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)signatureAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            int signatureIndex = this.constantPool.literalIndex(genericSignature);
            this.contents[this.contentsOffset++] = (byte)(signatureIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)signatureIndex;
            ++attributesNumber;
        }
        if (this.targetJDK >= 0x310000L && !this.creatingProblemType && (fieldDeclaration = fieldBinding.sourceField()) != null && (annotations = fieldDeclaration.annotations) != null) {
            attributesNumber += this.generateRuntimeAnnotations(annotations);
        }
        return attributesNumber;
    }

    private void addFieldInfo(FieldBinding fieldBinding) {
        if (this.contentsOffset + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int accessFlags = fieldBinding.getAccessFlags();
        if (this.targetJDK < 0x310000L) {
            accessFlags &= 0xFFFFEFFF;
        }
        this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
        this.contents[this.contentsOffset++] = (byte)accessFlags;
        int nameIndex = this.constantPool.literalIndex(fieldBinding.name);
        this.contents[this.contentsOffset++] = (byte)(nameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)nameIndex;
        int descriptorIndex = this.constantPool.literalIndex(fieldBinding.type.signature());
        this.contents[this.contentsOffset++] = (byte)(descriptorIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)descriptorIndex;
        int fieldAttributeOffset = this.contentsOffset;
        int attributeNumber = 0;
        this.contentsOffset += 2;
        attributeNumber += this.addFieldAttributes(fieldBinding, fieldAttributeOffset);
        this.contents[fieldAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[fieldAttributeOffset] = (byte)attributeNumber;
    }

    public void addFieldInfos() {
        SourceTypeBinding currentBinding = this.referenceBinding;
        FieldBinding[] syntheticFields = currentBinding.syntheticFields();
        int fieldCount = currentBinding.fieldCount() + (syntheticFields == null ? 0 : syntheticFields.length);
        if (fieldCount > 65535) {
            this.referenceBinding.scope.problemReporter().tooManyFields(this.referenceBinding.scope.referenceType());
        }
        this.contents[this.contentsOffset++] = (byte)(fieldCount >> 8);
        this.contents[this.contentsOffset++] = (byte)fieldCount;
        FieldBinding[] fieldBindings = currentBinding.fields();
        int i = 0;
        int max = fieldBindings.length;
        while (i < max) {
            this.addFieldInfo(fieldBindings[i]);
            ++i;
        }
        if (syntheticFields != null) {
            i = 0;
            max = syntheticFields.length;
            while (i < max) {
                this.addFieldInfo(syntheticFields[i]);
                ++i;
            }
        }
    }

    private void addInnerClasses(ReferenceBinding refBinding) {
        int i = 0;
        while (i < this.numberOfInnerClasses) {
            if (this.innerClassesBindings[i] == refBinding) {
                return;
            }
            ++i;
        }
        int length = this.innerClassesBindings.length;
        if (this.numberOfInnerClasses == length) {
            this.innerClassesBindings = new ReferenceBinding[length * 2];
            System.arraycopy(this.innerClassesBindings, 0, this.innerClassesBindings, 0, length);
        }
        this.innerClassesBindings[this.numberOfInnerClasses++] = refBinding;
    }

    private void addMissingAbstractProblemMethod(MethodDeclaration methodDeclaration, MethodBinding methodBinding, IProblem problem, CompilationResult compilationResult) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        ++attributeNumber;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("\t" + problem.getMessage() + "\n");
        buffer.insert(0, Messages.compilation_unresolvedProblem);
        String problemString = buffer.toString();
        this.codeStream.init(this);
        this.codeStream.preserveUnusedLocals = true;
        this.codeStream.initializeMaxLocals(methodBinding);
        this.codeStream.generateCodeAttributeForProblemMethod(problemString);
        this.completeCodeAttributeForMissingAbstractProblemMethod(methodBinding, codeAttributeOffset, compilationResult.lineSeparatorPositions, problem.getSourceLineNumber());
        this.completeMethodInfo(methodAttributeOffset, attributeNumber);
    }

    public void addProblemClinit(IProblem[] problems) {
        this.generateMethodInfoHeaderForClinit();
        this.contentsOffset -= 2;
        int attributeOffset = this.contentsOffset;
        this.contentsOffset += 2;
        int attributeNumber = 0;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.resetForProblemClinit(this);
        String problemString = "";
        int problemLine = 0;
        if (problems != null) {
            int max = problems.length;
            StringBuffer buffer = new StringBuffer(25);
            int count = 0;
            int i = 0;
            while (i < max) {
                IProblem problem = problems[i];
                if (problem != null && problem.isError()) {
                    buffer.append("\t" + problem.getMessage() + "\n");
                    ++count;
                    if (problemLine == 0) {
                        problemLine = problem.getSourceLineNumber();
                    }
                    problems[i] = null;
                }
                ++i;
            }
            if (count > 1) {
                buffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                buffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            problemString = buffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(problemString);
        this.completeCodeAttributeForClinit(codeAttributeOffset, this.referenceBinding.scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions, problemLine);
        this.contents[attributeOffset++] = (byte)(++attributeNumber >> 8);
        this.contents[attributeOffset] = (byte)attributeNumber;
    }

    public void addProblemConstructor(AbstractMethodDeclaration method, MethodBinding methodBinding, IProblem[] problems) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding, true);
        ++attributeNumber;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(method, this);
        String problemString = "";
        int problemLine = 0;
        if (problems != null) {
            int max = problems.length;
            StringBuffer buffer = new StringBuffer(25);
            int count = 0;
            int i = 0;
            while (i < max) {
                IProblem problem = problems[i];
                if (problem != null && problem.isError()) {
                    buffer.append("\t" + problem.getMessage() + "\n");
                    ++count;
                    if (problemLine == 0) {
                        problemLine = problem.getSourceLineNumber();
                    }
                }
                ++i;
            }
            if (count > 1) {
                buffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                buffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            problemString = buffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(problemString);
        MethodBinding methodBinding2 = methodBinding;
        this.completeCodeAttributeForProblemMethod(method, methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody1$advice((ClassFile)this, (MethodBinding)methodBinding2, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding2, null))).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions, problemLine);
        this.completeMethodInfo(methodAttributeOffset, attributeNumber);
    }

    public void addProblemConstructor(AbstractMethodDeclaration method, MethodBinding methodBinding, IProblem[] problems, int savedOffset) {
        this.contentsOffset = savedOffset;
        --this.methodCount;
        this.addProblemConstructor(method, methodBinding, problems);
    }

    public void addProblemMethod(AbstractMethodDeclaration method, MethodBinding methodBinding, IProblem[] problems) {
        MethodBinding methodBinding2;
        if (methodBinding.isAbstract() && ((ReferenceBinding)ClassFile.declaringClass_aroundBody3$advice(this, methodBinding2 = methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding2, null)).isInterface()) {
            method.abort(8, null);
        }
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding, true);
        ++attributeNumber;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(method, this);
        String problemString = "";
        int problemLine = 0;
        if (problems != null) {
            int max = problems.length;
            StringBuffer buffer = new StringBuffer(25);
            int count = 0;
            int i = 0;
            while (i < max) {
                IProblem problem = problems[i];
                if (problem != null && problem.isError() && problem.getSourceStart() >= method.declarationSourceStart && problem.getSourceEnd() <= method.declarationSourceEnd) {
                    buffer.append("\t" + problem.getMessage() + "\n");
                    ++count;
                    if (problemLine == 0) {
                        problemLine = problem.getSourceLineNumber();
                    }
                    problems[i] = null;
                }
                ++i;
            }
            if (count > 1) {
                buffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                buffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            problemString = buffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(problemString);
        MethodBinding methodBinding3 = methodBinding;
        this.completeCodeAttributeForProblemMethod(method, methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody5$advice((ClassFile)this, (MethodBinding)methodBinding3, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding3, null))).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions, problemLine);
        this.completeMethodInfo(methodAttributeOffset, attributeNumber);
    }

    public void addProblemMethod(AbstractMethodDeclaration method, MethodBinding methodBinding, IProblem[] problems, int savedOffset) {
        this.contentsOffset = savedOffset;
        --this.methodCount;
        this.addProblemMethod(method, methodBinding, problems);
    }

    public void addSpecialMethods() {
        this.generateMissingAbstractMethods(this.referenceBinding.scope.referenceType().missingAbstractMethods, this.referenceBinding.scope.referenceCompilationUnit().compilationResult);
        MethodBinding[] defaultAbstractMethods = this.referenceBinding.getDefaultAbstractMethods();
        int i = 0;
        int max = defaultAbstractMethods.length;
        while (i < max) {
            this.generateMethodInfoHeader(defaultAbstractMethods[i]);
            int methodAttributeOffset = this.contentsOffset;
            int attributeNumber = this.generateMethodInfoAttribute(defaultAbstractMethods[i]);
            this.completeMethodInfo(methodAttributeOffset, attributeNumber);
            ++i;
        }
        SyntheticMethodBinding[] syntheticMethods = this.referenceBinding.syntheticMethods();
        if (syntheticMethods != null) {
            int i2 = 0;
            int max2 = syntheticMethods.length;
            while (i2 < max2) {
                SyntheticMethodBinding syntheticMethod = syntheticMethods[i2];
                switch (syntheticMethod.kind) {
                    case 1: {
                        this.addSyntheticFieldReadAccessMethod(syntheticMethod);
                        break;
                    }
                    case 2: {
                        this.addSyntheticFieldWriteAccessMethod(syntheticMethod);
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        this.addSyntheticMethodAccessMethod(syntheticMethod);
                        break;
                    }
                    case 4: {
                        this.addSyntheticConstructorAccessMethod(syntheticMethod);
                        break;
                    }
                    case 7: {
                        this.addSyntheticEnumValuesMethod(syntheticMethod);
                        break;
                    }
                    case 8: {
                        this.addSyntheticEnumValueOfMethod(syntheticMethod);
                        break;
                    }
                    case 9: {
                        this.addSyntheticSwitchTable(syntheticMethod);
                    }
                }
                ++i2;
            }
        }
    }

    public void addSyntheticConstructorAccessMethod(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForConstructorAccess(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody7$advice((ClassFile)this, (MethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void addSyntheticEnumValueOfMethod(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValueOf(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody9$advice((ClassFile)this, (MethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void addSyntheticSwitchTable(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForSwitchTable(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(true, methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody11$advice((ClassFile)this, (MethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void addSyntheticEnumValuesMethod(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValues(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody13$advice((ClassFile)this, (MethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void addSyntheticFieldReadAccessMethod(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldReadAccess(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody15$advice((ClassFile)this, (MethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void addSyntheticFieldWriteAccessMethod(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldWriteAccess(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody17$advice((ClassFile)this, (MethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void addSyntheticMethodAccessMethod(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForMethodAccess(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody19$advice((ClassFile)this, (MethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void completeCodeAttribute(int codeAttributeOffset) {
        int i;
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int code_length = this.codeStream.position;
        if (code_length > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration);
        }
        if (localContentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        int exceptionHandlersNumber = this.codeStream.exceptionHandlersCounter;
        ExceptionLabel[] exceptionHandlers = this.codeStream.exceptionHandlers;
        int exSize = exceptionHandlersNumber * 8 + 2;
        if (exSize + localContentsOffset >= this.contents.length) {
            this.resizeContents(exSize);
        }
        this.contents[localContentsOffset++] = (byte)(exceptionHandlersNumber >> 8);
        this.contents[localContentsOffset++] = (byte)exceptionHandlersNumber;
        int i2 = 0;
        int max = this.codeStream.exceptionHandlersIndex;
        while (i2 < max) {
            ExceptionLabel exceptionHandler = exceptionHandlers[i2];
            if (exceptionHandler != null) {
                int start = exceptionHandler.start;
                this.contents[localContentsOffset++] = (byte)(start >> 8);
                this.contents[localContentsOffset++] = (byte)start;
                int end = exceptionHandler.end;
                this.contents[localContentsOffset++] = (byte)(end >> 8);
                this.contents[localContentsOffset++] = (byte)end;
                int handlerPC = exceptionHandler.position;
                this.contents[localContentsOffset++] = (byte)(handlerPC >> 8);
                this.contents[localContentsOffset++] = (byte)handlerPC;
                if (exceptionHandler.exceptionType == null) {
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                } else {
                    int nameIndex = exceptionHandler.exceptionType == BaseTypes.NullBinding ? this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : this.constantPool.literalIndexForType(exceptionHandler.exceptionType.constantPoolName());
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                }
            }
            ++i2;
        }
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        localContentsOffset += 2;
        if (this.codeStream.generateLineNumberAttributes) {
            int[] pcToSourceMapTable = this.codeStream.pcToSourceMap;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
                if (localContentsOffset + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
                int lineNumberTableOffset = localContentsOffset;
                localContentsOffset += 6;
                int numberOfEntries = 0;
                int length = this.codeStream.pcToSourceMapSize;
                i = 0;
                while (i < length) {
                    if (localContentsOffset + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    int pc = pcToSourceMapTable[i++];
                    this.contents[localContentsOffset++] = (byte)(pc >> 8);
                    this.contents[localContentsOffset++] = (byte)pc;
                    int lineNumber = pcToSourceMapTable[i++];
                    this.contents[localContentsOffset++] = (byte)(lineNumber >> 8);
                    this.contents[localContentsOffset++] = (byte)lineNumber;
                    ++numberOfEntries;
                }
                int lineNumberAttr_length = numberOfEntries * 4 + 2;
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 24);
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 16);
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 8);
                this.contents[lineNumberTableOffset++] = (byte)lineNumberAttr_length;
                this.contents[lineNumberTableOffset++] = (byte)(numberOfEntries >> 8);
                this.contents[lineNumberTableOffset++] = (byte)numberOfEntries;
                ++attributeNumber;
            }
        }
        if (this.codeStream.generateLocalVariableTableAttributes) {
            boolean currentInstanceIsGeneric;
            int resolvedPosition;
            int length;
            int endPC;
            int startPC;
            int j;
            int descriptorIndex;
            int nameIndex;
            int localVariableTableOffset = localContentsOffset;
            int numberOfEntries = 0;
            int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            boolean methodDeclarationIsStatic = this.codeStream.methodDeclaration.isStatic();
            int maxOfEntries = 8 + 10 * (methodDeclarationIsStatic ? 0 : 1);
            i = 0;
            while (i < this.codeStream.allLocalsCounter) {
                maxOfEntries += 10 * this.codeStream.locals[i].initializationCount;
                ++i;
            }
            if (localContentsOffset + maxOfEntries >= this.contents.length) {
                this.resizeContents(maxOfEntries);
            }
            this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
            localContentsOffset += 6;
            SourceTypeBinding declaringClassBinding = null;
            if (!methodDeclarationIsStatic) {
                ++numberOfEntries;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                this.contents[localContentsOffset++] = (byte)code_length;
                nameIndex = this.constantPool.literalIndex(ConstantPool.This);
                this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)nameIndex;
                MethodBinding methodBinding = this.codeStream.methodDeclaration.binding;
                declaringClassBinding = (SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody21$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null));
                descriptorIndex = this.constantPool.literalIndex(declaringClassBinding.signature());
                this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                this.contents[localContentsOffset++] = (byte)descriptorIndex;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
            }
            int genericLocalVariablesCounter = 0;
            LocalVariableBinding[] genericLocalVariables = null;
            int numberOfGenericEntries = 0;
            int i3 = 0;
            int max2 = this.codeStream.allLocalsCounter;
            while (i3 < max2) {
                boolean isParameterizedType;
                LocalVariableBinding localVariable = this.codeStream.locals[i3];
                TypeBinding localVariableTypeBinding = localVariable.type;
                boolean bl = isParameterizedType = localVariableTypeBinding.isParameterizedType() || localVariableTypeBinding.isTypeVariable();
                if (localVariable.initializationCount != 0 && isParameterizedType) {
                    if (genericLocalVariables == null) {
                        genericLocalVariables = new LocalVariableBinding[max2];
                    }
                    genericLocalVariables[genericLocalVariablesCounter++] = localVariable;
                }
                j = 0;
                while (j < localVariable.initializationCount) {
                    startPC = localVariable.initializationPCs[j << 1];
                    endPC = localVariable.initializationPCs[(j << 1) + 1];
                    if (startPC != endPC) {
                        if (endPC == -1) {
                            localVariable.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariable.name)), (ASTNode)((Object)localVariable.declaringScope.methodScope().referenceContext));
                        }
                        if (isParameterizedType) {
                            ++numberOfGenericEntries;
                        }
                        ++numberOfEntries;
                        this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                        this.contents[localContentsOffset++] = (byte)startPC;
                        length = endPC - startPC;
                        this.contents[localContentsOffset++] = (byte)(length >> 8);
                        this.contents[localContentsOffset++] = (byte)length;
                        nameIndex = this.constantPool.literalIndex(localVariable.name);
                        this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)nameIndex;
                        descriptorIndex = this.constantPool.literalIndex(localVariableTypeBinding.signature());
                        this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)descriptorIndex;
                        resolvedPosition = localVariable.resolvedPosition;
                        this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                        this.contents[localContentsOffset++] = (byte)resolvedPosition;
                    }
                    ++j;
                }
                ++i3;
            }
            int value = numberOfEntries * 10 + 2;
            localVariableTableOffset += 2;
            this.contents[localVariableTableOffset++] = (byte)(value >> 24);
            this.contents[localVariableTableOffset++] = (byte)(value >> 16);
            this.contents[localVariableTableOffset++] = (byte)(value >> 8);
            this.contents[localVariableTableOffset++] = (byte)value;
            this.contents[localVariableTableOffset++] = (byte)(numberOfEntries >> 8);
            this.contents[localVariableTableOffset] = (byte)numberOfEntries;
            ++attributeNumber;
            boolean bl = currentInstanceIsGeneric = !methodDeclarationIsStatic && declaringClassBinding != null && declaringClassBinding.typeVariables != TypeConstants.NoTypeVariables;
            if (genericLocalVariablesCounter != 0 || currentInstanceIsGeneric) {
                maxOfEntries = 8 + (numberOfGenericEntries += currentInstanceIsGeneric ? 1 : 0) * 10;
                if (localContentsOffset + maxOfEntries >= this.contents.length) {
                    this.resizeContents(maxOfEntries);
                }
                int localVariableTypeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[localContentsOffset++] = (byte)(localVariableTypeNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)localVariableTypeNameIndex;
                value = numberOfGenericEntries * 10 + 2;
                this.contents[localContentsOffset++] = (byte)(value >> 24);
                this.contents[localContentsOffset++] = (byte)(value >> 16);
                this.contents[localContentsOffset++] = (byte)(value >> 8);
                this.contents[localContentsOffset++] = (byte)value;
                this.contents[localContentsOffset++] = (byte)(numberOfGenericEntries >> 8);
                this.contents[localContentsOffset++] = (byte)numberOfGenericEntries;
                if (currentInstanceIsGeneric) {
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                    this.contents[localContentsOffset++] = (byte)code_length;
                    nameIndex = this.constantPool.literalIndex(ConstantPool.This);
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                    descriptorIndex = this.constantPool.literalIndex(declaringClassBinding.genericTypeSignature());
                    this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)descriptorIndex;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                }
                int i4 = 0;
                while (i4 < genericLocalVariablesCounter) {
                    LocalVariableBinding localVariable = genericLocalVariables[i4];
                    j = 0;
                    while (j < localVariable.initializationCount) {
                        startPC = localVariable.initializationPCs[j << 1];
                        endPC = localVariable.initializationPCs[(j << 1) + 1];
                        if (startPC != endPC) {
                            this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                            this.contents[localContentsOffset++] = (byte)startPC;
                            length = endPC - startPC;
                            this.contents[localContentsOffset++] = (byte)(length >> 8);
                            this.contents[localContentsOffset++] = (byte)length;
                            nameIndex = this.constantPool.literalIndex(localVariable.name);
                            this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)nameIndex;
                            descriptorIndex = this.constantPool.literalIndex(localVariable.type.genericTypeSignature());
                            this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)descriptorIndex;
                            resolvedPosition = localVariable.resolvedPosition;
                            this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                            this.contents[localContentsOffset++] = (byte)resolvedPosition;
                        }
                        ++j;
                    }
                    ++i4;
                }
                ++attributeNumber;
            }
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForClinit(int codeAttributeOffset) {
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int code_length = this.codeStream.position;
        if (code_length > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (localContentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        int exceptionHandlersNumber = this.codeStream.exceptionHandlersCounter;
        ExceptionLabel[] exceptionHandlers = this.codeStream.exceptionHandlers;
        int exSize = exceptionHandlersNumber * 8 + 2;
        if (exSize + localContentsOffset >= this.contents.length) {
            this.resizeContents(exSize);
        }
        this.contents[localContentsOffset++] = (byte)(exceptionHandlersNumber >> 8);
        this.contents[localContentsOffset++] = (byte)exceptionHandlersNumber;
        int i = 0;
        int max = this.codeStream.exceptionHandlersIndex;
        while (i < max) {
            ExceptionLabel exceptionHandler = exceptionHandlers[i];
            if (exceptionHandler != null) {
                int start = exceptionHandler.start;
                this.contents[localContentsOffset++] = (byte)(start >> 8);
                this.contents[localContentsOffset++] = (byte)start;
                int end = exceptionHandler.end;
                this.contents[localContentsOffset++] = (byte)(end >> 8);
                this.contents[localContentsOffset++] = (byte)end;
                int handlerPC = exceptionHandler.position;
                this.contents[localContentsOffset++] = (byte)(handlerPC >> 8);
                this.contents[localContentsOffset++] = (byte)handlerPC;
                if (exceptionHandler.exceptionType == null) {
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                } else {
                    int nameIndex = exceptionHandler.exceptionType == BaseTypes.NullBinding ? this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : this.constantPool.literalIndexForType(exceptionHandler.exceptionType.constantPoolName());
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                }
            }
            ++i;
        }
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        localContentsOffset += 2;
        if (this.codeStream.generateLineNumberAttributes) {
            int[] pcToSourceMapTable = this.codeStream.pcToSourceMap;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
                if (localContentsOffset + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
                int lineNumberTableOffset = localContentsOffset;
                localContentsOffset += 6;
                int numberOfEntries = 0;
                int length = this.codeStream.pcToSourceMapSize;
                int i2 = 0;
                while (i2 < length) {
                    if (localContentsOffset + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    int pc = pcToSourceMapTable[i2++];
                    this.contents[localContentsOffset++] = (byte)(pc >> 8);
                    this.contents[localContentsOffset++] = (byte)pc;
                    int lineNumber = pcToSourceMapTable[i2++];
                    this.contents[localContentsOffset++] = (byte)(lineNumber >> 8);
                    this.contents[localContentsOffset++] = (byte)lineNumber;
                    ++numberOfEntries;
                }
                int lineNumberAttr_length = numberOfEntries * 4 + 2;
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 24);
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 16);
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 8);
                this.contents[lineNumberTableOffset++] = (byte)lineNumberAttr_length;
                this.contents[lineNumberTableOffset++] = (byte)(numberOfEntries >> 8);
                this.contents[lineNumberTableOffset++] = (byte)numberOfEntries;
                ++attributeNumber;
            }
        }
        if (this.codeStream.generateLocalVariableTableAttributes) {
            int localVariableTableOffset = localContentsOffset;
            int numberOfEntries = 0;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                int resolvedPosition;
                int descriptorIndex;
                int nameIndex;
                int length;
                int endPC;
                int startPC;
                int j;
                int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
                if (localContentsOffset + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
                localContentsOffset += 6;
                int genericLocalVariablesCounter = 0;
                LocalVariableBinding[] genericLocalVariables = null;
                int numberOfGenericEntries = 0;
                int i3 = 0;
                int max2 = this.codeStream.allLocalsCounter;
                while (i3 < max2) {
                    boolean isParameterizedType;
                    LocalVariableBinding localVariable = this.codeStream.locals[i3];
                    TypeBinding localVariableTypeBinding = localVariable.type;
                    boolean bl = isParameterizedType = localVariableTypeBinding.isParameterizedType() || localVariableTypeBinding.isTypeVariable();
                    if (localVariable.initializationCount != 0 && isParameterizedType) {
                        if (genericLocalVariables == null) {
                            genericLocalVariables = new LocalVariableBinding[max2];
                        }
                        genericLocalVariables[genericLocalVariablesCounter++] = localVariable;
                    }
                    j = 0;
                    while (j < localVariable.initializationCount) {
                        startPC = localVariable.initializationPCs[j << 1];
                        endPC = localVariable.initializationPCs[(j << 1) + 1];
                        if (startPC != endPC) {
                            if (endPC == -1) {
                                localVariable.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariable.name)), (ASTNode)((Object)localVariable.declaringScope.methodScope().referenceContext));
                            }
                            if (localContentsOffset + 10 >= this.contents.length) {
                                this.resizeContents(10);
                            }
                            ++numberOfEntries;
                            if (isParameterizedType) {
                                ++numberOfGenericEntries;
                            }
                            this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                            this.contents[localContentsOffset++] = (byte)startPC;
                            length = endPC - startPC;
                            this.contents[localContentsOffset++] = (byte)(length >> 8);
                            this.contents[localContentsOffset++] = (byte)length;
                            nameIndex = this.constantPool.literalIndex(localVariable.name);
                            this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)nameIndex;
                            descriptorIndex = this.constantPool.literalIndex(localVariableTypeBinding.signature());
                            this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)descriptorIndex;
                            resolvedPosition = localVariable.resolvedPosition;
                            this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                            this.contents[localContentsOffset++] = (byte)resolvedPosition;
                        }
                        ++j;
                    }
                    ++i3;
                }
                int value = numberOfEntries * 10 + 2;
                localVariableTableOffset += 2;
                this.contents[localVariableTableOffset++] = (byte)(value >> 24);
                this.contents[localVariableTableOffset++] = (byte)(value >> 16);
                this.contents[localVariableTableOffset++] = (byte)(value >> 8);
                this.contents[localVariableTableOffset++] = (byte)value;
                this.contents[localVariableTableOffset++] = (byte)(numberOfEntries >> 8);
                this.contents[localVariableTableOffset] = (byte)numberOfEntries;
                ++attributeNumber;
                if (genericLocalVariablesCounter != 0) {
                    int maxOfEntries = 8 + numberOfGenericEntries * 10;
                    if (localContentsOffset + maxOfEntries >= this.contents.length) {
                        this.resizeContents(maxOfEntries);
                    }
                    int localVariableTypeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                    this.contents[localContentsOffset++] = (byte)(localVariableTypeNameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)localVariableTypeNameIndex;
                    value = numberOfGenericEntries * 10 + 2;
                    this.contents[localContentsOffset++] = (byte)(value >> 24);
                    this.contents[localContentsOffset++] = (byte)(value >> 16);
                    this.contents[localContentsOffset++] = (byte)(value >> 8);
                    this.contents[localContentsOffset++] = (byte)value;
                    this.contents[localContentsOffset++] = (byte)(numberOfGenericEntries >> 8);
                    this.contents[localContentsOffset++] = (byte)numberOfGenericEntries;
                    int i4 = 0;
                    while (i4 < genericLocalVariablesCounter) {
                        LocalVariableBinding localVariable = genericLocalVariables[i4];
                        j = 0;
                        while (j < localVariable.initializationCount) {
                            startPC = localVariable.initializationPCs[j << 1];
                            endPC = localVariable.initializationPCs[(j << 1) + 1];
                            if (startPC != endPC) {
                                this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                                this.contents[localContentsOffset++] = (byte)startPC;
                                length = endPC - startPC;
                                this.contents[localContentsOffset++] = (byte)(length >> 8);
                                this.contents[localContentsOffset++] = (byte)length;
                                nameIndex = this.constantPool.literalIndex(localVariable.name);
                                this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                                this.contents[localContentsOffset++] = (byte)nameIndex;
                                descriptorIndex = this.constantPool.literalIndex(localVariable.type.genericTypeSignature());
                                this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                                this.contents[localContentsOffset++] = (byte)descriptorIndex;
                                resolvedPosition = localVariable.resolvedPosition;
                                this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                                this.contents[localContentsOffset++] = (byte)resolvedPosition;
                            }
                            ++j;
                        }
                        ++i4;
                    }
                    ++attributeNumber;
                }
            }
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForClinit(int codeAttributeOffset, int[] startLineIndexes, int problemLine) {
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int code_length = this.codeStream.position;
        if (code_length > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (localContentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        this.contents[localContentsOffset++] = 0;
        this.contents[localContentsOffset++] = 0;
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        localContentsOffset += 2;
        if (this.codeStream.generateLineNumberAttributes) {
            if (localContentsOffset + 20 >= this.contents.length) {
                this.resizeContents(20);
            }
            int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 6;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 1;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = (byte)(problemLine >> 8);
            this.contents[localContentsOffset++] = (byte)problemLine;
            ++attributeNumber;
        }
        if (this.codeStream.generateLocalVariableTableAttributes) {
            int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 2;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            ++attributeNumber;
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForMissingAbstractProblemMethod(MethodBinding binding, int codeAttributeOffset, int[] startLineIndexes, int problemLine) {
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        int code_length = this.codeStream.position;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        if (localContentsOffset + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[localContentsOffset++] = 0;
        this.contents[localContentsOffset++] = 0;
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        localContentsOffset += 2;
        if (this.codeStream.generateLineNumberAttributes) {
            if (localContentsOffset + 12 >= this.contents.length) {
                this.resizeContents(12);
            }
            int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 6;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 1;
            if (problemLine == 0) {
                problemLine = ClassFile.searchLineNumber(startLineIndexes, binding.sourceStart());
            }
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = (byte)(problemLine >> 8);
            this.contents[localContentsOffset++] = (byte)problemLine;
            ++attributeNumber;
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForProblemMethod(AbstractMethodDeclaration method, MethodBinding binding, int codeAttributeOffset, int[] startLineIndexes, int problemLine) {
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        int code_length = this.codeStream.position;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        if (localContentsOffset + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[localContentsOffset++] = 0;
        this.contents[localContentsOffset++] = 0;
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        localContentsOffset += 2;
        if (this.codeStream.generateLineNumberAttributes) {
            if (localContentsOffset + 20 >= this.contents.length) {
                this.resizeContents(20);
            }
            int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 6;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 1;
            if (problemLine == 0) {
                problemLine = ClassFile.searchLineNumber(startLineIndexes, binding.sourceStart());
            }
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = (byte)(problemLine >> 8);
            this.contents[localContentsOffset++] = (byte)problemLine;
            ++attributeNumber;
        }
        if (this.codeStream.generateLocalVariableTableAttributes) {
            boolean currentInstanceIsGeneric;
            int resolvedPosition;
            int argSize;
            int descriptorIndex;
            int nameIndex;
            int localVariableTableOffset = localContentsOffset;
            int numberOfEntries = 0;
            int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
            localContentsOffset += 6;
            SourceTypeBinding declaringClassBinding = null;
            boolean methodDeclarationIsStatic = this.codeStream.methodDeclaration.isStatic();
            if (!methodDeclarationIsStatic) {
                ++numberOfEntries;
                if (localContentsOffset + 10 >= this.contents.length) {
                    this.resizeContents(10);
                }
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                this.contents[localContentsOffset++] = (byte)code_length;
                nameIndex = this.constantPool.literalIndex(ConstantPool.This);
                this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)nameIndex;
                MethodBinding methodBinding = this.codeStream.methodDeclaration.binding;
                declaringClassBinding = (SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody23$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null));
                descriptorIndex = this.constantPool.literalIndex(declaringClassBinding.signature());
                this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                this.contents[localContentsOffset++] = (byte)descriptorIndex;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
            }
            int genericLocalVariablesCounter = 0;
            LocalVariableBinding[] genericLocalVariables = null;
            int numberOfGenericEntries = 0;
            if (binding.isConstructor()) {
                MethodBinding methodBinding = binding;
                ReferenceBinding declaringClass = (ReferenceBinding)ClassFile.declaringClass_aroundBody25$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null);
                if (declaringClass.isNestedType()) {
                    NestedTypeBinding methodDeclaringClass = (NestedTypeBinding)declaringClass;
                    argSize = methodDeclaringClass.enclosingInstancesSlotSize;
                    SyntheticArgumentBinding[] syntheticArguments = methodDeclaringClass.syntheticEnclosingInstances();
                    if (syntheticArguments != null) {
                        int i = 0;
                        int max = syntheticArguments.length;
                        while (i < max) {
                            SyntheticArgumentBinding localVariable = syntheticArguments[i];
                            TypeBinding localVariableTypeBinding = localVariable.type;
                            if (localVariableTypeBinding.isParameterizedType() || localVariableTypeBinding.isTypeVariable()) {
                                if (genericLocalVariables == null) {
                                    genericLocalVariables = new LocalVariableBinding[max];
                                }
                                genericLocalVariables[genericLocalVariablesCounter++] = localVariable;
                                ++numberOfGenericEntries;
                            }
                            if (localContentsOffset + 10 >= this.contents.length) {
                                this.resizeContents(10);
                            }
                            ++numberOfEntries;
                            this.contents[localContentsOffset++] = 0;
                            this.contents[localContentsOffset++] = 0;
                            this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                            this.contents[localContentsOffset++] = (byte)code_length;
                            nameIndex = this.constantPool.literalIndex(localVariable.name);
                            this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)nameIndex;
                            descriptorIndex = this.constantPool.literalIndex(localVariableTypeBinding.signature());
                            this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)descriptorIndex;
                            int resolvedPosition2 = localVariable.resolvedPosition;
                            this.contents[localContentsOffset++] = (byte)(resolvedPosition2 >> 8);
                            this.contents[localContentsOffset++] = (byte)resolvedPosition2;
                            ++i;
                        }
                    }
                } else {
                    argSize = 1;
                }
            } else {
                argSize = binding.isStatic() ? 0 : 1;
            }
            int genericArgumentsCounter = 0;
            int[] genericArgumentsNameIndexes = null;
            int[] genericArgumentsResolvedPositions = null;
            TypeBinding[] genericArgumentsTypeBindings = null;
            if (method.binding != null) {
                TypeBinding[] parameters = method.binding.parameters;
                Argument[] arguments = method.arguments;
                if (parameters != null && arguments != null) {
                    int i = 0;
                    int max = parameters.length;
                    while (i < max) {
                        TypeBinding argumentBinding = parameters[i];
                        if (localContentsOffset + 10 >= this.contents.length) {
                            this.resizeContents(10);
                        }
                        ++numberOfEntries;
                        this.contents[localContentsOffset++] = 0;
                        this.contents[localContentsOffset++] = 0;
                        this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                        this.contents[localContentsOffset++] = (byte)code_length;
                        nameIndex = this.constantPool.literalIndex(arguments[i].name);
                        this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)nameIndex;
                        resolvedPosition = argSize;
                        if (argumentBinding.isParameterizedType() || argumentBinding.isTypeVariable()) {
                            if (genericArgumentsCounter == 0) {
                                genericArgumentsNameIndexes = new int[max];
                                genericArgumentsResolvedPositions = new int[max];
                                genericArgumentsTypeBindings = new TypeBinding[max];
                            }
                            genericArgumentsNameIndexes[genericArgumentsCounter] = nameIndex;
                            genericArgumentsResolvedPositions[genericArgumentsCounter] = resolvedPosition;
                            genericArgumentsTypeBindings[genericArgumentsCounter++] = argumentBinding;
                        }
                        descriptorIndex = this.constantPool.literalIndex(argumentBinding.signature());
                        this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)descriptorIndex;
                        argSize = argumentBinding == BaseTypes.LongBinding || argumentBinding == BaseTypes.DoubleBinding ? (argSize += 2) : ++argSize;
                        this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                        this.contents[localContentsOffset++] = (byte)resolvedPosition;
                        ++i;
                    }
                }
            }
            int value = numberOfEntries * 10 + 2;
            localVariableTableOffset += 2;
            this.contents[localVariableTableOffset++] = (byte)(value >> 24);
            this.contents[localVariableTableOffset++] = (byte)(value >> 16);
            this.contents[localVariableTableOffset++] = (byte)(value >> 8);
            this.contents[localVariableTableOffset++] = (byte)value;
            this.contents[localVariableTableOffset++] = (byte)(numberOfEntries >> 8);
            this.contents[localVariableTableOffset] = (byte)numberOfEntries;
            ++attributeNumber;
            boolean bl = currentInstanceIsGeneric = !methodDeclarationIsStatic && declaringClassBinding != null && declaringClassBinding.typeVariables != TypeConstants.NoTypeVariables;
            if (genericLocalVariablesCounter != 0 || genericArgumentsCounter != 0 || currentInstanceIsGeneric) {
                numberOfEntries = numberOfGenericEntries + genericArgumentsCounter + (currentInstanceIsGeneric ? 1 : 0);
                int maxOfEntries = 8 + numberOfEntries * 10;
                if (localContentsOffset + maxOfEntries >= this.contents.length) {
                    this.resizeContents(maxOfEntries);
                }
                int localVariableTypeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[localContentsOffset++] = (byte)(localVariableTypeNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)localVariableTypeNameIndex;
                value = numberOfEntries * 10 + 2;
                this.contents[localContentsOffset++] = (byte)(value >> 24);
                this.contents[localContentsOffset++] = (byte)(value >> 16);
                this.contents[localContentsOffset++] = (byte)(value >> 8);
                this.contents[localContentsOffset++] = (byte)value;
                this.contents[localContentsOffset++] = (byte)(numberOfEntries >> 8);
                this.contents[localContentsOffset++] = (byte)numberOfEntries;
                if (currentInstanceIsGeneric) {
                    ++numberOfEntries;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                    this.contents[localContentsOffset++] = (byte)code_length;
                    nameIndex = this.constantPool.literalIndex(ConstantPool.This);
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                    descriptorIndex = this.constantPool.literalIndex(declaringClassBinding.genericTypeSignature());
                    this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)descriptorIndex;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                }
                int i = 0;
                while (i < genericLocalVariablesCounter) {
                    LocalVariableBinding localVariable = genericLocalVariables[i];
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                    this.contents[localContentsOffset++] = (byte)code_length;
                    nameIndex = this.constantPool.literalIndex(localVariable.name);
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                    descriptorIndex = this.constantPool.literalIndex(localVariable.type.genericTypeSignature());
                    this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)descriptorIndex;
                    int resolvedPosition3 = localVariable.resolvedPosition;
                    this.contents[localContentsOffset++] = (byte)(resolvedPosition3 >> 8);
                    this.contents[localContentsOffset++] = (byte)resolvedPosition3;
                    ++i;
                }
                i = 0;
                while (i < genericArgumentsCounter) {
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                    this.contents[localContentsOffset++] = (byte)code_length;
                    nameIndex = genericArgumentsNameIndexes[i];
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                    descriptorIndex = this.constantPool.literalIndex(genericArgumentsTypeBindings[i].genericTypeSignature());
                    this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)descriptorIndex;
                    resolvedPosition = genericArgumentsResolvedPositions[i];
                    this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                    this.contents[localContentsOffset++] = (byte)resolvedPosition;
                    ++i;
                }
                ++attributeNumber;
            }
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForSyntheticMethod(SyntheticMethodBinding binding, int codeAttributeOffset, int[] startLineIndexes) {
        this.completeCodeAttributeForSyntheticMethod(false, binding, codeAttributeOffset, startLineIndexes);
    }

    public void completeCodeAttributeForSyntheticMethod(boolean hasExceptionHandlers, SyntheticMethodBinding binding, int codeAttributeOffset, int[] startLineIndexes) {
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        int code_length = this.codeStream.position;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        if (localContentsOffset + 40 >= this.contents.length) {
            this.resizeContents(40);
        }
        if (hasExceptionHandlers) {
            int exceptionHandlersNumber = this.codeStream.exceptionHandlersCounter;
            ExceptionLabel[] exceptionHandlers = this.codeStream.exceptionHandlers;
            int exSize = exceptionHandlersNumber * 8 + 2;
            if (exSize + localContentsOffset >= this.contents.length) {
                this.resizeContents(exSize);
            }
            this.contents[localContentsOffset++] = (byte)(exceptionHandlersNumber >> 8);
            this.contents[localContentsOffset++] = (byte)exceptionHandlersNumber;
            int i = 0;
            int max = this.codeStream.exceptionHandlersIndex;
            while (i < max) {
                ExceptionLabel exceptionHandler = exceptionHandlers[i];
                if (exceptionHandler != null) {
                    int start = exceptionHandler.start;
                    this.contents[localContentsOffset++] = (byte)(start >> 8);
                    this.contents[localContentsOffset++] = (byte)start;
                    int end = exceptionHandler.end;
                    this.contents[localContentsOffset++] = (byte)(end >> 8);
                    this.contents[localContentsOffset++] = (byte)end;
                    int handlerPC = exceptionHandler.position;
                    this.contents[localContentsOffset++] = (byte)(handlerPC >> 8);
                    this.contents[localContentsOffset++] = (byte)handlerPC;
                    if (exceptionHandler.exceptionType == null) {
                        this.contents[localContentsOffset++] = 0;
                        this.contents[localContentsOffset++] = 0;
                    } else {
                        int nameIndex;
                        switch (exceptionHandler.exceptionType.id) {
                            case 12: {
                                nameIndex = this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName);
                                break;
                            }
                            case 7: {
                                nameIndex = this.constantPool.literalIndexForType(ConstantPool.JavaLangNoSuchFieldErrorConstantPoolName);
                                break;
                            }
                            default: {
                                nameIndex = this.constantPool.literalIndexForType(exceptionHandler.exceptionType.constantPoolName());
                            }
                        }
                        this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)nameIndex;
                    }
                }
                ++i;
            }
        } else {
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
        }
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        localContentsOffset += 2;
        if (this.codeStream.generateLineNumberAttributes) {
            if (localContentsOffset + 12 >= this.contents.length) {
                this.resizeContents(12);
            }
            int index = 0;
            int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
            int lineNumberTableOffset = localContentsOffset;
            localContentsOffset += 6;
            index = ClassFile.searchLineNumber(startLineIndexes, binding.sourceStart);
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = (byte)(index >> 8);
            this.contents[localContentsOffset++] = (byte)index;
            this.contents[lineNumberTableOffset++] = 0;
            this.contents[lineNumberTableOffset++] = 0;
            this.contents[lineNumberTableOffset++] = 0;
            this.contents[lineNumberTableOffset++] = 6;
            this.contents[lineNumberTableOffset++] = 0;
            this.contents[lineNumberTableOffset++] = 1;
            ++attributeNumber;
        }
        if (this.codeStream.generateLocalVariableTableAttributes) {
            int resolvedPosition;
            int descriptorIndex;
            int length;
            int endPC;
            int startPC;
            int j;
            int localVariableTableOffset = localContentsOffset;
            int numberOfEntries = 0;
            int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (localContentsOffset + 8 > this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
            localContentsOffset += 6;
            int genericLocalVariablesCounter = 0;
            LocalVariableBinding[] genericLocalVariables = null;
            int numberOfGenericEntries = 0;
            int i = 0;
            int max = this.codeStream.allLocalsCounter;
            while (i < max) {
                boolean isParameterizedType;
                LocalVariableBinding localVariable = this.codeStream.locals[i];
                TypeBinding localVariableTypeBinding = localVariable.type;
                boolean bl = isParameterizedType = localVariableTypeBinding.isParameterizedType() || localVariableTypeBinding.isTypeVariable();
                if (localVariable.initializationCount != 0 && isParameterizedType) {
                    if (genericLocalVariables == null) {
                        genericLocalVariables = new LocalVariableBinding[max];
                    }
                    genericLocalVariables[genericLocalVariablesCounter++] = localVariable;
                }
                j = 0;
                while (j < localVariable.initializationCount) {
                    startPC = localVariable.initializationPCs[j << 1];
                    endPC = localVariable.initializationPCs[(j << 1) + 1];
                    if (startPC != endPC) {
                        if (endPC == -1) {
                            localVariable.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariable.name)), (ASTNode)((Object)localVariable.declaringScope.methodScope().referenceContext));
                        }
                        if (localContentsOffset + 10 > this.contents.length) {
                            this.resizeContents(10);
                        }
                        ++numberOfEntries;
                        if (isParameterizedType) {
                            ++numberOfGenericEntries;
                        }
                        this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                        this.contents[localContentsOffset++] = (byte)startPC;
                        length = endPC - startPC;
                        this.contents[localContentsOffset++] = (byte)(length >> 8);
                        this.contents[localContentsOffset++] = (byte)length;
                        int nameIndex = this.constantPool.literalIndex(localVariable.name);
                        this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)nameIndex;
                        descriptorIndex = this.constantPool.literalIndex(localVariableTypeBinding.signature());
                        this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)descriptorIndex;
                        resolvedPosition = localVariable.resolvedPosition;
                        this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                        this.contents[localContentsOffset++] = (byte)resolvedPosition;
                    }
                    ++j;
                }
                ++i;
            }
            int value = numberOfEntries * 10 + 2;
            localVariableTableOffset += 2;
            this.contents[localVariableTableOffset++] = (byte)(value >> 24);
            this.contents[localVariableTableOffset++] = (byte)(value >> 16);
            this.contents[localVariableTableOffset++] = (byte)(value >> 8);
            this.contents[localVariableTableOffset++] = (byte)value;
            this.contents[localVariableTableOffset++] = (byte)(numberOfEntries >> 8);
            this.contents[localVariableTableOffset] = (byte)numberOfEntries;
            ++attributeNumber;
            if (genericLocalVariablesCounter != 0) {
                int maxOfEntries = 8 + numberOfGenericEntries * 10;
                if (localContentsOffset + maxOfEntries >= this.contents.length) {
                    this.resizeContents(maxOfEntries);
                }
                int localVariableTypeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[localContentsOffset++] = (byte)(localVariableTypeNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)localVariableTypeNameIndex;
                value = numberOfGenericEntries * 10 + 2;
                this.contents[localContentsOffset++] = (byte)(value >> 24);
                this.contents[localContentsOffset++] = (byte)(value >> 16);
                this.contents[localContentsOffset++] = (byte)(value >> 8);
                this.contents[localContentsOffset++] = (byte)value;
                this.contents[localContentsOffset++] = (byte)(numberOfGenericEntries >> 8);
                this.contents[localContentsOffset++] = (byte)numberOfGenericEntries;
                int i2 = 0;
                while (i2 < genericLocalVariablesCounter) {
                    LocalVariableBinding localVariable = genericLocalVariables[i2];
                    j = 0;
                    while (j < localVariable.initializationCount) {
                        startPC = localVariable.initializationPCs[j << 1];
                        endPC = localVariable.initializationPCs[(j << 1) + 1];
                        if (startPC != endPC) {
                            this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                            this.contents[localContentsOffset++] = (byte)startPC;
                            length = endPC - startPC;
                            this.contents[localContentsOffset++] = (byte)(length >> 8);
                            this.contents[localContentsOffset++] = (byte)length;
                            int nameIndex = this.constantPool.literalIndex(localVariable.name);
                            this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)nameIndex;
                            descriptorIndex = this.constantPool.literalIndex(localVariable.type.genericTypeSignature());
                            this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)descriptorIndex;
                            resolvedPosition = localVariable.resolvedPosition;
                            this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                            this.contents[localContentsOffset++] = (byte)resolvedPosition;
                        }
                        ++j;
                    }
                    ++i2;
                }
                ++attributeNumber;
            }
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeMethodInfo(int methodAttributeOffset, int attributeNumber) {
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public char[] fileName() {
        return this.constantPool.UTF8Cache.returnKeyFor(1);
    }

    private void generateAnnotation(Annotation annotation, int attributeOffset) {
        TypeBinding annotationTypeBinding;
        if (this.contentsOffset + 4 >= this.contents.length) {
            this.resizeContents(4);
        }
        if ((annotationTypeBinding = annotation.resolvedType) == null) {
            this.contentsOffset = attributeOffset;
            return;
        }
        int typeIndex = this.constantPool.literalIndex(annotationTypeBinding.signature());
        this.contents[this.contentsOffset++] = (byte)(typeIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)typeIndex;
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            MemberValuePair[] memberValuePairs = normalAnnotation.memberValuePairs;
            if (memberValuePairs != null) {
                int memberValuePairsLength = memberValuePairs.length;
                this.contents[this.contentsOffset++] = (byte)(memberValuePairsLength >> 8);
                this.contents[this.contentsOffset++] = (byte)memberValuePairsLength;
                int i = 0;
                while (i < memberValuePairsLength) {
                    MemberValuePair memberValuePair = memberValuePairs[i];
                    if (this.contentsOffset + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    int elementNameIndex = this.constantPool.literalIndex(memberValuePair.name);
                    this.contents[this.contentsOffset++] = (byte)(elementNameIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)elementNameIndex;
                    MethodBinding methodBinding = memberValuePair.binding;
                    if (methodBinding == null) {
                        this.contentsOffset = attributeOffset;
                    } else {
                        this.generateElementValue(memberValuePair.value, methodBinding.returnType, attributeOffset);
                    }
                    ++i;
                }
            } else {
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
            }
        } else if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 1;
            if (this.contentsOffset + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            int elementNameIndex = this.constantPool.literalIndex(TypeConstants.VALUE);
            this.contents[this.contentsOffset++] = (byte)(elementNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)elementNameIndex;
            MethodBinding methodBinding = singleMemberAnnotation.memberValuePairs()[0].binding;
            if (methodBinding == null) {
                this.contentsOffset = attributeOffset;
            } else {
                this.generateElementValue(singleMemberAnnotation.memberValue, methodBinding.returnType, attributeOffset);
            }
        } else {
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
        }
    }

    public void generateCodeAttributeHeader() {
        if (this.contentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int constantValueNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.CodeName);
        this.contents[this.contentsOffset++] = (byte)(constantValueNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)constantValueNameIndex;
        this.contentsOffset += 12;
    }

    private void generateElementValue(Expression defaultValue, TypeBinding memberValuePairReturnType, int attributeOffset) {
        Constant constant = defaultValue.constant;
        TypeBinding defaultValueBinding = defaultValue.resolvedType;
        if (defaultValueBinding == null) {
            this.contentsOffset = attributeOffset;
        } else {
            if (memberValuePairReturnType.isArrayType() && !defaultValueBinding.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 1;
            }
            if (constant != null && constant != Constant.NotAConstant) {
                this.generateElementValue(attributeOffset, defaultValue, constant, memberValuePairReturnType.leafComponentType());
            } else {
                this.generateElementValueForNonConstantExpression(defaultValue, attributeOffset, defaultValueBinding);
            }
        }
    }

    private void generateElementValue(int attributeOffset, Expression defaultValue, Constant constant, TypeBinding binding) {
        if (this.contentsOffset + 3 >= this.contents.length) {
            this.resizeContents(3);
        }
        switch (binding.id) {
            case 5: {
                this.contents[this.contentsOffset++] = 90;
                int booleanValueIndex = this.constantPool.literalIndex(constant.booleanValue() ? 1 : 0);
                this.contents[this.contentsOffset++] = (byte)(booleanValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)booleanValueIndex;
                break;
            }
            case 3: {
                this.contents[this.contentsOffset++] = 66;
                int integerValueIndex = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(integerValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)integerValueIndex;
                break;
            }
            case 2: {
                this.contents[this.contentsOffset++] = 67;
                int integerValueIndex = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(integerValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)integerValueIndex;
                break;
            }
            case 10: {
                this.contents[this.contentsOffset++] = 73;
                int integerValueIndex = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(integerValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)integerValueIndex;
                break;
            }
            case 4: {
                this.contents[this.contentsOffset++] = 83;
                int integerValueIndex = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(integerValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)integerValueIndex;
                break;
            }
            case 9: {
                this.contents[this.contentsOffset++] = 70;
                int floatValueIndex = this.constantPool.literalIndex(constant.floatValue());
                this.contents[this.contentsOffset++] = (byte)(floatValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)floatValueIndex;
                break;
            }
            case 8: {
                this.contents[this.contentsOffset++] = 68;
                int doubleValueIndex = this.constantPool.literalIndex(constant.doubleValue());
                this.contents[this.contentsOffset++] = (byte)(doubleValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)doubleValueIndex;
                break;
            }
            case 7: {
                this.contents[this.contentsOffset++] = 74;
                int longValueIndex = this.constantPool.literalIndex(constant.longValue());
                this.contents[this.contentsOffset++] = (byte)(longValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)longValueIndex;
                break;
            }
            case 11: {
                this.contents[this.contentsOffset++] = 115;
                int stringValueIndex = this.constantPool.literalIndex(((StringConstant)constant).stringValue().toCharArray());
                if (stringValueIndex == -1) {
                    if (!this.creatingProblemType) {
                        TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                        typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(defaultValue);
                        break;
                    }
                    this.contentsOffset = attributeOffset;
                    break;
                }
                this.contents[this.contentsOffset++] = (byte)(stringValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)stringValueIndex;
            }
        }
    }

    private void generateElementValueForNonConstantExpression(Expression defaultValue, int attributeOffset, TypeBinding defaultValueBinding) {
        if (defaultValueBinding != null) {
            if (defaultValueBinding.isEnum()) {
                NameReference nameReference;
                if (this.contentsOffset + 5 >= this.contents.length) {
                    this.resizeContents(5);
                }
                this.contents[this.contentsOffset++] = 101;
                FieldBinding fieldBinding = null;
                if (defaultValue instanceof QualifiedNameReference) {
                    nameReference = (QualifiedNameReference)defaultValue;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else if (defaultValue instanceof SingleNameReference) {
                    nameReference = (SingleNameReference)defaultValue;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else {
                    this.contentsOffset = attributeOffset;
                }
                if (fieldBinding != null) {
                    int enumConstantTypeNameIndex = this.constantPool.literalIndex(fieldBinding.type.signature());
                    int enumConstantNameIndex = this.constantPool.literalIndex(fieldBinding.name);
                    this.contents[this.contentsOffset++] = (byte)(enumConstantTypeNameIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)enumConstantTypeNameIndex;
                    this.contents[this.contentsOffset++] = (byte)(enumConstantNameIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)enumConstantNameIndex;
                }
            } else if (defaultValueBinding.isAnnotationType()) {
                if (this.contentsOffset + 1 >= this.contents.length) {
                    this.resizeContents(1);
                }
                this.contents[this.contentsOffset++] = 64;
                this.generateAnnotation((Annotation)defaultValue, attributeOffset);
            } else if (defaultValueBinding.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                if (defaultValue instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)defaultValue;
                    int arrayLength = arrayInitializer.expressions != null ? arrayInitializer.expressions.length : 0;
                    this.contents[this.contentsOffset++] = (byte)(arrayLength >> 8);
                    this.contents[this.contentsOffset++] = (byte)arrayLength;
                    int i = 0;
                    while (i < arrayLength) {
                        this.generateElementValue(arrayInitializer.expressions[i], defaultValueBinding.leafComponentType(), attributeOffset);
                        ++i;
                    }
                } else {
                    this.contentsOffset = attributeOffset;
                }
            } else {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 99;
                if (defaultValue instanceof ClassLiteralAccess) {
                    ClassLiteralAccess classLiteralAccess = (ClassLiteralAccess)defaultValue;
                    int classInfoIndex = this.constantPool.literalIndex(classLiteralAccess.targetType.signature());
                    this.contents[this.contentsOffset++] = (byte)(classInfoIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)classInfoIndex;
                } else {
                    this.contentsOffset = attributeOffset;
                }
            }
        } else {
            this.contentsOffset = attributeOffset;
        }
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding) {
        return this.generateMethodInfoAttribute(methodBinding, false, null);
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding, boolean createProblemMethod) {
        return this.generateMethodInfoAttribute(methodBinding, createProblemMethod, null);
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding, boolean createProblemMethod, List extraAttributes) {
        AbstractMethodDeclaration methodDeclaration;
        char[] genericSignature;
        this.contentsOffset += 2;
        int attributeNumber = 0;
        ReferenceBinding[] thrownsExceptions = methodBinding.thrownExceptions;
        if (methodBinding.thrownExceptions != TypeConstants.NoExceptions) {
            int length = thrownsExceptions.length;
            int exSize = 8 + length * 2;
            if (exSize + this.contentsOffset >= this.contents.length) {
                this.resizeContents(exSize);
            }
            int exceptionNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.ExceptionsName);
            this.contents[this.contentsOffset++] = (byte)(exceptionNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)exceptionNameIndex;
            int attributeLength = length * 2 + 2;
            this.contents[this.contentsOffset++] = (byte)(attributeLength >> 24);
            this.contents[this.contentsOffset++] = (byte)(attributeLength >> 16);
            this.contents[this.contentsOffset++] = (byte)(attributeLength >> 8);
            this.contents[this.contentsOffset++] = (byte)attributeLength;
            this.contents[this.contentsOffset++] = (byte)(length >> 8);
            this.contents[this.contentsOffset++] = (byte)length;
            int i = 0;
            while (i < length) {
                int exceptionIndex = this.constantPool.literalIndexForType(thrownsExceptions[i].constantPoolName());
                this.contents[this.contentsOffset++] = (byte)(exceptionIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)exceptionIndex;
                ++i;
            }
            ++attributeNumber;
        }
        if (methodBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int deprecatedAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(deprecatedAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)deprecatedAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributeNumber;
        }
        if (this.targetJDK < 0x310000L && methodBinding.isSynthetic()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int syntheticAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
            this.contents[this.contentsOffset++] = (byte)(syntheticAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)syntheticAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributeNumber;
        }
        if ((genericSignature = methodBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int signatureAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(signatureAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)signatureAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            int signatureIndex = this.constantPool.literalIndex(genericSignature);
            this.contents[this.contentsOffset++] = (byte)(signatureIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)signatureIndex;
            ++attributeNumber;
        }
        if (this.targetJDK >= 0x310000L && !this.creatingProblemType && !createProblemMethod && (methodDeclaration = methodBinding.sourceMethod()) != null) {
            Argument[] arguments;
            Annotation[] annotations = methodDeclaration.annotations;
            if (annotations != null) {
                attributeNumber += this.generateRuntimeAnnotations(annotations);
            }
            if ((methodBinding.tagBits & 0x400L) != 0L && (arguments = methodDeclaration.arguments) != null) {
                attributeNumber += this.generateRuntimeAnnotationsForParameters(arguments);
            }
        }
        if (extraAttributes != null) {
            int i = 0;
            int len = extraAttributes.size();
            while (i < len) {
                IAttribute attribute = (IAttribute)extraAttributes.get(i);
                short nameIndex = (short)this.constantPool.literalIndex(attribute.getNameChars());
                this.writeToContents(attribute.getAllBytes(nameIndex));
                ++attributeNumber;
                ++i;
            }
        }
        return attributeNumber;
    }

    void writeToContents(byte[] data) {
        int N = data.length;
        if (this.contentsOffset + N >= this.contents.length) {
            this.resizeContents(N);
        }
        System.arraycopy(data, 0, this.contents, this.contentsOffset, N);
        this.contentsOffset += N;
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding, AnnotationMethodDeclaration declaration) {
        int attributesNumber = this.generateMethodInfoAttribute(methodBinding);
        int attributeOffset = this.contentsOffset;
        if ((declaration.modifiers & 0x20000) != 0) {
            int annotationDefaultNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.AnnotationDefaultName);
            this.contents[this.contentsOffset++] = (byte)(annotationDefaultNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)annotationDefaultNameIndex;
            int attributeLengthOffset = this.contentsOffset;
            this.contentsOffset += 4;
            this.generateElementValue(declaration.defaultValue, declaration.binding.returnType, attributeOffset);
            if (this.contentsOffset != attributeOffset) {
                int attributeLength = this.contentsOffset - attributeLengthOffset - 4;
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 24);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 16);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 8);
                this.contents[attributeLengthOffset++] = (byte)attributeLength;
                ++attributesNumber;
            }
        }
        return attributesNumber;
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers);
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding, int accessFlags) {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        if (this.targetJDK < 0x310000L) {
            accessFlags &= 0xFFFFEFFF;
        }
        if (methodBinding.isRequiredToClearPrivateModifier()) {
            accessFlags &= 0xFFFFFFFD;
        }
        this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
        this.contents[this.contentsOffset++] = (byte)accessFlags;
        int nameIndex = this.constantPool.literalIndex(methodBinding.selector);
        this.contents[this.contentsOffset++] = (byte)(nameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)nameIndex;
        int descriptorIndex = this.constantPool.literalIndex(methodBinding.signature());
        this.contents[this.contentsOffset++] = (byte)(descriptorIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)descriptorIndex;
    }

    public void generateMethodInfoHeaderForClinit() {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 8;
        int nameIndex = this.constantPool.literalIndex(ConstantPool.Clinit);
        this.contents[this.contentsOffset++] = (byte)(nameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)nameIndex;
        int descriptorIndex = this.constantPool.literalIndex(ConstantPool.ClinitSignature);
        this.contents[this.contentsOffset++] = (byte)(descriptorIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)descriptorIndex;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 1;
    }

    public void generateMissingAbstractMethods(MethodDeclaration[] methodDeclarations, CompilationResult compilationResult) {
        if (methodDeclarations != null) {
            int i = 0;
            int max = methodDeclarations.length;
            while (i < max) {
                MethodDeclaration methodDeclaration = methodDeclarations[i];
                MethodBinding methodBinding = methodDeclaration.binding;
                String readableName = new String(methodBinding.readableName());
                IProblem[] problems = compilationResult.problems;
                int problemsCount = compilationResult.problemCount;
                int j = 0;
                while (j < problemsCount) {
                    IProblem problem = problems[j];
                    if (problem != null && problem.getID() == 67109264 && problem.getMessage().indexOf(readableName) != -1) {
                        this.addMissingAbstractProblemMethod(methodDeclaration, methodBinding, problem, compilationResult);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private int generateRuntimeAnnotations(Annotation[] annotations) {
        int attributeLength;
        Annotation annotation;
        int i;
        int annotationsLengthOffset;
        int attributeLengthOffset;
        int annotationAttributeOffset;
        int attributesNumber = 0;
        int length = annotations.length;
        int visibleAnnotationsCounter = 0;
        int invisibleAnnotationsCounter = 0;
        int i2 = 0;
        while (i2 < length) {
            Annotation annotation2 = annotations[i2];
            if (this.isRuntimeInvisible(annotation2)) {
                ++invisibleAnnotationsCounter;
            } else if (this.isRuntimeVisible(annotation2)) {
                ++visibleAnnotationsCounter;
            }
            ++i2;
        }
        if (invisibleAnnotationsCounter != 0) {
            annotationAttributeOffset = this.contentsOffset;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            int runtimeInvisibleAnnotationsAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(runtimeInvisibleAnnotationsAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)runtimeInvisibleAnnotationsAttributeNameIndex;
            attributeLengthOffset = this.contentsOffset;
            this.contentsOffset += 4;
            annotationsLengthOffset = this.contentsOffset;
            this.contentsOffset += 2;
            this.contents[annotationsLengthOffset++] = (byte)(invisibleAnnotationsCounter >> 8);
            this.contents[annotationsLengthOffset++] = (byte)invisibleAnnotationsCounter;
            i = 0;
            while (i < length) {
                if (invisibleAnnotationsCounter == 0) break;
                annotation = annotations[i];
                if (this.isRuntimeInvisible(annotation)) {
                    this.generateAnnotation(annotation, annotationAttributeOffset);
                    --invisibleAnnotationsCounter;
                    if (this.contentsOffset == annotationAttributeOffset) break;
                }
                ++i;
            }
            if (this.contentsOffset != annotationAttributeOffset) {
                attributeLength = this.contentsOffset - attributeLengthOffset - 4;
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 24);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 16);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 8);
                this.contents[attributeLengthOffset++] = (byte)attributeLength;
                ++attributesNumber;
            } else {
                this.contentsOffset = annotationAttributeOffset;
            }
        }
        if (visibleAnnotationsCounter != 0) {
            annotationAttributeOffset = this.contentsOffset;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            int runtimeVisibleAnnotationsAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(runtimeVisibleAnnotationsAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)runtimeVisibleAnnotationsAttributeNameIndex;
            attributeLengthOffset = this.contentsOffset;
            this.contentsOffset += 4;
            annotationsLengthOffset = this.contentsOffset;
            this.contentsOffset += 2;
            this.contents[annotationsLengthOffset++] = (byte)(visibleAnnotationsCounter >> 8);
            this.contents[annotationsLengthOffset++] = (byte)visibleAnnotationsCounter;
            i = 0;
            while (i < length) {
                if (visibleAnnotationsCounter == 0) break;
                annotation = annotations[i];
                if (this.isRuntimeVisible(annotation)) {
                    --visibleAnnotationsCounter;
                    this.generateAnnotation(annotation, annotationAttributeOffset);
                    if (this.contentsOffset == annotationAttributeOffset) break;
                }
                ++i;
            }
            if (this.contentsOffset != annotationAttributeOffset) {
                attributeLength = this.contentsOffset - attributeLengthOffset - 4;
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 24);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 16);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 8);
                this.contents[attributeLengthOffset++] = (byte)attributeLength;
                ++attributesNumber;
            } else {
                this.contentsOffset = annotationAttributeOffset;
            }
        }
        return attributesNumber;
    }

    private int generateRuntimeAnnotationsForParameters(Argument[] arguments) {
        int attributeLength;
        Annotation annotation;
        int max;
        int j;
        Annotation[] annotations;
        Argument argument;
        int i;
        int attributeLengthOffset;
        int argumentsLength = arguments.length;
        boolean VISIBLE_INDEX = false;
        boolean INVISIBLE_INDEX = true;
        int invisibleParametersAnnotationsCounter = 0;
        int visibleParametersAnnotationsCounter = 0;
        int[][] annotationsCounters = new int[argumentsLength][2];
        int i2 = 0;
        while (i2 < argumentsLength) {
            Argument argument2 = arguments[i2];
            Annotation[] annotations2 = argument2.annotations;
            if (annotations2 != null) {
                int j2 = 0;
                int max2 = annotations2.length;
                while (j2 < max2) {
                    Annotation annotation2 = annotations2[j2];
                    if (this.isRuntimeInvisible(annotation2)) {
                        int[] nArray = annotationsCounters[i2];
                        nArray[1] = nArray[1] + 1;
                        ++invisibleParametersAnnotationsCounter;
                    } else if (this.isRuntimeVisible(annotation2)) {
                        int[] nArray = annotationsCounters[i2];
                        nArray[0] = nArray[0] + 1;
                        ++visibleParametersAnnotationsCounter;
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        int attributesNumber = 0;
        int annotationAttributeOffset = this.contentsOffset;
        if (invisibleParametersAnnotationsCounter != 0) {
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            int attributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(attributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)attributeNameIndex;
            attributeLengthOffset = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)argumentsLength;
            i = 0;
            block2: while (i < argumentsLength) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (invisibleParametersAnnotationsCounter == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                } else {
                    int numberOfInvisibleAnnotations = annotationsCounters[i][1];
                    this.contents[this.contentsOffset++] = (byte)(numberOfInvisibleAnnotations >> 8);
                    this.contents[this.contentsOffset++] = (byte)numberOfInvisibleAnnotations;
                    if (numberOfInvisibleAnnotations != 0) {
                        argument = arguments[i];
                        annotations = argument.annotations;
                        j = 0;
                        max = annotations.length;
                        while (j < max) {
                            annotation = annotations[j];
                            if (this.isRuntimeInvisible(annotation)) {
                                this.generateAnnotation(annotation, annotationAttributeOffset);
                                if (this.contentsOffset == annotationAttributeOffset) break block2;
                                --invisibleParametersAnnotationsCounter;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (this.contentsOffset != annotationAttributeOffset) {
                attributeLength = this.contentsOffset - attributeLengthOffset - 4;
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 24);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 16);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 8);
                this.contents[attributeLengthOffset++] = (byte)attributeLength;
                ++attributesNumber;
            } else {
                this.contentsOffset = annotationAttributeOffset;
            }
        }
        if (visibleParametersAnnotationsCounter != 0) {
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            int attributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(attributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)attributeNameIndex;
            attributeLengthOffset = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)argumentsLength;
            i = 0;
            block4: while (i < argumentsLength) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (visibleParametersAnnotationsCounter == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                } else {
                    int numberOfVisibleAnnotations = annotationsCounters[i][0];
                    this.contents[this.contentsOffset++] = (byte)(numberOfVisibleAnnotations >> 8);
                    this.contents[this.contentsOffset++] = (byte)numberOfVisibleAnnotations;
                    if (numberOfVisibleAnnotations != 0) {
                        argument = arguments[i];
                        annotations = argument.annotations;
                        j = 0;
                        max = annotations.length;
                        while (j < max) {
                            annotation = annotations[j];
                            if (this.isRuntimeVisible(annotation)) {
                                this.generateAnnotation(annotation, annotationAttributeOffset);
                                if (this.contentsOffset == annotationAttributeOffset) break block4;
                                --visibleParametersAnnotationsCounter;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (this.contentsOffset != annotationAttributeOffset) {
                attributeLength = this.contentsOffset - attributeLengthOffset - 4;
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 24);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 16);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 8);
                this.contents[attributeLengthOffset++] = (byte)attributeLength;
                ++attributesNumber;
            } else {
                this.contentsOffset = annotationAttributeOffset;
            }
        }
        return attributesNumber;
    }

    public byte[] getBytes() {
        byte[] fullContents = new byte[this.headerOffset + this.contentsOffset];
        System.arraycopy(this.header, 0, fullContents, 0, this.headerOffset);
        System.arraycopy(this.contents, 0, fullContents, this.headerOffset, this.contentsOffset);
        return fullContents;
    }

    public char[][] getCompoundName() {
        return CharOperation.splitOn('/', this.fileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initByteArrays() {
        LookupEnvironment env;
        LookupEnvironment lookupEnvironment = env = this.referenceBinding.scope.environment();
        synchronized (lookupEnvironment) {
            if (env.sharedArraysUsed) {
                this.ownSharedArrays = false;
                int members = this.referenceBinding.methods().length + this.referenceBinding.fields().length;
                this.header = new byte[1500];
                this.contents = new byte[members < 15 ? 400 : 1500];
            } else {
                env.sharedArraysUsed = true;
                this.ownSharedArrays = true;
                this.header = env.sharedClassFileHeader;
                this.contents = env.sharedClassFileContents;
            }
        }
    }

    private boolean isRuntimeInvisible(Annotation annotation) {
        TypeBinding annotationBinding = annotation.resolvedType;
        if (annotationBinding == null) {
            return false;
        }
        long metaTagBits = annotationBinding.getAnnotationTagBits();
        if ((metaTagBits & 0x180000000000L) == 0L) {
            return true;
        }
        return (metaTagBits & 0x180000000000L) == 0x100000000000L;
    }

    private boolean isRuntimeVisible(Annotation annotation) {
        TypeBinding annotationBinding = annotation.resolvedType;
        if (annotationBinding == null) {
            return false;
        }
        long metaTagBits = annotationBinding.getAnnotationTagBits();
        if ((metaTagBits & 0x180000000000L) == 0L) {
            return false;
        }
        return (metaTagBits & 0x180000000000L) == 0x180000000000L;
    }

    public ClassFile outerMostEnclosingClassFile() {
        ClassFile current = this;
        while (current.enclosingClassFile != null) {
            current = current.enclosingClassFile;
        }
        return current;
    }

    public void recordEnclosingTypeAttributes(ReferenceBinding binding) {
        ReferenceBinding enclosingType = this.referenceBinding.enclosingType();
        int depth = 0;
        while (enclosingType != null) {
            ++depth;
            enclosingType = enclosingType.enclosingType();
        }
        enclosingType = this.referenceBinding;
        if (depth >= 2) {
            ReferenceBinding[] enclosingTypes = new ReferenceBinding[depth];
            int i = depth - 1;
            while (i >= 0) {
                enclosingTypes[i] = enclosingType;
                enclosingType = enclosingType.enclosingType();
                --i;
            }
            i = 0;
            while (i < depth) {
                this.addInnerClasses(enclosingTypes[i]);
                ++i;
            }
        } else {
            this.addInnerClasses(this.referenceBinding);
        }
    }

    public void recordNestedLocalAttribute(ReferenceBinding binding) {
        ReferenceBinding enclosingType = this.referenceBinding.enclosingType();
        int depth = 0;
        while (enclosingType != null) {
            ++depth;
            enclosingType = enclosingType.enclosingType();
        }
        enclosingType = this.referenceBinding;
        if (depth >= 2) {
            ReferenceBinding[] enclosingTypes = new ReferenceBinding[depth];
            int i = depth - 1;
            while (i >= 0) {
                enclosingTypes[i] = enclosingType;
                enclosingType = enclosingType.enclosingType();
                --i;
            }
            i = 0;
            while (i < depth) {
                this.addInnerClasses(enclosingTypes[i]);
                ++i;
            }
        } else {
            this.addInnerClasses(binding);
        }
    }

    public void recordNestedMemberAttribute(ReferenceBinding binding) {
        this.addInnerClasses(binding);
    }

    private final void resizeContents(int minimalSize) {
        int length = this.contents.length;
        int toAdd = length;
        if (toAdd < minimalSize) {
            toAdd = minimalSize;
        }
        this.contents = new byte[length + toAdd];
        System.arraycopy(this.contents, 0, this.contents, 0, length);
    }

    public void setForMethodInfos() {
        this.methodCountOffset = this.contentsOffset;
        this.contentsOffset += 2;
    }

    private static final ReferenceBinding declaringClass_aroundBody0(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody1$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final ReferenceBinding declaringClass_aroundBody2(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody3$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final ReferenceBinding declaringClass_aroundBody4(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody5$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final ReferenceBinding declaringClass_aroundBody6(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody7$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final ReferenceBinding declaringClass_aroundBody8(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody9$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final ReferenceBinding declaringClass_aroundBody10(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody11$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final ReferenceBinding declaringClass_aroundBody12(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody13$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final ReferenceBinding declaringClass_aroundBody14(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody15$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final ReferenceBinding declaringClass_aroundBody16(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody17$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final ReferenceBinding declaringClass_aroundBody18(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody19$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final ReferenceBinding declaringClass_aroundBody20(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody21$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final ReferenceBinding declaringClass_aroundBody22(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody23$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final ReferenceBinding declaringClass_aroundBody24(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final Object declaringClass_aroundBody25$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }
}

