/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.HierarchyWalker;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.AspectJElementHierarchy;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;

public class ProgramElement
implements IProgramElement {
    private static final long serialVersionUID = 171673495267384449L;
    public static boolean shortITDNames = true;
    private static final String UNDEFINED = "<undefined>";
    private static int AccPublic = 1;
    private static int AccPrivate = 2;
    private static int AccProtected = 4;
    private static int AccPrivileged = 6;
    private static int AccStatic = 8;
    private static int AccFinal = 16;
    private static int AccSynchronized = 32;
    private static int AccVolatile = 64;
    private static int AccTransient = 128;
    private static int AccNative = 256;
    private static int AccInterface = 512;
    private static int AccAbstract = 1024;
    private static int AccStrictfp = 2048;
    protected String name;
    private IProgramElement.Kind kind;
    protected IProgramElement parent = null;
    protected List children = Collections.EMPTY_LIST;
    private Map kvpairs = Collections.EMPTY_MAP;
    protected ISourceLocation sourceLocation = null;
    private int modifiers;
    private String handle = null;

    public ProgramElement() {
    }

    public ProgramElement(String name, IProgramElement.Kind kind, List children) {
        this.name = name;
        this.kind = kind;
        if (children != null) {
            this.setChildren(children);
        }
    }

    public ProgramElement(String name, IProgramElement.Kind kind, ISourceLocation sourceLocation, int modifiers, String comment, List children) {
        this(name, kind, children);
        this.sourceLocation = sourceLocation;
        this.setFormalComment(comment);
        this.modifiers = modifiers;
    }

    public ProgramElement(String name, IProgramElement.Kind kind, int modifiers, String declaringType, String packageName, String comment, ISourceLocation sourceLocation, List relations, List children, boolean member) {
        this(name, kind, children);
        this.sourceLocation = sourceLocation;
        this.kind = kind;
        this.modifiers = modifiers;
        this.setDeclaringType(declaringType);
        this.setFormalComment(comment);
        if (relations != null && relations.size() != 0) {
            this.setRelations(relations);
        }
    }

    public List getModifiers() {
        return ProgramElement.genModifiers(this.modifiers);
    }

    public IProgramElement.Accessibility getAccessibility() {
        return ProgramElement.genAccessibility(this.modifiers);
    }

    public void setDeclaringType(String t) {
        if (t != null && t.length() > 0) {
            if (this.kvpairs == Collections.EMPTY_MAP) {
                this.kvpairs = new HashMap();
            }
            this.kvpairs.put("declaringType", t);
        }
    }

    public String getDeclaringType() {
        String dt = (String)this.kvpairs.get("declaringType");
        if (dt == null) {
            return "";
        }
        return dt;
    }

    public String getPackageName() {
        if (this.kind == IProgramElement.Kind.PACKAGE) {
            return this.getName();
        }
        if (this.getParent() == null || !(this.getParent() instanceof IProgramElement)) {
            return "";
        }
        return this.getParent().getPackageName();
    }

    public IProgramElement.Kind getKind() {
        return this.kind;
    }

    public boolean isCode() {
        return this.kind.equals(IProgramElement.Kind.CODE);
    }

    public ISourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(ISourceLocation sourceLocation) {
    }

    public IMessage getMessage() {
        return (IMessage)this.kvpairs.get("message");
    }

    public void setMessage(IMessage message) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("message", message);
    }

    public IProgramElement getParent() {
        return this.parent;
    }

    public void setParent(IProgramElement parent) {
        this.parent = parent;
    }

    public boolean isMemberKind() {
        return this.kind.isMember();
    }

    public void setRunnable(boolean value) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        if (value) {
            this.kvpairs.put("isRunnable", "true");
        } else {
            this.kvpairs.remove("isRunnable");
        }
    }

    public boolean isRunnable() {
        return this.kvpairs.get("isRunnable") != null;
    }

    public boolean isImplementor() {
        return this.kvpairs.get("isImplementor") != null;
    }

    public void setImplementor(boolean value) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        if (value) {
            this.kvpairs.put("isImplementor", "true");
        } else {
            this.kvpairs.remove("isImplementor");
        }
    }

    public boolean isOverrider() {
        return this.kvpairs.get("isOverrider") != null;
    }

    public void setOverrider(boolean value) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        if (value) {
            this.kvpairs.put("isOverrider", "true");
        } else {
            this.kvpairs.remove("isOverrider");
        }
    }

    public List getRelations() {
        return (List)this.kvpairs.get("relations");
    }

    public void setRelations(List relations) {
        if (relations.size() > 0) {
            if (this.kvpairs == Collections.EMPTY_MAP) {
                this.kvpairs = new HashMap();
            }
            this.kvpairs.put("relations", relations);
        }
    }

    public String getFormalComment() {
        return (String)this.kvpairs.get("formalComment");
    }

    public String toString() {
        return this.toLabelString();
    }

    private static List genModifiers(int modifiers) {
        ArrayList<IProgramElement.Modifiers> modifiersList = new ArrayList<IProgramElement.Modifiers>();
        if ((modifiers & AccStatic) != 0) {
            modifiersList.add(IProgramElement.Modifiers.STATIC);
        }
        if ((modifiers & AccFinal) != 0) {
            modifiersList.add(IProgramElement.Modifiers.FINAL);
        }
        if ((modifiers & AccSynchronized) != 0) {
            modifiersList.add(IProgramElement.Modifiers.SYNCHRONIZED);
        }
        if ((modifiers & AccVolatile) != 0) {
            modifiersList.add(IProgramElement.Modifiers.VOLATILE);
        }
        if ((modifiers & AccTransient) != 0) {
            modifiersList.add(IProgramElement.Modifiers.TRANSIENT);
        }
        if ((modifiers & AccNative) != 0) {
            modifiersList.add(IProgramElement.Modifiers.NATIVE);
        }
        if ((modifiers & AccAbstract) != 0) {
            modifiersList.add(IProgramElement.Modifiers.ABSTRACT);
        }
        return modifiersList;
    }

    public static IProgramElement.Accessibility genAccessibility(int modifiers) {
        if ((modifiers & AccPublic) != 0) {
            return IProgramElement.Accessibility.PUBLIC;
        }
        if ((modifiers & AccPrivate) != 0) {
            return IProgramElement.Accessibility.PRIVATE;
        }
        if ((modifiers & AccProtected) != 0) {
            return IProgramElement.Accessibility.PROTECTED;
        }
        if ((modifiers & AccPrivileged) != 0) {
            return IProgramElement.Accessibility.PRIVILEGED;
        }
        return IProgramElement.Accessibility.PACKAGE;
    }

    public String getBytecodeName() {
        String s = (String)this.kvpairs.get("bytecodeName");
        if (s == null) {
            return UNDEFINED;
        }
        return s;
    }

    public String getBytecodeSignature() {
        String s = (String)this.kvpairs.get("bytecodeSignature");
        return s;
    }

    public void setBytecodeName(String s) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("bytecodeName", s);
    }

    public void setBytecodeSignature(String s) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("bytecodeSignature", s);
    }

    public String getSourceSignature() {
        return (String)this.kvpairs.get("sourceSignature");
    }

    public void setSourceSignature(String string) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("sourceSignature", string);
    }

    public void setKind(IProgramElement.Kind kind) {
        this.kind = kind;
    }

    public void setCorrespondingType(String s) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("returnType", s);
    }

    public String getCorrespondingType() {
        return this.getCorrespondingType(false);
    }

    public String getCorrespondingType(boolean getFullyQualifiedType) {
        String returnType = (String)this.kvpairs.get("returnType");
        if (returnType == null) {
            returnType = "";
        }
        if (getFullyQualifiedType) {
            return returnType;
        }
        int index = returnType.lastIndexOf(".");
        if (index != -1) {
            return returnType.substring(index);
        }
        return returnType;
    }

    public String getName() {
        return this.name;
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
        if (children == null) {
            return;
        }
        Iterator it = children.iterator();
        while (it.hasNext()) {
            ((IProgramElement)it.next()).setParent(this);
        }
    }

    public void addChild(IProgramElement child) {
        if (this.children == null || this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public void addChild(int position, IProgramElement child) {
        if (this.children == null || this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList();
        }
        this.children.add(position, child);
        child.setParent(this);
    }

    public boolean removeChild(IProgramElement child) {
        child.setParent(null);
        return this.children.remove(child);
    }

    public void setName(String string) {
        this.name = string;
    }

    public IProgramElement walk(HierarchyWalker walker) {
        if (this.children != null) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                IProgramElement child = (IProgramElement)it.next();
                walker.process(child);
            }
        }
        return this;
    }

    public String toLongString() {
        final StringBuffer buffer = new StringBuffer();
        HierarchyWalker walker = new HierarchyWalker(){
            private int depth = 0;

            public void preProcess(IProgramElement node) {
                for (int i = 0; i < this.depth; ++i) {
                    buffer.append(' ');
                }
                buffer.append(((Object)node).toString());
                buffer.append('\n');
                this.depth += 2;
            }

            public void postProcess(IProgramElement node) {
                this.depth -= 2;
            }
        };
        walker.process(this);
        return buffer.toString();
    }

    public void setModifiers(int i) {
        this.modifiers = i;
    }

    public String toSignatureString() {
        return this.toSignatureString(true);
    }

    public String toSignatureString(boolean getFullyQualifiedArgTypes) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        List ptypes = this.getParameterTypes();
        if (ptypes != null) {
            sb.append('(');
            Iterator it = ptypes.iterator();
            while (it.hasNext()) {
                String arg = (String)it.next();
                if (getFullyQualifiedArgTypes) {
                    sb.append(arg);
                } else {
                    int index = arg.lastIndexOf(".");
                    if (index != -1) {
                        sb.append(arg.substring(index + 1));
                    } else {
                        sb.append(arg);
                    }
                }
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public String toLinkLabelString() {
        return this.toLinkLabelString(true);
    }

    public String toLinkLabelString(boolean getFullyQualifiedArgTypes) {
        String label;
        if (this.kind == IProgramElement.Kind.CODE || this.kind == IProgramElement.Kind.INITIALIZER) {
            label = this.parent.getParent().getName() + ": ";
        } else if (this.kind.isInterTypeMember()) {
            if (shortITDNames) {
                label = "";
            } else {
                int dotIndex = this.name.indexOf(46);
                if (dotIndex != -1) {
                    return this.parent.getName() + ": " + this.toLabelString().substring(dotIndex + 1);
                }
                label = this.parent.getName() + '.';
            }
        } else {
            label = this.kind == IProgramElement.Kind.CLASS || this.kind == IProgramElement.Kind.ASPECT || this.kind == IProgramElement.Kind.INTERFACE ? "" : (this.kind.equals(IProgramElement.Kind.DECLARE_PARENTS) ? "" : (this.parent != null ? this.parent.getName() + '.' : "injar aspect: "));
        }
        label = label + this.toLabelString(getFullyQualifiedArgTypes);
        return label;
    }

    public String toLabelString() {
        return this.toLabelString(true);
    }

    public String toLabelString(boolean getFullyQualifiedArgTypes) {
        String label = this.toSignatureString(getFullyQualifiedArgTypes);
        String details = this.getDetails();
        if (details != null) {
            label = label + ": " + details;
        }
        return label;
    }

    public String getHandleIdentifier() {
        if (null == this.handle && this.sourceLocation != null) {
            this.handle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(this.sourceLocation);
        }
        return this.handle;
    }

    public List getParameterNames() {
        List parameterNames = (List)this.kvpairs.get("parameterNames");
        return parameterNames;
    }

    public void setParameterNames(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("parameterNames", list);
    }

    public List getParameterTypes() {
        List parameterTypes = (List)this.kvpairs.get("parameterTypes");
        return parameterTypes;
    }

    public void setParameterTypes(List list) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        if (list == null || list.size() == 0) {
            this.kvpairs.put("parameterTypes", Collections.EMPTY_LIST);
        } else {
            this.kvpairs.put("parameterTypes", list);
        }
    }

    public String getDetails() {
        String details = (String)this.kvpairs.get("details");
        return details;
    }

    public void setDetails(String string) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("details", string);
    }

    public void setFormalComment(String txt) {
        if (txt != null && txt.length() > 0) {
            if (this.kvpairs == Collections.EMPTY_MAP) {
                this.kvpairs = new HashMap();
            }
            this.kvpairs.put("formalComment", txt);
        }
    }

    private void cacheByHandle() {
        String handle = this.getHandleIdentifier();
        if (handle != null) {
            AspectJElementHierarchy hierarchy = (AspectJElementHierarchy)AsmManager.getDefault().getHierarchy();
            hierarchy.cache(handle, this);
        }
    }

    public void setExtraInfo(IProgramElement.ExtraInformation info) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("ExtraInformation", info);
    }

    public IProgramElement.ExtraInformation getExtraInfo() {
        return (IProgramElement.ExtraInformation)this.kvpairs.get("ExtraInformation");
    }
}

