/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildOptionsAdapter;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.internal.BuildNotifierAdapter;
import org.aspectj.ajdt.ajc.AjdtCommand;
import org.aspectj.ajdt.ajc.BuildArgParser;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.ajdt.internal.core.builder.IncrementalStateManager;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.util.LangUtil;

public class CompilerAdapter {
    private static final Set DEFAULT__AJDE_WARNINGS = new HashSet();
    private AjBuildManager buildManager = null;
    private IMessageHandler messageHandler = null;
    private BuildNotifierAdapter currNotifier = null;
    private boolean initialized = false;
    private boolean structureDirty = true;
    private boolean showInfoMessages = false;
    private boolean nextBuild = false;

    public void showInfoMessages(boolean show) {
        this.showInfoMessages = show;
    }

    public boolean getShowInfoMessages() {
        return this.showInfoMessages;
    }

    public void nextBuildFresh() {
        if (this.nextBuild) {
            this.nextBuild = false;
        }
    }

    public void requestCompileExit() {
        if (this.currNotifier != null) {
            this.currNotifier.cancelBuild();
        } else {
            this.signalText("unable to cancel build process");
        }
    }

    public boolean isStructureDirty() {
        return this.structureDirty;
    }

    public void setStructureDirty(boolean structureDirty) {
        this.structureDirty = structureDirty;
    }

    public boolean compile(String configFile, BuildProgressMonitor progressMonitor, boolean buildModel) {
        if (configFile == null) {
            Ajde.getDefault().getErrorHandler().handleError("Tried to build null config file.");
        }
        this.init();
        try {
            boolean successfulBuild;
            boolean incrementalEnabled;
            CompilationAndWeavingContext.reset();
            AjBuildConfig buildConfig = this.genBuildConfig(configFile);
            if (buildConfig == null) {
                return false;
            }
            buildConfig.setGenerateModelMode(buildModel);
            this.currNotifier = new BuildNotifierAdapter(progressMonitor, this.buildManager);
            this.buildManager.setProgressListener(this.currNotifier);
            String rtInfo = this.buildManager.checkRtJar(buildConfig);
            if (rtInfo != null) {
                Ajde.getDefault().getErrorHandler().handleWarning("AspectJ Runtime error: " + rtInfo + "  Please place a valid aspectjrt.jar on the classpath.");
                return false;
            }
            boolean bl = incrementalEnabled = buildConfig.isIncrementalMode() || buildConfig.isIncrementalFileMode();
            if (incrementalEnabled && this.nextBuild) {
                successfulBuild = this.buildManager.incrementalBuild(buildConfig, this.messageHandler);
            } else {
                if (incrementalEnabled) {
                    this.nextBuild = incrementalEnabled;
                }
                successfulBuild = this.buildManager.batchBuild(buildConfig, this.messageHandler);
            }
            IncrementalStateManager.recordSuccessfulBuild(configFile, this.buildManager.getState());
            return successfulBuild;
        }
        catch (AbortException e) {
            IMessage message = e.getIMessage();
            if (message == null) {
                this.signalThrown(e);
            } else {
                String messageText = message.getMessage() + "\n" + CompilationAndWeavingContext.getCurrentContext();
                Ajde.getDefault().getErrorHandler().handleError(messageText, message.getThrown());
            }
            return false;
        }
        catch (Throwable t) {
            this.signalThrown(t);
            return false;
        }
    }

    public AjBuildConfig genBuildConfig(String configFilePath) {
        String message;
        this.init();
        File configFile = new File(configFilePath);
        if (!configFile.exists()) {
            Ajde.getDefault().getErrorHandler().handleError("Config file \"" + configFile + "\" does not exist.");
            return null;
        }
        String[] args = new String[]{"@" + configFile.getAbsolutePath()};
        CountingMessageHandler handler = CountingMessageHandler.makeCountingMessageHandler(this.messageHandler);
        BuildArgParser parser = new BuildArgParser(handler);
        AjBuildConfig config = new AjBuildConfig();
        parser.populateBuildConfig(config, args, false, configFile);
        CompilerAdapter.configureBuildOptions(config, Ajde.getDefault().getBuildManager().getBuildOptions(), handler);
        this.configureProjectOptions(config, Ajde.getDefault().getProjectProperties());
        SourceLocation location = null;
        if (config.getConfigFile() != null) {
            location = new SourceLocation(config.getConfigFile(), 0);
        }
        if (null != (message = parser.getOtherMessages(true))) {
            Message m = new Message(message, IMessage.ERROR, null, location);
            handler.handleMessage(m);
        }
        config.setGenerateModelMode(true);
        if (Ajde.getDefault().getBuildManager().getBuildOptions().getJavaOptionsMap() != null) {
            config.getOptions().set(Ajde.getDefault().getBuildManager().getBuildOptions().getJavaOptionsMap());
        }
        return config;
    }

    protected void signalText(String text) {
        Ajde.getDefault().getIdeUIAdapter().displayStatusInformation(text);
    }

    protected void signalThrown(Throwable t) {
        String text = LangUtil.unqualifiedClassName(t) + " thrown: " + t.getMessage();
        Ajde.getDefault().getErrorHandler().handleError(text, t);
    }

    private static boolean configureBuildOptions(AjBuildConfig config, BuildOptionsAdapter options, IMessageHandler handler) {
        String version;
        Map jom;
        Set warnings;
        String sourceLevel;
        String compliance;
        LangUtil.throwIaxIfNull(options, "options");
        LangUtil.throwIaxIfNull(config, "config");
        HashMap<String, String> optionsToSet = new HashMap<String, String>();
        LangUtil.throwIaxIfNull(optionsToSet, "javaOptions");
        if (options.getSourceCompatibilityLevel() != null && options.getSourceCompatibilityLevel().equals("1.5")) {
            optionsToSet.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            optionsToSet.put("org.eclipse.jdt.core.compiler.source", "1.5");
        } else if (options.getSourceCompatibilityLevel() != null && options.getSourceCompatibilityLevel().equals("1.4")) {
            optionsToSet.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            optionsToSet.put("org.eclipse.jdt.core.compiler.source", "1.4");
        }
        String enc = options.getCharacterEncoding();
        if (!LangUtil.isEmpty(enc)) {
            optionsToSet.put("org.eclipse.jdt.core.encoding", enc);
        }
        if (!LangUtil.isEmpty(compliance = options.getComplianceLevel())) {
            String version2 = "1.4";
            if (compliance.equals("1.3")) {
                version2 = "1.3";
            }
            optionsToSet.put("org.eclipse.jdt.core.compiler.compliance", version2);
            optionsToSet.put("org.eclipse.jdt.core.compiler.source", version2);
        }
        if (!LangUtil.isEmpty(sourceLevel = options.getSourceCompatibilityLevel())) {
            String setCompliance;
            String slVersion = "1.4";
            if (sourceLevel.equals("1.3")) {
                slVersion = "1.3";
            }
            if (sourceLevel.equals("1.5")) {
                optionsToSet.put("org.eclipse.jdt.core.compiler.source", "1.5");
            } else if (!(!optionsToSet.containsKey("org.eclipse.jdt.core.compiler.compliance") || (setCompliance = (String)optionsToSet.get("org.eclipse.jdt.core.compiler.compliance")).equals("1.4") && slVersion.equals("1.3"))) {
                optionsToSet.put("org.eclipse.jdt.core.compiler.source", slVersion);
            }
        }
        if (!LangUtil.isEmpty(warnings = options.getWarnings())) {
            CompilerAdapter.disableWarnings(optionsToSet);
            CompilerAdapter.enableWarnings(optionsToSet, warnings);
        } else if (warnings == null) {
            CompilerAdapter.enableWarnings(optionsToSet, DEFAULT__AJDE_WARNINGS);
        }
        Set debugOptions = options.getDebugLevel();
        if (!LangUtil.isEmpty(debugOptions)) {
            boolean sourceLine = false;
            boolean varAttr = false;
            boolean lineNo = false;
            Iterator it = debugOptions.iterator();
            while (it.hasNext()) {
                String debug = (String)it.next();
                if (debug.equals("all")) {
                    sourceLine = true;
                    varAttr = true;
                    lineNo = true;
                    continue;
                }
                if (debug.equals("lines")) {
                    lineNo = true;
                    continue;
                }
                if (debug.equals("source")) {
                    sourceLine = true;
                    continue;
                }
                if (!debug.equals("vars")) continue;
                varAttr = true;
            }
            if (sourceLine) {
                optionsToSet.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
            }
            if (varAttr) {
                optionsToSet.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
            }
            if (lineNo) {
                optionsToSet.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
            }
        }
        if (options.getPreserveAllLocals()) {
            optionsToSet.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        }
        if (!config.isIncrementalMode() && options.getIncrementalMode()) {
            config.setIncrementalMode(true);
        }
        if ((jom = options.getJavaOptionsMap()) != null && (version = (String)jom.get("org.eclipse.jdt.core.compiler.compliance")) != null && version.equals("1.5")) {
            config.setBehaveInJava5Way(true);
        }
        config.getOptions().set(optionsToSet);
        String toAdd = options.getNonStandardOptions();
        return LangUtil.isEmpty(toAdd) ? true : CompilerAdapter.configureNonStandardOptions(config, toAdd, handler);
    }

    private static void disableWarnings(Map options) {
        options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
    }

    private static void enableWarnings(Map options, Set warnings) {
        Iterator it = warnings.iterator();
        while (it.hasNext()) {
            String thisWarning = (String)it.next();
            if (thisWarning.equals("assertIdentifier")) {
                options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "warning");
                continue;
            }
            if (thisWarning.equals("constructorName")) {
                options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", "warning");
                continue;
            }
            if (thisWarning.equals("deprecation")) {
                options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                continue;
            }
            if (thisWarning.equals("maskedCatchBlocks")) {
                options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "warning");
                continue;
            }
            if (thisWarning.equals("packageDefaultMethod")) {
                options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", "warning");
                continue;
            }
            if (thisWarning.equals("syntheticAccess")) {
                options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "warning");
                continue;
            }
            if (thisWarning.equals("unusedArguments")) {
                options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
                continue;
            }
            if (thisWarning.equals("unusedImports")) {
                options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
                continue;
            }
            if (thisWarning.equals("unusedLocals")) {
                options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
                continue;
            }
            if (!thisWarning.equals("nonExternalisedString")) continue;
            options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        }
    }

    private static List tokenizeString(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(str);
        while (tok.hasMoreTokens()) {
            tokens.add(tok.nextToken());
        }
        return tokens;
    }

    private static boolean configureNonStandardOptions(AjBuildConfig config, String nonStdOptions, IMessageHandler messageHandler) {
        if (LangUtil.isEmpty(nonStdOptions)) {
            return true;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int ind = nonStdOptions.indexOf(34);
        int ind2 = nonStdOptions.indexOf(34, ind + 1);
        if (ind > -1 && ind2 > -1) {
            String pre = nonStdOptions.substring(0, ind);
            String quoted = nonStdOptions.substring(ind + 1, ind2);
            String post = nonStdOptions.substring(ind2 + 1, nonStdOptions.length());
            tokens.addAll(CompilerAdapter.tokenizeString(pre));
            tokens.add(quoted);
            tokens.addAll(CompilerAdapter.tokenizeString(post));
        } else {
            tokens.addAll(CompilerAdapter.tokenizeString(nonStdOptions));
        }
        String[] args = tokens.toArray(new String[0]);
        CountingMessageHandler counter = CountingMessageHandler.makeCountingMessageHandler(messageHandler);
        AjBuildConfig altConfig = AjdtCommand.genBuildConfig(args, counter);
        if (counter.hasErrors()) {
            return false;
        }
        config.installGlobals(altConfig);
        return true;
    }

    private void configureProjectOptions(AjBuildConfig config, ProjectPropertiesAdapter properties) {
        ArrayList<String> both;
        String entry;
        ArrayList<String> toAdd;
        List configClasspath;
        StringTokenizer st;
        String propcp = properties.getClasspath();
        if (!LangUtil.isEmpty(propcp)) {
            st = new StringTokenizer(propcp, File.pathSeparator);
            configClasspath = config.getClasspath();
            toAdd = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                entry = st.nextToken();
                if (configClasspath.contains(entry)) continue;
                toAdd.add(entry);
            }
            if (0 < toAdd.size()) {
                both = new ArrayList<String>(configClasspath.size() + toAdd.size());
                both.addAll(configClasspath);
                both.addAll(toAdd);
                config.setClasspath(both);
                Ajde.getDefault().logEvent("building with classpath: " + both);
            }
        }
        if (!LangUtil.isEmpty(propcp = properties.getBootClasspath())) {
            st = new StringTokenizer(propcp, File.pathSeparator);
            configClasspath = config.getBootclasspath();
            toAdd = new ArrayList();
            while (st.hasMoreTokens()) {
                entry = st.nextToken();
                if (configClasspath.contains(entry)) continue;
                toAdd.add(entry);
            }
            if (0 < toAdd.size()) {
                both = new ArrayList(configClasspath.size() + toAdd.size());
                both.addAll(configClasspath);
                both.addAll(toAdd);
                config.setBootclasspath(both);
                Ajde.getDefault().logEvent("building with boot classpath: " + both);
            }
        }
        if (null == config.getOutputDir() && null == config.getOutputJar()) {
            String outJar;
            String outPath = properties.getOutputPath();
            if (!LangUtil.isEmpty(outPath)) {
                config.setOutputDir(new File(outPath));
            }
            if (!LangUtil.isEmpty(outJar = properties.getOutJar())) {
                config.setOutputJar(new File(outJar));
            }
        }
        this.join(config.getSourceRoots(), properties.getSourceRoots());
        this.join(config.getInJars(), properties.getInJars());
        this.join(config.getInpath(), properties.getInpath());
        config.setSourcePathResources(properties.getSourcePathResources());
        this.join(config.getAspectpath(), properties.getAspectPath());
    }

    void join(Collection target, Collection source) {
        if (null == target || null == source) {
            return;
        }
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (target.contains(next)) continue;
            target.add(next);
        }
    }

    private void init() {
        if (!this.initialized) {
            this.messageHandler = Ajde.getDefault().getMessageHandler() != null ? Ajde.getDefault().getMessageHandler() : new MessageHandlerAdapter();
            this.buildManager = new AjBuildManager(this.messageHandler);
            this.buildManager.environmentSupportsIncrementalCompilation(true);
            this.initialized = true;
        }
    }

    public void setState(AjState buildState) {
        this.buildManager.setState(buildState);
        this.buildManager.setStructureModel(buildState.getStructureModel());
    }

    static {
        DEFAULT__AJDE_WARNINGS.add("assertIdentifier");
        DEFAULT__AJDE_WARNINGS.add("constructorName");
        DEFAULT__AJDE_WARNINGS.add("deprecation");
        DEFAULT__AJDE_WARNINGS.add("maskedCatchBlocks");
        DEFAULT__AJDE_WARNINGS.add("packageDefaultMethod");
        DEFAULT__AJDE_WARNINGS.add("unusedImports");
    }

    class MessageHandlerAdapter
    extends MessageHandler {
        private TaskListManager taskListManager = Ajde.getDefault().getTaskListManager();

        public boolean handleMessage(IMessage message) throws AbortException {
            IMessage.Kind kind = message.getKind();
            if (kind == IMessage.ABORT) {
                return this.handleAbort(message);
            }
            if (this.isIgnoring(kind) || !CompilerAdapter.this.showInfoMessages && IMessage.INFO.equals(kind)) {
                return true;
            }
            this.taskListManager.addSourcelineTask(message);
            return super.handleMessage(message);
        }

        private boolean handleAbort(IMessage abortMessage) {
            throw new AbortException(abortMessage);
        }
    }
}

