/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.ui.swing.CompilerMessagesCellRenderer;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;

public class CompilerMessagesPanel
extends JPanel
implements TaskListManager {
    private static final long serialVersionUID = -2251912345065588977L;
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JList list = new JList();
    private DefaultListModel listModel = new DefaultListModel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private boolean hasWarning = false;

    public CompilerMessagesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.list.setModel(this.listModel);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 1) {
                    int index = CompilerMessagesPanel.this.list.locationToIndex(e.getPoint());
                    if (CompilerMessagesPanel.this.listModel.getSize() >= index && index != -1) {
                        IMessage message = (IMessage)CompilerMessagesPanel.this.listModel.getElementAt(index);
                        Ajde.getDefault().getEditorAdapter().showSourceLine(message.getSourceLocation(), true);
                    }
                }
            }
        };
        this.list.addMouseListener(mouseListener);
        this.list.setCellRenderer(new CompilerMessagesCellRenderer());
    }

    public void addSourcelineTask(IMessage message) {
        this.listModel.addElement(message);
        this.checkIfWarning(message.getKind());
    }

    public void addSourcelineTask(String message, ISourceLocation sourceLocation, IMessage.Kind kind) {
        this.listModel.addElement(new Message(message, kind, null, sourceLocation));
        this.checkIfWarning(kind);
    }

    public void addProjectTask(String message, IMessage.Kind kind) {
        this.listModel.addElement(new Message(message, kind, null, null));
        this.checkIfWarning(kind);
    }

    private void checkIfWarning(IMessage.Kind kind) {
        if (kind.equals(IMessage.WARNING)) {
            this.hasWarning = true;
        }
    }

    public void clearTasks() {
        this.listModel.clear();
        this.hasWarning = false;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.list, null);
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }
}

