/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.reflect;

import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.reflect.ReflectionBasedReferenceTypeDelegateFactory;

public class ReflectionWorld
extends World {
    public ReflectionWorld() {
        this.setMessageHandler(new ExceptionBasedMessageHandler());
        this.setBehaveInJava5Way(LangUtil.is15VMOrGreater());
    }

    public ResolvedType resolve(Class aClass) {
        String className = aClass.getName();
        if (aClass.isArray()) {
            return this.resolve(UnresolvedType.forSignature(className));
        }
        return this.resolve(className);
    }

    protected ReferenceTypeDelegate resolveDelegate(ReferenceType ty) {
        return ReflectionBasedReferenceTypeDelegateFactory.createDelegate(ty, this);
    }

    public Advice createAdviceMunger(AjAttribute.AdviceAttribute attribute, Pointcut pointcut, Member signature) {
        throw new UnsupportedOperationException("Cannot create advice munger in ReflectionWorld");
    }

    public ConcreteTypeMunger makeCflowStackFieldAdder(ResolvedMember cflowField) {
        throw new UnsupportedOperationException("Cannot create cflow stack in ReflectionWorld");
    }

    public ConcreteTypeMunger makeCflowCounterFieldAdder(ResolvedMember cflowField) {
        throw new UnsupportedOperationException("Cannot create cflow counter in ReflectionWorld");
    }

    public ConcreteTypeMunger makePerClauseAspect(ResolvedType aspect, PerClause.Kind kind) {
        throw new UnsupportedOperationException("Cannot create per clause in ReflectionWorld");
    }

    public ConcreteTypeMunger concreteTypeMunger(ResolvedTypeMunger munger, ResolvedType aspectType) {
        throw new UnsupportedOperationException("Cannot create type munger in ReflectionWorld");
    }

    private static class ExceptionBasedMessageHandler
    implements IMessageHandler {
        private ExceptionBasedMessageHandler() {
        }

        public boolean handleMessage(IMessage message) throws AbortException {
            throw new ReflectionWorldException(message.toString());
        }

        public boolean isIgnoring(IMessage.Kind kind) {
            return kind == IMessage.INFO;
        }

        public void dontIgnore(IMessage.Kind kind) {
        }
    }

    public static class ReflectionWorldException
    extends RuntimeException {
        private static final long serialVersionUID = -3432261918302793005L;

        public ReflectionWorldException(String message) {
            super(message);
        }
    }
}

