/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.aspectj.asm.IHierarchy;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.context.PinpointingMessageHandler;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BoundedReferenceType;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.CrosscuttingMembersSet;
import org.aspectj.weaver.Dump;
import org.aspectj.weaver.ICrossReferenceHandler;
import org.aspectj.weaver.IHasSourceLocation;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MissingResolvedTypeWithKnownSignature;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.TypeFactory;
import org.aspectj.weaver.TypeVariableDeclaringElement;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public abstract class World
implements Dump.INode {
    private IMessageHandler messageHandler = IMessageHandler.SYSTEM_ERR;
    private ICrossReferenceHandler xrefHandler = null;
    private TypeVariableDeclaringElement typeVariableLookupScope;
    protected TypeMap typeMap = new TypeMap();
    private AspectPrecedenceCalculator precedenceCalculator;
    private CrosscuttingMembersSet crosscuttingMembersSet = new CrosscuttingMembersSet(this);
    private IHierarchy model = null;
    private Lint lint = new Lint(this);
    private boolean XnoInline;
    private boolean XlazyTjp;
    private boolean XhasMember = false;
    private boolean Xpinpoint = false;
    private boolean behaveInJava5Way = false;
    private List dumpState_cantFindTypeExceptions = null;
    private ResolvedType currentlyResolvingBaseType;

    protected World() {
        Dump.registerNode(this.getClass(), this);
        this.typeMap.put("B", ResolvedType.BYTE);
        this.typeMap.put("S", ResolvedType.SHORT);
        this.typeMap.put("I", ResolvedType.INT);
        this.typeMap.put("J", ResolvedType.LONG);
        this.typeMap.put("F", ResolvedType.FLOAT);
        this.typeMap.put("D", ResolvedType.DOUBLE);
        this.typeMap.put("C", ResolvedType.CHAR);
        this.typeMap.put("Z", ResolvedType.BOOLEAN);
        this.typeMap.put("V", ResolvedType.VOID);
        this.precedenceCalculator = new AspectPrecedenceCalculator(this);
    }

    public void accept(Dump.IVisitor visitor) {
        visitor.visitString("Shadow mungers:");
        visitor.visitList(this.crosscuttingMembersSet.getShadowMungers());
        visitor.visitString("Type mungers:");
        visitor.visitList(this.crosscuttingMembersSet.getTypeMungers());
        visitor.visitString("Late Type mungers:");
        visitor.visitList(this.crosscuttingMembersSet.getLateTypeMungers());
        if (this.dumpState_cantFindTypeExceptions != null) {
            visitor.visitString("Cant find type problems:");
            visitor.visitList(this.dumpState_cantFindTypeExceptions);
            this.dumpState_cantFindTypeExceptions = null;
        }
    }

    public ResolvedType resolve(UnresolvedType ty) {
        return this.resolve(ty, false);
    }

    public ResolvedType resolve(UnresolvedType ty, ISourceLocation isl) {
        ResolvedType ret = this.resolve(ty, true);
        if (ty == ResolvedType.MISSING) {
            IMessage msg = null;
            msg = isl != null ? MessageUtil.error(WeaverMessages.format("cantFindType", ty.getName()), isl) : MessageUtil.error(WeaverMessages.format("cantFindType", ty.getName()));
            this.messageHandler.handleMessage(msg);
        }
        return ret;
    }

    public ResolvedType[] resolve(UnresolvedType[] types) {
        if (types == null) {
            return new ResolvedType[0];
        }
        ResolvedType[] ret = new ResolvedType[types.length];
        for (int i = 0; i < types.length; ++i) {
            ret[i] = this.resolve(types[i]);
        }
        return ret;
    }

    public ResolvedType resolve(UnresolvedType ty, boolean allowMissing) {
        if (ty instanceof ResolvedType) {
            ResolvedType rty = (ResolvedType)ty;
            rty = this.resolve(rty);
            return rty;
        }
        if (ty.isTypeVariableReference()) {
            return ty.resolve(this);
        }
        String signature = ty.getSignature();
        ResolvedType ret = this.typeMap.get(signature);
        if (ret != null) {
            ret.world = this;
            return ret;
        }
        if (signature.equals("?") || signature.equals("*")) {
            BoundedReferenceType something = new BoundedReferenceType("?", this);
            this.typeMap.put("?", something);
            return something;
        }
        if (ty.isArray()) {
            ResolvedType componentType = this.resolve(ty.getComponentType(), allowMissing);
            String brackets = signature.substring(0, signature.lastIndexOf("[") + 1);
            ret = new ResolvedType.Array(signature, brackets + componentType.getErasureSignature(), this, componentType);
        } else {
            ret = this.resolveToReferenceType(ty);
            if (!allowMissing && ret == ResolvedType.MISSING) {
                ret = this.handleRequiredMissingTypeDuringResolution(ty);
            }
        }
        if (this.typeMap.get(signature) == null && ret != ResolvedType.MISSING) {
            this.typeMap.put(signature, ret);
        }
        return ret;
    }

    private ResolvedType handleRequiredMissingTypeDuringResolution(UnresolvedType ty) {
        if (this.dumpState_cantFindTypeExceptions == null) {
            this.dumpState_cantFindTypeExceptions = new ArrayList();
        }
        this.dumpState_cantFindTypeExceptions.add(new RuntimeException("Can't find type " + ty.getName()));
        return new MissingResolvedTypeWithKnownSignature(ty.getSignature(), this);
    }

    public ResolvedType resolve(ResolvedType ty) {
        if (ty.isTypeVariableReference()) {
            return ty;
        }
        ResolvedType resolved = this.typeMap.get(ty.getSignature());
        if (resolved == null) {
            this.typeMap.put(ty.getSignature(), ty);
            resolved = ty;
        }
        resolved.world = this;
        return resolved;
    }

    public ResolvedType resolve(String name) {
        return this.resolve(UnresolvedType.forName(name));
    }

    public ResolvedType resolve(String name, boolean allowMissing) {
        return this.resolve(UnresolvedType.forName(name), allowMissing);
    }

    private final ResolvedType resolveToReferenceType(UnresolvedType ty) {
        if (ty.isParameterizedType()) {
            ReferenceType genericType = (ReferenceType)this.resolveGenericTypeFor(ty, false);
            this.currentlyResolvingBaseType = genericType;
            ReferenceType parameterizedType = TypeFactory.createParameterizedType(genericType, ty.typeParameters, this);
            this.currentlyResolvingBaseType = null;
            return parameterizedType;
        }
        if (ty.isGenericType()) {
            ReferenceType genericType = (ReferenceType)this.resolveGenericTypeFor(ty, false);
            return genericType;
        }
        if (ty.isGenericWildcard()) {
            return this.resolveGenericWildcardFor(ty);
        }
        String erasedSignature = ty.getErasureSignature();
        ReferenceType simpleOrRawType = new ReferenceType(erasedSignature, this);
        ReferenceTypeDelegate delegate = this.resolveDelegate(simpleOrRawType);
        if (delegate == null) {
            return ResolvedType.MISSING;
        }
        if (delegate.isGeneric() && this.behaveInJava5Way) {
            simpleOrRawType.typeKind = UnresolvedType.TypeKind.RAW;
            ReferenceType genericType = this.makeGenericTypeFrom(delegate, simpleOrRawType);
            simpleOrRawType.setDelegate(delegate);
            genericType.setDelegate(delegate);
            simpleOrRawType.setGenericType(genericType);
            return simpleOrRawType;
        }
        simpleOrRawType.setDelegate(delegate);
        return simpleOrRawType;
    }

    public ResolvedType resolveGenericTypeFor(UnresolvedType anUnresolvedType, boolean allowMissing) {
        String rawSignature = anUnresolvedType.getRawType().getSignature();
        ResolvedType rawType = this.typeMap.get(rawSignature);
        if (rawType == null) {
            rawType = this.resolve(UnresolvedType.forSignature(rawSignature), false);
            this.typeMap.put(rawSignature, rawType);
        }
        ResolvedType genericType = rawType.getGenericType();
        if (rawType.isSimpleType() && (anUnresolvedType.typeParameters == null || anUnresolvedType.typeParameters.length == 0)) {
            rawType.world = this;
            return rawType;
        }
        if (genericType != null) {
            genericType.world = this;
            return genericType;
        }
        ReferenceTypeDelegate delegate = this.resolveDelegate((ReferenceType)rawType);
        ReferenceType genericRefType = this.makeGenericTypeFrom(delegate, (ReferenceType)rawType);
        ((ReferenceType)rawType).setGenericType(genericRefType);
        genericRefType.setDelegate(delegate);
        ((ReferenceType)rawType).setDelegate(delegate);
        return genericRefType;
    }

    private ReferenceType makeGenericTypeFrom(ReferenceTypeDelegate delegate, ReferenceType rawType) {
        String genericSig = delegate.getDeclaredGenericSignature();
        if (genericSig != null) {
            return new ReferenceType(UnresolvedType.forGenericTypeSignature(rawType.getSignature(), delegate.getDeclaredGenericSignature()), this);
        }
        return new ReferenceType(UnresolvedType.forGenericTypeVariables(rawType.getSignature(), delegate.getTypeVariables()), this);
    }

    private ReferenceType resolveGenericWildcardFor(UnresolvedType aType) {
        BoundedReferenceType ret = null;
        if (aType.isExtends()) {
            ReferenceType upperBound = (ReferenceType)this.resolve(aType.getUpperBound());
            ret = new BoundedReferenceType(upperBound, true, this);
        } else if (aType.isSuper()) {
            ReferenceType lowerBound = (ReferenceType)this.resolve(aType.getLowerBound());
            ret = new BoundedReferenceType(lowerBound, false, this);
        }
        return ret;
    }

    protected abstract ReferenceTypeDelegate resolveDelegate(ReferenceType var1);

    public ResolvedType getCoreType(UnresolvedType tx) {
        ResolvedType coreTy = this.resolve(tx, true);
        if (coreTy == ResolvedType.MISSING) {
            MessageUtil.error(this.messageHandler, WeaverMessages.format("cantFindCoreType", tx.getName()));
        }
        return coreTy;
    }

    public ReferenceType lookupOrCreateName(UnresolvedType ty) {
        String signature = ty.getSignature();
        ReferenceType ret = this.lookupBySignature(signature);
        if (ret == null) {
            ret = ReferenceType.fromTypeX(ty, this);
            this.typeMap.put(signature, ret);
        }
        return ret;
    }

    public ReferenceType lookupBySignature(String signature) {
        return (ReferenceType)this.typeMap.get(signature);
    }

    public ResolvedMember resolve(Member member) {
        ResolvedMember ret;
        ResolvedType declaring = member.getDeclaringType().resolve(this);
        if (declaring.isRawType()) {
            declaring = declaring.getGenericType();
        }
        if ((ret = member.getKind() == Member.FIELD ? declaring.lookupField(member) : declaring.lookupMethod(member)) != null) {
            return ret;
        }
        return declaring.lookupSyntheticMember(member);
    }

    public abstract Advice createAdviceMunger(AjAttribute.AdviceAttribute var1, Pointcut var2, Member var3);

    public final Advice createAdviceMunger(AdviceKind kind, Pointcut p, Member signature, int extraParameterFlags, IHasSourceLocation loc) {
        AjAttribute.AdviceAttribute attribute = new AjAttribute.AdviceAttribute(kind, p, extraParameterFlags, loc.getStart(), loc.getEnd(), loc.getSourceContext());
        return this.createAdviceMunger(attribute, p, signature);
    }

    public abstract ConcreteTypeMunger makeCflowStackFieldAdder(ResolvedMember var1);

    public abstract ConcreteTypeMunger makeCflowCounterFieldAdder(ResolvedMember var1);

    public abstract ConcreteTypeMunger makePerClauseAspect(ResolvedType var1, PerClause.Kind var2);

    public abstract ConcreteTypeMunger concreteTypeMunger(ResolvedTypeMunger var1, ResolvedType var2);

    public int compareByPrecedence(ResolvedType aspect1, ResolvedType aspect2) {
        return this.precedenceCalculator.compareByPrecedence(aspect1, aspect2);
    }

    public int compareByPrecedenceAndHierarchy(ResolvedType aspect1, ResolvedType aspect2) {
        return this.precedenceCalculator.compareByPrecedenceAndHierarchy(aspect1, aspect2);
    }

    public IMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(IMessageHandler messageHandler) {
        this.messageHandler = this.isInPinpointMode() ? new PinpointingMessageHandler(messageHandler) : messageHandler;
    }

    public void showMessage(IMessage.Kind kind, String message, ISourceLocation loc1, ISourceLocation loc2) {
        if (loc1 != null) {
            this.messageHandler.handleMessage(new Message(message, kind, null, loc1));
            if (loc2 != null) {
                this.messageHandler.handleMessage(new Message(message, kind, null, loc2));
            }
        } else {
            this.messageHandler.handleMessage(new Message(message, kind, null, loc2));
        }
    }

    public void setCrossReferenceHandler(ICrossReferenceHandler xrefHandler) {
        this.xrefHandler = xrefHandler;
    }

    public ICrossReferenceHandler getCrossReferenceHandler() {
        return this.xrefHandler;
    }

    public void setTypeVariableLookupScope(TypeVariableDeclaringElement scope) {
        this.typeVariableLookupScope = scope;
    }

    public TypeVariableDeclaringElement getTypeVariableLookupScope() {
        return this.typeVariableLookupScope;
    }

    public List getDeclareParents() {
        return this.crosscuttingMembersSet.getDeclareParents();
    }

    public List getDeclareAnnotationOnTypes() {
        return this.crosscuttingMembersSet.getDeclareAnnotationOnTypes();
    }

    public List getDeclareAnnotationOnFields() {
        return this.crosscuttingMembersSet.getDeclareAnnotationOnFields();
    }

    public List getDeclareAnnotationOnMethods() {
        return this.crosscuttingMembersSet.getDeclareAnnotationOnMethods();
    }

    public List getDeclareSoft() {
        return this.crosscuttingMembersSet.getDeclareSofts();
    }

    public CrosscuttingMembersSet getCrosscuttingMembersSet() {
        return this.crosscuttingMembersSet;
    }

    public IHierarchy getModel() {
        return this.model;
    }

    public void setModel(IHierarchy model) {
        this.model = model;
    }

    public Lint getLint() {
        return this.lint;
    }

    public void setLint(Lint lint) {
        this.lint = lint;
    }

    public boolean isXnoInline() {
        return this.XnoInline;
    }

    public void setXnoInline(boolean xnoInline) {
        this.XnoInline = xnoInline;
    }

    public boolean isXlazyTjp() {
        return this.XlazyTjp;
    }

    public void setXlazyTjp(boolean b) {
        this.XlazyTjp = b;
    }

    public boolean isHasMemberSupportEnabled() {
        return this.XhasMember;
    }

    public void setXHasMemberSupportEnabled(boolean b) {
        this.XhasMember = b;
    }

    public boolean isInPinpointMode() {
        return this.Xpinpoint;
    }

    public void setPinpointMode(boolean b) {
        this.Xpinpoint = b;
    }

    public void setBehaveInJava5Way(boolean b) {
        this.behaveInJava5Way = b;
    }

    public boolean isInJava5Mode() {
        return this.behaveInJava5Way;
    }

    public void validateType(UnresolvedType type) {
    }

    private static class AspectPrecedenceCalculator {
        private World world;
        private Map cachedResults;

        public AspectPrecedenceCalculator(World forSomeWorld) {
            this.world = forSomeWorld;
            this.cachedResults = new HashMap();
        }

        public int compareByPrecedence(ResolvedType firstAspect, ResolvedType secondAspect) {
            PrecedenceCacheKey key = new PrecedenceCacheKey(firstAspect, secondAspect);
            if (this.cachedResults.containsKey(key)) {
                return (Integer)this.cachedResults.get(key);
            }
            int order = 0;
            DeclarePrecedence orderer = null;
            Iterator i = this.world.getCrosscuttingMembersSet().getDeclareDominates().iterator();
            while (i.hasNext()) {
                DeclarePrecedence d = (DeclarePrecedence)i.next();
                int thisOrder = d.compare(firstAspect, secondAspect);
                if (thisOrder == 0) continue;
                if (orderer == null) {
                    orderer = d;
                }
                if (order != 0 && order != thisOrder) {
                    ISourceLocation[] isls = new ISourceLocation[]{orderer.getSourceLocation(), d.getSourceLocation()};
                    Message m = new Message("conflicting declare precedence orderings for aspects: " + firstAspect.getName() + " and " + secondAspect.getName(), null, true, isls);
                    this.world.getMessageHandler().handleMessage(m);
                    continue;
                }
                order = thisOrder;
            }
            this.cachedResults.put(key, new Integer(order));
            return order;
        }

        public int compareByPrecedenceAndHierarchy(ResolvedType firstAspect, ResolvedType secondAspect) {
            if (firstAspect.equals(secondAspect)) {
                return 0;
            }
            int ret = this.compareByPrecedence(firstAspect, secondAspect);
            if (ret != 0) {
                return ret;
            }
            if (firstAspect.isAssignableFrom(secondAspect)) {
                return -1;
            }
            if (secondAspect.isAssignableFrom(firstAspect)) {
                return 1;
            }
            return 0;
        }

        private static class PrecedenceCacheKey {
            public ResolvedType aspect1;
            public ResolvedType aspect2;

            public PrecedenceCacheKey(ResolvedType a1, ResolvedType a2) {
                this.aspect1 = a1;
                this.aspect2 = a2;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof PrecedenceCacheKey)) {
                    return false;
                }
                PrecedenceCacheKey other = (PrecedenceCacheKey)obj;
                return this.aspect1 == other.aspect1 && this.aspect2 == other.aspect2;
            }

            public int hashCode() {
                return this.aspect1.hashCode() + this.aspect2.hashCode();
            }
        }
    }

    protected static class TypeMap {
        private Map tMap = new HashMap();
        private Map expendableMap = new WeakHashMap();
        private static final boolean debug = false;

        protected TypeMap() {
        }

        public ResolvedType put(String key, ResolvedType type) {
            if (type.isParameterizedType() && type.isParameterizedWithAMemberTypeVariable()) {
                return type;
            }
            if (type.isTypeVariableReference()) {
                return type;
            }
            if (type instanceof BoundedReferenceType) {
                return type;
            }
            if (type instanceof MissingResolvedTypeWithKnownSignature) {
                return type;
            }
            if (this.isExpendable(type)) {
                return this.expendableMap.put(key, type);
            }
            return this.tMap.put(key, type);
        }

        public ResolvedType get(String key) {
            ResolvedType ret = (ResolvedType)this.tMap.get(key);
            if (ret == null) {
                ret = (ResolvedType)this.expendableMap.get(key);
            }
            return ret;
        }

        public ResolvedType remove(String key) {
            ResolvedType ret = (ResolvedType)this.tMap.remove(key);
            if (ret == null) {
                ret = (ResolvedType)this.expendableMap.remove(key);
            }
            return ret;
        }

        private boolean isExpendable(ResolvedType type) {
            return type != null && !type.isExposedToWeaver() && !type.isPrimitiveType();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("types:\n");
            sb.append(this.dumpthem(this.tMap));
            sb.append("expendables:\n");
            sb.append(this.dumpthem(this.expendableMap));
            return sb.toString();
        }

        private String dumpthem(Map m) {
            StringBuffer sb = new StringBuffer();
            Set keys = m.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String k = (String)iter.next();
                sb.append(k + "=" + m.get(k)).append("\n");
            }
            return sb.toString();
        }
    }
}

