/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.Collection;
import java.util.Map;
import org.aspectj.asm.AsmManager;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.util.PartialOrder;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public abstract class ShadowMunger
implements PartialOrder.PartialComparable,
IHasPosition {
    protected Pointcut pointcut;
    protected int start;
    protected int end;
    protected ISourceContext sourceContext;
    private ISourceLocation sourceLocation;
    private String handle = null;
    private ResolvedType declaringType;
    public static final ShadowMunger[] NONE = new ShadowMunger[0];

    public ShadowMunger(Pointcut pointcut, int start, int end, ISourceContext sourceContext) {
        this.pointcut = pointcut;
        this.start = start;
        this.end = end;
        this.sourceContext = sourceContext;
    }

    public abstract ShadowMunger concretize(ResolvedType var1, World var2, PerClause var3);

    public abstract void specializeOn(Shadow var1);

    public abstract void implementOn(Shadow var1);

    public boolean match(Shadow shadow, World world) {
        return this.pointcut.match(shadow).maybeTrue();
    }

    public abstract ShadowMunger parameterizeWith(Map var1);

    public int fallbackCompareTo(Object other) {
        return this.toString().compareTo(this.toString());
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public ISourceLocation getSourceLocation() {
        if (this.sourceLocation == null && this.sourceContext != null) {
            this.sourceLocation = this.sourceContext.makeSourceLocation(this);
        }
        return this.sourceLocation;
    }

    public String getHandle() {
        ISourceLocation sl;
        if (null == this.handle && (sl = this.getSourceLocation()) != null) {
            this.handle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(sl.getSourceFile(), sl.getLine(), sl.getColumn(), sl.getOffset());
        }
        return this.handle;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public void setDeclaringType(ResolvedType aType) {
        this.declaringType = aType;
    }

    public ResolvedType getDeclaringType() {
        return this.declaringType;
    }

    public abstract Collection getThrownExceptions();

    public abstract boolean mustCheckExceptions();

    public abstract /* synthetic */ int compareTo(Object var1);
}

