/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.tools.ajdoc.DocException;
import org.aspectj.tools.ajdoc.StructureUtil;
import org.aspectj.tools.ajdoc.SymbolManager;

class StubFileGenerator {
    static Hashtable declIDTable = null;
    static int nextDeclID = 0;

    StubFileGenerator() {
    }

    static void doFiles(Hashtable table, SymbolManager symbolManager, File[] inputFiles, File[] signatureFiles) throws DocException {
        declIDTable = table;
        for (int i = 0; i < inputFiles.length; ++i) {
            StubFileGenerator.processFile(symbolManager, inputFiles[i], signatureFiles[i]);
        }
    }

    static void processFile(SymbolManager symbolManager, File inputFile, File signatureFile) throws DocException {
        try {
            String path = StructureUtil.translateAjPathName(signatureFile.getCanonicalPath());
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(path)));
            String packageName = StructureUtil.getPackageDeclarationFromFile(inputFile);
            if (packageName != null && packageName != "") {
                writer.println("package " + packageName + ";");
            }
            IProgramElement fileNode = AsmManager.getDefault().getHierarchy().findElementForSourceFile(inputFile.getAbsolutePath());
            Iterator it = fileNode.getChildren().iterator();
            while (it.hasNext()) {
                IProgramElement node = (IProgramElement)it.next();
                if (node.getKind().equals(IProgramElement.Kind.IMPORT_REFERENCE)) {
                    StubFileGenerator.processImportDeclaration(node, writer);
                    continue;
                }
                try {
                    StubFileGenerator.processTypeDeclaration(node, writer);
                }
                catch (DocException d) {
                    throw new DocException("File name invalid: " + inputFile.toString());
                }
            }
            writer.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void processImportDeclaration(IProgramElement node, PrintWriter writer) throws IOException {
        List imports = node.getChildren();
        Iterator i = imports.iterator();
        while (i.hasNext()) {
            IProgramElement importNode = (IProgramElement)i.next();
            writer.print("import ");
            writer.print(importNode.getName());
            writer.println(';');
        }
    }

    private static void processTypeDeclaration(IProgramElement classNode, PrintWriter writer) throws DocException {
        String formalComment = StubFileGenerator.addDeclID(classNode, classNode.getFormalComment());
        writer.println(formalComment);
        String signature = StubFileGenerator.genSourceSignature(classNode);
        if (signature == null) {
            throw new DocException("The java file is invalid");
        }
        if (!StructureUtil.isAnonymous(classNode) && !classNode.getName().equals("<undefined>")) {
            writer.println(signature + " {");
            StubFileGenerator.processMembers(classNode.getChildren(), writer, classNode.getKind().equals(IProgramElement.Kind.INTERFACE));
            writer.println();
            writer.println("}");
        }
    }

    private static void processMembers(List members, PrintWriter writer, boolean declaringTypeIsInterface) throws DocException {
        Iterator it = members.iterator();
        while (it.hasNext()) {
            IProgramElement member = (IProgramElement)it.next();
            if (member.getKind().isType()) {
                if (member.getParent().getKind().equals(IProgramElement.Kind.METHOD) || StructureUtil.isAnonymous(member)) continue;
                StubFileGenerator.processTypeDeclaration(member, writer);
                continue;
            }
            String formalComment = StubFileGenerator.addDeclID(member, member.getFormalComment());
            writer.println(formalComment);
            String signature = "";
            if (!member.getKind().equals(IProgramElement.Kind.POINTCUT) && !member.getKind().equals(IProgramElement.Kind.ADVICE)) {
                signature = member.getSourceSignature();
                if (member.getKind().equals(IProgramElement.Kind.ENUM_VALUE)) {
                    signature = ((IProgramElement)members.get(members.indexOf(member) + 1)).getKind().equals(IProgramElement.Kind.ENUM_VALUE) ? signature + "," : signature + ";";
                }
            }
            if (!(member.getKind().isDeclare() || signature == null || signature == "" || member.getKind().isInterTypeMember() || member.getKind().equals(IProgramElement.Kind.INITIALIZER) || StructureUtil.isAnonymous(member))) {
                writer.print(signature);
            }
            if (member.getKind().equals(IProgramElement.Kind.METHOD) || member.getKind().equals(IProgramElement.Kind.CONSTRUCTOR)) {
                if (member.getParent().getKind().equals(IProgramElement.Kind.INTERFACE) || signature.indexOf("abstract ") != -1) {
                    writer.println(";");
                    continue;
                }
                writer.println(" { }");
                continue;
            }
            if (!member.getKind().equals(IProgramElement.Kind.FIELD)) continue;
        }
    }

    private static String genSourceSignature(IProgramElement classNode) {
        int index;
        String signature = classNode.getSourceSignature();
        if (signature != null && (index = signature.indexOf("aspect")) != -1 && signature.charAt(index - 1) != '.') {
            signature = signature.substring(0, index) + "class " + signature.substring(index + 6, signature.length());
        }
        return signature;
    }

    static String addDeclID(IProgramElement decl, String formalComment) {
        String declID = "" + ++nextDeclID;
        declIDTable.put(declID, decl);
        return StubFileGenerator.addToFormal(formalComment, "__AJDECLID:" + declID + ":__");
    }

    static String addToFormal(String formalComment, String string) {
        boolean appendPeriod = true;
        if (formalComment == null || formalComment.equals("")) {
            formalComment = "/**\n * \n */\n";
            appendPeriod = false;
        }
        formalComment = formalComment.trim();
        int atsignPos = formalComment.indexOf(64);
        int endPos = formalComment.indexOf("*/");
        int periodPos = formalComment.indexOf("/**") + 2;
        int position = 0;
        String periodPlaceHolder = "";
        if (periodPos != -1) {
            position = periodPos + 1;
        } else if (atsignPos != -1) {
            string = string + "\n * ";
            position = atsignPos;
        } else if (endPos != -1) {
            string = "* " + string + "\n";
            position = endPos;
        } else {
            throw new Error("Failed to append to formal comment for comment: " + formalComment);
        }
        return formalComment.substring(0, position) + periodPlaceHolder + string + formalComment.substring(position);
    }
}

