/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.ReplaceEdit;

public class Indents {
    private Indents() {
    }

    public static boolean isIndentChar(char ch) {
        return Character.isWhitespace(ch) && !Indents.isLineDelimiterChar(ch);
    }

    public static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public static int computeIndentUnits(String line, int tabWidth, int indentWidth) {
        if (indentWidth == 0) {
            return -1;
        }
        int visualLength = Indents.measureIndentLength(line, tabWidth);
        return visualLength / indentWidth;
    }

    public static int measureIndentLength(CharSequence line, int tabSize) {
        int length = 0;
        int max = line.length();
        int i = 0;
        while (i < max) {
            char ch = line.charAt(i);
            if (ch == '\t') {
                int reminder = length % tabSize;
                length += tabSize - reminder;
            } else if (Indents.isIndentChar(ch)) {
                ++length;
            } else {
                return length;
            }
            ++i;
        }
        return length;
    }

    public static String trimIndent(String line, int indentsToRemove, int tabWidth, int indentWidth) {
        if (line == null || indentsToRemove <= 0) {
            return line;
        }
        int spaceEquivalentsToRemove = indentsToRemove * indentWidth;
        int start = 0;
        int spaceEquivalents = 0;
        int size = line.length();
        String prefix = null;
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c == '\t') {
                int remainder = spaceEquivalents % tabWidth;
                spaceEquivalents += tabWidth - remainder;
            } else if (Indents.isIndentChar(c)) {
                ++spaceEquivalents;
            } else {
                start = i;
                break;
            }
            if (spaceEquivalents == spaceEquivalentsToRemove) {
                start = i + 1;
                break;
            }
            if (spaceEquivalents > spaceEquivalentsToRemove) {
                start = i + 1;
                char[] missing = new char[spaceEquivalents - spaceEquivalentsToRemove];
                Arrays.fill(missing, ' ');
                prefix = new String(missing);
                break;
            }
            ++i;
        }
        String trimmed = start == size ? "" : line.substring(start);
        if (prefix == null) {
            return trimmed;
        }
        return String.valueOf(prefix) + trimmed;
    }

    public static String getIndentString(String line, int tabWidth, int indentWidth) {
        int size = line.length();
        int end = 0;
        int spaceEquivs = 0;
        int characters = 0;
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c == '\t') {
                int remainder = spaceEquivs % tabWidth;
                spaceEquivs += tabWidth - remainder;
                ++characters;
            } else {
                if (!Indents.isIndentChar(c)) break;
                ++spaceEquivs;
                ++characters;
            }
            if (spaceEquivs >= indentWidth) {
                end += characters;
                characters = 0;
                spaceEquivs %= indentWidth;
            }
            ++i;
        }
        if (end == 0) {
            return "";
        }
        if (end == size) {
            return line;
        }
        return line.substring(0, end);
    }

    public static int computeIndentLength(String line, int numberOfIndents, int tabWidth, int indentWidth) {
        Assert.isTrue(numberOfIndents >= 0);
        Assert.isTrue(tabWidth >= 0);
        Assert.isTrue(indentWidth >= 0);
        int spaceEquivalents = numberOfIndents * indentWidth;
        int size = line.length();
        int result = -1;
        int blanks = 0;
        int i = 0;
        while (i < size && blanks < spaceEquivalents) {
            char c = line.charAt(i);
            if (c == '\t') {
                int remainder = blanks % tabWidth;
                blanks += tabWidth - remainder;
            } else {
                if (!Indents.isIndentChar(c)) break;
                ++blanks;
            }
            result = i++;
        }
        if (blanks < spaceEquivalents) {
            return -1;
        }
        return result + 1;
    }

    public static String changeIndent(String code, int codeIndentLevel, int tabWidth, int indentWidth, String newIndent, String lineDelim) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(code);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return code;
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < nLines) {
                IRegion region = tracker.getLineInformation(i);
                int start = region.getOffset();
                int end = start + region.getLength();
                String line = code.substring(start, end);
                if (i == 0) {
                    buf.append(line);
                } else {
                    buf.append(lineDelim);
                    buf.append(newIndent);
                    buf.append(Indents.trimIndent(line, codeIndentLevel, tabWidth, indentWidth));
                }
                ++i;
            }
            return buf.toString();
        }
        catch (BadLocationException e) {
            return code;
        }
    }

    public static ReplaceEdit[] getChangeIndentEdits(String source, int sourceIndentLevel, int tabWidth, int indentWidth, String newIndent) {
        ArrayList<ReplaceEdit> result = new ArrayList<ReplaceEdit>();
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(source);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return result.toArray(new ReplaceEdit[result.size()]);
            }
            int i = 1;
            while (i < nLines) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                String line = source.substring(offset, offset + region.getLength());
                int length = Indents.computeIndentLength(line, sourceIndentLevel, tabWidth, indentWidth);
                if (length >= 0) {
                    result.add(new ReplaceEdit(offset, length, newIndent));
                } else {
                    length = Indents.computeIndentUnits(line, tabWidth, indentWidth);
                    result.add(new ReplaceEdit(offset, length, ""));
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return result.toArray(new ReplaceEdit[result.size()]);
    }

    public static int getTabWidth(Map options) {
        return Indents.parseIntValue(options, "org.aspectj.org.eclipse.jdt.core.formatter.tabulation.size", 4);
    }

    public static int getIndentWidth(Map options, int tabWidth) {
        boolean isMixedMode = "mixed".equals(options.get("org.aspectj.org.eclipse.jdt.core.formatter.tabulation.char"));
        if (isMixedMode) {
            return Indents.parseIntValue(options, "org.aspectj.org.eclipse.jdt.core.formatter.indentation.size", tabWidth);
        }
        return tabWidth;
    }

    private static int parseIntValue(Map options, String key, int def) {
        try {
            return Integer.parseInt((String)options.get(key));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static String changeIndent(String code, int codeIndentLevel, int tabWidth, String newIndent, String lineDelim) {
        return Indents.changeIndent(code, codeIndentLevel, tabWidth, tabWidth, newIndent, lineDelim);
    }

    public static int computeIndent(String line, int tabWidth) {
        return Indents.computeIndentUnits(line, tabWidth, tabWidth);
    }
}

