/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;

public class ArrayElementValue
extends ElementValue {
    private ElementValue[] evalues;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < this.evalues.length; ++i) {
            sb.append(this.evalues[i].toString());
            if (i + 1 >= this.evalues.length) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public ArrayElementValue(int type, ElementValue[] datums, ConstantPool cpool) {
        super(type, cpool);
        if (type != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor");
        }
        this.evalues = datums;
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        dos.writeShort(this.evalues.length);
        for (int i = 0; i < this.evalues.length; ++i) {
            this.evalues[i].dump(dos);
        }
    }

    public String stringifyValue() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.evalues.length; ++i) {
            sb.append(this.evalues[i].stringifyValue());
            if (i + 1 >= this.evalues.length) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public ElementValue[] getElementValuesArray() {
        return this.evalues;
    }

    public int getElementValuesArraySize() {
        return this.evalues.length;
    }
}

