/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.util.Map;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class AjCompilerOptions
extends CompilerOptions {
    public static final String OPTION_ReportInvalidAbsoluteTypeName = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    public static final String OPTION_ReportInvalidWildcardTypeName = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    public static final String OPTION_ReportUnresolvableMember = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    public static final String OPTION_ReportTypeNotExposedToWeaver = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    public static final String OPTION_ReportShadowNotInStructure = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    public static final String OPTION_ReportUnmatchedSuperTypeInCall = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    public static final String OPTION_ReportCannotImplementLazyTJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    public static final String OPTION_ReportNeedSerialVersionUIDField = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    public static final String OPTION_ReportIncompatibleSerialVersion = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    public static final String OPTION_NoWeave = "org.aspectj.ajdt.core.compiler.weaver.NoWeave";
    public static final String OPTION_XSerializableAspects = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    public static final String OPTION_XLazyThisJoinPoint = "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint";
    public static final String OPTION_XNoInline = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    public static final String OPTION_XNotReweavable = "org.aspectj.ajdt.core.compiler.weaver.XNotReweavable";
    public static final String OPTION_XHasMember = "org.aspectj.ajdt.core.compiler.weaver.XHasMember";
    public static final String OPTION_XdevPinpoint = "org.aspectj.ajdt.core.compiler.weaver.XdevPinpoint";
    public static final String OPTION_XDevNoAtAspectJProcessing = "org.aspectj.ajdt.core.compiler.ast.NoAtAspectJProcessing";
    public static final String OPTION_GenerateModel = "org.aspectj.ajdt.core.compiler.model.GenerateModel";
    public static final String OPTION_GenerateJavaDocsInModel = "org.aspectj.ajdt.core.compiler.model.GenerateJavaDocsInModel";
    public static final String OPTION_Emacssym = "org.aspectj.ajdt.core.compiler.model.Emacssym";
    public static final long InvalidAbsoluteTypeName = 0x100000000000L;
    public static final long InvalidWildCardTypeName = 0x200000000000L;
    public static final long UnresolvableMember = 0x400000000000L;
    public static final long TypeNotExposedToWeaver = 0x800000000000L;
    public static final long ShadowNotInStructure = 0x1000000000000L;
    public static final long UnmatchedSuperTypeInCall = 0x2000000000000L;
    public static final long CannotImplementLazyTJP = 0x4000000000000L;
    public static final long NeedSerialVersionUIDField = 0x8000000000000L;
    public static final long IncompatibleSerialVersion = 0x10000000000000L;
    public boolean noWeave = false;
    public boolean xSerializableAspects = false;
    public boolean xLazyThisJoinPoint = false;
    public boolean xNoInline = false;
    public boolean xNotReweavable = false;
    public boolean xHasMember = false;
    public boolean xdevPinpoint = false;
    public boolean showWeavingInformation = false;
    public boolean behaveInJava5Way = false;
    public boolean generateModel = false;
    public boolean generateJavaDocsInModel = false;
    public boolean generateEmacsSymFiles = false;
    public boolean noAtAspectJProcessing = false;
    public boolean generateCrossRefs = false;
    public boolean proceedOnError = false;

    public AjCompilerOptions() {
        this.setAspectJWarningDefaults();
    }

    public AjCompilerOptions(Map settings) {
        this.setAspectJWarningDefaults();
        if (settings == null) {
            return;
        }
        this.set(settings);
    }

    public Map getMap() {
        Map map = super.getMap();
        map.put(OPTION_ReportInvalidAbsoluteTypeName, this.getSeverityString(0x100000000000L));
        map.put(OPTION_ReportInvalidWildcardTypeName, this.getSeverityString(0x200000000000L));
        map.put(OPTION_ReportUnresolvableMember, this.getSeverityString(0x400000000000L));
        map.put(OPTION_ReportTypeNotExposedToWeaver, this.getSeverityString(0x800000000000L));
        map.put(OPTION_ReportShadowNotInStructure, this.getSeverityString(0x1000000000000L));
        map.put(OPTION_ReportUnmatchedSuperTypeInCall, this.getSeverityString(0x2000000000000L));
        map.put(OPTION_ReportCannotImplementLazyTJP, this.getSeverityString(0x4000000000000L));
        map.put(OPTION_ReportNeedSerialVersionUIDField, this.getSeverityString(0x8000000000000L));
        map.put(OPTION_ReportIncompatibleSerialVersion, this.getSeverityString(0x10000000000000L));
        map.put(OPTION_NoWeave, this.noWeave ? "enabled" : "disabled");
        map.put(OPTION_XSerializableAspects, this.xSerializableAspects ? "enabled" : "disabled");
        map.put(OPTION_XLazyThisJoinPoint, this.xLazyThisJoinPoint ? "enabled" : "disabled");
        map.put(OPTION_XNoInline, this.xNoInline ? "enabled" : "disabled");
        map.put(OPTION_XNotReweavable, this.xNotReweavable ? "enabled" : "disabled");
        map.put(OPTION_XHasMember, this.xHasMember ? "enabled" : "disabled");
        map.put(OPTION_XdevPinpoint, this.xdevPinpoint ? "enabled" : "disabled");
        map.put(OPTION_GenerateModel, this.generateModel ? "enabled" : "disabled");
        map.put(OPTION_GenerateJavaDocsInModel, this.generateJavaDocsInModel ? "enabled" : "disabled");
        map.put(OPTION_Emacssym, this.generateEmacsSymFiles ? "enabled" : "disabled");
        map.put(OPTION_XDevNoAtAspectJProcessing, this.noAtAspectJProcessing ? "enabled" : "disabled");
        return map;
    }

    public void set(Map optionsMap) {
        super.set(optionsMap);
        Object optionValue = optionsMap.get(OPTION_ReportInvalidAbsoluteTypeName);
        if (optionValue != null) {
            this.updateSeverity(0x100000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportInvalidWildcardTypeName)) != null) {
            this.updateSeverity(0x200000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnresolvableMember)) != null) {
            this.updateSeverity(0x400000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportTypeNotExposedToWeaver)) != null) {
            this.updateSeverity(0x800000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportShadowNotInStructure)) != null) {
            this.updateSeverity(0x1000000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnmatchedSuperTypeInCall)) != null) {
            this.updateSeverity(0x2000000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportCannotImplementLazyTJP)) != null) {
            this.updateSeverity(0x4000000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportNeedSerialVersionUIDField)) != null) {
            this.updateSeverity(0x8000000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportIncompatibleSerialVersion)) != null) {
            this.updateSeverity(0x10000000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_NoWeave)) != null) {
            if ("enabled".equals(optionValue)) {
                this.noWeave = true;
            } else if ("disabled".equals(optionValue)) {
                this.noWeave = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_XSerializableAspects)) != null) {
            if ("enabled".equals(optionValue)) {
                this.xSerializableAspects = true;
            } else if ("disabled".equals(optionValue)) {
                this.xSerializableAspects = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_XLazyThisJoinPoint)) != null) {
            if ("enabled".equals(optionValue)) {
                this.xLazyThisJoinPoint = true;
            } else if ("disabled".equals(optionValue)) {
                this.xLazyThisJoinPoint = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_XNoInline)) != null) {
            if ("enabled".equals(optionValue)) {
                this.xNoInline = true;
            } else if ("disabled".equals(optionValue)) {
                this.xNoInline = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_XNotReweavable)) != null) {
            if ("enabled".equals(optionValue)) {
                this.xNotReweavable = true;
            } else if ("disabled".equals(optionValue)) {
                this.xNotReweavable = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_XHasMember)) != null) {
            if ("enabled".equals(optionValue)) {
                this.xHasMember = true;
            } else if ("disabled".equals(optionValue)) {
                this.xHasMember = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_XdevPinpoint)) != null) {
            if ("enabled".equals(optionValue)) {
                this.xdevPinpoint = true;
            } else if ("disabled".equals(optionValue)) {
                this.xdevPinpoint = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_GenerateModel)) != null) {
            if ("enabled".equals(optionValue)) {
                this.generateModel = true;
            } else if ("disabled".equals(optionValue)) {
                this.generateModel = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_GenerateJavaDocsInModel)) != null) {
            if ("enabled".equals(optionValue)) {
                this.generateJavaDocsInModel = true;
            } else if ("disabled".equals(optionValue)) {
                this.generateJavaDocsInModel = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_Emacssym)) != null) {
            if ("enabled".equals(optionValue)) {
                this.generateEmacsSymFiles = true;
            } else if ("disabled".equals(optionValue)) {
                this.generateEmacsSymFiles = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_XDevNoAtAspectJProcessing)) != null) {
            if ("enabled".equals(optionValue)) {
                this.noAtAspectJProcessing = true;
            } else if ("disabled".equals(optionValue)) {
                this.noAtAspectJProcessing = false;
            }
        }
    }

    private void setAspectJWarningDefaults() {
        this.warningThreshold = this.warningThreshold | 0x100000000000L | 0x400000000000L | 0x800000000000L | 0x2000000000000L | 0x4000000000000L;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("\n\tAspectJ Specific Options:");
        buf.append("\n\t- no weave: ").append(this.noWeave ? "enabled" : "disabled");
        buf.append("\n\t- no inline (X option): ").append(this.xNoInline ? "enabled" : "disabled");
        buf.append("\n\t- generate serializable aspects (X option): ").append(this.xSerializableAspects ? "enabled" : "disabled");
        buf.append("\n\t- lazy thisJoinPoint (X option): ").append(this.xLazyThisJoinPoint ? "enabled" : "disabled");
        buf.append("\n\t- generate non-reweavable class files (X option): ").append(this.xNotReweavable ? "enabled" : "disabled");
        buf.append("\n\t- has member support (X option): ").append(this.xHasMember ? "enabled" : "disabled");
        buf.append("\n\t- generate AJDE model: ").append(this.generateModel ? "enabled" : "disabled");
        buf.append("\n\t- generate Javadocs in AJDE model: ").append(this.generateJavaDocsInModel ? "enabled" : "disabled");
        buf.append("\n\t- generate Emacs symbol files: ").append(this.generateEmacsSymFiles ? "enabled" : "disabled");
        buf.append("\n\t- suppress @AspectJ processing: ").append(this.noAtAspectJProcessing ? "enabled" : "disabled");
        buf.append("\n\t- invalid absolute type name (XLint): ").append(this.getSeverityString(0x100000000000L));
        buf.append("\n\t- invalid wildcard type name (XLint): ").append(this.getSeverityString(0x200000000000L));
        buf.append("\n\t- unresolvable member (XLint): ").append(this.getSeverityString(0x400000000000L));
        buf.append("\n\t- type not exposed to weaver (XLint): ").append(this.getSeverityString(0x800000000000L));
        buf.append("\n\t- shadow not in structure (XLint): ").append(this.getSeverityString(0x1000000000000L));
        buf.append("\n\t- unmatched super type in call (XLint): ").append(this.getSeverityString(0x2000000000000L));
        buf.append("\n\t- cannot implement lazy thisJoinPoint (XLint): ").append(this.getSeverityString(0x4000000000000L));
        buf.append("\n\t- need serialVersionUID field (XLint): ").append(this.getSeverityString(0x8000000000000L));
        buf.append("\n\t- incompatible serial version (XLint): ").append(this.getSeverityString(0x10000000000000L));
        return buf.toString();
    }
}

