/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;

public final class AdapterManager
implements IAdapterManager {
    protected Hashtable factories = new Hashtable(5);
    protected Hashtable lookup = null;

    private void addFactoriesFor(Vector types, Hashtable lookupTable) {
        Enumeration classes = types.elements();
        while (classes.hasMoreElements()) {
            Class clazz = (Class)classes.nextElement();
            Vector factoryList = (Vector)this.factories.get(clazz);
            if (factoryList == null) continue;
            Enumeration list = factoryList.elements();
            while (list.hasMoreElements()) {
                IAdapterFactory factory = (IAdapterFactory)list.nextElement();
                Class[] adapters = factory.getAdapterList();
                int i = 0;
                while (i < adapters.length) {
                    Class adapter = adapters[i];
                    if (lookupTable.get(adapter) == null) {
                        lookupTable.put(adapter, factory);
                    }
                    ++i;
                }
            }
        }
    }

    private Vector computeClassOrder(Class extensibleClass) {
        Vector result = new Vector(4);
        Class clazz = extensibleClass;
        while (clazz != null) {
            result.addElement(clazz);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private Vector computeInterfaceOrder(Vector classList) {
        Vector result = new Vector(4);
        Hashtable seen = new Hashtable(4);
        Enumeration list = classList.elements();
        while (list.hasMoreElements()) {
            Class[] interfaces = ((Class)list.nextElement()).getInterfaces();
            this.internalComputeInterfaceOrder(interfaces, result, seen);
        }
        return result;
    }

    public void flushLookup() {
        this.lookup = null;
    }

    public Object getAdapter(Object object, Class target) {
        IAdapterFactory factory = this.getFactory(object.getClass(), target);
        Object result = null;
        if (factory != null) {
            result = factory.getAdapter(object, target);
        }
        if (result == null && target.isInstance(object)) {
            return object;
        }
        return result;
    }

    private IAdapterFactory getFactory(Class extensibleClass, Class adapter) {
        Hashtable table;
        if (this.lookup != null && (table = (Hashtable)this.lookup.get(extensibleClass)) != null) {
            return (IAdapterFactory)table.get(adapter);
        }
        table = new Hashtable(4);
        Vector classList = this.computeClassOrder(extensibleClass);
        this.addFactoriesFor(classList, table);
        classList = this.computeInterfaceOrder(classList);
        this.addFactoriesFor(classList, table);
        if (this.lookup == null) {
            this.lookup = new Hashtable(5);
        }
        this.lookup.put(extensibleClass, table);
        return (IAdapterFactory)table.get(adapter);
    }

    private void internalComputeInterfaceOrder(Class[] interfaces, Vector result, Hashtable seen) {
        Vector<Class> newInterfaces = new Vector<Class>(seen.size());
        int i = 0;
        while (i < interfaces.length) {
            Class interfac = interfaces[i];
            if (seen.get(interfac) == null) {
                result.addElement(interfac);
                seen.put(interfac, interfac);
                newInterfaces.addElement(interfac);
            }
            ++i;
        }
        Enumeration newList = newInterfaces.elements();
        while (newList.hasMoreElements()) {
            this.internalComputeInterfaceOrder(((Class)newList.nextElement()).getInterfaces(), result, seen);
        }
    }

    public void registerAdapters(IAdapterFactory factory, Class extensibleType) {
        Vector<IAdapterFactory> list = (Vector<IAdapterFactory>)this.factories.get(extensibleType);
        if (list == null) {
            list = new Vector<IAdapterFactory>(5);
            this.factories.put(extensibleType, list);
        }
        list.addElement(factory);
        this.flushLookup();
    }

    public void unregisterAdapters(IAdapterFactory factory) {
        Enumeration enumeration = this.factories.elements();
        while (enumeration.hasMoreElements()) {
            Vector list = (Vector)enumeration.nextElement();
            list.removeElement(factory);
        }
        this.flushLookup();
    }

    public void unregisterAdapters(IAdapterFactory factory, Class extensibleType) {
        Vector factoryList = (Vector)this.factories.get(extensibleType);
        if (factoryList == null) {
            return;
        }
        factoryList.removeElement(factory);
        this.flushLookup();
    }

    public void unregisterAllAdapters() {
        this.factories = new Hashtable(5);
        this.flushLookup();
    }
}

