/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PluginClassLoader
extends URLClassLoader {
    private Bundle bundle;
    private PluginDescriptor descriptor;

    PluginClassLoader(PluginDescriptor descriptor) {
        super(PluginClassLoader.computeURLs(descriptor));
        this.descriptor = descriptor;
        this.bundle = InternalPlatform.getDefault().getBundle(descriptor.getUniqueIdentifier());
        if (this.bundle == null) {
            throw new IllegalArgumentException();
        }
    }

    private static URL[] computeURLs(PluginDescriptor descriptor) {
        Bundle bundle = InternalPlatform.getDefault().getBundle(descriptor.getUniqueIdentifier());
        if (bundle == null) {
            throw new IllegalArgumentException();
        }
        ILibrary[] libs = descriptor.getRuntimeLibraries();
        String[] devPath = PluginClassLoader.computeDevPath();
        URL pluginBase = descriptor.getInstallURL();
        try {
            pluginBase = Platform.resolve(descriptor.getInstallURL());
        }
        catch (IOException iOException) {}
        URL[] urls = new URL[devPath.length + libs.length];
        int j = 0;
        int i = 0;
        while (i < devPath.length) {
            try {
                urls[j++] = new URL(pluginBase, devPath[i]);
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        i = 0;
        while (i < libs.length) {
            try {
                urls[j++] = new URL(pluginBase, libs[i].getPath().toOSString());
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        return urls;
    }

    private static String[] computeDevPath() {
        if (!BootLoader.inDevelopmentMode()) {
            return new String[0];
        }
        Vector<String> devClassPath = new Vector<String>(6);
        StringTokenizer st = new StringTokenizer(System.getProperty("osgi.dev"), ",");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("")) continue;
            devClassPath.addElement(tok);
        }
        String[] devCP = new String[devClassPath.size()];
        devClassPath.toArray(devCP);
        return devCP;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        return this.bundle.loadClass(name);
    }

    public URL findResource(String name) {
        return this.bundle.getResource(name);
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.descriptor;
    }
}

