/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;

public class StructureUtil {
    public static List getTargets(IProgramElement node, IRelationship.Kind kind) {
        List relations = AsmManager.getDefault().getRelationshipMap().get(node);
        List targets = null;
        if (relations == null) {
            return null;
        }
        Iterator it = relations.iterator();
        while (it.hasNext()) {
            IRelationship rtn = (IRelationship)it.next();
            if (!rtn.getKind().equals(kind)) continue;
            targets = rtn.getTargets();
        }
        return targets;
    }

    public static String getPackageDeclarationFromFile(File file) {
        IProgramElement fileNode = AsmManager.getDefault().getHierarchy().findElementForSourceFile(file.getAbsolutePath());
        String packageName = ((IProgramElement)fileNode.getChildren().get(0)).getPackageName();
        return packageName;
    }

    public static String genSignature(IProgramElement node) {
        StringBuffer sb = new StringBuffer();
        String accessibility = node.getAccessibility().toString();
        if (!accessibility.equals("package")) {
            sb.append(accessibility);
            sb.append(' ');
        }
        String modifiers = "";
        Iterator modIt = node.getModifiers().iterator();
        while (modIt.hasNext()) {
            modifiers = modifiers + modIt.next() + " ";
        }
        if (node.getKind().equals(IProgramElement.Kind.METHOD) || node.getKind().equals(IProgramElement.Kind.FIELD)) {
            sb.append(node.getCorrespondingType());
            sb.append(' ');
        }
        if (node.getKind().equals(IProgramElement.Kind.CLASS)) {
            sb.append("class ");
        } else if (node.getKind().equals(IProgramElement.Kind.INTERFACE)) {
            sb.append("interface ");
        }
        sb.append(node.getName());
        if (node.getParameterTypes() != null) {
            sb.append('(');
            int i = 0;
            while (i < node.getParameterTypes().size()) {
                sb.append((String)node.getParameterTypes().get(i));
                sb.append(' ');
                sb.append((String)node.getParameterNames().get(i));
                if (i < node.getParameterTypes().size() - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static boolean isAnonymous(IProgramElement node) {
        boolean isIntName = true;
        try {
            Integer.valueOf(node.getName());
        }
        catch (NumberFormatException nfe) {
            isIntName = false;
        }
        return isIntName || node.getName().startsWith("new ");
    }
}

