/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;

public class BuildConfigNode {
    protected BuildConfigNode parent = null;
    protected String name = "";
    protected Kind kind;
    protected List children = new ArrayList();
    protected IMessage message = null;
    protected ISourceLocation sourceLocation = null;
    private String resourcePath;
    private boolean isActive = true;

    public BuildConfigNode() {
    }

    public BuildConfigNode(String name, Kind kind, String resourcePath) {
        this(name, kind);
        this.kind = kind;
        this.resourcePath = resourcePath;
    }

    public BuildConfigNode(String name, Kind kind) {
        this.name = name;
        this.kind = kind;
    }

    public String toString() {
        return this.name;
    }

    public List getChildren() {
        return this.children;
    }

    public void addChild(BuildConfigNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public void addChild(int position, BuildConfigNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(position, child);
        child.setParent(this);
    }

    public boolean removeChild(BuildConfigNode child) {
        child.setParent(null);
        return this.children.remove(child);
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        BuildConfigNode sn = (BuildConfigNode)o;
        return this.getName().compareTo(sn.getName());
    }

    public String getName() {
        return this.name;
    }

    public ISourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(ISourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public IMessage getMessage() {
        return this.message;
    }

    public void setMessage(IMessage message) {
        this.message = message;
    }

    public BuildConfigNode getParent() {
        return this.parent;
    }

    public void setParent(BuildConfigNode parent) {
        this.parent = parent;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public boolean isValidResource() {
        return this.name.endsWith(".java") || this.name.endsWith(".aj") || this.name.endsWith(".lst");
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public Kind getBuildConfigNodeKind() {
        return this.kind;
    }

    public static class Kind
    implements Serializable {
        public static final Kind FILE_JAVA = new Kind("Java source file");
        public static final Kind FILE_ASPECTJ = new Kind("AspectJ source file");
        public static final Kind FILE_LST = new Kind("build configuration file");
        public static final Kind ERROR = new Kind("error");
        public static final Kind DIRECTORY = new Kind("directory");
        public static final Kind[] ALL = new Kind[]{FILE_JAVA, FILE_ASPECTJ, FILE_LST, DIRECTORY};
        private final String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private Kind(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            return o.equals(this.name);
        }

        public boolean isDeclareKind() {
            return this.name.startsWith("declare");
        }

        private Object readResolve() throws ObjectStreamException {
            return ALL[this.ordinal];
        }
    }
}

