/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;

public class Policy {
    public static final long MAX_BUILD_DELAY = 1000L;
    public static final long MIN_BUILD_DELAY = 100L;
    private static String bundleName = "org.eclipse.core.internal.utils.messages";
    private static ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
    private static final int autoBuildOpWork = 99;
    private static final int autoBuildBuildWork = 1;
    private static final int manualBuildOpWork = 99;
    private static final int manualBuildBuildWork = 1;
    public static final boolean buildOnCancel = false;
    public static int opWork;
    public static int buildWork;
    public static int totalWork;
    public static final boolean defaultAutoBuild = true;
    public static final boolean defaultSnapshots = true;
    public static final int defaultOperationsPerSnapshot = 100;
    public static final long defaultSnapshotInterval = 300000L;
    public static final long defaultDeltaExpiration = 2592000000L;
    public static final long defaultFileStateLongevity = 604800000L;
    public static final long defaultMaxFileStateSize = 0x100000L;
    public static final int defaultMaxFileStates = 50;
    public static final int defaultMaxBuildIterations = 10;
    public static final long defaultMaxNotifyDelay = 10000L;
    public static boolean DEBUG_BUILD_FAILURE;
    public static boolean DEBUG_NEEDS_BUILD;
    public static boolean DEBUG_BUILD_INVOKING;
    public static boolean DEBUG_BUILD_DELTA;
    public static boolean DEBUG_NATURES;
    public static boolean DEBUG_HISTORY;
    public static boolean DEBUG_PREFERENCES;
    public static boolean MONITOR_BUILDERS;
    public static boolean MONITOR_LISTENERS;
    public static boolean DEBUG_RESTORE;
    public static boolean DEBUG_RESTORE_MARKERS;
    public static boolean DEBUG_RESTORE_SYNCINFO;
    public static boolean DEBUG_RESTORE_TREE;
    public static boolean DEBUG_RESTORE_METAINFO;
    public static boolean DEBUG_RESTORE_SNAPSHOTS;
    public static boolean DEBUG_RESTORE_MASTERTABLE;
    public static boolean DEBUG_SAVE;
    public static boolean DEBUG_SAVE_MARKERS;
    public static boolean DEBUG_SAVE_SYNCINFO;
    public static boolean DEBUG_SAVE_TREE;
    public static boolean DEBUG_SAVE_METAINFO;
    public static boolean DEBUG_SAVE_SNAPSHOTS;
    public static boolean DEBUG_SAVE_MASTERTABLE;
    public static boolean DEBUG_AUTO_REFRESH;

    static {
        DEBUG_BUILD_FAILURE = false;
        DEBUG_NEEDS_BUILD = false;
        DEBUG_BUILD_INVOKING = false;
        DEBUG_BUILD_DELTA = false;
        DEBUG_NATURES = false;
        DEBUG_HISTORY = false;
        DEBUG_PREFERENCES = false;
        MONITOR_BUILDERS = false;
        MONITOR_LISTENERS = false;
        DEBUG_RESTORE = false;
        DEBUG_RESTORE_MARKERS = false;
        DEBUG_RESTORE_SYNCINFO = false;
        DEBUG_RESTORE_TREE = false;
        DEBUG_RESTORE_METAINFO = false;
        DEBUG_RESTORE_SNAPSHOTS = false;
        DEBUG_RESTORE_MASTERTABLE = false;
        DEBUG_SAVE = false;
        DEBUG_SAVE_MARKERS = false;
        DEBUG_SAVE_SYNCINFO = false;
        DEBUG_SAVE_TREE = false;
        DEBUG_SAVE_METAINFO = false;
        DEBUG_SAVE_SNAPSHOTS = false;
        DEBUG_SAVE_MASTERTABLE = false;
        DEBUG_AUTO_REFRESH = false;
        Policy.setupAutoBuildProgress(true);
        if (ResourcesPlugin.getPlugin().isDebugging()) {
            String sTrue = Boolean.TRUE.toString();
            DEBUG_BUILD_FAILURE = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/build/failure"));
            DEBUG_NEEDS_BUILD = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/build/needbuild"));
            DEBUG_BUILD_INVOKING = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/build/invoking"));
            DEBUG_BUILD_DELTA = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/build/delta"));
            DEBUG_NATURES = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/natures"));
            DEBUG_HISTORY = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/history"));
            DEBUG_PREFERENCES = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/preferences"));
            MONITOR_BUILDERS = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/monitor/builders"));
            MONITOR_LISTENERS = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/monitor/listeners"));
            DEBUG_RESTORE_MARKERS = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/restore/markers"));
            DEBUG_RESTORE_SYNCINFO = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/restore/syncinfo"));
            DEBUG_RESTORE_TREE = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/restore/tree"));
            DEBUG_RESTORE_METAINFO = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/restore/metainfo"));
            DEBUG_RESTORE_SNAPSHOTS = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/restore/snapshots"));
            DEBUG_RESTORE_MASTERTABLE = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/restore/mastertable"));
            DEBUG_RESTORE = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/restore"));
            DEBUG_SAVE_MARKERS = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/save/markers"));
            DEBUG_SAVE_SYNCINFO = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/save/syncinfo"));
            DEBUG_SAVE_TREE = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/save/tree"));
            DEBUG_SAVE_METAINFO = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/save/metainfo"));
            DEBUG_SAVE_SNAPSHOTS = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/save/snapshots"));
            DEBUG_SAVE_MASTERTABLE = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/save/mastertable"));
            DEBUG_SAVE = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/save"));
            DEBUG_AUTO_REFRESH = sTrue.equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.resources/refresh"));
        }
    }

    public static String bind(String id) {
        return Policy.bind(id, null);
    }

    public static String bind(String id, String binding) {
        return Policy.bind(id, new String[]{binding});
    }

    public static String bind(String id, String binding1, String binding2) {
        return Policy.bind(id, new String[]{binding1, binding2});
    }

    public static String bind(String id, String[] bindings) {
        if (id == null) {
            return "No message available";
        }
        String message = null;
        try {
            message = bundle.getString(id);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + id + " in: " + bundleName;
        }
        if (bindings == null) {
            return message;
        }
        return MessageFormat.format(message, bindings);
    }

    public static void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public static void setupAutoBuildProgress(boolean on) {
        opWork = on ? 99 : 99;
        buildWork = on ? 1 : 1;
        totalWork = opWork + buildWork;
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks, int style) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks, style);
    }

    public static void debug(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(new Date(System.currentTimeMillis()));
        buffer.append(" - [");
        buffer.append(Thread.currentThread().getName());
        buffer.append("] ");
        buffer.append(message);
        System.out.println(buffer.toString());
    }
}

