/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;

public class ThrowsPattern
extends PatternNode {
    private TypePatternList required;
    private TypePatternList forbidden;
    public static final ThrowsPattern ANY = new ThrowsPattern(TypePatternList.EMPTY, TypePatternList.EMPTY);

    public ThrowsPattern(TypePatternList required, TypePatternList forbidden) {
        this.required = required;
        this.forbidden = forbidden;
    }

    public String toString() {
        if (this == ANY) {
            return "";
        }
        String ret = "throws " + this.required.toString();
        if (this.forbidden.size() > 0) {
            ret = ret + " !(" + this.forbidden.toString() + ")";
        }
        return ret;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ThrowsPattern)) {
            return false;
        }
        ThrowsPattern o = (ThrowsPattern)other;
        return o.required.equals(this.required) && o.forbidden.equals(this.forbidden);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.required.hashCode();
        result = 37 * result + this.forbidden.hashCode();
        return result;
    }

    public ThrowsPattern resolveBindings(IScope scope, Bindings bindings) {
        if (this == ANY) {
            return this;
        }
        this.required = this.required.resolveBindings(scope, bindings, false, false);
        this.forbidden = this.forbidden.resolveBindings(scope, bindings, false, false);
        return this;
    }

    public ThrowsPattern resolveBindingsFromRTTI() {
        this.required = this.required.resolveBindingsFromRTTI(false, false);
        this.forbidden = this.forbidden.resolveBindingsFromRTTI(false, false);
        return this;
    }

    public boolean matches(TypeX[] tys, World world) {
        if (this == ANY) {
            return true;
        }
        ResolvedTypeX[] types = world.resolve(tys);
        int j = 0;
        int lenj = this.required.size();
        while (j < lenj) {
            if (!this.matchesAny(this.required.get(j), types)) {
                return false;
            }
            ++j;
        }
        int j2 = 0;
        int lenj2 = this.forbidden.size();
        while (j2 < lenj2) {
            if (this.matchesAny(this.forbidden.get(j2), types)) {
                return false;
            }
            ++j2;
        }
        return true;
    }

    public boolean matches(Class[] onTypes) {
        if (this == ANY) {
            return true;
        }
        int j = 0;
        int lenj = this.required.size();
        while (j < lenj) {
            if (!this.matchesAny(this.required.get(j), onTypes)) {
                return false;
            }
            ++j;
        }
        int j2 = 0;
        int lenj2 = this.forbidden.size();
        while (j2 < lenj2) {
            if (this.matchesAny(this.forbidden.get(j2), onTypes)) {
                return false;
            }
            ++j2;
        }
        return true;
    }

    private boolean matchesAny(TypePattern typePattern, ResolvedTypeX[] types) {
        int i = types.length - 1;
        while (i >= 0) {
            if (typePattern.matchesStatically(types[i])) {
                return true;
            }
            --i;
        }
        return false;
    }

    private boolean matchesAny(TypePattern typePattern, Class[] types) {
        int i = types.length - 1;
        while (i >= 0) {
            if (typePattern.matchesStatically(types[i])) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static ThrowsPattern read(DataInputStream s, ISourceContext context) throws IOException {
        TypePatternList required = TypePatternList.read(s, context);
        TypePatternList forbidden = TypePatternList.read(s, context);
        if (required.size() == 0 && forbidden.size() == 0) {
            return ANY;
        }
        ThrowsPattern ret = new ThrowsPattern(required, forbidden);
        return ret;
    }

    public void write(DataOutputStream s) throws IOException {
        this.required.write(s);
        this.forbidden.write(s);
    }
}

