/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.BindingTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;

public class ReferencePointcut
extends Pointcut {
    public TypeX onType;
    public TypePattern onTypeSymbolic;
    public String name;
    public TypePatternList arguments;
    private boolean concretizing = false;

    public ReferencePointcut(TypePattern onTypeSymbolic, String name, TypePatternList arguments) {
        this.onTypeSymbolic = onTypeSymbolic;
        this.name = name;
        this.arguments = arguments;
    }

    public ReferencePointcut(TypeX onType, String name, TypePatternList arguments) {
        this.onType = onType;
        this.name = name;
        this.arguments = arguments;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean match(Shadow shadow) {
        return FuzzyBoolean.NO;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.onType != null) {
            buf.append(this.onType);
            buf.append(".");
        }
        buf.append(this.name);
        buf.append(this.arguments.toString());
        return buf.toString();
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(8);
        if (this.onType != null) {
            s.writeBoolean(true);
            this.onType.write(s);
        } else {
            s.writeBoolean(false);
        }
        s.writeUTF(this.name);
        this.arguments.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        TypeX onType = null;
        if (s.readBoolean()) {
            onType = TypeX.read(s);
        }
        ReferencePointcut ret = new ReferencePointcut(onType, s.readUTF(), TypePatternList.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        ResolvedTypeX[] parameterTypes;
        if (this.onTypeSymbolic != null) {
            this.onType = this.onTypeSymbolic.resolveExactType(scope, bindings);
            if (this.onType == ResolvedTypeX.MISSING) {
                return;
            }
        }
        ResolvedTypeX searchType = this.onType != null ? scope.getWorld().resolve(this.onType) : scope.getEnclosingType();
        this.arguments.resolveBindings(scope, bindings, true, true);
        ResolvedPointcutDefinition pointcutDef = searchType.findPointcut(this.name);
        if (pointcutDef == null && this.onType == null) {
            ResolvedTypeX declaringType;
            while ((declaringType = searchType.getDeclaringType()) != null) {
                searchType = ((TypeX)declaringType).resolve(scope.getWorld());
                pointcutDef = searchType.findPointcut(this.name);
                if (pointcutDef == null) continue;
                this.onType = searchType;
                break;
            }
        }
        if (pointcutDef == null) {
            scope.message(IMessage.ERROR, this, "can't find referenced pointcut");
            return;
        }
        if (!pointcutDef.isVisible(scope.getEnclosingType())) {
            scope.message(IMessage.ERROR, this, "pointcut declaration " + pointcutDef + " is not accessible");
            return;
        }
        if (Modifier.isAbstract(pointcutDef.getModifiers())) {
            if (this.onType != null) {
                scope.message(IMessage.ERROR, this, "can't make static reference to abstract pointcut");
                return;
            }
            if (!searchType.isAbstract()) {
                scope.message(IMessage.ERROR, this, "can't use abstract pointcut in concrete context");
                return;
            }
        }
        if ((parameterTypes = scope.getWorld().resolve(pointcutDef.getParameterTypes())).length != this.arguments.size()) {
            scope.message(IMessage.ERROR, this, "incompatible number of arguments to pointcut, expected " + parameterTypes.length + " found " + this.arguments.size());
            return;
        }
        int i = 0;
        int len = this.arguments.size();
        while (i < len) {
            TypePattern p = this.arguments.get(i);
            if (p == TypePattern.NO) {
                scope.message(IMessage.ERROR, this, "bad parameter to pointcut reference");
                return;
            }
            if (!p.matchesSubtypes(parameterTypes[i]) && !p.getExactType().equals(TypeX.OBJECT)) {
                scope.message(IMessage.ERROR, p, "incompatible type, expected " + parameterTypes[i].getName() + " found " + p);
                return;
            }
            ++i;
        }
    }

    public void resolveBindingsFromRTTI() {
        throw new UnsupportedOperationException("Referenced pointcuts are not supported in runtime evaluation");
    }

    public void postRead(ResolvedTypeX enclosingType) {
        this.arguments.postRead(enclosingType);
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        throw new RuntimeException("shouldn't happen");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pointcut concretize1(ResolvedTypeX searchStart, IntMap bindings) {
        Pointcut pointcut;
        block14: {
            Pointcut pointcut2;
            block13: {
                Pointcut pointcut3;
                block12: {
                    if (this.concretizing) {
                        searchStart.getWorld().getMessageHandler().handleMessage(MessageUtil.error(WeaverMessages.format("circularPointcutDeclaration", this), this.getSourceLocation()));
                        return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
                    }
                    try {
                        this.concretizing = true;
                        if (this.onType != null && (searchStart = this.onType.resolve(searchStart.getWorld())) == ResolvedTypeX.MISSING) {
                            Pointcut pointcut4 = Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
                            Object var13_7 = null;
                            this.concretizing = false;
                            return pointcut4;
                        }
                        ResolvedPointcutDefinition pointcutDec = searchStart.findPointcut(this.name);
                        if (pointcutDec == null) {
                            searchStart.getWorld().getMessageHandler().handleMessage(MessageUtil.error(WeaverMessages.format("cantFindPointcut", this.name, searchStart.getName()), this.getSourceLocation()));
                            pointcut3 = Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
                            break block12;
                        }
                        if (pointcutDec.isAbstract()) {
                            ShadowMunger enclosingAdvice = bindings.getEnclosingAdvice();
                            searchStart.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("abstractPointcut", pointcutDec), this.getSourceLocation(), null == enclosingAdvice ? null : enclosingAdvice.getSourceLocation());
                            pointcut2 = Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
                            break block13;
                        }
                        ResolvedTypeX[] parameterTypes = searchStart.getWorld().resolve(pointcutDec.getParameterTypes());
                        TypePatternList arguments = this.arguments.resolveReferences(bindings);
                        IntMap newBindings = new IntMap();
                        int i = 0;
                        int len = arguments.size();
                        while (true) {
                            if (i >= len) {
                                newBindings.copyContext(bindings);
                                newBindings.pushEnclosingDefinition(pointcutDec);
                                try {
                                    pointcut = pointcutDec.getPointcut().concretize(searchStart, newBindings);
                                    Object var11_19 = null;
                                    newBindings.popEnclosingDefinitition();
                                    break block14;
                                }
                                catch (Throwable throwable) {
                                    Object var11_20 = null;
                                    newBindings.popEnclosingDefinitition();
                                    throw throwable;
                                }
                            }
                            TypePattern p = arguments.get(i);
                            if (!p.matchesSubtypes(parameterTypes[i]) && !p.getExactType().equals(TypeX.OBJECT)) {
                                throw new BCException("illegal change to pointcut declaration: " + this);
                            }
                            if (p instanceof BindingTypePattern) {
                                newBindings.put(i, ((BindingTypePattern)p).getFormalIndex());
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_11 = null;
                        this.concretizing = false;
                        throw throwable;
                    }
                }
                Object var13_8 = null;
                this.concretizing = false;
                return pointcut3;
            }
            Object var13_9 = null;
            this.concretizing = false;
            return pointcut2;
        }
        Object var13_10 = null;
        this.concretizing = false;
        return pointcut;
    }

    protected boolean shouldCopyLocationForConcretize() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof ReferencePointcut)) {
            return false;
        }
        ReferencePointcut o = (ReferencePointcut)other;
        if (!o.name.equals(this.name)) return false;
        if (!o.arguments.equals(this.arguments)) return false;
        if (o.onType == null) {
            if (this.onType != null) return false;
            return true;
        }
        boolean bl = o.onType.equals(this.onType);
        if (!bl) return false;
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.onType == null ? 0 : this.onType.hashCode());
        result = 37 * result + this.arguments.hashCode();
        result = 37 * result + this.name.hashCode();
        return result;
    }
}

