/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.ast.Expr;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.bcel.BcelCflowAccessVar;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;

public class ConcreteCflowPointcut
extends Pointcut {
    private Member cflowField;
    List slots;
    boolean usesCounter;
    private static final Member cflowStackIsValidMethod = Member.method(TypeX.forName("org.aspectj.runtime.internal.CFlowStack"), 0, "isValid", "()Z");
    private static final Member cflowCounterIsValidMethod = Member.method(TypeX.forName("org.aspectj.runtime.internal.CFlowCounter"), 0, "isValid", "()Z");

    public ConcreteCflowPointcut(Member cflowField, List slots, boolean usesCounter) {
        this.cflowField = cflowField;
        this.slots = slots;
        this.usesCounter = usesCounter;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean match(Shadow shadow) {
        return FuzzyBoolean.MAYBE;
    }

    public void write(DataOutputStream s) throws IOException {
        throw new RuntimeException("unimplemented");
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        throw new RuntimeException("unimplemented");
    }

    public void resolveBindingsFromRTTI() {
        throw new RuntimeException("unimplemented");
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConcreteCflowPointcut)) {
            return false;
        }
        ConcreteCflowPointcut o = (ConcreteCflowPointcut)other;
        return o.cflowField.equals(this.cflowField);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.cflowField.hashCode();
        return result;
    }

    public String toString() {
        return "concretecflow(" + this.cflowField + ")";
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        if (this.usesCounter) {
            return Test.makeFieldGetCall(this.cflowField, cflowCounterIsValidMethod, Expr.NONE);
        }
        if (this.slots != null) {
            Iterator i = this.slots.iterator();
            while (i.hasNext()) {
                Slot slot = (Slot)i.next();
                state.set(slot.formalIndex, new BcelCflowAccessVar(slot.formalType, this.cflowField, slot.arrayIndex));
            }
        }
        return Test.makeFieldGetCall(this.cflowField, cflowStackIsValidMethod, Expr.NONE);
    }

    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        throw new RuntimeException("unimplemented");
    }

    public static class Slot {
        int formalIndex;
        ResolvedTypeX formalType;
        int arrayIndex;

        public Slot(int formalIndex, ResolvedTypeX formalType, int arrayIndex) {
            this.formalIndex = formalIndex;
            this.formalType = formalType;
            this.arrayIndex = arrayIndex;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Slot)) {
                return false;
            }
            Slot o = (Slot)other;
            return o.formalIndex == this.formalIndex && o.arrayIndex == this.arrayIndex && o.formalType.equals(this.formalType);
        }

        public String toString() {
            return "Slot(" + this.formalIndex + ", " + this.formalType + ", " + this.arrayIndex + ")";
        }
    }
}

