/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;

public class AndPointcut
extends Pointcut {
    Pointcut left;
    Pointcut right;

    public AndPointcut(Pointcut left, Pointcut right) {
        this.left = left;
        this.right = right;
        this.setLocation(left.getSourceContext(), left.getStart(), right.getEnd());
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return this.left.fastMatch(type).and(this.right.fastMatch(type));
    }

    public FuzzyBoolean match(Shadow shadow) {
        return this.left.match(shadow).and(this.right.match(shadow));
    }

    public FuzzyBoolean match(JoinPoint jp, JoinPoint.StaticPart encJP) {
        return this.left.match(jp, encJP).and(this.right.match(jp, encJP));
    }

    public FuzzyBoolean match(JoinPoint.StaticPart jpsp) {
        return this.left.match(jpsp).and(this.right.match(jpsp));
    }

    public String toString() {
        return "(" + this.left.toString() + " && " + this.right.toString() + ")";
    }

    public boolean equals(Object other) {
        if (!(other instanceof AndPointcut)) {
            return false;
        }
        AndPointcut o = (AndPointcut)other;
        return o.left.equals(this.left) && o.right.equals(this.right);
    }

    public int hashCode() {
        int result = 19;
        result = 37 * result + this.left.hashCode();
        result = 37 * result + this.right.hashCode();
        return result;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        this.left.resolveBindings(scope, bindings);
        this.right.resolveBindings(scope, bindings);
    }

    public void resolveBindingsFromRTTI() {
        this.left.resolveBindingsFromRTTI();
        this.right.resolveBindingsFromRTTI();
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(5);
        this.left.write(s);
        this.right.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        AndPointcut ret = new AndPointcut(Pointcut.read(s, context), Pointcut.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        return Test.makeAnd(this.left.findResidue(shadow, state), this.right.findResidue(shadow, state));
    }

    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        return new AndPointcut(this.left.concretize(inAspect, bindings), this.right.concretize(inAspect, bindings));
    }

    public Pointcut getLeft() {
        return this.left;
    }

    public Pointcut getRight() {
        return this.right;
    }
}

