/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.bcel.Range;

public final class ExceptionRange
extends Range {
    private InstructionHandle handler;
    private final TypeX exceptionType;
    private final int priority;
    private volatile int hashCode = 0;

    public ExceptionRange(InstructionList body, TypeX exceptionType, int priority) {
        super(body);
        this.exceptionType = exceptionType;
        this.priority = priority;
    }

    public ExceptionRange(InstructionList body, TypeX exceptionType, boolean insideExisting) {
        this(body, exceptionType, insideExisting ? Integer.MAX_VALUE : -1);
    }

    public void associateWithTargets(InstructionHandle start, InstructionHandle end, InstructionHandle handler) {
        this.start = start;
        this.end = end;
        this.handler = handler;
        start.addTargeter(this);
        end.addTargeter(this);
        handler.addTargeter(this);
    }

    public InstructionHandle getHandler() {
        return this.handler;
    }

    public TypeX getCatchType() {
        return this.exceptionType;
    }

    public int getPriority() {
        return this.priority;
    }

    public String toString() {
        String str = this.exceptionType == null ? "finally" : "catch " + this.exceptionType;
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        boolean bl;
        if (!(other instanceof ExceptionRange)) {
            return false;
        }
        ExceptionRange o = (ExceptionRange)other;
        if (o.getStart() != this.getStart()) return false;
        if (o.getEnd() != this.getEnd()) return false;
        if (o.handler != this.handler) return false;
        if (o.exceptionType == null) {
            if (this.exceptionType != null) return false;
            bl = true;
        } else {
            bl = o.exceptionType.equals(this.exceptionType);
        }
        if (!bl) return false;
        if (o.priority != this.priority) return false;
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int ret = 17;
            ret = 37 * ret + this.getStart().hashCode();
            ret = 37 * ret + this.getEnd().hashCode();
            ret = 37 * ret + this.handler.hashCode();
            ret = 37 * ret + (this.exceptionType == null ? 0 : this.exceptionType.hashCode());
            this.hashCode = ret = 37 * ret + this.priority;
        }
        return this.hashCode;
    }

    public void updateTarget(InstructionHandle oldIh, InstructionHandle newIh, InstructionList newBody) {
        super.updateTarget(oldIh, newIh, newBody);
        if (oldIh == this.handler) {
            this.handler = newIh;
        }
    }

    public static boolean isExceptionStart(InstructionHandle ih) {
        if (!Range.isRangeHandle(ih)) {
            return false;
        }
        Range r = Range.getRange(ih);
        if (!(r instanceof ExceptionRange)) {
            return false;
        }
        ExceptionRange er = (ExceptionRange)r;
        return er.getStart() == ih;
    }

    public static boolean isExceptionEnd(InstructionHandle ih) {
        if (!Range.isRangeHandle(ih)) {
            return false;
        }
        Range r = Range.getRange(ih);
        if (!(r instanceof ExceptionRange)) {
            return false;
        }
        ExceptionRange er = (ExceptionRange)r;
        return er.getEnd() == ih;
    }
}

