/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;

public class ClassPathManager {
    private List entries;

    public ClassPathManager(List classpath, IMessageHandler handler) {
        this.entries = new ArrayList();
        Iterator i = classpath.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            this.addPath(name, handler);
        }
    }

    protected ClassPathManager() {
    }

    public void addPath(String name, IMessageHandler handler) {
        File f = new File(name);
        String lc = name.toLowerCase();
        if (lc.endsWith(".jar") || lc.endsWith(".zip")) {
            if (!f.isFile()) {
                MessageUtil.info(handler, WeaverMessages.format("zipfileEntryMissing", name));
                return;
            }
            try {
                this.entries.add(new ZipFileEntry(f));
            }
            catch (IOException ioe) {
                MessageUtil.warn(handler, WeaverMessages.format("zipfileEntryInvalid", name, ioe.getMessage()));
                return;
            }
        } else {
            if (!f.isDirectory()) {
                MessageUtil.info(handler, WeaverMessages.format("directoryEntryMissing", name));
                return;
            }
            this.entries.add(new DirEntry(f));
        }
    }

    public ClassFile find(TypeX type) {
        String name = type.getName();
        Iterator i = this.entries.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            ClassFile ret = entry.find(name);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        boolean start = true;
        Iterator i = this.entries.iterator();
        while (i.hasNext()) {
            if (start) {
                start = false;
            } else {
                buf.append(File.pathSeparator);
            }
            buf.append(i.next());
        }
        return buf.toString();
    }

    public List getAllClassFiles() {
        ArrayList ret = new ArrayList();
        Iterator i = this.entries.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            ret.addAll(entry.getAllClassFiles());
        }
        return ret;
    }

    static boolean hasClassExtension(String name) {
        return name.toLowerCase().endsWith(".class");
    }

    public class ZipFileEntry
    extends Entry {
        private ZipFile zipFile;

        public ZipFileEntry(File file) throws IOException {
            this(new ZipFile(file));
        }

        public ZipFileEntry(ZipFile zipFile) {
            this.zipFile = zipFile;
        }

        public ClassFile find(String name) {
            String key = name.replace('.', '/') + ".class";
            ZipEntry entry = this.zipFile.getEntry(key);
            if (entry != null) {
                return new ZipEntryClassFile(this.zipFile, entry);
            }
            return null;
        }

        public List getAllClassFiles() {
            ArrayList<ZipEntryClassFile> ret = new ArrayList<ZipEntryClassFile>();
            Enumeration<? extends ZipEntry> e = this.zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String name = entry.getName();
                if (!ClassPathManager.hasClassExtension(name)) continue;
                ret.add(new ZipEntryClassFile(this.zipFile, entry));
            }
            return ret;
        }

        public String toString() {
            return this.zipFile.getName();
        }
    }

    private static class ZipEntryClassFile
    extends ClassFile {
        private ZipEntry entry;
        private ZipFile zipFile;

        public ZipEntryClassFile(ZipFile zipFile, ZipEntry entry) {
            this.zipFile = zipFile;
            this.entry = entry;
        }

        public InputStream getInputStream() throws IOException {
            return this.zipFile.getInputStream(this.entry);
        }

        public String getPath() {
            return this.entry.getName();
        }
    }

    public class DirEntry
    extends Entry {
        private String dirPath;

        public DirEntry(File dir) {
            this.dirPath = dir.getPath();
        }

        public DirEntry(String dirPath) {
            this.dirPath = dirPath;
        }

        public ClassFile find(String name) {
            File f = new File(this.dirPath + File.separator + name.replace('.', File.separatorChar) + ".class");
            if (f.isFile()) {
                return new FileClassFile(f);
            }
            return null;
        }

        public List getAllClassFiles() {
            throw new RuntimeException("unimplemented");
        }

        public String toString() {
            return this.dirPath;
        }
    }

    private static class FileClassFile
    extends ClassFile {
        private File file;

        public FileClassFile(File file) {
            this.file = file;
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public String getPath() {
            return this.file.getPath();
        }
    }

    public static abstract class Entry {
        public abstract ClassFile find(String var1);

        public abstract List getAllClassFiles();
    }

    public static abstract class ClassFile {
        public abstract InputStream getInputStream() throws IOException;

        public abstract String getPath();
    }
}

