/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.Synthetic;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelObjectType;

final class BcelField
extends ResolvedMember {
    private Field field;
    private boolean isAjSynthetic;
    private boolean isSynthetic = false;

    BcelField(BcelObjectType declaringType, Field field) {
        super(Member.FIELD, declaringType.getResolvedTypeX(), field.getAccessFlags(), field.getName(), field.getSignature());
        this.field = field;
        this.unpackAttributes(declaringType.getResolvedTypeX().getWorld());
        this.checkedExceptions = TypeX.NONE;
    }

    private void unpackAttributes(World world) {
        Attribute[] attrs = this.field.getAttributes();
        List as = BcelAttributes.readAjAttributes(attrs, this.getSourceContext(world), world.getMessageHandler());
        Iterator iter = as.iterator();
        while (iter.hasNext()) {
            AjAttribute a = (AjAttribute)iter.next();
            if (a instanceof AjAttribute.AjSynthetic) {
                this.isAjSynthetic = true;
                continue;
            }
            throw new BCException("weird field attribute " + a);
        }
        this.isAjSynthetic = false;
        int i = attrs.length - 1;
        while (i >= 0) {
            if (attrs[i] instanceof Synthetic) {
                this.isSynthetic = true;
            }
            --i;
        }
    }

    public boolean isAjSynthetic() {
        return this.isAjSynthetic;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }
}

