/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.apache.bcel.generic.BranchInstruction;
import org.aspectj.apache.bcel.generic.CPInstruction;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.FieldInstruction;
import org.aspectj.apache.bcel.generic.INVOKESPECIAL;
import org.aspectj.apache.bcel.generic.IndexedInstruction;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.InstructionTargeter;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.LocalVariableInstruction;
import org.aspectj.apache.bcel.generic.NEW;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.PUTFIELD;
import org.aspectj.apache.bcel.generic.PUTSTATIC;
import org.aspectj.apache.bcel.generic.RET;
import org.aspectj.apache.bcel.generic.ReturnInstruction;
import org.aspectj.apache.bcel.generic.Select;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.bridge.IMessage;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.util.PartialOrder;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.IClassWeaver;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.WeaverMetrics;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.bcel.BcelAdvice;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelShadow;
import org.aspectj.weaver.bcel.BcelTypeMunger;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.ExceptionRange;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.bcel.Range;
import org.aspectj.weaver.bcel.ShadowRange;
import org.aspectj.weaver.bcel.Tag;
import org.aspectj.weaver.bcel.Utility;
import org.aspectj.weaver.patterns.FastMatchInfo;

class BcelClassWeaver
implements IClassWeaver {
    private final LazyClassGen clazz;
    private final List shadowMungers;
    private final List typeMungers;
    private final BcelObjectType ty;
    private final BcelWorld world;
    private final ConstantPoolGen cpg;
    private final InstructionFactory fact;
    private final List addedLazyMethodGens = new ArrayList();
    private final Set addedDispatchTargets = new HashSet();
    private static boolean inReweavableMode = false;
    private static boolean compressReweavableAttributes = false;
    private List addedSuperInitializersAsList = null;
    private final Map addedSuperInitializers = new HashMap();
    private List addedThisInitializers = new ArrayList();
    private List addedClassInitializers = new ArrayList();
    private BcelShadow clinitShadow = null;
    private final List initializationShadows = new ArrayList(1);
    private List[] perKindShadowMungers;
    private boolean canMatchBodyShadows = false;
    private boolean canMatchInitialization = false;

    public static boolean weave(BcelWorld world, LazyClassGen clazz, List shadowMungers, List typeMungers) {
        boolean b = new BcelClassWeaver(world, clazz, shadowMungers, typeMungers).weave();
        return b;
    }

    private BcelClassWeaver(BcelWorld world, LazyClassGen clazz, List shadowMungers, List typeMungers) {
        this.world = world;
        this.clazz = clazz;
        this.shadowMungers = shadowMungers;
        this.typeMungers = typeMungers;
        this.ty = clazz.getBcelObjectType();
        this.cpg = clazz.getConstantPoolGen();
        this.fact = clazz.getFactory();
        this.fastMatchShadowMungers(shadowMungers);
        this.initializeSuperInitializerMap(this.ty.getResolvedTypeX());
    }

    private void fastMatchShadowMungers(List shadowMungers) {
        this.perKindShadowMungers = new List[12];
        int i = 0;
        while (i < Shadow.SHADOW_KINDS.length) {
            ArrayList mungers;
            Shadow.Kind kind = Shadow.SHADOW_KINDS[i];
            this.perKindShadowMungers[kind.getKey()] = mungers = new ArrayList(0);
            this.fastMatchShadowMungers(shadowMungers, mungers, kind);
            if (mungers.isEmpty()) {
                this.perKindShadowMungers[kind.getKey()] = null;
            } else if (kind == Shadow.Initialization) {
                this.canMatchInitialization = true;
            } else if (!kind.isEnclosingKind()) {
                this.canMatchBodyShadows = true;
            }
            ++i;
        }
    }

    private boolean canMatch(Shadow.Kind kind) {
        return this.perKindShadowMungers[kind.getKey()] != null;
    }

    private void fastMatchShadowMungers(List shadowMungers, ArrayList mungers, Shadow.Kind kind) {
        FastMatchInfo info = new FastMatchInfo(this.clazz.getType(), kind);
        Iterator i = shadowMungers.iterator();
        while (i.hasNext()) {
            ShadowMunger munger = (ShadowMunger)i.next();
            FuzzyBoolean fb = munger.getPointcut().fastMatch(info);
            WeaverMetrics.recordFastMatchResult(fb);
            if (!fb.maybeTrue()) continue;
            mungers.add(munger);
        }
    }

    private void initializeSuperInitializerMap(ResolvedTypeX child) {
        ResolvedTypeX[] superInterfaces = child.getDeclaredInterfaces();
        int i = 0;
        int len = superInterfaces.length;
        while (i < len) {
            if (this.ty.getResolvedTypeX().isTopmostImplementor(superInterfaces[i]) && this.addSuperInitializer(superInterfaces[i])) {
                this.initializeSuperInitializerMap(superInterfaces[i]);
            }
            ++i;
        }
    }

    private boolean addSuperInitializer(ResolvedTypeX onType) {
        IfaceInitList l = (IfaceInitList)this.addedSuperInitializers.get(onType);
        if (l != null) {
            return false;
        }
        l = new IfaceInitList(onType);
        this.addedSuperInitializers.put(onType, l);
        return true;
    }

    public void addInitializer(ConcreteTypeMunger cm) {
        NewFieldTypeMunger m = (NewFieldTypeMunger)cm.getMunger();
        ResolvedTypeX onType = m.getSignature().getDeclaringType().resolve(this.world);
        if (m.getSignature().isStatic()) {
            this.addedClassInitializers.add(cm);
        } else if (onType == this.ty.getResolvedTypeX()) {
            this.addedThisInitializers.add(cm);
        } else {
            IfaceInitList l = (IfaceInitList)this.addedSuperInitializers.get(onType);
            l.list.add(cm);
        }
    }

    public boolean addDispatchTarget(ResolvedMember m) {
        return this.addedDispatchTargets.add(m);
    }

    public void addLazyMethodGen(LazyMethodGen gen) {
        this.addedLazyMethodGens.add(gen);
    }

    public void addOrReplaceLazyMethodGen(LazyMethodGen mg) {
        if (this.alreadyDefined(this.clazz, mg)) {
            return;
        }
        Iterator i = this.addedLazyMethodGens.iterator();
        while (i.hasNext()) {
            LazyMethodGen existing = (LazyMethodGen)i.next();
            if (!this.signaturesMatch(mg, existing)) continue;
            if (existing.definingType == null) {
                return;
            }
            if (mg.definingType.isAssignableFrom(existing.definingType)) {
                return;
            }
            if (existing.definingType.isAssignableFrom(mg.definingType)) {
                i.remove();
                this.addedLazyMethodGens.add(mg);
                return;
            }
            throw new BCException("conflict between: " + mg + " and " + existing);
        }
        this.addedLazyMethodGens.add(mg);
    }

    private boolean alreadyDefined(LazyClassGen clazz, LazyMethodGen mg) {
        Iterator i = clazz.getMethodGens().iterator();
        while (i.hasNext()) {
            LazyMethodGen existing = (LazyMethodGen)i.next();
            if (!this.signaturesMatch(mg, existing)) continue;
            if (!mg.isAbstract() && existing.isAbstract()) {
                i.remove();
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean signaturesMatch(LazyMethodGen mg, LazyMethodGen existing) {
        return mg.getName().equals(existing.getName()) && mg.getSignature().equals(existing.getSignature());
    }

    public boolean weave() {
        if (this.clazz.isWoven() && !this.clazz.isReweavable()) {
            this.world.showMessage(IMessage.ERROR, WeaverMessages.format("alreadyWoven", this.clazz.getType().getName()), this.ty.getSourceLocation(), null);
            return false;
        }
        HashSet<String> aspectsAffectingType = null;
        if (inReweavableMode) {
            aspectsAffectingType = new HashSet<String>();
        }
        boolean isChanged = false;
        if (this.clazz.getType().isAspect()) {
            isChanged = true;
        }
        Iterator i = this.typeMungers.iterator();
        while (i.hasNext()) {
            BcelTypeMunger munger;
            boolean typeMungerAffectedType;
            Object o = i.next();
            if (!(o instanceof BcelTypeMunger) || !(typeMungerAffectedType = (munger = (BcelTypeMunger)o).munge(this))) continue;
            isChanged = true;
            if (!inReweavableMode) continue;
            aspectsAffectingType.add(munger.getAspectType().getName());
        }
        this.addedSuperInitializersAsList = new ArrayList(this.addedSuperInitializers.values());
        this.addedSuperInitializersAsList = PartialOrder.sort(this.addedSuperInitializersAsList);
        if (this.addedSuperInitializersAsList == null) {
            throw new BCException("circularity in inter-types");
        }
        LazyMethodGen staticInit = this.clazz.getStaticInitializer();
        staticInit.getBody().insert(this.genInitInstructions(this.addedClassInitializers, true));
        ArrayList methodGens = new ArrayList(this.clazz.getMethodGens());
        Iterator i2 = methodGens.iterator();
        while (i2.hasNext()) {
            boolean shadowMungerMatched;
            LazyMethodGen mg = (LazyMethodGen)i2.next();
            if (!mg.hasBody() || !(shadowMungerMatched = this.match(mg))) continue;
            if (inReweavableMode) {
                aspectsAffectingType.addAll(this.findAspectsForMungers(mg));
            }
            isChanged = true;
        }
        if (!isChanged) {
            return false;
        }
        Iterator i3 = methodGens.iterator();
        while (i3.hasNext()) {
            LazyMethodGen mg = (LazyMethodGen)i3.next();
            if (!mg.hasBody()) continue;
            this.implement(mg);
        }
        if (!this.initializationShadows.isEmpty()) {
            while (this.inlineSelfConstructors(methodGens)) {
            }
            this.positionAndImplement(this.initializationShadows);
        }
        if (isChanged) {
            this.clazz.getOrCreateWeaverStateInfo();
            this.weaveInAddedMethods();
        }
        if (inReweavableMode) {
            WeaverStateInfo wsi = this.clazz.getOrCreateWeaverStateInfo();
            wsi.addAspectsAffectingType(aspectsAffectingType);
            wsi.setUnwovenClassFileData(this.ty.getJavaClass().getBytes());
            wsi.setReweavable(true, compressReweavableAttributes);
        } else {
            this.clazz.getOrCreateWeaverStateInfo().setReweavable(false, false);
        }
        return isChanged;
    }

    private Set findAspectsForMungers(LazyMethodGen mg) {
        HashSet<String> aspectsAffectingType = new HashSet<String>();
        Iterator iter = mg.matchedShadows.iterator();
        while (iter.hasNext()) {
            BcelShadow aShadow = (BcelShadow)iter.next();
            Iterator iter2 = aShadow.getMungers().iterator();
            while (iter2.hasNext()) {
                ShadowMunger aMunger = (ShadowMunger)iter2.next();
                if (!(aMunger instanceof BcelAdvice)) continue;
                BcelAdvice bAdvice = (BcelAdvice)aMunger;
                aspectsAffectingType.add(bAdvice.getConcreteAspect().getName());
            }
        }
        return aspectsAffectingType;
    }

    private boolean inlineSelfConstructors(List methodGens) {
        boolean inlinedSomething = false;
        Iterator i = methodGens.iterator();
        while (i.hasNext()) {
            InstructionHandle ih;
            LazyMethodGen mg = (LazyMethodGen)i.next();
            if (!mg.getName().equals("<init>") || (ih = this.findSuperOrThisCall(mg)) == null || !this.isThisCall(ih)) continue;
            LazyMethodGen donor = this.getCalledMethod(ih);
            BcelClassWeaver.inlineMethod(donor, mg, ih);
            inlinedSomething = true;
        }
        return inlinedSomething;
    }

    private void positionAndImplement(List initializationShadows) {
        Iterator i = initializationShadows.iterator();
        while (i.hasNext()) {
            BcelShadow s = (BcelShadow)i.next();
            this.positionInitializationShadow(s);
            s.implement();
        }
    }

    private void positionInitializationShadow(BcelShadow s) {
        LazyMethodGen mg = s.getEnclosingMethod();
        InstructionHandle call = this.findSuperOrThisCall(mg);
        InstructionList body = mg.getBody();
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(s);
        if (s.getKind() == Shadow.PreInitialization) {
            r.associateWithTargets(Range.genStart(body, body.getStart().getNext()), Range.genEnd(body, call.getPrev()));
        } else {
            r.associateWithTargets(Range.genStart(body, call.getNext()), Range.genEnd(body));
        }
    }

    private boolean isThisCall(InstructionHandle ih) {
        INVOKESPECIAL inst = (INVOKESPECIAL)ih.getInstruction();
        return inst.getClassName(this.cpg).equals(this.clazz.getName());
    }

    public static void inlineMethod(LazyMethodGen donor, LazyMethodGen recipient, InstructionHandle call) {
        InstructionFactory fact = recipient.getEnclosingClass().getFactory();
        IntMap frameEnv = new IntMap();
        InstructionList argumentStores = BcelClassWeaver.genArgumentStores(donor, recipient, frameEnv, fact);
        InstructionList inlineInstructions = BcelClassWeaver.genInlineInstructions(donor, recipient, frameEnv, fact, false);
        inlineInstructions.insert(argumentStores);
        recipient.getBody().append(call, inlineInstructions);
        Utility.deleteInstruction(call, recipient);
    }

    static InstructionList genInlineInstructions(LazyMethodGen donor, LazyMethodGen recipient, IntMap frameEnv, InstructionFactory fact, boolean keepReturns) {
        ConstantPoolGen recipientCpg;
        InstructionList footer = new InstructionList();
        InstructionHandle end = footer.append(InstructionConstants.NOP);
        InstructionList ret = new InstructionList();
        InstructionList sourceList = donor.getBody();
        HashMap<InstructionHandle, InstructionHandle> srcToDest = new HashMap<InstructionHandle, InstructionHandle>();
        ConstantPoolGen donorCpg = donor.getEnclosingClass().getConstantPoolGen();
        boolean isAcrossClass = donorCpg != (recipientCpg = recipient.getEnclosingClass().getConstantPoolGen());
        InstructionHandle src = sourceList.getStart();
        while (src != null) {
            InstructionHandle dest;
            Instruction fresh = Utility.copyInstruction(src.getInstruction());
            if (fresh instanceof CPInstruction && isAcrossClass) {
                CPInstruction cpi = (CPInstruction)fresh;
                cpi.setIndex(recipientCpg.addConstant(donorCpg.getConstant(cpi.getIndex()), donorCpg));
            }
            if (src.getInstruction() == Range.RANGEINSTRUCTION) {
                dest = ret.append(Range.RANGEINSTRUCTION);
            } else if (fresh instanceof ReturnInstruction) {
                dest = keepReturns ? ret.append(fresh) : ret.append(InstructionFactory.createBranchInstruction((short)167, end));
            } else if (fresh instanceof BranchInstruction) {
                dest = ret.append((BranchInstruction)fresh);
            } else if (fresh instanceof LocalVariableInstruction || fresh instanceof RET) {
                int freshIndex;
                IndexedInstruction indexed = (IndexedInstruction)((Object)fresh);
                int oldIndex = indexed.getIndex();
                if (!frameEnv.hasKey(oldIndex)) {
                    freshIndex = recipient.allocateLocal(2);
                    frameEnv.put(oldIndex, freshIndex);
                } else {
                    freshIndex = frameEnv.get(oldIndex);
                }
                indexed.setIndex(freshIndex);
                dest = ret.append(fresh);
            } else {
                dest = ret.append(fresh);
            }
            srcToDest.put(src, dest);
            src = src.getNext();
        }
        HashMap<Tag, Tag> tagMap = new HashMap<Tag, Tag>();
        HashMap<ShadowRange, ShadowRange> shadowMap = new HashMap<ShadowRange, ShadowRange>();
        InstructionHandle dest = ret.getStart();
        InstructionHandle src2 = sourceList.getStart();
        while (dest != null) {
            InstructionTargeter[] srcTargeters;
            BranchInstruction branch;
            InstructionHandle oldTarget;
            InstructionHandle newTarget;
            Instruction inst = dest.getInstruction();
            if (inst instanceof BranchInstruction && (newTarget = (InstructionHandle)srcToDest.get(oldTarget = (branch = (BranchInstruction)inst).getTarget())) != null) {
                branch.setTarget(newTarget);
                if (branch instanceof Select) {
                    Select select = (Select)branch;
                    InstructionHandle[] oldTargets = select.getTargets();
                    int k = oldTargets.length - 1;
                    while (k >= 0) {
                        select.setTarget(k, (InstructionHandle)srcToDest.get(oldTargets[k]));
                        --k;
                    }
                }
            }
            if ((srcTargeters = src2.getTargeters()) != null) {
                int j = srcTargeters.length - 1;
                while (j >= 0) {
                    ShadowRange oldRange;
                    InstructionTargeter old = srcTargeters[j];
                    if (old instanceof Tag) {
                        Tag oldTag = (Tag)old;
                        Tag fresh = (Tag)tagMap.get(oldTag);
                        if (fresh == null) {
                            fresh = oldTag.copy();
                            tagMap.put(oldTag, fresh);
                        }
                        dest.addTargeter(fresh);
                    } else if (old instanceof ExceptionRange) {
                        ExceptionRange er = (ExceptionRange)old;
                        if (er.getStart() == src2) {
                            ExceptionRange freshEr = new ExceptionRange(recipient.getBody(), er.getCatchType(), er.getPriority());
                            freshEr.associateWithTargets(dest, (InstructionHandle)srcToDest.get(er.getEnd()), (InstructionHandle)srcToDest.get(er.getHandler()));
                        }
                    } else if (old instanceof ShadowRange && (oldRange = (ShadowRange)old).getStart() == src2) {
                        BcelShadow oldShadow = oldRange.getShadow();
                        BcelShadow freshEnclosing = oldShadow.getEnclosingShadow() == null ? null : (BcelShadow)shadowMap.get(oldShadow.getEnclosingShadow());
                        BcelShadow freshShadow = oldShadow.copyInto(recipient, freshEnclosing);
                        ShadowRange freshRange = new ShadowRange(recipient.getBody());
                        freshRange.associateWithShadow(freshShadow);
                        freshRange.associateWithTargets(dest, (InstructionHandle)srcToDest.get(oldRange.getEnd()));
                        shadowMap.put(oldRange, freshRange);
                    }
                    --j;
                }
            }
            dest = dest.getNext();
            src2 = src2.getNext();
        }
        if (!keepReturns) {
            ret.append(footer);
        }
        return ret;
    }

    private static InstructionList genArgumentStores(LazyMethodGen donor, LazyMethodGen recipient, IntMap frameEnv, InstructionFactory fact) {
        InstructionList ret = new InstructionList();
        int donorFramePos = 0;
        if (!donor.isStatic()) {
            int targetSlot = recipient.allocateLocal(Type.OBJECT);
            ret.insert(InstructionFactory.createStore(Type.OBJECT, targetSlot));
            frameEnv.put(donorFramePos, targetSlot);
            ++donorFramePos;
        }
        Type[] argTypes = donor.getArgumentTypes();
        int i = 0;
        int len = argTypes.length;
        while (i < len) {
            Type argType = argTypes[i];
            int argSlot = recipient.allocateLocal(argType);
            ret.insert(InstructionFactory.createStore(argType, argSlot));
            frameEnv.put(donorFramePos, argSlot);
            donorFramePos += argType.getSize();
            ++i;
        }
        return ret;
    }

    private LazyMethodGen getCalledMethod(InstructionHandle ih) {
        InvokeInstruction inst = (InvokeInstruction)ih.getInstruction();
        String methodName = inst.getName(this.cpg);
        String signature = inst.getSignature(this.cpg);
        return this.clazz.getLazyMethodGen(methodName, signature);
    }

    private void weaveInAddedMethods() {
        Collections.sort(this.addedLazyMethodGens, new Comparator(){

            public int compare(Object a, Object b) {
                LazyMethodGen aa = (LazyMethodGen)a;
                LazyMethodGen bb = (LazyMethodGen)b;
                int i = aa.getName().compareTo(bb.getName());
                if (i != 0) {
                    return i;
                }
                return aa.getSignature().compareTo(bb.getSignature());
            }
        });
        Iterator i = this.addedLazyMethodGens.iterator();
        while (i.hasNext()) {
            this.clazz.addMethodGen((LazyMethodGen)i.next());
        }
    }

    void addPerSingletonField(Member field) {
        ObjectType aspectType = (ObjectType)BcelWorld.makeBcelType(field.getReturnType());
        String aspectName = field.getReturnType().getName();
        LazyMethodGen clinit = this.clazz.getStaticInitializer();
        InstructionList setup = new InstructionList();
        InstructionFactory fact = this.clazz.getFactory();
        setup.append(fact.createNew(aspectType));
        setup.append(InstructionFactory.createDup(1));
        setup.append(fact.createInvoke(aspectName, "<init>", Type.VOID, new Type[0], (short)183));
        setup.append(fact.createFieldAccess(aspectName, field.getName(), aspectType, (short)179));
        clinit.getBody().insert(setup);
    }

    private InstructionHandle findSuperOrThisCall(LazyMethodGen mg) {
        int depth = 1;
        InstructionHandle start = mg.getBody().getStart();
        while (start != null) {
            Instruction inst = start.getInstruction();
            if (inst instanceof INVOKESPECIAL && ((INVOKESPECIAL)inst).getName(this.cpg).equals("<init>")) {
                if (--depth == 0) {
                    return start;
                }
            } else if (inst instanceof NEW) {
                ++depth;
            }
            start = start.getNext();
        }
        return null;
    }

    private boolean match(LazyMethodGen mg) {
        BcelShadow enclosingShadow;
        ArrayList shadowAccumulator = new ArrayList();
        if (mg.getName().equals("<init>")) {
            return this.matchInit(mg, shadowAccumulator);
        }
        if (!this.shouldWeaveBody(mg)) {
            return false;
        }
        if (mg.getName().equals("<clinit>")) {
            this.clinitShadow = enclosingShadow = BcelShadow.makeStaticInitialization(this.world, mg);
        } else if (mg.isAdviceMethod()) {
            enclosingShadow = BcelShadow.makeAdviceExecution(this.world, mg);
        } else {
            AjAttribute.EffectiveSignatureAttribute effective = mg.getEffectiveSignature();
            if (effective == null) {
                enclosingShadow = BcelShadow.makeMethodExecution(this.world, mg, !this.canMatchBodyShadows);
            } else if (effective.isWeaveBody()) {
                enclosingShadow = BcelShadow.makeShadowForMethod(this.world, mg, effective.getShadowKind(), effective.getEffectiveSignature());
            } else {
                return false;
            }
        }
        if (this.canMatchBodyShadows) {
            InstructionHandle h = mg.getBody().getStart();
            while (h != null) {
                this.match(mg, h, enclosingShadow, shadowAccumulator);
                h = h.getNext();
            }
        }
        if (this.match(enclosingShadow, shadowAccumulator)) {
            enclosingShadow.init();
        }
        mg.matchedShadows = shadowAccumulator;
        return !shadowAccumulator.isEmpty();
    }

    private boolean matchInit(LazyMethodGen mg, List shadowAccumulator) {
        InstructionHandle superOrThisCall = this.findSuperOrThisCall(mg);
        if (superOrThisCall == null) {
            return false;
        }
        BcelShadow enclosingShadow = BcelShadow.makeConstructorExecution(this.world, mg, superOrThisCall);
        boolean beforeSuperOrThisCall = true;
        if (this.shouldWeaveBody(mg)) {
            if (this.canMatchBodyShadows) {
                InstructionHandle h = mg.getBody().getStart();
                while (h != null) {
                    if (h == superOrThisCall) {
                        beforeSuperOrThisCall = false;
                    } else {
                        this.match(mg, h, beforeSuperOrThisCall ? null : enclosingShadow, shadowAccumulator);
                    }
                    h = h.getNext();
                }
            }
            this.match(enclosingShadow, shadowAccumulator);
        }
        if (superOrThisCall != null && !this.isThisCall(superOrThisCall)) {
            InstructionHandle curr = enclosingShadow.getRange().getStart();
            Iterator i = this.addedSuperInitializersAsList.iterator();
            while (i.hasNext()) {
                IfaceInitList l = (IfaceInitList)i.next();
                Member ifaceInitSig = AjcMemberMaker.interfaceConstructor(l.onType);
                BcelShadow initShadow = BcelShadow.makeIfaceInitialization(this.world, mg, ifaceInitSig);
                InstructionList inits = this.genInitInstructions(l.list, false);
                if (!this.match(initShadow, shadowAccumulator) && inits.isEmpty()) continue;
                initShadow.initIfaceInitializer(curr);
                initShadow.getRange().insert(inits, Range.OutsideBefore);
            }
            InstructionList inits = this.genInitInstructions(this.addedThisInitializers, false);
            enclosingShadow.getRange().insert(inits, Range.OutsideBefore);
        }
        boolean addedInitialization = this.match(BcelShadow.makeUnfinishedInitialization(this.world, mg), this.initializationShadows);
        mg.matchedShadows = shadowAccumulator;
        return (addedInitialization |= this.match(BcelShadow.makeUnfinishedPreinitialization(this.world, mg), this.initializationShadows)) || !shadowAccumulator.isEmpty();
    }

    private boolean shouldWeaveBody(LazyMethodGen mg) {
        if (mg.isAjSynthetic()) {
            return mg.getName().equals("<clinit>");
        }
        AjAttribute.EffectiveSignatureAttribute a = mg.getEffectiveSignature();
        if (a != null) {
            return a.isWeaveBody();
        }
        return true;
    }

    private InstructionList genInitInstructions(List list, boolean isStatic) {
        if ((list = PartialOrder.sort(list)) == null) {
            throw new BCException("circularity in inter-types");
        }
        InstructionList ret = new InstructionList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger cmunger = (ConcreteTypeMunger)i.next();
            NewFieldTypeMunger munger = (NewFieldTypeMunger)cmunger.getMunger();
            ResolvedMember initMethod = munger.getInitMethod(cmunger.getAspectType());
            if (!isStatic) {
                ret.append(InstructionConstants.ALOAD_0);
            }
            ret.append(Utility.createInvoke(this.fact, this.world, initMethod));
        }
        return ret;
    }

    private void match(LazyMethodGen mg, InstructionHandle ih, BcelShadow enclosingShadow, List shadowAccumulator) {
        Instruction i = ih.getInstruction();
        if (i instanceof FieldInstruction) {
            FieldInstruction fi = (FieldInstruction)i;
            if (fi instanceof PUTFIELD || fi instanceof PUTSTATIC) {
                InstructionHandle prevHandle = ih.getPrev();
                Instruction prevI = prevHandle.getInstruction();
                if (Utility.isConstantPushInstruction(prevI)) {
                    Member field = BcelWorld.makeFieldSignature(this.clazz, (FieldInstruction)i);
                    ResolvedMember resolvedField = field.resolve(this.world);
                    if (resolvedField != null && !Modifier.isFinal(resolvedField.getModifiers())) {
                        this.matchSetInstruction(mg, ih, enclosingShadow, shadowAccumulator);
                    }
                } else {
                    this.matchSetInstruction(mg, ih, enclosingShadow, shadowAccumulator);
                }
            } else {
                this.matchGetInstruction(mg, ih, enclosingShadow, shadowAccumulator);
            }
        } else if (i instanceof InvokeInstruction) {
            InvokeInstruction ii = (InvokeInstruction)i;
            if (ii.getMethodName(this.clazz.getConstantPoolGen()).equals("<init>")) {
                this.match(BcelShadow.makeConstructorCall(this.world, mg, ih, enclosingShadow), shadowAccumulator);
            } else if (ii instanceof INVOKESPECIAL) {
                String onTypeName = ii.getClassName(this.cpg);
                if (onTypeName.equals(mg.getEnclosingClass().getName())) {
                    this.matchInvokeInstruction(mg, ih, ii, enclosingShadow, shadowAccumulator);
                }
            } else {
                this.matchInvokeInstruction(mg, ih, ii, enclosingShadow, shadowAccumulator);
            }
        }
        if (Range.isRangeHandle(ih)) {
            return;
        }
        InstructionTargeter[] targeters = ih.getTargeters();
        if (targeters != null) {
            int j = 0;
            while (j < targeters.length) {
                ExceptionRange er;
                InstructionTargeter t = targeters[j];
                if (t instanceof ExceptionRange && (er = (ExceptionRange)t).getCatchType() != null) {
                    if (this.isInitFailureHandler(ih)) {
                        return;
                    }
                    this.match(BcelShadow.makeExceptionHandler(this.world, er, mg, ih, enclosingShadow), shadowAccumulator);
                }
                ++j;
            }
        }
    }

    private boolean isInitFailureHandler(InstructionHandle ih) {
        String name;
        InstructionHandle twoInstructionsAway = ih.getNext().getNext();
        return twoInstructionsAway.getInstruction() instanceof PUTSTATIC && (name = ((PUTSTATIC)twoInstructionsAway.getInstruction()).getFieldName(this.cpg)).equals("ajc$initFailureCause");
    }

    private void matchSetInstruction(LazyMethodGen mg, InstructionHandle ih, BcelShadow enclosingShadow, List shadowAccumulator) {
        FieldInstruction fi = (FieldInstruction)ih.getInstruction();
        Member field = BcelWorld.makeFieldSignature(this.clazz, fi);
        if (field.getName().startsWith("ajc$")) {
            return;
        }
        ResolvedMember resolvedField = field.resolve(this.world);
        if (resolvedField == null) {
            return;
        }
        if (Modifier.isFinal(resolvedField.getModifiers()) && Utility.isConstantPushInstruction(ih.getPrev().getInstruction())) {
            return;
        }
        if (resolvedField.isSynthetic()) {
            return;
        }
        this.match(BcelShadow.makeFieldSet(this.world, mg, ih, enclosingShadow), shadowAccumulator);
    }

    private void matchGetInstruction(LazyMethodGen mg, InstructionHandle ih, BcelShadow enclosingShadow, List shadowAccumulator) {
        FieldInstruction fi = (FieldInstruction)ih.getInstruction();
        Member field = BcelWorld.makeFieldSignature(this.clazz, fi);
        if (field.getName().startsWith("ajc$")) {
            return;
        }
        ResolvedMember resolvedField = field.resolve(this.world);
        if (resolvedField == null) {
            return;
        }
        if (resolvedField.isSynthetic()) {
            return;
        }
        this.match(BcelShadow.makeFieldGet(this.world, mg, ih, enclosingShadow), shadowAccumulator);
    }

    private void matchInvokeInstruction(LazyMethodGen mg, InstructionHandle ih, InvokeInstruction invoke, BcelShadow enclosingShadow, List shadowAccumulator) {
        String methodName = invoke.getName(this.cpg);
        if (methodName.startsWith("ajc$")) {
            Member method = BcelWorld.makeMethodSignature(this.clazz, invoke);
            ResolvedMember declaredSig = method.resolve(this.world);
            if (declaredSig == null) {
                return;
            }
            if (declaredSig.getKind() == Member.FIELD) {
                Shadow.Kind kind = method.getReturnType().equals(ResolvedTypeX.VOID) ? Shadow.FieldSet : Shadow.FieldGet;
                this.match(BcelShadow.makeShadowForMethodCall(this.world, mg, ih, enclosingShadow, kind, declaredSig), shadowAccumulator);
            } else {
                AjAttribute.EffectiveSignatureAttribute effectiveSig = declaredSig.getEffectiveSignature();
                if (effectiveSig == null) {
                    return;
                }
                if (effectiveSig.isWeaveBody()) {
                    return;
                }
                this.match(BcelShadow.makeShadowForMethodCall(this.world, mg, ih, enclosingShadow, effectiveSig.getShadowKind(), effectiveSig.getEffectiveSignature()), shadowAccumulator);
            }
        } else {
            this.match(BcelShadow.makeMethodCall(this.world, mg, ih, enclosingShadow), shadowAccumulator);
        }
    }

    private boolean match(BcelShadow shadow, List shadowAccumulator) {
        boolean isMatched = false;
        Iterator i = this.shadowMungers.iterator();
        while (i.hasNext()) {
            ShadowMunger munger = (ShadowMunger)i.next();
            if (munger.match(shadow, this.world)) {
                WeaverMetrics.recordMatchResult(true);
                shadow.addMunger(munger);
                isMatched = true;
                if (shadow.getKind() != Shadow.StaticInitialization) continue;
                this.clazz.warnOnAddedStaticInitializer(shadow, munger.getSourceLocation());
                continue;
            }
            WeaverMetrics.recordMatchResult(false);
        }
        if (isMatched) {
            shadowAccumulator.add(shadow);
        }
        return isMatched;
    }

    private void implement(LazyMethodGen mg) {
        List shadows = mg.matchedShadows;
        if (shadows == null) {
            return;
        }
        Iterator i = shadows.iterator();
        while (i.hasNext()) {
            BcelShadow shadow = (BcelShadow)i.next();
            shadow.implement();
        }
        mg.matchedShadows = null;
    }

    public LazyClassGen getLazyClassGen() {
        return this.clazz;
    }

    public List getShadowMungers() {
        return this.shadowMungers;
    }

    public BcelWorld getWorld() {
        return this.world;
    }

    public static void setReweavableMode(boolean mode, boolean compress) {
        inReweavableMode = mode;
        compressReweavableAttributes = compress;
    }

    private static class IfaceInitList
    implements PartialOrder.PartialComparable {
        final ResolvedTypeX onType;
        List list = new ArrayList();

        IfaceInitList(ResolvedTypeX onType) {
            this.onType = onType;
        }

        public int compareTo(Object other) {
            IfaceInitList o = (IfaceInitList)other;
            if (this.onType.isAssignableFrom(o.onType)) {
                return 1;
            }
            if (o.onType.isAssignableFrom(this.onType)) {
                return -1;
            }
            return 0;
        }

        public int fallbackCompareTo(Object other) {
            return 0;
        }
    }
}

