/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.TypeSafeEnum;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NewConstructorTypeMunger;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.NewMethodTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.World;

public abstract class ResolvedTypeMunger {
    protected Kind kind;
    protected ResolvedMember signature;
    public static transient boolean persistSourceLocation = false;
    private Set superMethodsCalled = Collections.EMPTY_SET;
    private ISourceLocation location;
    public static final Kind Field = new Kind("Field", 1);
    public static final Kind Method = new Kind("Method", 2);
    public static final Kind Constructor = new Kind("Constructor", 5);
    public static final Kind PerObjectInterface = new Kind("PerObjectInterface", 3);
    public static final Kind PrivilegedAccess = new Kind("PrivilegedAccess", 4);
    public static final Kind Parent = new Kind("Parent", 6);
    public static final String SUPER_DISPATCH_NAME = "superDispatch";

    public ResolvedTypeMunger(Kind kind, ResolvedMember signature) {
        this.kind = kind;
        this.signature = signature;
    }

    public void setSourceLocation(ISourceLocation isl) {
        this.location = isl;
    }

    public ISourceLocation getSourceLocation() {
        return this.location;
    }

    public ConcreteTypeMunger concretize(World world, ResolvedTypeX aspectType) {
        ConcreteTypeMunger munger = world.concreteTypeMunger(this, aspectType);
        return munger;
    }

    public boolean matches(ResolvedTypeX matchType, ResolvedTypeX aspectType) {
        ResolvedTypeX onType = matchType.getWorld().resolve(this.signature.getDeclaringType());
        if (matchType.equals(onType)) {
            if (!onType.isExposedToWeaver() && onType.getWeaverState() == null && matchType.getWorld().getLint().typeNotExposedToWeaver.isEnabled()) {
                matchType.getWorld().getLint().typeNotExposedToWeaver.signal(matchType.getName(), this.signature.getSourceLocation());
            }
            return true;
        }
        if (onType.isInterface()) {
            return matchType.isTopmostImplementor(onType);
        }
        return false;
    }

    public String toString() {
        return "ResolvedTypeMunger(" + this.getKind() + ", " + this.getSignature() + ")";
    }

    public static ResolvedTypeMunger read(DataInputStream s, ISourceContext context) throws IOException {
        Kind kind = Kind.read(s);
        if (kind == Field) {
            return NewFieldTypeMunger.readField(s, context);
        }
        if (kind == Method) {
            return NewMethodTypeMunger.readMethod(s, context);
        }
        if (kind == Constructor) {
            return NewConstructorTypeMunger.readConstructor(s, context);
        }
        throw new RuntimeException("unimplemented");
    }

    protected static Set readSuperMethodsCalled(DataInputStream s) throws IOException {
        HashSet<ResolvedMember> ret = new HashSet<ResolvedMember>();
        int n = s.readInt();
        int i = 0;
        while (i < n) {
            ret.add(ResolvedMember.readResolvedMember(s, null));
            ++i;
        }
        return ret;
    }

    protected void writeSuperMethodsCalled(DataOutputStream s) throws IOException {
        if (this.superMethodsCalled == null) {
            s.writeInt(0);
            return;
        }
        ArrayList ret = new ArrayList(this.superMethodsCalled);
        Collections.sort(ret);
        int n = ret.size();
        s.writeInt(n);
        Iterator i = ret.iterator();
        while (i.hasNext()) {
            ResolvedMember m = (ResolvedMember)i.next();
            m.write(s);
        }
    }

    protected static ISourceLocation readSourceLocation(DataInputStream s) throws IOException {
        if (!persistSourceLocation) {
            return null;
        }
        SourceLocation ret = null;
        ObjectInputStream ois = new ObjectInputStream(s);
        try {
            Boolean validLocation = (Boolean)ois.readObject();
            if (validLocation.booleanValue()) {
                File f = (File)ois.readObject();
                Integer ii = (Integer)ois.readObject();
                ret = new SourceLocation(f, ii);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        ois.close();
        return ret;
    }

    protected void writeSourceLocation(DataOutputStream s) throws IOException {
        if (!persistSourceLocation) {
            return;
        }
        ObjectOutputStream oos = new ObjectOutputStream(s);
        oos.writeObject(new Boolean(this.location != null));
        if (this.location != null) {
            oos.writeObject(this.location.getSourceFile());
            oos.writeObject(new Integer(this.location.getLine()));
        }
        oos.flush();
        oos.close();
    }

    public abstract void write(DataOutputStream var1) throws IOException;

    public Kind getKind() {
        return this.kind;
    }

    public void setSuperMethodsCalled(Set c) {
        this.superMethodsCalled = c;
    }

    public Set getSuperMethodsCalled() {
        return this.superMethodsCalled;
    }

    public ResolvedMember getSignature() {
        return this.signature;
    }

    public ResolvedMember getMatchingSyntheticMember(Member member, ResolvedTypeX aspectType) {
        if (this.getSignature() != null && this.getSignature().isPublic() && member.equals(this.getSignature())) {
            return this.getSignature();
        }
        return null;
    }

    public boolean changesPublicSignature() {
        return this.kind == Field || this.kind == Method || this.kind == Constructor;
    }

    public boolean needsAccessToTopmostImplementor() {
        if (this.kind == Field) {
            return true;
        }
        if (this.kind == Method) {
            return !this.signature.isAbstract();
        }
        return false;
    }

    public static class Kind
    extends TypeSafeEnum {
        Kind(String name, int key) {
            super(name, key);
        }

        public static Kind read(DataInputStream s) throws IOException {
            byte key = s.readByte();
            switch (key) {
                case 1: {
                    return Field;
                }
                case 2: {
                    return Method;
                }
                case 5: {
                    return Constructor;
                }
            }
            throw new BCException("bad kind: " + key);
        }
    }
}

