/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ant.taskdefs;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.tools.ajc.Main;
import org.aspectj.util.FileUtil;

public class Ajc10
extends MatchingTask {
    private static final List VALID_XOPTIONS;
    protected boolean source14;
    protected Set ignoredOptions;
    protected Commandline cmd;
    protected Commandline vmcmd;
    private int threads = -1;
    private File destdir;
    private File workingdir;
    private Path internalclasspath;
    private Path classpath;
    private Path bootclasspath;
    private Path extdirs;
    private Path srcdir;
    private List argfiles;
    private boolean fork;
    private boolean failonerror;
    private boolean verbose;
    private String encoding;
    private String source;

    public Ajc10() {
        this.reset();
    }

    public void setVerbose(boolean verbose) {
        this.setif(verbose, "-verbose");
        this.verbose = verbose;
    }

    public void setVersion(boolean version) {
        if (version) {
            this.setif(true, "-version");
        }
    }

    public void setNocomments(boolean nocomments) {
        if (nocomments) {
            this.ignore("-nocomments");
        }
    }

    public void setEmacssym(boolean input) {
        this.setif(input, "-emacssym");
    }

    public void setUsejavac(boolean input) {
        if (input) {
            this.ignore("-usejavac");
        }
    }

    public void setPreprocess(boolean preprocess) {
        if (preprocess) {
            this.ignore("-preprocess");
        }
    }

    public void setWorkingdir(String workingdir) {
        this.ignore("-workingdir");
    }

    public void setDestdir(String destdir) {
        this.destdir = ((ProjectComponent)this).project.resolveFile(destdir);
    }

    public void setOptimize(boolean optimize) {
        this.setif(optimize, "-O");
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathref(Reference classpathref) {
        this.createClasspath().setRefid(classpathref);
    }

    public void setBootclasspath(Path bootclasspath) {
        this.ignore("bootclasspath");
    }

    public Path createBootclasspath() {
        this.ignore("bootclasspath");
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(((ProjectComponent)this).project);
        }
        return this.bootclasspath.createPath();
    }

    public void setBootclasspathref(Reference bootclasspathref) {
        this.ignore("bootclasspath");
    }

    public void setExtdirs(Path extdirs) {
        this.ignore("-extdirs");
    }

    public Path createExtdirs() {
        this.ignore("-extdirs");
        if (this.extdirs == null) {
            this.extdirs = new Path(((ProjectComponent)this).project);
        }
        return this.extdirs.createPath();
    }

    public void setArgfile(File argfile) {
        if (this.argfiles == null) {
            this.argfiles = new Vector();
        }
        this.argfiles.add(argfile);
    }

    public void setArgfiles(String argfiles) {
        StringTokenizer tok = new StringTokenizer(argfiles, ", ", false);
        if (tok.hasMoreTokens() && this.argfiles == null) {
            this.argfiles = new Vector();
        }
        while (tok.hasMoreTokens()) {
            this.argfiles.add(((ProjectComponent)this).project.resolveFile(tok.nextToken().trim()));
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSource(String input) {
        this.source = input;
    }

    public void setLenient(boolean input) {
        this.ignore("-lenient");
    }

    public void setStrict(boolean input) {
        this.ignore("-strict");
    }

    public void setPorting(boolean input) {
        this.ignore("-porting");
    }

    public void setX(String input) {
        StringTokenizer tokens = new StringTokenizer(input, ",", false);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (1 >= token.length()) continue;
            if (VALID_XOPTIONS.contains(token)) {
                this.setif(true, "-X" + token);
                continue;
            }
            this.ignore("-X" + token);
        }
    }

    public void setThreads(int threads) {
        this.ignore("-threads");
    }

    public void setDumpstack(boolean dumpstack) {
        this.ignore("-dumpstack");
    }

    public void setInternalclasspath(Path internalclasspath) {
        if (this.internalclasspath == null) {
            this.internalclasspath = internalclasspath;
        } else {
            this.internalclasspath.append(internalclasspath);
        }
    }

    public Path createInternalclasspath() {
        if (this.internalclasspath == null) {
            this.internalclasspath = new Path(((ProjectComponent)this).project);
        }
        return this.internalclasspath.createPath();
    }

    public void setInternalclasspathref(Reference internalclasspathref) {
        this.createInternalclasspath().setRefid(internalclasspathref);
    }

    public void setSrcdir(Path srcdir) {
        if (this.srcdir == null) {
            this.srcdir = srcdir;
        } else {
            this.srcdir.append(srcdir);
        }
    }

    public Path createSrc() {
        return this.createSrcdir();
    }

    public Path createSrcdir() {
        if (this.srcdir == null) {
            this.srcdir = new Path(((ProjectComponent)this).project);
        }
        return this.srcdir.createPath();
    }

    public void setFork(boolean fork) {
        this.ignore("fork");
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setMaxmemory(String max) {
        this.ignore("-maxmemory");
    }

    public void setJvmarg(String input) {
        this.ignore("jvmarg");
    }

    public Commandline.Argument createJvmarg() {
        this.ignore("jvmarg");
        return this.vmcmd.createArgument();
    }

    public void setNosymbols(boolean nosymbols) {
        this.ignore("-nosymbols");
    }

    public void setDebug(boolean debug) {
        this.setif(debug, "-g");
    }

    public void setDeprecation(boolean deprecation) {
        this.setif(deprecation, "-deprecation");
    }

    public void setTarget(String target) {
        this.ignore("target");
    }

    public void setDepend(String depend) {
        this.ignore("depend");
    }

    public void setIncludeantruntime(boolean includeAntruntime) {
        this.ignore("includeantruntime");
    }

    public void setIncludejavaruntime(boolean includeJavaruntime) {
        this.ignore("includeJavaruntime");
    }

    protected final void ignore(String attribute) {
        this.ignoredOptions.add(attribute);
    }

    public void backdoorSetFile(File file) {
        if (null != file) {
            this.cmd.createArgument().setFile(file);
        }
    }

    public void reset() {
        this.source14 = false;
        this.ignoredOptions = new HashSet();
        this.cmd = new Commandline();
        this.vmcmd = new Commandline();
        this.threads = -1;
        this.destdir = null;
        this.workingdir = null;
        this.internalclasspath = null;
        this.classpath = null;
        this.bootclasspath = null;
        this.extdirs = null;
        this.srcdir = null;
        this.argfiles = null;
        this.fork = false;
        this.failonerror = true;
        this.encoding = null;
        this.source = null;
    }

    protected final void setif(boolean b, String flag) {
        if (b) {
            this.cmd.createArgument().setValue(flag);
        }
    }

    public void execute() throws BuildException {
        int result;
        if (this.srcdir == null && this.argfiles == null) {
            throw new BuildException("one of srcdir or argfiles must be set!", ((Task)this).location);
        }
        if (this.destdir != null) {
            this.cmd.createArgument().setValue("-d");
            this.cmd.createArgument().setFile(this.destdir);
        }
        if (this.classpath != null) {
            this.cmd.createArgument().setValue("-classpath");
            this.cmd.createArgument().setPath(this.classpath);
        }
        if (this.bootclasspath != null) {
            this.cmd.createArgument().setValue("-bootclasspath");
            this.cmd.createArgument().setPath(this.bootclasspath);
        }
        if (this.extdirs != null) {
            this.cmd.createArgument().setValue("-extdirs");
            this.cmd.createArgument().setPath(this.extdirs);
        }
        if (null != this.encoding) {
            this.cmd.createArgument().setValue("-encoding");
            this.cmd.createArgument().setValue(this.encoding);
        }
        if (null != this.source) {
            this.cmd.createArgument().setValue("-source");
            this.cmd.createArgument().setValue(this.source);
        }
        int numargfiles = 0;
        if (this.argfiles != null) {
            Iterator i = this.argfiles.iterator();
            while (i.hasNext()) {
                String name = i.next() + "";
                File argfile = ((ProjectComponent)this).project.resolveFile(name);
                if (!this.check(argfile, name, false, ((Task)this).location)) continue;
                this.cmd.createArgument().setValue("-argfile");
                this.cmd.createArgument().setFile(argfile);
                ++numargfiles;
            }
        }
        int numfiles = 0;
        if (this.srcdir != null) {
            String[] dirs = this.srcdir.list();
            int i = 0;
            while (i < dirs.length) {
                File dir = ((ProjectComponent)this).project.resolveFile(dirs[i]);
                this.check(dir, dirs[i], true, ((Task)this).location);
                String[] files = this.getDirectoryScanner(dir).getIncludedFiles();
                int j = 0;
                while (j < files.length) {
                    File file = new File(dir, files[j]);
                    if (FileUtil.hasSourceSuffix(file)) {
                        this.cmd.createArgument().setFile(file);
                        ++numfiles;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (null != this.ignoredOptions && this.ignoredOptions.size() > 0) {
            this.log("The following attributes were ignored " + this.ignoredOptions, 1);
            if (this.ignoredOptions.contains("-preprocess")) {
                throw new BuildException("preprocess no longer supported");
            }
        }
        this.log("Compiling " + numfiles + " source and " + numargfiles + " arg files" + (null == this.destdir ? "" : " to " + this.destdir.getPath()), 2);
        if (this.fork || this.internalclasspath != null) {
            this.log("WARNING: fork not supported", 1);
        }
        if ((result = this.spoon()) != 0) {
            String msg = "Compilation error: " + result;
            if (this.failonerror) {
                this.reset();
                throw new BuildException(msg);
            }
            this.log(msg, 1);
        }
        this.reset();
    }

    public static String render(String[] args) {
        if (null == args) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            sb.append(args[i]);
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int spoon() throws BuildException {
        int result = -1;
        MessageHandler handler = new MessageHandler();
        if (!this.verbose) {
            handler.ignore(IMessage.INFO);
        }
        IMessageHandler delegate = this.verbose ? Main.MessagePrinter.VERBOSE : Main.MessagePrinter.TERSE;
        handler.setInterceptor(delegate);
        MessageHandler holder = handler;
        try {
            try {
                String[] args = this.cmd.getCommandline();
                this.log("Running  in-process using " + Ajc10.render(this.cmd.getCommandline()), 3);
                Main main = new Main();
                main.run(args, holder);
                int errs = holder.numMessages(IMessage.ERROR, true);
                if (0 >= errs) return 0;
                return 1;
            }
            catch (Throwable t) {}
            while (t instanceof AbortException) {
                Throwable tt;
                if (((AbortException)t).isSilent()) {
                    t = null;
                    break;
                }
                IMessage m = ((AbortException)t).getIMessage();
                if (null == m || null == (tt = m.getThrown())) break;
                t = tt;
            }
            if (null == t) return result;
            throw new BuildException("Compiler failure", t, ((Task)this).location);
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            throw throwable;
        }
    }

    protected final boolean check(File file, String name, boolean isDir, Location loc) {
        Location location = loc = loc != null ? loc : ((Task)this).location;
        if (file == null) {
            throw new BuildException(name + " is null!", loc);
        }
        if (!file.exists()) {
            throw new BuildException(file + "doesn't exist!", loc);
        }
        if (isDir ^ file.isDirectory()) {
            String e = file + " should" + (isDir ? "" : "n't") + " be a directory!";
            throw new BuildException(e, loc);
        }
        return true;
    }

    static {
        String[] xs = new String[]{"lint", "serializableAspects", "targetNearSource", "OcodeSize", "incrementalFile"};
        VALID_XOPTIONS = Collections.unmodifiableList(Arrays.asList(xs));
    }
}

