/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.aspectj.tools.ajdoc.CompilerWrapper;
import org.aspectj.tools.ajdoc.Config;
import org.aspectj.tools.ajdoc.HtmlDecorator;
import org.aspectj.tools.ajdoc.JavadocRunner;
import org.aspectj.tools.ajdoc.StructureUtil;
import org.aspectj.tools.ajdoc.StubFileGenerator;
import org.aspectj.tools.ajdoc.SymbolManager;
import org.aspectj.util.FileUtil;

public class Main
implements Config {
    private static final String FAIL_MESSAGE = "> compile failed, exiting ajdoc";
    static SymbolManager symbolManager = null;
    static Vector options;
    static Vector ajcOptions;
    static Vector filenames;
    static Vector fileList;
    static Vector packageList;
    static String docModifier;
    static Vector sourcepath;
    static boolean verboseMode;
    static boolean packageMode;
    static boolean authorStandardDocletSwitch;
    static boolean versionStandardDocletSwitch;
    static File rootDir;
    static Hashtable declIDTable;
    static String docDir;
    private static boolean deleteTempFilesOnExit;
    private static boolean aborted;
    static final String internalErrorMessage = "Please copy the following text into an email message and send it,\nalong with any additional information you can add to:            \n                                                                 \n       aspectj-dev@eclipse.org                           \n                                                                 \n";

    public static void clearState() {
        symbolManager = null;
        options = new Vector();
        ajcOptions = new Vector();
        filenames = new Vector();
        fileList = new Vector();
        packageList = new Vector();
        docModifier = "package";
        sourcepath = new Vector();
        verboseMode = false;
        packageMode = false;
        rootDir = null;
        declIDTable = new Hashtable();
        docDir = ".";
        aborted = false;
        deleteTempFilesOnExit = true;
    }

    public static void main(String[] args) {
        Main.clearState();
        sourcepath.addElement(".");
        Main.parseCommandLine(args);
        rootDir = Main.getRootDir();
        symbolManager = SymbolManager.getDefault();
        File[] inputFiles = new File[filenames.size()];
        File[] signatureFiles = new File[filenames.size()];
        try {
            if (!new File("ajdocworkingdir").isDirectory()) {
                File dir = new File("ajdocworkingdir");
                dir.mkdir();
                if (deleteTempFilesOnExit) {
                    dir.deleteOnExit();
                }
            }
            int i = 0;
            while (i < filenames.size()) {
                inputFiles[i] = new File((String)filenames.elementAt(i));
                ++i;
            }
            ajcOptions.addElement("-noExit");
            ajcOptions.addElement("-XjavadocsInModel");
            ajcOptions.addElement("-d");
            ajcOptions.addElement(rootDir.getAbsolutePath());
            String[] argsToCompiler = new String[ajcOptions.size() + inputFiles.length];
            int i2 = 0;
            while (i2 < ajcOptions.size()) {
                argsToCompiler[i2] = (String)ajcOptions.elementAt(i2);
                ++i2;
            }
            int j = 0;
            while (j < inputFiles.length) {
                argsToCompiler[i2] = inputFiles[j].getAbsolutePath();
                ++i2;
                ++j;
            }
            System.out.println("> Calling ajc...");
            CompilerWrapper.main(argsToCompiler);
            if (CompilerWrapper.hasErrors()) {
                System.out.println(FAIL_MESSAGE);
                aborted = true;
                return;
            }
            int ii = 0;
            while (ii < filenames.size()) {
                signatureFiles[ii] = Main.createSignatureFile(inputFiles[ii]);
                ++ii;
            }
            System.out.println("> Building signature files...");
            StubFileGenerator.doFiles(declIDTable, symbolManager, inputFiles, signatureFiles);
            System.out.println("> Calling javadoc...");
            String[] javadocargs = null;
            if (packageMode) {
                int numExtraArgs = 2;
                if (authorStandardDocletSwitch) {
                    ++numExtraArgs;
                }
                if (versionStandardDocletSwitch) {
                    ++numExtraArgs;
                }
                javadocargs = new String[numExtraArgs + options.size() + packageList.size() + fileList.size()];
                javadocargs[0] = "-sourcepath";
                javadocargs[1] = "ajdocworkingdir";
                int argIndex = 2;
                if (authorStandardDocletSwitch) {
                    javadocargs[argIndex] = "-author";
                    ++argIndex;
                }
                if (versionStandardDocletSwitch) {
                    javadocargs[argIndex] = "-version";
                }
                int k = 0;
                while (k < options.size()) {
                    javadocargs[numExtraArgs + k] = (String)options.elementAt(k);
                    ++k;
                }
                int k2 = 0;
                while (k2 < packageList.size()) {
                    javadocargs[numExtraArgs + Main.options.size() + k2] = (String)packageList.elementAt(k2);
                    ++k2;
                }
                int k3 = 0;
                while (k3 < fileList.size()) {
                    javadocargs[numExtraArgs + Main.options.size() + Main.packageList.size() + k3] = (String)fileList.elementAt(k3);
                    ++k3;
                }
            } else {
                javadocargs = new String[options.size() + signatureFiles.length];
                int k = 0;
                while (k < options.size()) {
                    javadocargs[k] = (String)options.elementAt(k);
                    ++k;
                }
                int k4 = 0;
                while (k4 < signatureFiles.length) {
                    javadocargs[Main.options.size() + k4] = StructureUtil.translateAjPathName(signatureFiles[k4].getCanonicalPath());
                    ++k4;
                }
            }
            JavadocRunner.callJavadoc(javadocargs);
            System.out.println("> Decorating html files...");
            HtmlDecorator.decorateHTMLFromInputFiles(declIDTable, rootDir, symbolManager, inputFiles, docModifier);
            System.out.println("> Removing generated tags (this may take a while)...");
            Main.removeDeclIDsFromFile("index-all.html", true);
            Main.removeDeclIDsFromFile("serialized-form.html", true);
            if (packageList.size() > 0) {
                int p = 0;
                while (p < packageList.size()) {
                    Main.removeDeclIDsFromFile(((String)packageList.elementAt(p)).replace('.', '/') + "/" + "package-summary.html", true);
                    ++p;
                }
            } else {
                File[] files = FileUtil.listFiles(rootDir, new FileFilter(){

                    public boolean accept(File f) {
                        return f.getName().equals("package-summary.html");
                    }
                });
                int j2 = 0;
                while (j2 < files.length) {
                    Main.removeDeclIDsFromFile(files[j2].getAbsolutePath(), false);
                    ++j2;
                }
            }
            System.out.println("> Finished.");
        }
        catch (Throwable e) {
            Main.handleInternalError(e);
            Main.exit(-2);
        }
    }

    private static void removeDeclIDsFromFile(String filename, boolean relativePath) {
        File indexFile = relativePath ? new File(docDir + "/" + filename) : new File(filename);
        try {
            if (indexFile.exists()) {
                BufferedReader indexFileReader = new BufferedReader(new FileReader(indexFile));
                String indexFileBuffer = "";
                String line = indexFileReader.readLine();
                while (line != null) {
                    int indexStart = line.indexOf("__AJDECLID:");
                    int indexEnd = line.indexOf(":__");
                    if (indexStart != -1 && indexEnd != -1) {
                        line = line.substring(0, indexStart) + line.substring(indexEnd + ":__".length());
                    }
                    indexFileBuffer = indexFileBuffer + line;
                    line = indexFileReader.readLine();
                }
                FileOutputStream fos = new FileOutputStream(indexFile);
                fos.write(indexFileBuffer.getBytes());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static Vector getSourcePath() {
        Vector<String> sourcePath = new Vector<String>();
        boolean found = false;
        int i = 0;
        while (i < options.size()) {
            String currOption = (String)options.elementAt(i);
            if (found && !currOption.startsWith("-")) {
                sourcePath.add(currOption);
            }
            if (currOption.equals("-sourcepath")) {
                found = true;
            }
            ++i;
        }
        return sourcePath;
    }

    static File getRootDir() {
        File rootDir = new File(".");
        int i = 0;
        while (i < options.size()) {
            if (((String)options.elementAt(i)).equals("-d") && !(rootDir = new File((String)options.elementAt(i + 1))).exists()) {
                rootDir.mkdir();
            }
            ++i;
        }
        return rootDir;
    }

    static File createSignatureFile(File inputFile) throws IOException {
        String packageName = StructureUtil.getPackageDeclarationFromFile(inputFile);
        String filename = "";
        if (packageName != null) {
            String pathName = "ajdocworkingdir/" + packageName.replace('.', '/');
            File packageDir = new File(pathName);
            if (!packageDir.exists()) {
                packageDir.mkdirs();
                if (deleteTempFilesOnExit) {
                    packageDir.deleteOnExit();
                }
            }
            packageName = packageName.replace('.', '/');
            filename = "ajdocworkingdir/" + packageName + "/" + inputFile.getName();
        } else {
            filename = "ajdocworkingdir/" + inputFile.getName();
        }
        File signatureFile = new File(filename);
        if (deleteTempFilesOnExit) {
            signatureFile.deleteOnExit();
        }
        return signatureFile;
    }

    static void parseCommandLine(String[] args) {
        if (args.length == 0) {
            Main.displayHelpAndExit(null);
        } else if (args.length == 1 && args[0].startsWith("@")) {
            String argFile = args[0].substring(1);
            System.out.println("> Using arg file: " + argFile);
            try {
                BufferedReader br = new BufferedReader(new FileReader(argFile));
                String line = "";
                line = br.readLine();
                StringTokenizer st = new StringTokenizer(line, " ");
                ArrayList<String> argList = new ArrayList<String>();
                while (st.hasMoreElements()) {
                    argList.add((String)st.nextElement());
                }
                args = new String[argList.size()];
                int counter = 0;
                Iterator it = argList.iterator();
                while (it.hasNext()) {
                    args[counter] = (String)it.next();
                    ++counter;
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("> could not read arg file: " + argFile);
                e.printStackTrace();
            }
            catch (IOException ioe) {
                System.err.println("> could not read arg file: " + argFile);
                ioe.printStackTrace();
            }
        }
        LinkedList<String> vargs = new LinkedList<String>(Arrays.asList(args));
        Main.parseArgs(vargs, new File("."));
        if (filenames.size() == 0) {
            Main.displayHelpAndExit("ajdoc: No packages or classes specified");
        }
    }

    static void setSourcepath(String arg) {
        sourcepath.clear();
        arg = arg + File.pathSeparator;
        StringTokenizer tokenizer = new StringTokenizer(arg, File.pathSeparator);
        while (tokenizer.hasMoreElements()) {
            sourcepath.addElement(tokenizer.nextElement());
        }
    }

    static String getSourcepathAsString() {
        String cPath = "";
        int i = 0;
        while (i < sourcepath.size()) {
            cPath = cPath + (String)sourcepath.elementAt(i) + "/" + "ajdocworkingdir";
            if (i != sourcepath.size() - 1) {
                cPath = cPath + File.pathSeparator;
            }
            ++i;
        }
        return cPath;
    }

    static void parseArgs(List vargs, File currentWorkingDir) {
        boolean addNextAsOption = false;
        boolean addNextAsArgFile = false;
        boolean addNextToAJCOptions = false;
        boolean addNextAsDocDir = false;
        boolean addNextAsClasspath = false;
        boolean ignoreArg = false;
        boolean addNextAsSourcePath = false;
        if (vargs.size() == 0) {
            Main.displayHelpAndExit(null);
        }
        int i = 0;
        while (i < vargs.size()) {
            String arg = (String)vargs.get(i);
            ignoreArg = false;
            if (addNextToAJCOptions) {
                ajcOptions.addElement(arg);
                addNextToAJCOptions = false;
            }
            if (addNextAsDocDir) {
                docDir = arg;
                addNextAsDocDir = false;
            }
            if (addNextAsClasspath) {
                addNextAsClasspath = false;
            }
            if (addNextAsSourcePath) {
                Main.setSourcepath(arg);
                addNextAsSourcePath = false;
                ignoreArg = true;
            }
            if (arg.startsWith("@")) {
                Main.expandAtSignFile(arg.substring(1), currentWorkingDir);
            } else if (arg.equals("-argfile")) {
                addNextAsArgFile = true;
            } else if (addNextAsArgFile) {
                Main.expandAtSignFile(arg, currentWorkingDir);
                addNextAsArgFile = false;
            } else if (arg.equals("-d")) {
                addNextAsOption = true;
                options.addElement(arg);
                addNextAsDocDir = true;
            } else if (arg.equals("-bootclasspath")) {
                addNextAsOption = true;
                addNextToAJCOptions = true;
                options.addElement(arg);
                ajcOptions.addElement(arg);
            } else if (arg.equals("-source")) {
                addNextAsOption = true;
                addNextToAJCOptions = true;
                addNextAsClasspath = true;
                options.addElement(arg);
                ajcOptions.addElement(arg);
            } else if (arg.equals("-classpath")) {
                addNextAsOption = true;
                addNextToAJCOptions = true;
                addNextAsClasspath = true;
                options.addElement(arg);
                ajcOptions.addElement(arg);
            } else if (arg.equals("-encoding")) {
                addNextAsOption = true;
                addNextToAJCOptions = false;
                options.addElement(arg);
            } else if (arg.equals("-docencoding")) {
                addNextAsOption = true;
                addNextToAJCOptions = false;
                options.addElement(arg);
            } else if (arg.equals("-charset")) {
                addNextAsOption = true;
                addNextToAJCOptions = false;
                options.addElement(arg);
            } else if (arg.equals("-sourcepath")) {
                addNextAsSourcePath = true;
            } else if (arg.equals("-XajdocDebug")) {
                deleteTempFilesOnExit = false;
            } else if (arg.equals("-use")) {
                System.out.println("> Ignoring unsupported option: -use");
            } else if (!arg.equals("-splitindex")) {
                if (arg.startsWith("-") || addNextAsOption) {
                    if (arg.equals("-private")) {
                        docModifier = "private";
                    } else if (arg.equals("-package")) {
                        docModifier = "package";
                    } else if (arg.equals("-protected")) {
                        docModifier = "protected";
                    } else if (arg.equals("-public")) {
                        docModifier = "public";
                    } else if (arg.equals("-verbose")) {
                        verboseMode = true;
                    } else if (arg.equals("-author")) {
                        authorStandardDocletSwitch = true;
                    } else if (arg.equals("-version")) {
                        versionStandardDocletSwitch = true;
                    } else if (arg.equals("-v")) {
                        System.out.println(Main.getVersion());
                        Main.exit(0);
                    } else if (arg.equals("-help")) {
                        Main.displayHelpAndExit(null);
                    } else if (arg.equals("-doclet") || arg.equals("-docletpath")) {
                        System.out.println("The doclet and docletpath options are not currently supported    \nsince ajdoc makes assumptions about the behavior of the standard \ndoclet. If you would find this option useful please email us at: \n                                                                 \n       aspectj-dev@eclipse.org                            \n                                                                 \n");
                        Main.exit(0);
                    } else if (!(arg.equals("-nonavbar") || arg.equals("-noindex") || addNextAsOption)) {
                        System.err.println("> unrecognized argument: " + arg);
                        Main.displayHelpAndExit(null);
                    }
                    options.addElement(arg);
                    addNextAsOption = false;
                } else {
                    String entryName = arg.substring(arg.lastIndexOf(File.separator) + 1);
                    if (FileUtil.hasSourceSuffix(arg) || arg.endsWith(".lst") && arg != null) {
                        File f = new File(arg);
                        if (f.isAbsolute()) {
                            filenames.addElement(arg);
                        } else {
                            filenames.addElement(currentWorkingDir + "/" + arg);
                        }
                        fileList.addElement(arg);
                    } else if (!ignoreArg) {
                        packageMode = true;
                        packageList.addElement(arg);
                        arg = arg.replace('.', '/');
                        int c = 0;
                        while (c < sourcepath.size()) {
                            String path = (String)sourcepath.elementAt(c) + "/" + arg;
                            File pkg = new File(path);
                            if (pkg.isDirectory()) {
                                String[] files = pkg.list(new FilenameFilter(){

                                    public boolean accept(File dir, String name) {
                                        int index1 = name.lastIndexOf(".");
                                        int index2 = name.length();
                                        return index1 >= 0 && index2 >= 0 && (name.substring(index1, index2).equals(".java") || name.substring(index1, index2).equals(".aj"));
                                    }
                                });
                                int j = 0;
                                while (j < files.length) {
                                    filenames.addElement((String)sourcepath.elementAt(c) + "/" + arg + "/" + files[j]);
                                    ++j;
                                }
                            } else if (c == sourcepath.size()) {
                                System.out.println("ajdoc: No package, class, or source file found named " + arg + ".");
                            }
                            ++c;
                        }
                    }
                }
            }
            ++i;
        }
        if (!(options.contains("-private") || options.contains("-package") || options.contains("-protected") || options.contains("-public"))) {
            options.addElement("-package");
        }
    }

    static void expandAtSignFile(String filename, File currentWorkingDir) {
        LinkedList<String> result = new LinkedList<String>();
        File atFile = Main.qualifiedFile(filename, currentWorkingDir);
        String atFileParent = atFile.getParent();
        File myWorkingDir = null;
        if (atFileParent != null) {
            myWorkingDir = new File(atFileParent);
        }
        try {
            BufferedReader stream = new BufferedReader(new FileReader(atFile));
            String line = null;
            while ((line = stream.readLine()) != null) {
                int commentStart = line.indexOf("//");
                if (commentStart != -1) {
                    line = line.substring(0, commentStart);
                }
                if ((line = line.trim()).length() == 0) continue;
                result.add(line);
            }
        }
        catch (IOException e) {
            System.err.println("Error while reading the @ file " + atFile.getPath() + ".\n" + e);
            System.exit(-1);
        }
        Main.parseArgs(result, myWorkingDir);
    }

    static File qualifiedFile(String name, File currentWorkingDir) {
        File file = new File(name = name.replace('/', File.separatorChar));
        if (!file.isAbsolute() && currentWorkingDir != null) {
            file = new File(currentWorkingDir, name);
        }
        return file;
    }

    static void displayHelpAndExit(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println();
        System.err.println("Usage: ajdoc <options> <source files>\n\nwhere <options> includes:\n  -public                   Show only public classes and members\n  -protected                Show protected/public classes and members\n  -package                  Show package/protected/public classes and members\n  -private                  Show all classes and members\n  -help                     Display command line options\n  -sourcepath <pathlist>    Specify where to find source files\n  -classpath <pathlist>     Specify where to find user class files\n  -bootclasspath <pathlist> Override location of class files loaded\n  -d <directory>            Destination directory for output files\n  -argfile <file>           Build config file (wildcards not supported\n  -verbose                  Output messages about what Javadoc is doing\n  -v                        Print out the version of ajdoc\nIf an argument is of the form @<filename>, the file will be interpreted as\na line delimited set of arguments to insert into the argument list.");
        Main.exit(0);
    }

    protected static void exit(int value) {
        System.out.flush();
        System.err.flush();
        System.exit(value);
    }

    public static void handleInternalError(Throwable uncaughtThrowable) {
        System.err.println("An internal error occured in ajdoc");
        System.err.println(internalErrorMessage);
        System.err.println(uncaughtThrowable.toString());
        uncaughtThrowable.printStackTrace();
        System.err.println();
    }

    static String getVersion() {
        return "ajdoc version 1.2.1";
    }

    public static boolean hasAborted() {
        return aborted;
    }

    static {
        docModifier = "package";
        verboseMode = false;
        packageMode = false;
        authorStandardDocletSwitch = false;
        versionStandardDocletSwitch = false;
        rootDir = null;
        declIDTable = new Hashtable();
        docDir = ".";
        deleteTempFilesOnExit = true;
        aborted = false;
    }
}

