/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.util;

import org.aspectj.org.eclipse.jdt.core.util.ClassFormatException;
import org.aspectj.org.eclipse.jdt.core.util.IAttributeNamesConstants;
import org.aspectj.org.eclipse.jdt.core.util.IConstantPool;
import org.aspectj.org.eclipse.jdt.core.util.ILineNumberAttribute;
import org.aspectj.org.eclipse.jdt.internal.core.util.ClassFileAttribute;

public class LineNumberAttribute
extends ClassFileAttribute
implements ILineNumberAttribute {
    private static final int[][] NO_ENTRIES = new int[0][0];
    private int lineNumberTableLength;
    private int[][] lineNumberTable;

    public LineNumberAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        this.lineNumberTableLength = this.u2At(classFileBytes, 6, offset);
        this.lineNumberTable = NO_ENTRIES;
        if (this.lineNumberTableLength != 0) {
            this.lineNumberTable = new int[this.lineNumberTableLength][2];
        }
        int readOffset = 8;
        int i = 0;
        int max = this.lineNumberTableLength;
        while (i < max) {
            this.lineNumberTable[i][0] = this.u2At(classFileBytes, readOffset, offset);
            this.lineNumberTable[i][1] = this.u2At(classFileBytes, readOffset + 2, offset);
            readOffset += 4;
            ++i;
        }
    }

    public char[] getAttributeName() {
        return IAttributeNamesConstants.LINE_NUMBER;
    }

    public int[][] getLineNumberTable() {
        return this.lineNumberTable;
    }

    public int getLineNumberTableLength() {
        return this.lineNumberTableLength;
    }
}

