/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.util;

import org.aspectj.org.eclipse.jdt.core.util.IConstantPool;
import org.aspectj.org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.aspectj.org.eclipse.jdt.internal.core.util.ClassFileStruct;
import org.aspectj.org.eclipse.jdt.internal.core.util.ConstantPoolEntry;

public class ConstantPool
extends ClassFileStruct
implements IConstantPool {
    private int constantPoolCount;
    private int[] constantPoolOffset;
    private byte[] classFileBytes;
    private ConstantPoolEntry constantPoolEntry;

    ConstantPool(byte[] reference, int[] constantPoolOffset) {
        this.constantPoolCount = constantPoolOffset.length;
        this.constantPoolOffset = constantPoolOffset;
        this.classFileBytes = reference;
        this.constantPoolEntry = new ConstantPoolEntry();
    }

    public IConstantPoolEntry decodeEntry(int index) {
        this.constantPoolEntry.reset();
        int kind = this.getEntryKind(index);
        this.constantPoolEntry.setKind(kind);
        switch (kind) {
            case 7: {
                this.constantPoolEntry.setClassInfoNameIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                this.constantPoolEntry.setClassInfoName(this.getUtf8ValueAt(this.constantPoolEntry.getClassInfoNameIndex()));
                break;
            }
            case 6: {
                this.constantPoolEntry.setDoubleValue(this.doubleAt(this.classFileBytes, 1, this.constantPoolOffset[index]));
                break;
            }
            case 9: {
                this.constantPoolEntry.setClassIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                int declaringClassIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[this.constantPoolEntry.getClassIndex()]);
                this.constantPoolEntry.setClassName(this.getUtf8ValueAt(declaringClassIndex));
                this.constantPoolEntry.setNameAndTypeIndex(this.u2At(this.classFileBytes, 3, this.constantPoolOffset[index]));
                int fieldNameIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[this.constantPoolEntry.getNameAndTypeIndex()]);
                int fieldDescriptorIndex = this.u2At(this.classFileBytes, 3, this.constantPoolOffset[this.constantPoolEntry.getNameAndTypeIndex()]);
                this.constantPoolEntry.setFieldName(this.getUtf8ValueAt(fieldNameIndex));
                this.constantPoolEntry.setFieldDescriptor(this.getUtf8ValueAt(fieldDescriptorIndex));
                break;
            }
            case 10: 
            case 11: {
                this.constantPoolEntry.setClassIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                int declaringClassIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[this.constantPoolEntry.getClassIndex()]);
                this.constantPoolEntry.setClassName(this.getUtf8ValueAt(declaringClassIndex));
                this.constantPoolEntry.setNameAndTypeIndex(this.u2At(this.classFileBytes, 3, this.constantPoolOffset[index]));
                int methodNameIndex = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[this.constantPoolEntry.getNameAndTypeIndex()]);
                int methodDescriptorIndex = this.u2At(this.classFileBytes, 3, this.constantPoolOffset[this.constantPoolEntry.getNameAndTypeIndex()]);
                this.constantPoolEntry.setMethodName(this.getUtf8ValueAt(methodNameIndex));
                this.constantPoolEntry.setMethodDescriptor(this.getUtf8ValueAt(methodDescriptorIndex));
                break;
            }
            case 4: {
                this.constantPoolEntry.setFloatValue(this.floatAt(this.classFileBytes, 1, this.constantPoolOffset[index]));
                break;
            }
            case 3: {
                this.constantPoolEntry.setIntegerValue(this.i4At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                break;
            }
            case 5: {
                this.constantPoolEntry.setLongValue(this.i8At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                break;
            }
            case 12: {
                this.constantPoolEntry.setNameAndTypeNameIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                this.constantPoolEntry.setNameAndTypeDescriptorIndex(this.u2At(this.classFileBytes, 3, this.constantPoolOffset[index]));
                break;
            }
            case 8: {
                this.constantPoolEntry.setStringIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                this.constantPoolEntry.setStringValue(this.getUtf8ValueAt(this.constantPoolEntry.getStringIndex()));
                break;
            }
            case 1: {
                this.constantPoolEntry.setUtf8Length(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[index]));
                this.constantPoolEntry.setUtf8Value(this.getUtf8ValueAt(index));
            }
        }
        return this.constantPoolEntry;
    }

    public int getConstantPoolCount() {
        return this.constantPoolCount;
    }

    public int getEntryKind(int index) {
        return this.u1At(this.classFileBytes, 0, this.constantPoolOffset[index]);
    }

    private char[] getUtf8ValueAt(int utf8Index) {
        int utf8Offset = this.constantPoolOffset[utf8Index];
        return this.utf8At(this.classFileBytes, 0, utf8Offset + 3, this.u2At(this.classFileBytes, 0, utf8Offset + 1));
    }
}

