/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.IImportDeclaration;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceField;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceImport;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceMethod;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.aspectj.org.eclipse.jdt.internal.core.ImportDeclaration;
import org.aspectj.org.eclipse.jdt.internal.core.ImportDeclarationElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.Initializer;
import org.aspectj.org.eclipse.jdt.internal.core.InitializerElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.MemberElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.SourceField;
import org.aspectj.org.eclipse.jdt.internal.core.SourceMethod;
import org.aspectj.org.eclipse.jdt.internal.core.SourceType;

public class SourceTypeElementInfo
extends MemberElementInfo
implements ISourceType {
    protected static final ISourceImport[] NO_IMPORTS = new ISourceImport[0];
    protected static final InitializerElementInfo[] NO_INITIALIZERS = new InitializerElementInfo[0];
    protected static final ISourceField[] NO_FIELDS = new ISourceField[0];
    protected static final ISourceMethod[] NO_METHODS = new ISourceMethod[0];
    protected static final ISourceType[] NO_TYPES = new ISourceType[0];
    protected char[] superclassName;
    protected char[][] superInterfaceNames;
    protected char[] sourceFileName;
    protected char[] packageName;
    private ISourceImport[] imports;
    protected IType handle = null;

    public ISourceType getEnclosingType() {
        IJavaElement parent = this.handle.getParent();
        if (parent != null && parent.getElementType() == 7) {
            try {
                return (ISourceType)((JavaElement)parent).getElementInfo();
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        return null;
    }

    public ISourceField[] getFields() {
        int length = this.children.length;
        if (length == 0) {
            return NO_FIELDS;
        }
        ISourceField[] fields = new ISourceField[length];
        int fieldIndex = 0;
        int i = 0;
        while (i < length) {
            IJavaElement child = this.children[i];
            if (child instanceof SourceField) {
                try {
                    ISourceField field = (ISourceField)((SourceField)child).getElementInfo();
                    fields[fieldIndex++] = field;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (fieldIndex == 0) {
            return NO_FIELDS;
        }
        ISourceField[] iSourceFieldArray = fields;
        fields = new ISourceField[fieldIndex];
        System.arraycopy(iSourceFieldArray, 0, fields, 0, fieldIndex);
        return fields;
    }

    public char[] getFileName() {
        return this.sourceFileName;
    }

    public IType getHandle() {
        return this.handle;
    }

    public ISourceImport[] getImports() {
        if (this.imports == null) {
            try {
                IImportDeclaration[] importDeclarations = this.handle.getCompilationUnit().getImports();
                int length = importDeclarations.length;
                if (length == 0) {
                    this.imports = NO_IMPORTS;
                } else {
                    ISourceImport[] sourceImports = new ISourceImport[length];
                    int i = 0;
                    while (i < length) {
                        sourceImports[i] = (ImportDeclarationElementInfo)((ImportDeclaration)importDeclarations[i]).getElementInfo();
                        ++i;
                    }
                    this.imports = sourceImports;
                }
            }
            catch (JavaModelException e) {
                this.imports = NO_IMPORTS;
            }
        }
        return this.imports;
    }

    public InitializerElementInfo[] getInitializers() {
        int length = this.children.length;
        if (length == 0) {
            return NO_INITIALIZERS;
        }
        InitializerElementInfo[] initializers = new InitializerElementInfo[length];
        int initializerIndex = 0;
        int i = 0;
        while (i < length) {
            IJavaElement child = this.children[i];
            if (child instanceof Initializer) {
                try {
                    InitializerElementInfo initializer = (InitializerElementInfo)((Initializer)child).getElementInfo();
                    initializers[initializerIndex++] = initializer;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (initializerIndex == 0) {
            return NO_INITIALIZERS;
        }
        InitializerElementInfo[] initializerElementInfoArray = initializers;
        initializers = new InitializerElementInfo[initializerIndex];
        System.arraycopy(initializerElementInfoArray, 0, initializers, 0, initializerIndex);
        return initializers;
    }

    public char[][] getInterfaceNames() {
        if (this.handle.getElementName().length() == 0) {
            return null;
        }
        return this.superInterfaceNames;
    }

    public ISourceType[] getMemberTypes() {
        int length = this.children.length;
        if (length == 0) {
            return NO_TYPES;
        }
        ISourceType[] memberTypes = new ISourceType[length];
        int typeIndex = 0;
        int i = 0;
        while (i < length) {
            IJavaElement child = this.children[i];
            if (child instanceof SourceType) {
                try {
                    ISourceType type = (ISourceType)((SourceType)child).getElementInfo();
                    memberTypes[typeIndex++] = type;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (typeIndex == 0) {
            return NO_TYPES;
        }
        ISourceType[] iSourceTypeArray = memberTypes;
        memberTypes = new ISourceType[typeIndex];
        System.arraycopy(iSourceTypeArray, 0, memberTypes, 0, typeIndex);
        return memberTypes;
    }

    public ISourceMethod[] getMethods() {
        int length = this.children.length;
        if (length == 0) {
            return NO_METHODS;
        }
        ISourceMethod[] methods = new ISourceMethod[length];
        int methodIndex = 0;
        int i = 0;
        while (i < length) {
            IJavaElement child = this.children[i];
            if (child instanceof SourceMethod) {
                try {
                    ISourceMethod method = (ISourceMethod)((SourceMethod)child).getElementInfo();
                    methods[methodIndex++] = method;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (methodIndex == 0) {
            return NO_METHODS;
        }
        ISourceMethod[] iSourceMethodArray = methods;
        methods = new ISourceMethod[methodIndex];
        System.arraycopy(iSourceMethodArray, 0, methods, 0, methodIndex);
        return methods;
    }

    public char[] getPackageName() {
        return this.packageName;
    }

    public char[] getSuperclassName() {
        char[][] interfaceNames;
        if (this.handle.getElementName().length() == 0 && (interfaceNames = this.superInterfaceNames) != null && interfaceNames.length > 0) {
            return interfaceNames[0];
        }
        return this.superclassName;
    }

    public boolean isBinaryType() {
        return false;
    }

    public boolean isClass() {
        return (this.flags & 0x200) == 0;
    }

    public boolean isInterface() {
        return (this.flags & 0x200) != 0;
    }

    protected void setHandle(IType handle) {
        this.handle = handle;
    }

    protected void setPackageName(char[] name) {
        this.packageName = name;
    }

    protected void setSourceFileName(char[] name) {
        this.sourceFileName = name;
    }

    protected void setSuperclassName(char[] superclassName) {
        this.superclassName = superclassName;
    }

    protected void setSuperInterfaceNames(char[][] superInterfaceNames) {
        this.superInterfaceNames = superInterfaceNames;
    }

    public String toString() {
        return "Info for " + this.handle.toString();
    }
}

