/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.Flags;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IMethod;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.jdom.IDOMMethod;
import org.aspectj.org.eclipse.jdt.core.jdom.IDOMNode;
import org.aspectj.org.eclipse.jdt.internal.core.Assert;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationUnitStructureRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.Member;
import org.aspectj.org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;

class SourceMethod
extends Member
implements IMethod {
    protected String[] fParameterTypes;
    protected static final String[] fgEmptyList = new String[0];

    protected SourceMethod(JavaElement parent, String name, String[] parameterTypes) {
        super(parent, name);
        Assert.isTrue(name.indexOf(46) == -1);
        this.fParameterTypes = parameterTypes == null ? fgEmptyList : parameterTypes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SourceMethod)) {
            return false;
        }
        return super.equals(o) && Util.equalArraysOrNull(this.fParameterTypes, ((SourceMethod)o).fParameterTypes);
    }

    protected boolean equalsDOMNode(IDOMNode node) {
        if (node.getNodeType() == 6) {
            try {
                IDOMMethod m = (IDOMMethod)node;
                if (this.isConstructor()) {
                    return (m.isConstructor() || m.getName().equals(this.getElementName())) && this.signatureEquals(m);
                }
                return super.equalsDOMNode(node) && this.signatureEquals(m);
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return false;
    }

    public int getElementType() {
        return 9;
    }

    public String[] getExceptionTypes() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        char[][] exs = info.getExceptionTypeNames();
        return CompilationUnitStructureRequestor.convertTypeNamesToSigs(exs);
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        char delimiter = this.getHandleMementoDelimiter();
        buff.append(delimiter);
        this.escapeMementoName(buff, this.getElementName());
        int i = 0;
        while (i < this.fParameterTypes.length) {
            buff.append(delimiter);
            buff.append(this.fParameterTypes[i]);
            ++i;
        }
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
        return buff.toString();
    }

    protected char getHandleMementoDelimiter() {
        return '~';
    }

    public int getNumberOfParameters() {
        return this.fParameterTypes == null ? 0 : this.fParameterTypes.length;
    }

    public String[] getParameterNames() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        char[][] names = info.getArgumentNames();
        if (names == null || names.length == 0) {
            return fgEmptyList;
        }
        String[] strings = new String[names.length];
        int i = 0;
        while (i < names.length) {
            strings[i] = new String(names[i]);
            ++i;
        }
        return strings;
    }

    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        return new String[0];
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && (cu = (CompilationUnit)this.getAncestor(5)).isPrimary()) {
            return this;
        }
        IJavaElement primaryParent = this.parent.getPrimaryElement(false);
        return ((IType)primaryParent).getMethod(this.name, this.fParameterTypes);
    }

    public String getReturnType() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return Signature.createTypeSignature(info.getReturnTypeName(), false);
    }

    public String getSignature() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return info.getSignature();
    }

    public int hashCode() {
        int hash = super.hashCode();
        int i = 0;
        int length = this.fParameterTypes.length;
        while (i < length) {
            hash = Util.combineHashCodes(hash, this.fParameterTypes[i].hashCode());
            ++i;
        }
        return hash;
    }

    public boolean isConstructor() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return info.isConstructor();
    }

    public boolean isMainMethod() throws JavaModelException {
        return this.isMainMethod(this);
    }

    public boolean isSimilar(IMethod method) {
        return this.areSimilarMethods(this.getElementName(), this.getParameterTypes(), method.getElementName(), method.getParameterTypes(), null);
    }

    public String readableName() {
        int length;
        StringBuffer buffer = new StringBuffer(super.readableName());
        buffer.append('(');
        String[] parameterTypes = this.getParameterTypes();
        if (parameterTypes != null && (length = parameterTypes.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString(parameterTypes[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected boolean signatureEquals(IDOMMethod method) {
        String[] otherTypes = method.getParameterTypes();
        String[] types = this.getParameterTypes();
        boolean ok = true;
        if (otherTypes == null || otherTypes.length == 0) {
            ok = types == null || types.length == 0;
        } else if (types != null) {
            ok = otherTypes.length == types.length;
        } else {
            return false;
        }
        if (ok && types != null) {
            int i = 0;
            while (i < types.length) {
                String otherType = Signature.createTypeSignature(otherTypes[i].toCharArray(), false);
                if (!types[i].equals(otherType)) {
                    ok = false;
                    break;
                }
                ++i;
            }
        }
        return ok;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                if (Flags.isStatic(this.getFlags())) {
                    buffer.append("static ");
                }
                if (!this.isConstructor()) {
                    buffer.append(Signature.toString(this.getReturnType()));
                    buffer.append(' ');
                }
                this.toStringName(buffer);
            }
            catch (JavaModelException e) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }

    protected void toStringName(StringBuffer buffer) {
        int length;
        buffer.append(this.getElementName());
        buffer.append('(');
        String[] parameters = this.getParameterTypes();
        if (parameters != null && (length = parameters.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString(parameters[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(')');
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }
}

