/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.aspectj.org.eclipse.jdt.core.IClasspathContainer;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaModelStatus;
import org.aspectj.org.eclipse.jdt.core.IJavaModelStatusConstants;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IPackageFragment;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JavaModelStatus
extends Status
implements IJavaModelStatus,
IJavaModelStatusConstants,
IResourceStatus {
    protected IJavaElement[] elements = new IJavaElement[0];
    protected IPath path;
    protected String string;
    protected static final IStatus[] NO_CHILDREN = new IStatus[0];
    protected IStatus[] children = NO_CHILDREN;
    public static final IJavaModelStatus VERIFIED_OK = new JavaModelStatus(0, 0, Util.bind("status.OK"));

    public JavaModelStatus() {
        super(4, "org.eclipse.ajdt.core.plugin", 0, "JavaModelStatus", null);
    }

    public JavaModelStatus(int code) {
        super(4, "org.eclipse.ajdt.core.plugin", code, "JavaModelStatus", null);
        this.elements = JavaElement.NO_ELEMENTS;
    }

    public JavaModelStatus(int code, IJavaElement[] elements) {
        super(4, "org.eclipse.ajdt.core.plugin", code, "JavaModelStatus", null);
        this.elements = elements;
        this.path = null;
    }

    public JavaModelStatus(int code, String string) {
        this(4, code, string);
    }

    public JavaModelStatus(int severity, int code, String string) {
        super(severity, "org.eclipse.ajdt.core.plugin", code, "JavaModelStatus", null);
        this.elements = JavaElement.NO_ELEMENTS;
        this.path = null;
        this.string = string;
    }

    public JavaModelStatus(int code, Throwable throwable) {
        super(4, "org.eclipse.ajdt.core.plugin", code, "JavaModelStatus", throwable);
        this.elements = JavaElement.NO_ELEMENTS;
    }

    public JavaModelStatus(int code, IPath path) {
        super(4, "org.eclipse.ajdt.core.plugin", code, "JavaModelStatus", null);
        this.elements = JavaElement.NO_ELEMENTS;
        this.path = path;
    }

    public JavaModelStatus(int code, IJavaElement element) {
        this(code, new IJavaElement[]{element});
    }

    public JavaModelStatus(int code, IJavaElement element, String string) {
        this(code, new IJavaElement[]{element});
        this.string = string;
    }

    public JavaModelStatus(int code, IJavaElement element, IPath path) {
        this(code, new IJavaElement[]{element});
        this.path = path;
    }

    public JavaModelStatus(int code, IJavaElement element, IPath path, String string) {
        this(code, new IJavaElement[]{element});
        this.path = path;
        this.string = string;
    }

    public JavaModelStatus(CoreException coreException) {
        super(4, "org.eclipse.ajdt.core.plugin", 966, "JavaModelStatus", coreException);
        this.elements = JavaElement.NO_ELEMENTS;
    }

    protected int getBits() {
        int severity = 1 << this.getCode() % 100 / 33;
        int category = 1 << this.getCode() / 100 + 3;
        return severity | category;
    }

    public IStatus[] getChildren() {
        return this.children;
    }

    public IJavaElement[] getElements() {
        return this.elements;
    }

    public String getMessage() {
        Throwable exception = this.getException();
        if (exception == null) {
            switch (this.getCode()) {
                case 966: {
                    return Util.bind("status.coreException");
                }
                case 990: {
                    return Util.bind("build.initializationError");
                }
                case 991: {
                    return Util.bind("build.serializationError");
                }
                case 973: {
                    return Util.bind("status.cannotUseDeviceOnPath", this.getPath().toString());
                }
                case 986: {
                    return Util.bind("status.JDOMError");
                }
                case 969: {
                    return Util.bind("element.doesNotExist", ((JavaElement)this.elements[0]).toStringWithAncestors());
                }
                case 992: {
                    return Util.bind("status.evaluationError", this.string);
                }
                case 980: {
                    return Util.bind("status.indexOutOfBounds");
                }
                case 984: {
                    return Util.bind("status.invalidContents");
                }
                case 978: {
                    return Util.bind("status.invalidDestination", ((JavaElement)this.elements[0]).toStringWithAncestors());
                }
                case 967: {
                    StringBuffer buff = new StringBuffer(Util.bind("operation.notSupported"));
                    int i = 0;
                    while (i < this.elements.length) {
                        if (i > 0) {
                            buff.append(", ");
                        }
                        buff.append(((JavaElement)this.elements[i]).toStringWithAncestors());
                        ++i;
                    }
                    return buff.toString();
                }
                case 983: {
                    return Util.bind("status.invalidName", this.string);
                }
                case 998: {
                    return Util.bind("status.invalidPackage", this.string);
                }
                case 979: {
                    if (this.string != null) {
                        return this.string;
                    }
                    return Util.bind("status.invalidPath", this.getPath() == null ? "null" : this.getPath().toString());
                }
                case 997: {
                    return Util.bind("status.invalidProject", this.string);
                }
                case 995: {
                    return Util.bind("status.invalidResource", this.string);
                }
                case 996: {
                    return Util.bind("status.invalidResourceType", this.string);
                }
                case 993: {
                    if (this.string != null) {
                        return Util.bind("status.invalidSibling", this.string);
                    }
                    return Util.bind("status.invalidSibling", ((JavaElement)this.elements[0]).toStringWithAncestors());
                }
                case 985: {
                    return Util.bind("status.IOException");
                }
                case 977: {
                    if (this.elements != null && this.elements.length > 0) {
                        IJavaElement element = this.elements[0];
                        String name = element.getElementName();
                        if (element instanceof IPackageFragment && name.equals("")) {
                            return Util.bind("operation.cannotRenameDefaultPackage");
                        }
                    }
                    if (this.string != null) {
                        return this.string;
                    }
                    return Util.bind("status.nameCollision", "");
                }
                case 968: {
                    return Util.bind("operation.needElements");
                }
                case 982: {
                    return Util.bind("operation.needName");
                }
                case 970: {
                    return Util.bind("operation.needPath");
                }
                case 974: {
                    return Util.bind("operation.needString");
                }
                case 971: {
                    return Util.bind("operation.pathOutsideProject", this.string, ((JavaElement)this.elements[0]).toStringWithAncestors());
                }
                case 976: {
                    IJavaElement element = this.elements[0];
                    String name = element.getElementName();
                    if (element instanceof IPackageFragment && name.equals("")) {
                        return Util.bind("status.defaultPackageReadOnly");
                    }
                    return Util.bind("status.readOnly", name);
                }
                case 972: {
                    return Util.bind("operation.needAbsolutePath", this.getPath().toString());
                }
                case 987: {
                    return Util.bind("status.targetException");
                }
                case 981: {
                    return Util.bind("status.updateConflict");
                }
                case 999: {
                    return Util.bind("status.noLocalContents", this.getPath().toString());
                }
                case 963: {
                    IJavaProject javaProject = (IJavaProject)this.elements[0];
                    ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer(this.path.segment(0));
                    String description = null;
                    if (initializer != null) {
                        description = initializer.getDescription(this.path, javaProject);
                    }
                    if (description == null) {
                        description = this.path.makeRelative().toString();
                    }
                    return Util.bind("classpath.unboundContainerPath", description, javaProject.getElementName());
                }
                case 962: {
                    IJavaProject javaProject = (IJavaProject)this.elements[0];
                    IClasspathContainer container = null;
                    String description = null;
                    try {
                        container = JavaCore.getClasspathContainer(this.path, javaProject);
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                    if (container == null) {
                        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer(this.path.segment(0));
                        if (initializer != null) {
                            description = initializer.getDescription(this.path, javaProject);
                        }
                    } else {
                        description = container.getDescription();
                    }
                    if (description == null) {
                        description = this.path.makeRelative().toString();
                    }
                    return Util.bind("classpath.invalidContainer", description, javaProject.getElementName());
                }
                case 965: {
                    IJavaProject javaProject = (IJavaProject)this.elements[0];
                    return Util.bind("classpath.unboundVariablePath", this.path.makeRelative().toString(), javaProject.getElementName());
                }
                case 1001: {
                    IJavaProject javaProject = (IJavaProject)this.elements[0];
                    return Util.bind("classpath.cycle", javaProject.getElementName());
                }
                case 1002: {
                    IJavaProject javaProject = (IJavaProject)this.elements[0];
                    String projectName = javaProject.getElementName();
                    IPath newPath = this.path;
                    if (this.path.segment(0).toString().equals(projectName)) {
                        newPath = this.path.removeFirstSegments(1);
                    }
                    return Util.bind("classpath.disabledInclusionExclusionPatterns", newPath.makeRelative().toString(), projectName);
                }
                case 1003: {
                    IJavaProject javaProject = (IJavaProject)this.elements[0];
                    String projectName = javaProject.getElementName();
                    IPath newPath = this.path;
                    if (this.path.segment(0).toString().equals(projectName)) {
                        newPath = this.path.removeFirstSegments(1);
                    }
                    return Util.bind("classpath.disabledMultipleOutputLocations", newPath.makeRelative().toString(), projectName);
                }
                case 1004: {
                    IJavaProject javaProject = (IJavaProject)this.elements[0];
                    return Util.bind("classpath.incompatibleLibraryJDKLevel", new String[]{javaProject.getElementName(), javaProject.getOption("org.eclipse.ajdt.core.plugin.compiler.codegen.targetPlatform", true), this.path.makeRelative().toString(), this.string});
                }
            }
            if (this.string != null) {
                return this.string;
            }
            return "";
        }
        String message = exception.getMessage();
        if (message != null) {
            return message;
        }
        return exception.toString();
    }

    public IPath getPath() {
        return this.path;
    }

    public int getSeverity() {
        if (this.children == NO_CHILDREN) {
            return super.getSeverity();
        }
        int severity = -1;
        int i = 0;
        int max = this.children.length;
        while (i < max) {
            int childrenSeverity = this.children[i].getSeverity();
            if (childrenSeverity > severity) {
                severity = childrenSeverity;
            }
            ++i;
        }
        return severity;
    }

    public String getString() {
        return this.string;
    }

    public boolean isDoesNotExist() {
        return this.getCode() == 969;
    }

    public boolean isMultiStatus() {
        return this.children != NO_CHILDREN;
    }

    public boolean isOK() {
        return this.getCode() == 0;
    }

    public boolean matches(int mask) {
        if (!this.isMultiStatus()) {
            return this.matches(this, mask);
        }
        int i = 0;
        int max = this.children.length;
        while (i < max) {
            if (this.matches((JavaModelStatus)this.children[i], mask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matches(JavaModelStatus status, int mask) {
        int severityMask = mask & 7;
        int categoryMask = mask & 0xFFFFFFF8;
        int bits = status.getBits();
        return !(severityMask != 0 && (bits & severityMask) == 0 || categoryMask != 0 && (bits & categoryMask) == 0);
    }

    public static IJavaModelStatus newMultiStatus(IJavaModelStatus[] children) {
        JavaModelStatus jms = new JavaModelStatus();
        jms.children = children;
        return jms;
    }

    public String toString() {
        if (this == VERIFIED_OK) {
            return "JavaModelStatus[OK]";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Java Model Status [");
        buffer.append(this.getMessage());
        buffer.append("]");
        return buffer.toString();
    }
}

