/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.ElementCache;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelInfo;
import org.aspectj.org.eclipse.jdt.internal.core.OverflowingLRUCache;

public class JavaModelCache {
    public static final int PKG_CACHE_SIZE = 500;
    public static final int OPENABLE_CACHE_SIZE = 2000;
    protected JavaModelInfo modelInfo;
    protected Map projectAndRootCache = new HashMap(50);
    protected Map pkgCache = new HashMap(500);
    protected OverflowingLRUCache openableCache = new ElementCache(2000);
    protected Map childrenCache = new HashMap(40000);

    public double openableFillingRatio() {
        return this.openableCache.fillingRatio();
    }

    public int pkgSize() {
        return this.pkgCache.size();
    }

    public Object getInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: 
            case 3: {
                return this.projectAndRootCache.get(element);
            }
            case 4: {
                return this.pkgCache.get(element);
            }
            case 5: 
            case 6: {
                return this.openableCache.get(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected Object peekAtInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: 
            case 3: {
                return this.projectAndRootCache.get(element);
            }
            case 4: {
                return this.pkgCache.get(element);
            }
            case 5: 
            case 6: {
                return this.openableCache.peek(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected void putInfo(IJavaElement element, Object info) {
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = (JavaModelInfo)info;
                break;
            }
            case 2: 
            case 3: {
                this.projectAndRootCache.put(element, info);
                break;
            }
            case 4: {
                this.pkgCache.put(element, info);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.put(element, info);
                break;
            }
            default: {
                this.childrenCache.put(element, info);
            }
        }
    }

    protected void removeInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = null;
                break;
            }
            case 2: 
            case 3: {
                this.projectAndRootCache.remove(element);
                break;
            }
            case 4: {
                this.pkgCache.remove(element);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.remove(element);
                break;
            }
            default: {
                this.childrenCache.remove(element);
            }
        }
    }
}

