/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class SyntheticAccessMethodBinding
extends MethodBinding {
    public FieldBinding targetReadField;
    public FieldBinding targetWriteField;
    public MethodBinding targetMethod;
    public int accessType;
    public static final int FieldReadAccess = 1;
    public static final int FieldWriteAccess = 2;
    public static final int MethodAccess = 3;
    public static final int ConstructorAccess = 4;
    public static final int SuperMethodAccess = 5;
    static final char[] AccessMethodPrefix = new char[]{'a', 'c', 'c', 'e', 's', 's', '$'};
    public int sourceStart = 0;
    public int index;

    public SyntheticAccessMethodBinding(FieldBinding targetField, boolean isReadAccess, ReferenceBinding declaringClass) {
        int i;
        boolean needRename;
        int methodId;
        this.modifiers = 4104;
        SourceTypeBinding declaringSourceType = (SourceTypeBinding)declaringClass;
        SyntheticAccessMethodBinding[] knownAccessMethods = declaringSourceType.syntheticAccessMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        this.selector = CharOperation.concat(AccessMethodPrefix, String.valueOf(methodId).toCharArray());
        if (isReadAccess) {
            this.returnType = targetField.type;
            if (targetField.isStatic()) {
                this.parameters = TypeConstants.NoParameters;
            } else {
                this.parameters = new TypeBinding[1];
                this.parameters[0] = declaringSourceType;
            }
            this.targetReadField = targetField;
            this.accessType = 1;
        } else {
            this.returnType = BaseTypes.VoidBinding;
            if (targetField.isStatic()) {
                this.parameters = new TypeBinding[1];
                this.parameters[0] = targetField.type;
            } else {
                this.parameters = new TypeBinding[2];
                this.parameters[0] = declaringSourceType;
                this.parameters[1] = targetField.type;
            }
            this.targetWriteField = targetField;
            this.accessType = 2;
        }
        this.thrownExceptions = TypeConstants.NoExceptions;
        this.declaringClass = declaringSourceType;
        do {
            block15: {
                needRename = false;
                MethodBinding[] methods = declaringSourceType.methods;
                i = 0;
                int length = methods.length;
                while (i < length) {
                    if (CharOperation.equals(this.selector, methods[i].selector) && this.areParametersEqual(methods[i])) {
                        needRename = true;
                        break block15;
                    }
                    ++i;
                }
                if (knownAccessMethods != null) {
                    i = 0;
                    length = knownAccessMethods.length;
                    while (i < length) {
                        if (knownAccessMethods[i] != null && CharOperation.equals(this.selector, knownAccessMethods[i].selector) && this.areParametersEqual(methods[i])) {
                            needRename = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (!needRename) continue;
            this.setSelector(CharOperation.concat(AccessMethodPrefix, String.valueOf(++methodId).toCharArray()));
        } while (needRename);
        FieldDeclaration[] fieldDecls = declaringSourceType.scope.referenceContext.fields;
        if (fieldDecls != null) {
            i = 0;
            int max = fieldDecls.length;
            while (i < max) {
                if (fieldDecls[i].binding == targetField) {
                    this.sourceStart = fieldDecls[i].sourceStart;
                    return;
                }
                ++i;
            }
        }
        this.sourceStart = declaringSourceType.scope.referenceContext.sourceStart;
    }

    public SyntheticAccessMethodBinding(MethodBinding targetMethod, boolean isSuperAccess, ReferenceBinding receiverType) {
        if (targetMethod.isConstructor()) {
            this.initializeConstructorAccessor(targetMethod);
        } else {
            this.initializeMethodAccessor(targetMethod, isSuperAccess, receiverType);
        }
    }

    public SyntheticAccessMethodBinding(MethodBinding myBinding) {
        super(myBinding, null);
    }

    public void initializeConstructorAccessor(MethodBinding accessedConstructor) {
        int length;
        int i;
        boolean needRename;
        this.targetMethod = accessedConstructor;
        this.modifiers = 4096;
        SourceTypeBinding sourceType = (SourceTypeBinding)accessedConstructor.declaringClass;
        SyntheticAccessMethodBinding[] knownAccessMethods = sourceType.syntheticAccessMethods();
        this.index = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        this.selector = accessedConstructor.selector;
        this.returnType = accessedConstructor.returnType;
        this.accessType = 4;
        this.parameters = new TypeBinding[accessedConstructor.parameters.length + 1];
        System.arraycopy(accessedConstructor.parameters, 0, this.parameters, 0, accessedConstructor.parameters.length);
        this.parameters[accessedConstructor.parameters.length] = accessedConstructor.declaringClass;
        this.thrownExceptions = accessedConstructor.thrownExceptions;
        this.declaringClass = sourceType;
        do {
            block9: {
                needRename = false;
                MethodBinding[] methods = sourceType.methods;
                i = 0;
                length = methods.length;
                while (i < length) {
                    if (CharOperation.equals(this.selector, methods[i].selector) && this.areParametersEqual(methods[i])) {
                        needRename = true;
                        break block9;
                    }
                    ++i;
                }
                if (knownAccessMethods != null) {
                    i = 0;
                    length = knownAccessMethods.length;
                    while (i < length) {
                        if (knownAccessMethods[i] != null && CharOperation.equals(this.selector, knownAccessMethods[i].selector) && this.areParametersEqual(knownAccessMethods[i])) {
                            needRename = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (!needRename) continue;
            int length2 = this.parameters.length;
            this.parameters = new TypeBinding[length2 + 1];
            System.arraycopy(this.parameters, 0, this.parameters, 0, length2);
            this.parameters[length2] = this.declaringClass;
        } while (needRename);
        AbstractMethodDeclaration[] methodDecls = sourceType.scope.referenceContext.methods;
        if (methodDecls != null) {
            i = 0;
            length = methodDecls.length;
            while (i < length) {
                if (methodDecls[i].binding == accessedConstructor) {
                    this.sourceStart = methodDecls[i].sourceStart;
                    return;
                }
                ++i;
            }
        }
    }

    public void initializeMethodAccessor(MethodBinding accessedMethod, boolean isSuperAccess, ReferenceBinding receiverType) {
        int length;
        int i;
        boolean needRename;
        int methodId;
        this.targetMethod = accessedMethod;
        this.modifiers = 4104;
        SourceTypeBinding declaringSourceType = (SourceTypeBinding)receiverType;
        SyntheticAccessMethodBinding[] knownAccessMethods = declaringSourceType.syntheticAccessMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        this.selector = CharOperation.concat(AccessMethodPrefix, String.valueOf(methodId).toCharArray());
        this.returnType = accessedMethod.returnType;
        int n = this.accessType = isSuperAccess ? 5 : 3;
        if (accessedMethod.isStatic()) {
            this.parameters = accessedMethod.parameters;
        } else {
            this.parameters = new TypeBinding[accessedMethod.parameters.length + 1];
            this.parameters[0] = declaringSourceType;
            System.arraycopy(accessedMethod.parameters, 0, this.parameters, 1, accessedMethod.parameters.length);
        }
        this.thrownExceptions = accessedMethod.thrownExceptions;
        this.declaringClass = declaringSourceType;
        do {
            block11: {
                needRename = false;
                MethodBinding[] methods = declaringSourceType.methods;
                i = 0;
                length = methods.length;
                while (i < length) {
                    if (CharOperation.equals(this.selector, methods[i].selector) && this.areParametersEqual(methods[i])) {
                        needRename = true;
                        break block11;
                    }
                    ++i;
                }
                if (knownAccessMethods != null) {
                    i = 0;
                    length = knownAccessMethods.length;
                    while (i < length) {
                        if (knownAccessMethods[i] != null && CharOperation.equals(this.selector, knownAccessMethods[i].selector) && this.areParametersEqual(knownAccessMethods[i])) {
                            needRename = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (!needRename) continue;
            this.setSelector(CharOperation.concat(AccessMethodPrefix, String.valueOf(++methodId).toCharArray()));
        } while (needRename);
        AbstractMethodDeclaration[] methodDecls = declaringSourceType.scope.referenceContext.methods;
        if (methodDecls != null) {
            i = 0;
            length = methodDecls.length;
            while (i < length) {
                if (methodDecls[i].binding == accessedMethod) {
                    this.sourceStart = methodDecls[i].sourceStart;
                    return;
                }
                ++i;
            }
        }
    }

    protected boolean isConstructorRelated() {
        return this.accessType == 4;
    }
}

