/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Reference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Assignment
extends Expression {
    public Expression lhs;
    public Expression expression;

    public Assignment(Expression lhs, Expression expression, int sourceEnd) {
        this.lhs = lhs;
        lhs.bits |= 0x2000;
        this.expression = expression;
        this.sourceStart = lhs.sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return ((Reference)this.lhs).analyseAssignment(currentScope, flowContext, flowInfo, this, false).unconditionalInits();
    }

    void checkAssignmentEffect(BlockScope scope) {
        Binding left = this.getDirectBinding(this.lhs);
        if (left != null && left == this.getDirectBinding(this.expression)) {
            scope.problemReporter().assignmentHasNoEffect(this, left.shortReadableName());
            this.bits |= 0x20000000;
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if ((this.bits & 0x20000000) != 0) {
            if (valueRequired) {
                this.expression.generateCode(currentScope, codeStream, true);
            }
        } else {
            ((Reference)this.lhs).generateAssignment(currentScope, codeStream, this, valueRequired);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    Binding getDirectBinding(Expression someExpression) {
        if (someExpression instanceof SingleNameReference) {
            return ((SingleNameReference)someExpression).binding;
        }
        if (someExpression instanceof FieldReference) {
            FieldReference fieldRef = (FieldReference)someExpression;
            if (fieldRef.receiver.isThis() && !(fieldRef.receiver instanceof QualifiedThisReference)) {
                return fieldRef.binding;
            }
        }
        return null;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        ASTNode.printIndent(indent, output);
        return this.printExpressionNoParenthesis(indent, output);
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('(');
        return this.printExpressionNoParenthesis(0, output).append(')');
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.lhs.printExpression(indent, output).append(" = ");
        return this.expression.printExpression(0, output);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        return this.print(indent, output).append(';');
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = ASTNode.NotAConstant;
        if (!(this.lhs instanceof Reference) || this.lhs.isThis()) {
            scope.problemReporter().expressionShouldBeAVariable(this.lhs);
            return null;
        }
        this.resolvedType = this.lhs.resolveType(scope);
        TypeBinding rhsType = this.expression.resolveType(scope);
        if (this.resolvedType == null || rhsType == null) {
            return null;
        }
        this.checkAssignmentEffect(scope);
        if (this.expression.isConstantValueOfTypeAssignableToType(rhsType, this.resolvedType) || this.resolvedType.isBaseType() && BaseTypeBinding.isWidening(this.resolvedType.id, rhsType.id) || rhsType.isCompatibleWith(this.resolvedType)) {
            this.expression.implicitWidening(this.resolvedType, rhsType);
            return this.resolvedType;
        }
        scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this.expression, rhsType, this.resolvedType);
        return this.resolvedType;
    }

    public TypeBinding resolveTypeExpecting(BlockScope scope, TypeBinding expectedType) {
        TypeBinding type = super.resolveTypeExpecting(scope, expectedType);
        if (expectedType == BaseTypes.BooleanBinding && this.lhs.resolvedType == BaseTypes.BooleanBinding && (this.lhs.bits & 0x2000) != 0) {
            scope.problemReporter().possibleAccidentalBooleanAssignment(this);
        }
        return type;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.lhs.traverse(visitor, scope);
            this.expression.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

