/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.TypeX;

public class InterTypeMethodBinding
extends MethodBinding {
    private ReferenceBinding targetType;
    private MethodBinding syntheticMethod;
    public MethodBinding postDispatchMethod;
    public AbstractMethodDeclaration sourceMethod;

    public InterTypeMethodBinding(EclipseFactory world, ResolvedMember signature, TypeX withinType, AbstractMethodDeclaration sourceMethod) {
        super(world.makeMethodBinding(signature), null);
        this.sourceMethod = sourceMethod;
        this.targetType = (ReferenceBinding)world.makeTypeBinding(signature.getDeclaringType());
        this.declaringClass = (ReferenceBinding)world.makeTypeBinding(withinType);
        if (signature.getKind() == Member.METHOD) {
            this.syntheticMethod = world.makeMethodBinding(AjcMemberMaker.interMethodDispatcher(signature, withinType));
            this.postDispatchMethod = world.makeMethodBinding(AjcMemberMaker.interMethodBody(signature, withinType));
        } else {
            this.postDispatchMethod = this.syntheticMethod = world.makeMethodBinding(AjcMemberMaker.interConstructor(world.getWorld().resolve(signature.getDeclaringType()), signature, withinType));
        }
    }

    public boolean canBeSeenBy(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        scope.compilationUnitScope().recordTypeReference(this.declaringClass);
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.invocationType();
        if (invocationType == this.declaringClass) {
            return true;
        }
        if (this.isProtected()) {
            throw new RuntimeException("unimplemented");
        }
        if (this.isPrivate()) {
            if (invocationType != this.declaringClass) {
                ReferenceBinding outerInvocationType = invocationType;
                ReferenceBinding temp = outerInvocationType.enclosingType();
                while (temp != null) {
                    outerInvocationType = temp;
                    temp = temp.enclosingType();
                }
                ReferenceBinding outerDeclaringClass = this.declaringClass;
                temp = outerDeclaringClass.enclosingType();
                while (temp != null) {
                    outerDeclaringClass = temp;
                    temp = temp.enclosingType();
                }
                if (outerInvocationType != outerDeclaringClass) {
                    return false;
                }
            }
            return true;
        }
        return invocationType.fPackage == this.declaringClass.fPackage;
    }

    public MethodBinding getAccessMethod(boolean staticReference) {
        if (staticReference) {
            return this.postDispatchMethod;
        }
        return this.syntheticMethod;
    }

    public boolean alwaysNeedsAccessMethod() {
        return true;
    }

    public AbstractMethodDeclaration sourceMethod() {
        return this.sourceMethod;
    }

    public ReferenceBinding getTargetType() {
        return this.targetType;
    }

    public String toString() {
        return "InterTypeMethodBinding(" + super.toString() + ", " + this.getTargetType() + ")";
    }
}

