/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.lookup.AjLookupEnvironment;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseShadow;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceType;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.HelperInterfaceBinding;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.ajdt.internal.core.builder.AsmHierarchyBuilder;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;

public class EclipseFactory {
    public static boolean DEBUG = false;
    private AjBuildManager buildManager;
    private LookupEnvironment lookupEnvironment;
    private boolean xSerializableAspects;
    private World world;
    private AsmHierarchyBuilder asmHierarchyBuilder;
    private Map typexToBinding = new HashMap();
    public Collection finishedTypeMungers = null;

    public static EclipseFactory fromLookupEnvironment(LookupEnvironment env) {
        AjLookupEnvironment aenv = (AjLookupEnvironment)env;
        return aenv.factory;
    }

    public static EclipseFactory fromScopeLookupEnvironment(Scope scope) {
        return EclipseFactory.fromLookupEnvironment(AstUtil.getCompilationUnitScope((Scope)scope).environment);
    }

    public EclipseFactory(LookupEnvironment lookupEnvironment, AjBuildManager buildManager) {
        this.lookupEnvironment = lookupEnvironment;
        this.buildManager = buildManager;
        this.world = buildManager.getWorld();
        this.xSerializableAspects = buildManager.buildConfig.isXserializableAspects();
    }

    public EclipseFactory(LookupEnvironment lookupEnvironment, World world, boolean xSer) {
        this.lookupEnvironment = lookupEnvironment;
        this.world = world;
        this.xSerializableAspects = xSer;
        this.buildManager = null;
    }

    public World getWorld() {
        return this.world;
    }

    public void showMessage(IMessage.Kind kind, String message, ISourceLocation loc1, ISourceLocation loc2) {
        this.getWorld().showMessage(kind, message, loc1, loc2);
    }

    public ResolvedTypeX fromEclipse(ReferenceBinding binding) {
        if (binding == null) {
            return ResolvedTypeX.MISSING;
        }
        ResolvedTypeX ret = this.getWorld().resolve(EclipseFactory.fromBinding(binding));
        return ret;
    }

    public ResolvedTypeX[] fromEclipse(ReferenceBinding[] bindings) {
        if (bindings == null) {
            return ResolvedTypeX.NONE;
        }
        int len = bindings.length;
        ResolvedTypeX[] ret = new ResolvedTypeX[len];
        int i = 0;
        while (i < len) {
            ret[i] = this.fromEclipse(bindings[i]);
            ++i;
        }
        return ret;
    }

    private static String getName(TypeBinding binding) {
        if (binding instanceof ReferenceBinding) {
            return new String(CharOperation.concatWith(((ReferenceBinding)binding).compoundName, '.'));
        }
        String packageName = new String(binding.qualifiedPackageName());
        String className = new String(binding.qualifiedSourceName()).replace('.', '$');
        if (packageName.length() > 0) {
            className = packageName + "." + className;
        }
        return new String(className);
    }

    public static TypeX fromBinding(TypeBinding binding) {
        if (binding instanceof HelperInterfaceBinding) {
            return ((HelperInterfaceBinding)binding).getTypeX();
        }
        if (binding == null || binding.qualifiedSourceName() == null) {
            return ResolvedTypeX.MISSING;
        }
        return TypeX.forName(EclipseFactory.getName(binding));
    }

    public static TypeX[] fromBindings(TypeBinding[] bindings) {
        if (bindings == null) {
            return TypeX.NONE;
        }
        int len = bindings.length;
        TypeX[] ret = new TypeX[len];
        int i = 0;
        while (i < len) {
            ret[i] = EclipseFactory.fromBinding(bindings[i]);
            ++i;
        }
        return ret;
    }

    public static ASTNode astForLocation(IHasPosition location) {
        return new EmptyStatement(location.getStart(), location.getEnd());
    }

    public Collection getDeclareParents() {
        return this.getWorld().getDeclareParents();
    }

    public boolean areTypeMungersFinished() {
        return this.finishedTypeMungers != null;
    }

    public void finishTypeMungers() {
        ArrayList<EclipseTypeMunger> ret = new ArrayList<EclipseTypeMunger>();
        List baseTypeMungers = this.getWorld().getCrosscuttingMembersSet().getTypeMungers();
        Iterator i = baseTypeMungers.iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger munger = (ConcreteTypeMunger)i.next();
            EclipseTypeMunger etm = this.makeEclipseTypeMunger(munger);
            if (etm == null) continue;
            ret.add(etm);
        }
        this.finishedTypeMungers = ret;
    }

    public EclipseTypeMunger makeEclipseTypeMunger(ConcreteTypeMunger concrete) {
        if (concrete.getMunger() != null && EclipseTypeMunger.supportsKind(concrete.getMunger().getKind())) {
            EclipseTypeMunger ret;
            AbstractMethodDeclaration method = null;
            if (concrete instanceof EclipseTypeMunger) {
                method = ((EclipseTypeMunger)concrete).getSourceMethod();
            }
            if ((ret = new EclipseTypeMunger(this, concrete.getMunger(), concrete.getAspectType(), method)).getSourceLocation() == null) {
                ret.setSourceLocation(concrete.getSourceLocation());
            }
            return ret;
        }
        return null;
    }

    public Collection getTypeMungers() {
        return this.finishedTypeMungers;
    }

    public static ResolvedMember makeResolvedMember(MethodBinding binding) {
        return EclipseFactory.makeResolvedMember(binding, (TypeBinding)binding.declaringClass);
    }

    public static ResolvedMember makeResolvedMember(MethodBinding binding, TypeBinding declaringType) {
        ResolvedMember ret = new ResolvedMember(binding.isConstructor() ? Member.CONSTRUCTOR : Member.METHOD, EclipseFactory.fromBinding(declaringType), binding.modifiers, EclipseFactory.fromBinding(binding.returnType), new String(binding.selector), EclipseFactory.fromBindings(binding.parameters), EclipseFactory.fromBindings(binding.thrownExceptions));
        return ret;
    }

    public static ResolvedMember makeResolvedMember(FieldBinding binding) {
        return EclipseFactory.makeResolvedMember(binding, (TypeBinding)binding.declaringClass);
    }

    public static ResolvedMember makeResolvedMember(FieldBinding binding, TypeBinding receiverType) {
        return new ResolvedMember(Member.FIELD, EclipseFactory.fromBinding(receiverType), binding.modifiers, EclipseFactory.fromBinding(binding.type), new String(binding.name), TypeX.NONE);
    }

    public TypeBinding makeTypeBinding(TypeX typeX) {
        TypeBinding ret = (TypeBinding)this.typexToBinding.get(typeX);
        if (ret == null) {
            ret = this.makeTypeBinding1(typeX);
            this.typexToBinding.put(typeX, ret);
        }
        if (ret == null) {
            System.out.println("can't find: " + typeX);
        }
        return ret;
    }

    private TypeBinding makeTypeBinding1(TypeX typeX) {
        if (typeX.isPrimitive()) {
            if (typeX == ResolvedTypeX.BOOLEAN) {
                return BaseTypes.BooleanBinding;
            }
            if (typeX == ResolvedTypeX.BYTE) {
                return BaseTypes.ByteBinding;
            }
            if (typeX == ResolvedTypeX.CHAR) {
                return BaseTypes.CharBinding;
            }
            if (typeX == ResolvedTypeX.DOUBLE) {
                return BaseTypes.DoubleBinding;
            }
            if (typeX == ResolvedTypeX.FLOAT) {
                return BaseTypes.FloatBinding;
            }
            if (typeX == ResolvedTypeX.INT) {
                return BaseTypes.IntBinding;
            }
            if (typeX == ResolvedTypeX.LONG) {
                return BaseTypes.LongBinding;
            }
            if (typeX == ResolvedTypeX.SHORT) {
                return BaseTypes.ShortBinding;
            }
            if (typeX == ResolvedTypeX.VOID) {
                return BaseTypes.VoidBinding;
            }
            throw new RuntimeException("weird primitive type " + typeX);
        }
        if (typeX.isArray()) {
            int dim = 0;
            while (typeX.isArray()) {
                ++dim;
                typeX = typeX.getComponentType();
            }
            return this.lookupEnvironment.createArrayType(this.makeTypeBinding(typeX), dim);
        }
        String n = typeX.getName();
        char[][] name = CharOperation.splitOn('.', n.toCharArray());
        return this.lookupEnvironment.getType(name);
    }

    public TypeBinding[] makeTypeBindings(TypeX[] types) {
        int len = types.length;
        TypeBinding[] ret = new TypeBinding[len];
        int i = 0;
        while (i < len) {
            ret[i] = this.makeTypeBinding(types[i]);
            ++i;
        }
        return ret;
    }

    private ReferenceBinding[] makeReferenceBindings(TypeX[] types) {
        int len = types.length;
        ReferenceBinding[] ret = new ReferenceBinding[len];
        int i = 0;
        while (i < len) {
            ret[i] = (ReferenceBinding)this.makeTypeBinding(types[i]);
            ++i;
        }
        return ret;
    }

    public FieldBinding makeFieldBinding(ResolvedMember member) {
        return new FieldBinding(member.getName().toCharArray(), this.makeTypeBinding(member.getReturnType()), member.getModifiers(), (ReferenceBinding)this.makeTypeBinding(member.getDeclaringType()), Constant.NotAConstant);
    }

    public MethodBinding makeMethodBinding(ResolvedMember member) {
        return new MethodBinding(member.getModifiers(), member.getName().toCharArray(), this.makeTypeBinding(member.getReturnType()), this.makeTypeBindings(member.getParameterTypes()), this.makeReferenceBindings(member.getExceptions()), (ReferenceBinding)this.makeTypeBinding(member.getDeclaringType()));
    }

    public MethodBinding makeMethodBindingForCall(Member member) {
        return new MethodBinding(member.getCallsiteModifiers(), member.getName().toCharArray(), this.makeTypeBinding(member.getReturnType()), this.makeTypeBindings(member.getParameterTypes()), new ReferenceBinding[0], (ReferenceBinding)this.makeTypeBinding(member.getDeclaringType()));
    }

    public void finishedCompilationUnit(CompilationUnitDeclaration unit) {
        if (this.buildManager != null && this.buildManager.doGenerateModel()) {
            AjBuildManager.getAsmHierarchyBuilder().buildStructureForCompilationUnit(unit, this.buildManager.getStructureModel(), this.buildManager.buildConfig);
        }
    }

    public void addTypeBinding(TypeBinding binding) {
        this.typexToBinding.put(EclipseFactory.fromBinding(binding), binding);
    }

    public Shadow makeShadow(ASTNode location, ReferenceContext context) {
        return EclipseShadow.makeShadow(this, location, context);
    }

    public Shadow makeShadow(ReferenceContext context) {
        return EclipseShadow.makeShadow(this, (ASTNode)((Object)context), context);
    }

    public void addSourceTypeBinding(SourceTypeBinding binding) {
        TypeDeclaration decl = binding.scope.referenceContext;
        ResolvedTypeX.Name name = this.getWorld().lookupOrCreateName(TypeX.forName(EclipseFactory.getName(binding)));
        EclipseSourceType t = new EclipseSourceType(name, this, binding, decl);
        name.setDelegate(t);
        if (decl instanceof AspectDeclaration) {
            ((AspectDeclaration)decl).typeX = name;
            ((AspectDeclaration)decl).concreteName = t;
        }
        ReferenceBinding[] memberTypes = binding.memberTypes;
        int i = 0;
        int length = memberTypes.length;
        while (i < length) {
            this.addSourceTypeBinding((SourceTypeBinding)memberTypes[i]);
            ++i;
        }
    }

    public boolean isXSerializableAspects() {
        return this.xSerializableAspects;
    }
}

