/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.BuildConfigEditor;
import org.aspectj.ajde.ui.BuildConfigModel;
import org.aspectj.ajde.ui.BuildConfigNode;
import org.aspectj.ajde.ui.InvalidResourceException;
import org.aspectj.ajde.ui.swing.AjdeUIManager;
import org.aspectj.asm.IProgramElement;

public class TreeViewBuildConfigEditor
extends JPanel
implements BuildConfigEditor {
    private ConfigTreeNode root;
    private BuildConfigModel model = null;
    private static List selectedEntries = new ArrayList();
    private String configFile = null;
    private File sourcePath = null;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JPanel jPanel2 = new JPanel();
    JButton cancel_button = new JButton();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton save_button = new JButton();
    JScrollPane jScrollPane = new JScrollPane();
    JTree buildConfig_tree = new JTree();

    public void openFile(String configFile) throws IOException, InvalidResourceException {
        try {
            if (configFile == null) {
                Ajde.getDefault().getErrorHandler().handleError("No structure is selected for editing.");
                return;
            }
            this.configFile = configFile;
            this.sourcePath = new File(new File(configFile).getParent());
            this.jbInit();
            this.jLabel1.setText(" Build configuration: " + configFile);
            this.model = Ajde.getDefault().getConfigurationManager().buildModel(configFile);
            this.root = this.buildTree(this.model.getRoot());
            this.buildConfig_tree.setModel(new DefaultTreeModel(this.root));
            this.buildConfig_tree.addMouseListener(new ConfigFileMouseAdapter(this.buildConfig_tree));
            this.buildConfig_tree.setCellRenderer(new ConfigTreeCellRenderer());
            int j = 0;
            while (j < this.buildConfig_tree.getRowCount()) {
                this.buildConfig_tree.expandPath(this.buildConfig_tree.getPathForRow(j));
                ++j;
            }
        }
        catch (Exception e) {
            Ajde.getDefault().getErrorHandler().handleError("Could not open file.", e);
        }
    }

    private ConfigTreeNode buildTree(BuildConfigNode node) {
        ConfigTreeNode treeNode = new ConfigTreeNode(node);
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            BuildConfigNode childNode = (BuildConfigNode)it.next();
            treeNode.add(this.buildTree(childNode));
        }
        return treeNode;
    }

    private void saveModel() {
        Ajde.getDefault().getConfigurationManager().writeModel(this.model);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setMaximumSize(new Dimension(80, 30));
        this.jLabel1.setMinimumSize(new Dimension(80, 20));
        this.jLabel1.setPreferredSize(new Dimension(80, 20));
        this.jLabel1.setText("Config File Editor");
        this.cancel_button.setFont(new Font("Dialog", 0, 11));
        this.cancel_button.setMaximumSize(new Dimension(73, 20));
        this.cancel_button.setMinimumSize(new Dimension(73, 20));
        this.cancel_button.setPreferredSize(new Dimension(73, 20));
        this.cancel_button.setText("Cancel");
        this.cancel_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeViewBuildConfigEditor.this.cancel_button_actionPerformed(e);
            }
        });
        this.jPanel1.setLayout(this.borderLayout2);
        this.save_button.setText("Save");
        this.save_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeViewBuildConfigEditor.this.save_button_actionPerformed(e);
            }
        });
        this.save_button.setPreferredSize(new Dimension(73, 20));
        this.save_button.setMinimumSize(new Dimension(73, 20));
        this.save_button.setMaximumSize(new Dimension(73, 20));
        this.save_button.setFont(new Font("Dialog", 0, 11));
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.save_button, null);
        this.jPanel1.add((Component)this.jLabel1, "Center");
        this.add((Component)this.jScrollPane, "Center");
        this.jScrollPane.getViewport().add((Component)this.buildConfig_tree, null);
    }

    void cancel_button_actionPerformed(ActionEvent e) {
    }

    void save_button_actionPerformed(ActionEvent e) {
        this.saveModel();
    }

    static class ConfigTreeCellRenderer
    extends DefaultTreeCellRenderer {
        ConfigTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            BuildConfigNode.Kind kind;
            ConfigTreeNode ctn;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.setBackground(Color.white);
            this.setFont(new Font("Dialog", 0, 11));
            JCheckBox cbox = ((ConfigTreeNode)value).checkBox;
            cbox.setBackground(Color.white);
            if (row != 0) {
                p.add(cbox);
            }
            if ((ctn = (ConfigTreeNode)value).getModelNode().isActive()) {
                cbox.setSelected(true);
            }
            if (!ctn.getModelNode().isValidResource()) {
                ctn.checkBox.setEnabled(false);
            }
            if ((kind = ctn.getModelNode().getBuildConfigNodeKind()).equals(BuildConfigNode.Kind.FILE_ASPECTJ)) {
                this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getStructureSwingIcon(IProgramElement.Kind.FILE_ASPECTJ));
            } else if (kind.equals(BuildConfigNode.Kind.FILE_JAVA)) {
                this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getStructureSwingIcon(IProgramElement.Kind.FILE_JAVA));
            } else if (kind.equals(BuildConfigNode.Kind.FILE_LST)) {
                this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getStructureSwingIcon(IProgramElement.Kind.FILE_LST));
            } else if (kind.equals(BuildConfigNode.Kind.DIRECTORY)) {
                this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getStructureSwingIcon(IProgramElement.Kind.PACKAGE));
            } else {
                this.setIcon((Icon)AjdeUIManager.getDefault().getIconRegistry().getIcon(IProgramElement.Kind.ERROR).getIconResource());
                p.remove(cbox);
            }
            p.add(this);
            return p;
        }
    }

    private class ConfigFileMouseAdapter
    extends MouseAdapter {
        private JTree tree = null;
        final JCheckBox checkBoxProto = new JCheckBox();
        final int width;

        public ConfigFileMouseAdapter(JTree tree) {
            this.width = this.checkBoxProto.getPreferredSize().width;
            this.tree = tree;
        }

        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            TreePath path = this.tree.getClosestPathForLocation(x, y);
            ConfigTreeNode node = (ConfigTreeNode)path.getLastPathComponent();
            if (node.checkBox.isSelected()) {
                node.getModelNode().setActive(false);
                node.checkBox.setSelected(false);
            } else {
                node.getModelNode().setActive(true);
                node.checkBox.setSelected(true);
            }
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
            if (node.getModelNode().getName() != null) {
                if (node.checkBox.isSelected()) {
                    selectedEntries.add(node.getModelNode().getName());
                } else {
                    selectedEntries.remove(node.getModelNode().getName());
                }
            }
            super.mousePressed(e);
        }

        boolean isCheckBox(int x, int x_) {
            int d = x - x_;
            return d < this.width && d > 0;
        }
    }

    private class ConfigTreeNode
    extends DefaultMutableTreeNode {
        public JCheckBox checkBox = null;
        public BuildConfigNode modelNode;

        public ConfigTreeNode(BuildConfigNode modelNode) {
            super(modelNode.getName(), true);
            this.modelNode = modelNode;
            this.checkBox = new JCheckBox();
        }

        public BuildConfigNode getModelNode() {
            return this.modelNode;
        }

        public void setModelNode(BuildConfigNode modelNode) {
            this.modelNode = modelNode;
        }
    }
}

