/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.WorkingCopy;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchSet;

public class MatchingOpenable {
    static final CompilationUnitDeclaration ALREADY_RESOLVED = new CompilationUnitDeclaration(null, null, 0);
    private MatchLocator locator;
    public IResource resource;
    public Openable openable;
    private CompilationUnitDeclaration parsedUnit;
    private char[] source;
    private MatchSet matchSet;

    public MatchingOpenable(MatchLocator locator, IResource resource, Openable openable, CompilationUnitDeclaration parsedUnit, MatchSet matchSet) {
        this.locator = locator;
        this.resource = resource;
        this.openable = openable;
        this.parsedUnit = parsedUnit;
        this.matchSet = matchSet;
    }

    public static IType getTopLevelType(IType binaryType) {
        String typeName = binaryType.getElementName();
        int lastDollar = typeName.lastIndexOf(36);
        int length = typeName.length();
        if (lastDollar != -1 && lastDollar < length - 1 && Character.isDigit(typeName.charAt(lastDollar + 1))) {
            typeName = typeName.substring(0, lastDollar);
            IClassFile classFile = binaryType.getPackageFragment().getClassFile(String.valueOf(typeName) + ".class");
            try {
                binaryType = classFile.getType();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        IType declaringType = binaryType.getDeclaringType();
        while (declaringType != null) {
            binaryType = declaringType;
            declaringType = binaryType.getDeclaringType();
        }
        return binaryType;
    }

    public void buildTypeBindings() {
        if (this.parsedUnit == null) {
            char[] source = this.getSource();
            if (source == null) {
                return;
            }
            this.buildTypeBindings(source);
        } else {
            if (this.parsedUnit.scope != null) {
                return;
            }
            this.locator.lookupEnvironment.buildTypeBindings(this.parsedUnit);
        }
    }

    private void buildTypeBindings(char[] source) {
        char[] qualifiedName = this.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        this.matchSet = new MatchSet(this.locator);
        try {
            this.locator.parser.matchSet = this.matchSet;
            this.parsedUnit = (CompilationUnitDeclaration)this.locator.parsedUnits.get(qualifiedName);
            if (this.parsedUnit == null) {
                this.parsedUnit = this.locator.dietParse(source);
                this.locator.lookupEnvironment.buildTypeBindings(this.parsedUnit);
            }
            this.locator.parsedUnits.put(qualifiedName, ALREADY_RESOLVED);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.locator.parser.matchSet = null;
            throw throwable;
        }
        Object var3_5 = null;
        this.locator.parser.matchSet = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MatchingOpenable)) {
            return false;
        }
        return this.openable.equals(((MatchingOpenable)obj).openable);
    }

    private char[] getQualifiedName() {
        if (this.openable instanceof CompilationUnit) {
            String fileName = this.resource.getFullPath().lastSegment();
            char[] mainTypeName = fileName.substring(0, fileName.length() - 5).toCharArray();
            CompilationUnit cu = (CompilationUnit)this.openable;
            return cu.getType(new String(mainTypeName)).getFullyQualifiedName().toCharArray();
        }
        ClassFile classFile = (ClassFile)this.openable;
        try {
            IType type = MatchingOpenable.getTopLevelType(classFile.getType());
            return type.getFullyQualifiedName().toCharArray();
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public char[] getSource() {
        if (this.source != null) {
            return this.source;
        }
        try {
            if (this.openable instanceof WorkingCopy) {
                IBuffer buffer = this.openable.getBuffer();
                if (buffer == null) {
                    return null;
                }
                this.source = buffer.getCharacters();
            } else if (this.openable instanceof CompilationUnit) {
                this.source = Util.getResourceContentsAsCharArray((IFile)this.resource);
            } else if (this.openable instanceof ClassFile) {
                ClassFile classFile = (ClassFile)this.openable;
                this.source = this.locator.findSource(classFile);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return this.source;
    }

    public int hashCode() {
        return this.openable.hashCode();
    }

    public boolean hasAlreadyDefinedType() {
        if (this.parsedUnit == null) {
            return false;
        }
        CompilationResult result = this.parsedUnit.compilationResult;
        if (result == null) {
            return false;
        }
        int i = 0;
        while (i < result.problemCount) {
            IProblem problem = result.problems[i];
            if (problem.getID() == 16777539) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void locateMatches() throws CoreException {
        char[] source = this.getSource();
        if (source == null) {
            if (this.openable instanceof ClassFile) {
                this.locateMatchesInClassFile();
            }
        } else {
            this.locateMatchesInCompilationUnit(source);
        }
    }

    private void locateMatchesInClassFile() throws CoreException, JavaModelException {
        IField fieldHandle;
        int i;
        IMethod methodHandle;
        Object[] methods;
        ClassFile classFile = (ClassFile)this.openable;
        IBinaryType info = this.locator.getBinaryInfo(classFile, this.resource);
        if (info == null) {
            return;
        }
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (this.locator.pattern.matchesBinary(info, null)) {
            this.locator.reportBinaryMatch(binaryType, info, 0);
        }
        boolean compilationAborted = false;
        if (this.locator.pattern.needsResolve) {
            BinaryTypeBinding binding = null;
            try {
                binding = this.locator.cacheBinaryType(binaryType);
                if (binding != null) {
                    if (this.locator.hierarchyResolver != null && !this.locator.hierarchyResolver.subOrSuperOfFocus(binding)) {
                        return;
                    }
                    methods = binding.methods();
                    int i2 = 0;
                    while (i2 < methods.length) {
                        Object method = methods[i2];
                        int level = this.locator.pattern.matchLevel((Binding)method);
                        switch (level) {
                            case 0: 
                            case 3: {
                                break;
                            }
                            default: {
                                methodHandle = binaryType.getMethod(new String(((MethodBinding)method).isConstructor() ? binding.compoundName[binding.compoundName.length - 1] : ((MethodBinding)method).selector), Signature.getParameterTypes(new String(((MethodBinding)method).signature()).replace('/', '.')));
                                this.locator.reportBinaryMatch(methodHandle, info, level == 2 ? 0 : 1);
                            }
                        }
                        ++i2;
                    }
                    FieldBinding[] fields = binding.fields();
                    i = 0;
                    while (i < fields.length) {
                        FieldBinding field = fields[i];
                        int level = this.locator.pattern.matchLevel(field);
                        switch (level) {
                            case 0: 
                            case 3: {
                                break;
                            }
                            default: {
                                fieldHandle = binaryType.getField(new String(field.name));
                                this.locator.reportBinaryMatch(fieldHandle, info, level == 2 ? 0 : 1);
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (AbortCompilation e) {
                binding = null;
            }
            boolean bl = compilationAborted = binding == null;
            if (!compilationAborted) {
                return;
            }
        }
        int accuracy = compilationAborted ? 1 : 0;
        methods = info.getMethods();
        int length = methods == null ? 0 : methods.length;
        i = 0;
        while (i < length) {
            Object method = methods[i];
            if (this.locator.pattern.matchesBinary(method, info)) {
                methodHandle = binaryType.getMethod(new String(method.isConstructor() ? info.getName() : method.getSelector()), Signature.getParameterTypes(new String(method.getMethodDescriptor()).replace('/', '.')));
                this.locator.reportBinaryMatch(methodHandle, info, accuracy);
            }
            ++i;
        }
        IBinaryField[] fields = info.getFields();
        length = fields == null ? 0 : fields.length;
        int i3 = 0;
        while (i3 < length) {
            IBinaryField field = fields[i3];
            if (this.locator.pattern.matchesBinary(field, info)) {
                fieldHandle = binaryType.getField(new String(field.getName()));
                this.locator.reportBinaryMatch(fieldHandle, info, accuracy);
            }
            ++i3;
        }
    }

    private void locateMatchesInCompilationUnit(char[] source) throws CoreException {
        block11: {
            block10: {
                if (this.parsedUnit == null) {
                    this.locator.parser.matchSet = this.matchSet = new MatchSet(this.locator);
                    char[] qualifiedName = this.getQualifiedName();
                    if (qualifiedName == null || (this.parsedUnit = (CompilationUnitDeclaration)this.locator.parsedUnits.get(qualifiedName)) == null) {
                        this.parsedUnit = this.locator.dietParse(source);
                    }
                }
                if (this.parsedUnit == null || this.parsedUnit == ALREADY_RESOLVED) break block11;
                try {
                    this.locator.parser.matchSet = this.matchSet;
                    this.locator.parser.scanner.setSource(source);
                    this.locator.parser.parseBodies(this.parsedUnit);
                    this.matchSet.cuHasBeenResolved = false;
                    this.matchSet.reportMatching(this.parsedUnit);
                    if (!this.matchSet.needsResolve() || this.parsedUnit.types == null) break block10;
                    if (!this.locator.compilationAborted) {
                        try {
                            if (this.parsedUnit.scope == null) {
                                MatchingOpenable[] openables = this.locator.matchingOpenables.getMatchingOpenables(this.openable.getJavaProject().getPackageFragmentRoots());
                                this.locator.createAndResolveBindings(openables);
                            }
                            if (this.parsedUnit.scope != null) {
                                this.parsedUnit.scope.faultInTypes();
                                this.parsedUnit.resolve();
                            }
                            this.matchSet.cuHasBeenResolved = true;
                            this.matchSet.reportMatching(this.parsedUnit);
                            break block10;
                        }
                        catch (AbortCompilation e) {
                            this.matchSet.cuHasBeenResolved = true;
                            this.matchSet.reportMatching(this.parsedUnit);
                            if (!(e instanceof AbortCompilationUnit)) {
                                throw e;
                            }
                            break block10;
                        }
                    }
                    this.matchSet.cuHasBeenResolved = true;
                    this.matchSet.reportMatching(this.parsedUnit);
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    this.locator.parser.matchSet = null;
                    throw throwable;
                }
            }
            Object var3_6 = null;
            this.locator.parser.matchSet = null;
        }
    }

    public void reset() {
        this.locator.parsedUnits.removeKey(this.getQualifiedName());
        this.parsedUnit = null;
        this.matchSet = null;
    }

    public String toString() {
        return this.openable.toString();
    }
}

