/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import java.util.HashMap;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.HandleFactory;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchNameEnvironment2;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocatorParser;
import org.eclipse.jdt.internal.core.search.matching.MatchSet;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.MatchingOpenable;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.PackageDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.PotentialMatch;
import org.eclipse.jdt.internal.core.search.matching.PotentialMatchSet;
import org.eclipse.jdt.internal.core.search.matching.SearchPattern;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeNamesCollector;

public class MatchLocator2
extends MatchLocator
implements ITypeRequestor {
    public static final int MAX_AT_ONCE = 500;
    public static final PotentialMatch[] NO_POTENTIAL_MATH = new PotentialMatch[0];
    public char[][][] allSuperTypeNames;
    public PotentialMatchSet potentialMatches;
    public int parseThreshold = -1;
    public CompilerOptions options;
    public CompilationUnitDeclaration[] unitsToProcess;
    public PotentialMatch[] matchesToProcess;
    public int totalUnits;
    public PotentialMatch currentPotentialMatch;

    public MatchLocator2(SearchPattern pattern, int detailLevel, IJavaSearchResultCollector collector, IJavaSearchScope scope, IProgressMonitor progressMonitor) {
        super(pattern, detailLevel, collector, scope, progressMonitor);
        this.pattern = pattern;
        this.detailLevel = detailLevel;
        this.collector = collector;
        this.scope = scope;
        this.progressMonitor = progressMonitor;
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding);
    }

    public void accept(ICompilationUnit sourceUnit) {
        block4: {
            CompilationResult unitResult = new CompilationResult(sourceUnit, this.totalUnits, this.totalUnits, this.options.maxProblemsPerUnit);
            try {
                CompilationUnitDeclaration parsedUnit;
                MatchSet originalMatchSet = this.parser.matchSet;
                try {
                    this.parser.matchSet = new MatchingNodeSet(this);
                    parsedUnit = this.totalUnits < this.parseThreshold ? this.parser.parse(sourceUnit, unitResult) : this.parser.dietParse(sourceUnit, unitResult);
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    this.parser.matchSet = originalMatchSet;
                    throw throwable;
                }
                Object var5_8 = null;
                this.parser.matchSet = originalMatchSet;
                this.lookupEnvironment.buildTypeBindings(parsedUnit);
                this.addCompilationUnit(sourceUnit, parsedUnit);
                this.lookupEnvironment.completeTypeBindings(parsedUnit);
            }
            catch (AbortCompilationUnit e) {
                if (unitResult.compilationUnit == sourceUnit) break block4;
                throw e;
            }
        }
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        if (sourceType instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)sourceType;
            IType type = elementInfo.getHandle();
            ICompilationUnit sourceUnit = (ICompilationUnit)((Object)type.getCompilationUnit());
            this.accept(sourceUnit);
        } else {
            CompilationResult result = new CompilationResult(sourceType.getFileName(), 0, 0, 0);
            CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, true, true, false, this.lookupEnvironment.problemReporter, result);
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    protected void addCompilationUnit(ICompilationUnit sourceUnit, CompilationUnitDeclaration parsedUnit) {
        int size = this.unitsToProcess.length;
        if (this.totalUnits == size) {
            int newSize = size == 0 ? 1 : size * 2;
            this.unitsToProcess = new CompilationUnitDeclaration[newSize];
            System.arraycopy(this.unitsToProcess, 0, this.unitsToProcess, 0, this.totalUnits);
            this.matchesToProcess = new PotentialMatch[newSize];
            System.arraycopy(this.matchesToProcess, 0, this.matchesToProcess, 0, this.totalUnits);
        }
        if (sourceUnit instanceof PotentialMatch) {
            this.matchesToProcess[this.totalUnits] = (PotentialMatch)sourceUnit;
        }
        this.unitsToProcess[this.totalUnits] = parsedUnit;
        ++this.totalUnits;
    }

    void addPotentialMatch(IResource resource, Openable openable) {
        PotentialMatch potentialMatch = new PotentialMatch(this, resource, openable);
        this.potentialMatches.add(potentialMatch);
    }

    BinaryTypeBinding cacheBinaryType(IType type) throws JavaModelException {
        char[][] compoundName;
        ReferenceBinding referenceBinding;
        IBinaryType binaryType;
        BinaryTypeBinding binding;
        IType enclosingType = type.getDeclaringType();
        if (enclosingType != null) {
            this.cacheBinaryType(enclosingType);
        }
        if ((binding = this.lookupEnvironment.cacheBinaryType(binaryType = (IBinaryType)((BinaryType)type).getElementInfo())) == null && (referenceBinding = this.lookupEnvironment.getCachedType(compoundName = CharOperation.splitOn('.', type.getFullyQualifiedName().toCharArray()))) != null && referenceBinding instanceof BinaryTypeBinding) {
            binding = (BinaryTypeBinding)referenceBinding;
        }
        return binding;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClassFileReader classFileReader(IType type) {
        IClassFile classFile = type.getClassFile();
        if (((IOpenable)classFile).isOpen()) {
            JavaModelManager manager;
            JavaModelManager javaModelManager = manager = JavaModelManager.getJavaModelManager();
            synchronized (javaModelManager) {
                return (ClassFileReader)manager.getInfo(type);
            }
        }
        IPackageFragment pkg = type.getPackageFragment();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        try {
            ClassFileReader classFileReader;
            IPath zipPath;
            if (!root.isArchive()) return ClassFileReader.read(type.getPath().toOSString());
            IPath iPath = zipPath = root.isExternal() ? root.getPath() : root.getResource().getLocation();
            if (zipPath == null) {
                return null;
            }
            ZipFile zipFile = null;
            try {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [MatchLocator.classFileReader()] Creating ZipFile on " + zipPath);
                }
                zipFile = new ZipFile(zipPath.toOSString());
                char[] pkgPath = pkg.getElementName().toCharArray();
                CharOperation.replace(pkgPath, '.', '/');
                char[] classFileName = classFile.getElementName().toCharArray();
                char[] path = pkgPath.length == 0 ? classFileName : CharOperation.concat(pkgPath, classFileName, '/');
                classFileReader = ClassFileReader.read(zipFile, new String(path));
                Object var10_15 = null;
                if (zipFile == null) return classFileReader;
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                if (zipFile == null) throw throwable;
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                zipFile.close();
                return classFileReader;
            }
            catch (IOException e) {
                // empty catch block
            }
            return classFileReader;
        }
        catch (ClassFormatException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void computeSuperTypeNames() {
        if (this.allSuperTypeNames != null) {
            return;
        }
        IType focusType = this.getFocusType();
        if (focusType == null) {
            return;
        }
        String fullyQualifiedName = focusType.getFullyQualifiedName();
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        char[] qualification = lastDot == -1 ? CharOperation.NO_CHAR : fullyQualifiedName.substring(0, lastDot).toCharArray();
        char[] simpleName = focusType.getElementName().toCharArray();
        SuperTypeNamesCollector superTypeNamesCollector = new SuperTypeNamesCollector(this.pattern, simpleName, qualification, new MatchLocator2(this.pattern, this.detailLevel, this.collector, this.scope, this.progressMonitor), focusType, this.progressMonitor);
        try {
            this.allSuperTypeNames = superTypeNamesCollector.collect();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected void createAndResolveBindings(PotentialMatch[] potentialMatches, int start, int length) {
        int i = start;
        int maxUnits = start + length;
        while (i < maxUnits) {
            Object var9_9;
            if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PotentialMatch potentialMatch = potentialMatches[i];
            try {
                CompilationUnitDeclaration parsedUnit;
                if (potentialMatch != null) {
                    this.parser.matchSet = potentialMatch.matchingNodeSet;
                }
                CompilationResult unitResult = new CompilationResult(potentialMatch, i, maxUnits, this.options.maxProblemsPerUnit);
                if (SearchEngine.VERBOSE) {
                    System.out.println("Parsing " + potentialMatch.openable.toStringWithAncestors());
                }
                if ((parsedUnit = this.totalUnits < this.parseThreshold ? this.parser.parse(potentialMatch, unitResult) : this.parser.dietParse(potentialMatch, unitResult)) != null && !parsedUnit.isEmpty()) {
                    this.lookupEnvironment.buildTypeBindings(parsedUnit);
                }
                this.addCompilationUnit(potentialMatch, parsedUnit);
                if (this.progressMonitor != null) {
                    this.progressMonitor.worked(4);
                }
            }
            catch (Throwable throwable) {
                var9_9 = null;
                this.parser.matchSet = null;
                potentialMatches[i] = null;
                throw throwable;
            }
            var9_9 = null;
            this.parser.matchSet = null;
            potentialMatches[i] = null;
            ++i;
        }
        this.lookupEnvironment.completeTypeBindings();
    }

    public IField createFieldHandle(FieldDeclaration field, IType type) {
        if (type == null) {
            return null;
        }
        return type.getField(new String(field.name));
    }

    protected boolean createHierarchyResolver(PotentialMatch[] potentialMatches) {
        IType focusType = this.getFocusType();
        if (focusType != null) {
            char[][] compoundName = CharOperation.splitOn('.', focusType.getFullyQualifiedName().toCharArray());
            boolean isPotentialMatch = false;
            int i = 0;
            int length = potentialMatches.length;
            while (i < length) {
                if (CharOperation.equals(potentialMatches[i].compoundName, compoundName)) {
                    isPotentialMatch = true;
                    break;
                }
                ++i;
            }
            if (!isPotentialMatch) {
                if (focusType.isBinary()) {
                    try {
                        this.cacheBinaryType(focusType);
                    }
                    catch (JavaModelException e) {
                        return false;
                    }
                } else {
                    this.accept((ICompilationUnit)((Object)focusType.getCompilationUnit()));
                }
            }
            this.hierarchyResolver = new HierarchyResolver(this.lookupEnvironment, null);
            ReferenceBinding focusTypeBinding = this.hierarchyResolver.setFocusType(compoundName);
            if (focusTypeBinding == null || !focusTypeBinding.isValidBinding() || (focusTypeBinding.tagBits & 0x8000) > 0) {
                return false;
            }
        } else {
            this.hierarchyResolver = null;
        }
        return true;
    }

    public IJavaElement createImportHandle(ImportReference importRef) {
        Openable currentOpenable;
        char[] importName = CharOperation.concatWith(importRef.getImportName(), '.');
        if (importRef.onDemand) {
            importName = CharOperation.concat(importName, ".*".toCharArray());
        }
        if ((currentOpenable = this.getCurrentOpenable()) instanceof CompilationUnit) {
            return ((CompilationUnit)currentOpenable).getImport(new String(importName));
        }
        try {
            return ((ClassFile)currentOpenable).getType();
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public IInitializer createInitializerHandle(TypeDeclaration typeDecl, FieldDeclaration initializer, IType type) {
        if (type == null) {
            return null;
        }
        int occurrenceCount = 0;
        FieldDeclaration[] fields = typeDecl.fields;
        int i = 0;
        int length = fields.length;
        while (i < length) {
            FieldDeclaration field = fields[i];
            if (!field.isField()) {
                ++occurrenceCount;
                if (field.equals(initializer)) break;
            }
            ++i;
        }
        return type.getInitializer(occurrenceCount);
    }

    public IMethod createMethodHandle(AbstractMethodDeclaration method, IType type) {
        int length;
        if (type == null) {
            return null;
        }
        Argument[] arguments = method.arguments;
        int n = length = arguments == null ? 0 : arguments.length;
        if (type.isBinary()) {
            ClassFileReader reader = this.classFileReader(type);
            if (reader == null) {
                return null;
            }
            IBinaryMethod[] methods = reader.getMethods();
            if (methods != null) {
                int i = 0;
                int methodsLength = methods.length;
                while (i < methodsLength) {
                    String[] parameterTypes;
                    char[] selector;
                    IBinaryMethod binaryMethod = methods[i];
                    char[] cArray = selector = binaryMethod.isConstructor() ? type.getElementName().toCharArray() : binaryMethod.getSelector();
                    if (CharOperation.equals(selector, method.selector) && length == (parameterTypes = Signature.getParameterTypes(new String(binaryMethod.getMethodDescriptor()))).length) {
                        boolean sameParameters = true;
                        int j = 0;
                        while (j < length) {
                            TypeReference parameterType = arguments[j].type;
                            char[] typeName = CharOperation.concatWith(parameterType.getTypeName(), '.');
                            int k = 0;
                            while (k < parameterType.dimensions()) {
                                typeName = CharOperation.concat(typeName, "[]".toCharArray());
                                ++k;
                            }
                            String parameterTypeName = parameterTypes[j].replace('/', '.');
                            if (!Signature.toString(parameterTypeName).endsWith(new String(typeName))) {
                                sameParameters = false;
                                break;
                            }
                            parameterTypes[j] = parameterTypeName;
                            ++j;
                        }
                        if (sameParameters) {
                            return type.getMethod(new String(selector), parameterTypes);
                        }
                    }
                    ++i;
                }
            }
            return null;
        }
        String[] parameterTypeSignatures = new String[length];
        int i = 0;
        while (i < length) {
            TypeReference parameterType = arguments[i].type;
            char[] typeName = CharOperation.concatWith(parameterType.getTypeName(), '.');
            int j = 0;
            while (j < parameterType.dimensions()) {
                typeName = CharOperation.concat(typeName, "[]".toCharArray());
                ++j;
            }
            parameterTypeSignatures[i] = Signature.createTypeSignature(typeName, false);
            ++i;
        }
        return type.getMethod(new String(method.selector), parameterTypeSignatures);
    }

    public IType createTypeHandle(char[] simpleTypeName) {
        IType type;
        Openable currentOpenable = this.getCurrentOpenable();
        if (currentOpenable instanceof CompilationUnit) {
            CompilationUnit unit = (CompilationUnit)currentOpenable;
            return unit.getType(new String(simpleTypeName));
        }
        try {
            type = ((ClassFile)currentOpenable).getType();
        }
        catch (JavaModelException e) {
            return null;
        }
        return MatchingOpenable.getTopLevelType(type);
    }

    public IType createTypeHandle(IType parent, char[] simpleTypeName) {
        return parent.getType(new String(simpleTypeName));
    }

    protected Openable getCurrentOpenable() {
        return this.currentPotentialMatch.openable;
    }

    protected IResource getCurrentResource() {
        return this.currentPotentialMatch.resource;
    }

    protected IType getFocusType() {
        return this.scope instanceof HierarchyScope ? ((HierarchyScope)this.scope).focusType : null;
    }

    public IBinaryType getBinaryInfo(ClassFile classFile, IResource resource) throws CoreException {
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (classFile.isOpen()) {
            return (IBinaryType)binaryType.getElementInfo();
        }
        try {
            ClassFileReader info;
            IJavaElement pkg = classFile.getParent();
            PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
            if (root.isArchive()) {
                String pkgPath = pkg.getElementName().replace('.', '/');
                String classFilePath = pkgPath.length() > 0 ? String.valueOf(pkgPath) + "/" + classFile.getElementName() : classFile.getElementName();
                ZipFile zipFile = null;
                try {
                    zipFile = ((JarPackageFragmentRoot)root).getJar();
                    info = ClassFileReader.read(zipFile, classFilePath);
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                    throw throwable;
                }
                Object var10_15 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
            } else {
                String osPath = resource.getFullPath().toOSString();
                info = ClassFileReader.read(osPath);
            }
            return info;
        }
        catch (ClassFormatException e) {
            return null;
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
    }

    protected void getMethodBodies(CompilationUnitDeclaration unit, int place) {
        if (unit.ignoreMethodBodies) {
            unit.ignoreFurtherInvestigation = true;
            return;
        }
        if (place < this.parseThreshold) {
            return;
        }
        this.parser.scanner.setSource(unit.compilationResult.compilationUnit.getContents());
        this.parser.parseBodies(unit);
    }

    public void initialize(JavaProject project) throws JavaModelException {
        this.initialize(project, NO_POTENTIAL_MATH);
    }

    public void initialize(JavaProject project, PotentialMatch[] potentialMatches) throws JavaModelException {
        if (this.nameEnvironment != null) {
            this.nameEnvironment.cleanup();
        }
        this.nameEnvironment = potentialMatches.length == 1 ? project.getSearchableNameEnvironment() : new JavaSearchNameEnvironment2(project);
        this.options = new CompilerOptions(project.getOptions(true));
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
        this.lookupEnvironment = new LookupEnvironment(this, this.options, problemReporter, this.nameEnvironment);
        this.parser = new MatchLocatorParser(problemReporter, this.options.sourceLevel >= 3);
        this.nameLookup = project.getNameLookup();
        this.totalUnits = 0;
        int maxUnits = potentialMatches.length;
        this.unitsToProcess = new CompilationUnitDeclaration[maxUnits];
        this.matchesToProcess = new PotentialMatch[maxUnits];
    }

    public boolean hasAlreadyDefinedType(CompilationUnitDeclaration parsedUnit) {
        if (parsedUnit == null) {
            return false;
        }
        CompilationResult result = parsedUnit.compilationResult;
        if (result == null) {
            return false;
        }
        int i = 0;
        while (i < result.problemCount) {
            IProblem problem = result.problems[i];
            if (problem.getID() == 16777539) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void locateMatches(JavaProject javaProject) throws JavaModelException {
        PotentialMatch[] potentialMatches = this.potentialMatches.getPotentialMatches(javaProject.getPackageFragmentRoots());
        int length = potentialMatches.length;
        int index = 0;
        while (index < length) {
            int max = Math.min(500, length - index);
            this.locateMatches(javaProject, potentialMatches, index, max);
            index += max;
        }
    }

    private void locateMatches(JavaProject javaProject, PotentialMatch[] potentialMatches, int start, int length) throws JavaModelException {
        PotentialMatch[] copy = new PotentialMatch[length];
        System.arraycopy(potentialMatches, start, copy, 0, length);
        this.initialize(javaProject, copy);
        this.compilationAborted = false;
        try {
            this.createAndResolveBindings(potentialMatches, start, length);
        }
        catch (AbortCompilation e) {
            this.compilationAborted = true;
        }
        try {
            if (!this.compilationAborted && !this.createHierarchyResolver(copy)) {
                this.computeSuperTypeNames();
                if (this.allSuperTypeNames == null) {
                    return;
                }
            }
        }
        catch (AbortCompilation e) {
            this.compilationAborted = true;
        }
        copy = null;
        potentialMatches = null;
        try {
            CompilationUnitDeclaration unit = null;
            int i = 0;
            while (i < this.totalUnits) {
                Object var9_14;
                block19: {
                    if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    unit = this.unitsToProcess[i];
                    try {
                        try {
                            this.process(unit, i);
                        }
                        catch (AbortCompilation e) {
                            this.compilationAborted = true;
                        }
                        catch (CoreException e) {
                            if (e instanceof JavaModelException) {
                                this.compilationAborted = true;
                                break block19;
                            }
                            throw new JavaModelException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        var9_14 = null;
                        unit.cleanUp();
                        if (this.options.verbose) {
                            System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.totalUnits), new String(this.unitsToProcess[i].getFileName())}));
                        }
                        throw throwable;
                    }
                }
                var9_14 = null;
                unit.cleanUp();
                if (this.options.verbose) {
                    System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.totalUnits), new String(this.unitsToProcess[i].getFileName())}));
                }
                this.unitsToProcess[i] = null;
                this.matchesToProcess[i] = null;
                if (this.progressMonitor != null) {
                    this.progressMonitor.worked(5);
                }
                ++i;
            }
        }
        catch (AbortCompilation e) {
            this.compilationAborted = true;
        }
    }

    public void locateMatches(String[] filePaths, IWorkspace workspace, IWorkingCopy[] workingCopies) throws JavaModelException {
        if (SearchEngine.VERBOSE) {
            System.out.println("Locating matches in files [");
            int i = 0;
            int length = filePaths.length;
            while (i < length) {
                String path = filePaths[i];
                System.out.println("\t" + path);
                ++i;
            }
            System.out.println("]");
            if (workingCopies != null) {
                System.out.println("and working copies [");
                i = 0;
                length = workingCopies.length;
                while (i < length) {
                    IWorkingCopy wc = workingCopies[i];
                    System.out.println("\t" + ((JavaElement)((Object)wc)).toStringWithAncestors());
                    ++i;
                }
                System.out.println("]");
            }
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            int wcLength;
            manager.cacheZipFiles();
            if (this.handleFactory == null) {
                this.handleFactory = new HandleFactory(workspace);
            }
            this.workingCopies = workingCopies;
            HashMap<String, IWorkingCopy> wcPaths = new HashMap<String, IWorkingCopy>();
            if (workingCopies != null && (wcLength = workingCopies.length) > 0) {
                String[] newPaths = new String[wcLength];
                int i = 0;
                while (i < wcLength) {
                    IWorkingCopy workingCopy = workingCopies[i];
                    String path = workingCopy.getOriginalElement().getPath().toString();
                    wcPaths.put(path, workingCopy);
                    newPaths[i] = path;
                    ++i;
                }
                int filePathsLength = filePaths.length;
                String[] stringArray = filePaths;
                filePaths = new String[filePathsLength + wcLength];
                System.arraycopy(stringArray, 0, filePaths, 0, filePathsLength);
                System.arraycopy(newPaths, 0, filePaths, filePathsLength, wcLength);
            }
            int length = filePaths.length;
            if (this.progressMonitor != null) {
                if (this.pattern.needsResolve) {
                    this.progressMonitor.beginTask("", length * 10);
                } else {
                    this.progressMonitor.beginTask("", length * 5);
                }
            }
            Util.sort(filePaths);
            this.potentialMatches = new PotentialMatchSet();
            this.pattern.initializePolymorphicSearch(this, this.progressMonitor);
            JavaProject previousJavaProject = null;
            int i = 0;
            while (i < length) {
                block31: {
                    IResource resource;
                    Openable openable;
                    block29: {
                        IWorkingCopy workingCopy;
                        block34: {
                            String pathString;
                            block33: {
                                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                pathString = filePaths[i];
                                if (i > 0 && pathString.equals(filePaths[i - 1])) break block31;
                                workingCopy = (IWorkingCopy)wcPaths.get(pathString);
                                if (workingCopy == null) break block33;
                                openable = (Openable)((Object)workingCopy);
                                break block34;
                            }
                            openable = this.handleFactory.createOpenable(pathString, this.scope);
                            if (openable == null) break block31;
                        }
                        resource = null;
                        JavaProject javaProject = null;
                        try {
                            javaProject = (JavaProject)openable.getJavaProject();
                            resource = workingCopy != null ? workingCopy.getOriginalElement().getResource() : openable.getResource();
                            if (resource == null) {
                                resource = javaProject.getProject();
                            }
                            if (javaProject.equals(previousJavaProject)) break block29;
                            if (previousJavaProject != null) {
                                block30: {
                                    try {
                                        this.locateMatches(previousJavaProject);
                                    }
                                    catch (JavaModelException e) {
                                        if (!(e.getException() instanceof CoreException)) break block30;
                                        throw e;
                                    }
                                }
                                this.potentialMatches = new PotentialMatchSet();
                            }
                            previousJavaProject = javaProject;
                        }
                        catch (JavaModelException e) {
                            break block31;
                        }
                    }
                    this.addPotentialMatch(resource, openable);
                    if (this.progressMonitor != null) {
                        this.progressMonitor.worked(1);
                    }
                }
                ++i;
            }
            if (previousJavaProject != null) {
                block32: {
                    try {
                        this.locateMatches(previousJavaProject);
                    }
                    catch (JavaModelException e) {
                        if (!(e.getException() instanceof CoreException)) break block32;
                        throw e;
                    }
                }
                this.potentialMatches = new PotentialMatchSet();
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
        }
        catch (Throwable throwable) {
            Object var16_26 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
            throw throwable;
        }
        Object var16_27 = null;
        if (this.nameEnvironment != null) {
            this.nameEnvironment.cleanup();
        }
        manager.flushZipFiles();
    }

    public void locatePackageDeclarations(IWorkspace workspace) throws JavaModelException {
        this.locatePackageDeclarations(this.pattern, workspace);
    }

    private void locatePackageDeclarations(SearchPattern searchPattern, IWorkspace workspace) throws JavaModelException {
        if (searchPattern instanceof OrPattern) {
            OrPattern orPattern = (OrPattern)searchPattern;
            this.locatePackageDeclarations(orPattern.leftPattern, workspace);
            this.locatePackageDeclarations(orPattern.rightPattern, workspace);
        } else if (searchPattern instanceof PackageDeclarationPattern) {
            PackageDeclarationPattern pkgPattern = (PackageDeclarationPattern)searchPattern;
            IJavaProject[] projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IJavaProject javaProject = projects[i];
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                int j = 0;
                int rootsLength = roots.length;
                while (j < rootsLength) {
                    IJavaElement[] pkgs = roots[j].getChildren();
                    int k = 0;
                    int pksLength = pkgs.length;
                    while (k < pksLength) {
                        IPackageFragment pkg = (IPackageFragment)pkgs[k];
                        if (pkg.getChildren().length > 0 && pkgPattern.matchesName(pkgPattern.pkgName, pkg.getElementName().toCharArray())) {
                            IResource resource = pkg.getResource();
                            if (resource == null) {
                                resource = javaProject.getProject();
                            }
                            this.currentPotentialMatch = new PotentialMatch(this, resource, null);
                            try {
                                this.report(-1, -2, pkg, 0);
                            }
                            catch (CoreException e) {
                                if (e instanceof JavaModelException) {
                                    throw (JavaModelException)e;
                                }
                                throw new JavaModelException(e);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(CompilationUnitDeclaration unit, int i) throws CoreException {
        block17: {
            block16: {
                block15: {
                    MatchingNodeSet matchingNodeSet = null;
                    try {
                        block14: {
                            try {
                                this.currentPotentialMatch = this.matchesToProcess[i];
                                if (this.currentPotentialMatch == null) {
                                    Object var5_4 = null;
                                    break block14;
                                }
                                matchingNodeSet = this.currentPotentialMatch.matchingNodeSet;
                                if (unit == null || unit.isEmpty()) {
                                    if (this.currentPotentialMatch.openable instanceof ClassFile) {
                                        this.currentPotentialMatch.locateMatchesInClassFile();
                                    }
                                    break block15;
                                }
                                if (this.hasAlreadyDefinedType(unit)) {
                                    break block16;
                                }
                                this.parser.matchSet = this.currentPotentialMatch.matchingNodeSet;
                                this.getMethodBodies(unit, i);
                                matchingNodeSet.cuHasBeenResolved = this.compilationAborted;
                                matchingNodeSet.reportMatching(unit);
                                if ((this.pattern.needsResolve || matchingNodeSet.needsResolve()) && unit.types != null && !this.compilationAborted) {
                                    if (SearchEngine.VERBOSE) {
                                        System.out.println("Resolving " + this.currentPotentialMatch.openable.toStringWithAncestors());
                                    }
                                    if (unit.scope != null) {
                                        unit.scope.faultInTypes();
                                    }
                                    if (unit.scope != null) {
                                        unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                                    }
                                    unit.resolve();
                                    unit.compilationResult.totalUnitsKnown = this.totalUnits;
                                    matchingNodeSet.cuHasBeenResolved = true;
                                    matchingNodeSet.reportMatching(unit);
                                }
                                break block17;
                            }
                            catch (AbortCompilation e) {
                                if (matchingNodeSet != null) {
                                    matchingNodeSet.cuHasBeenResolved = true;
                                    matchingNodeSet.reportMatching(unit);
                                }
                                if (!(e instanceof AbortCompilationUnit)) {
                                    throw e;
                                }
                                break block17;
                            }
                        }
                        this.parser.matchSet = null;
                        this.currentPotentialMatch = null;
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        this.parser.matchSet = null;
                        this.currentPotentialMatch = null;
                        throw throwable;
                    }
                }
                Object var5_5 = null;
                this.parser.matchSet = null;
                this.currentPotentialMatch = null;
                return;
            }
            Object var5_6 = null;
            this.parser.matchSet = null;
            this.currentPotentialMatch = null;
            return;
        }
        Object var5_8 = null;
        this.parser.matchSet = null;
        this.currentPotentialMatch = null;
    }

    public void report(int sourceStart, int sourceEnd, IJavaElement element, int accuracy) throws CoreException {
        if (this.scope.encloses(element)) {
            if (SearchEngine.VERBOSE) {
                IResource res = this.getCurrentResource();
                System.out.println("Reporting match");
                System.out.println("\tResource: " + (res == null ? " <unknown> " : res.getFullPath().toString()));
                System.out.println("\tPositions: [" + sourceStart + ", " + sourceEnd + "]");
                System.out.println("\tJava element: " + ((JavaElement)element).toStringWithAncestors());
                if (accuracy == 0) {
                    System.out.println("\tAccuracy: EXACT_MATCH");
                } else {
                    System.out.println("\tAccuracy: POTENTIAL_MATCH");
                }
            }
            this.report(this.getCurrentResource(), sourceStart, sourceEnd, element, accuracy);
        }
    }

    public void report(IResource resource, int sourceStart, int sourceEnd, IJavaElement element, int accuracy) throws CoreException {
        this.collector.accept(resource, sourceStart, sourceEnd + 1, element, accuracy);
    }

    public void reportAccurateReference(int sourceStart, int sourceEnd, char[][] qualifiedName, IJavaElement element, int accuracy) throws CoreException {
        if (accuracy == -1) {
            return;
        }
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentPotentialMatch.getContents());
        scanner.resetTo(sourceStart, sourceEnd);
        int refSourceStart = -1;
        int refSourceEnd = -1;
        int tokenNumber = qualifiedName.length;
        int token = -1;
        int previousValid = -1;
        int i = 0;
        while (true) {
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (token != 6 && token != 139) continue;
            if (token != 139) {
                char[] currentTokenSource = scanner.getCurrentTokenSource();
                boolean equals = false;
                while (i < tokenNumber && !(equals = this.pattern.matchesName(qualifiedName[i++], currentTokenSource))) {
                }
                if (equals && (previousValid == -1 || previousValid == i - 2)) {
                    previousValid = i - 1;
                    if (refSourceStart == -1) {
                        refSourceStart = currentPosition;
                    }
                    refSourceEnd = scanner.currentPosition - 1;
                } else {
                    i = 0;
                    refSourceStart = -1;
                    previousValid = -1;
                }
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
            }
            if (i == tokenNumber) {
                if (refSourceStart != -1) {
                    this.report(refSourceStart, refSourceEnd, element, accuracy);
                } else {
                    this.report(sourceStart, sourceEnd, element, accuracy);
                }
                return;
            }
            if (token == 139) break;
        }
    }

    public void reportAccurateReference(int sourceStart, int sourceEnd, char[][] tokens, IJavaElement element, int[] accuracies) throws CoreException {
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentPotentialMatch.getContents());
        scanner.resetTo(sourceStart, sourceEnd);
        int refSourceStart = -1;
        int refSourceEnd = -1;
        int length = tokens.length;
        int token = -1;
        int previousValid = -1;
        int i = 0;
        int accuracyIndex = 0;
        do {
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (token != 139) {
                char[] currentTokenSource = scanner.getCurrentTokenSource();
                boolean equals = false;
                while (i < length && !(equals = this.pattern.matchesName(tokens[i++], currentTokenSource))) {
                }
                if (equals && (previousValid == -1 || previousValid == i - 2)) {
                    previousValid = i - 1;
                    if (refSourceStart == -1) {
                        refSourceStart = currentPosition;
                    }
                    refSourceEnd = scanner.currentPosition - 1;
                } else {
                    i = 0;
                    refSourceStart = -1;
                    previousValid = -1;
                }
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
            }
            if (accuracies[accuracyIndex] != -1) {
                if (refSourceStart != -1) {
                    this.report(refSourceStart, refSourceEnd, element, accuracies[accuracyIndex]);
                } else {
                    this.report(sourceStart, sourceEnd, element, accuracies[accuracyIndex]);
                }
                i = 0;
            }
            refSourceStart = -1;
            previousValid = -1;
            if (accuracyIndex >= accuracies.length - 1) continue;
            ++accuracyIndex;
        } while (token != 139);
    }

    public void reportBinaryMatch(IMember binaryMember, IBinaryType info, int accuracy) throws CoreException, JavaModelException {
        this.reportBinaryMatch(null, binaryMember, info, accuracy);
    }

    public void reportBinaryMatch(IResource resource, IMember binaryMember, IBinaryType info, int accuracy) throws CoreException, JavaModelException {
        char[] contents;
        IType type;
        String sourceFileName;
        ClassFile classFile;
        SourceMapper mapper;
        ISourceRange range = binaryMember.getNameRange();
        if (range.getOffset() == -1 && (mapper = (classFile = (ClassFile)binaryMember.getClassFile()).getSourceMapper()) != null && (sourceFileName = mapper.findSourceFileName(type = classFile.getType(), info)) != null && (contents = mapper.findSource(type, sourceFileName)) != null) {
            range = mapper.mapSource(type, contents, binaryMember);
        }
        int startIndex = range.getOffset();
        int endIndex = startIndex + range.getLength() - 1;
        if (resource == null) {
            this.report(startIndex, endIndex, binaryMember, accuracy);
        } else {
            this.report(resource, startIndex, endIndex, binaryMember, accuracy);
        }
    }

    public void reportFieldDeclaration(FieldDeclaration fieldDeclaration, IJavaElement parent, int accuracy) throws CoreException {
        this.report(fieldDeclaration.sourceStart, fieldDeclaration.sourceEnd, parent instanceof IType ? ((IType)parent).getField(new String(fieldDeclaration.name)) : parent, accuracy);
    }

    public void reportImport(ImportReference reference, int accuracy) throws CoreException {
        IJavaElement importHandle = this.createImportHandle(reference);
        this.pattern.matchReportImportRef(reference, null, importHandle, accuracy, this);
    }

    public void reportMethodDeclaration(AbstractMethodDeclaration methodDeclaration, IJavaElement parent, int accuracy) throws CoreException {
        IJavaElement enclosingElement;
        if (parent instanceof IType) {
            enclosingElement = this.createMethodHandle(methodDeclaration, (IType)parent);
            if (enclosingElement == null) {
                return;
            }
        } else {
            enclosingElement = parent;
        }
        Scanner scanner = this.parser.scanner;
        int nameSourceStart = methodDeclaration.sourceStart;
        scanner.setSource(this.currentPotentialMatch.getContents());
        scanner.resetTo(nameSourceStart, methodDeclaration.sourceEnd);
        try {
            scanner.getNextToken();
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        int nameSourceEnd = scanner.currentPosition - 1;
        this.report(nameSourceStart, nameSourceEnd, enclosingElement, accuracy);
    }

    public void reportPackageDeclaration(ImportReference node) {
    }

    public void reportReference(AstNode reference, AbstractMethodDeclaration methodDeclaration, IJavaElement parent, int accuracy) throws CoreException {
        IJavaElement enclosingElement;
        if (parent instanceof IType) {
            enclosingElement = this.createMethodHandle(methodDeclaration, (IType)parent);
            if (enclosingElement == null) {
                return;
            }
        } else {
            enclosingElement = parent;
        }
        this.pattern.matchReportReference(reference, enclosingElement, accuracy, this);
    }

    public void reportReference(AstNode reference, TypeDeclaration typeDeclaration, FieldDeclaration fieldDeclaration, IJavaElement parent, int accuracy) throws CoreException {
        if (fieldDeclaration.isField()) {
            IJavaElement enclosingElement;
            if (parent instanceof IType) {
                enclosingElement = this.createFieldHandle(fieldDeclaration, (IType)parent);
                if (enclosingElement == null) {
                    return;
                }
            } else {
                enclosingElement = parent;
            }
            this.pattern.matchReportReference(reference, enclosingElement, accuracy, this);
        } else {
            IJavaElement enclosingElement;
            if (parent instanceof IType) {
                enclosingElement = this.createInitializerHandle(typeDeclaration, fieldDeclaration, (IType)parent);
                if (enclosingElement == null) {
                    return;
                }
            } else {
                enclosingElement = parent;
            }
            this.pattern.matchReportReference(reference, enclosingElement, accuracy, this);
        }
    }

    public void reportSuperTypeReference(TypeReference typeRef, IJavaElement type, int accuracy) throws CoreException {
        this.pattern.matchReportReference(typeRef, type, accuracy, this);
    }

    public void reportTypeDeclaration(TypeDeclaration typeDeclaration, IJavaElement parent, int accuracy) throws CoreException {
        this.report(typeDeclaration.sourceStart, typeDeclaration.sourceEnd, parent == null ? this.createTypeHandle(typeDeclaration.name) : (parent instanceof IType ? this.createTypeHandle((IType)parent, typeDeclaration.name) : parent), accuracy);
    }

    public boolean typeInHierarchy(ReferenceBinding binding) {
        if (this.hierarchyResolver == null) {
            return true;
        }
        if (this.hierarchyResolver.subOrSuperOfFocus(binding)) {
            return true;
        }
        if (this.allSuperTypeNames != null) {
            char[][] compoundName = binding.compoundName;
            int i = 0;
            int length = this.allSuperTypeNames.length;
            while (i < length) {
                if (CharOperation.equals(compoundName, this.allSuperTypeNames[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }
}

