/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IGenericType;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.RegionBasedTypeHierarchy;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;

public class RegionBasedHierarchyBuilder
extends HierarchyBuilder {
    public RegionBasedHierarchyBuilder(TypeHierarchy hierarchy) throws JavaModelException {
        super(hierarchy);
    }

    public void build(boolean computeSubtypes) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles();
            if (this.hierarchy.type == null || computeSubtypes) {
                SubProgressMonitor typeInRegionMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 30);
                ArrayList allTypesInRegion = this.determineTypesInRegion(typeInRegionMonitor);
                this.hierarchy.initialize(allTypesInRegion.size());
                SubProgressMonitor buildMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 70);
                this.createTypeHierarchyBasedOnRegion(allTypesInRegion, buildMonitor);
                ((RegionBasedTypeHierarchy)this.hierarchy).pruneDeadBranches();
            } else {
                this.hierarchy.initialize(1);
                this.buildSupertypes();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            manager.flushZipFiles();
            throw throwable;
        }
        Object var6_8 = null;
        manager.flushZipFiles();
    }

    private void createTypeHierarchyBasedOnRegion(ArrayList allTypesInRegion, IProgressMonitor monitor) {
        block20: {
            block19: {
                ICompilationUnit[] compilationUnits;
                IGenericType[] genericTypes;
                int size = allTypesInRegion.size();
                if (size != 0) {
                    this.infoToHandle = new HashMap(size);
                }
                Object[] types = new IType[size];
                allTypesInRegion.toArray(types);
                Util.sort(types, new Util.Comparer(){

                    public int compare(Object a, Object b) {
                        return -((IJavaElement)a).getParent().getElementName().compareTo(((IJavaElement)b).getParent().getElementName());
                    }
                });
                ArrayList infos = new ArrayList();
                ArrayList units = new ArrayList();
                int i = 0;
                while (i < size) {
                    try {
                        Object type = types[i];
                        this.addInfoFromElement((Openable)type.getOpenable(), infos, units, type.getPath().toString());
                    }
                    catch (JavaModelException type) {
                        // empty catch block
                    }
                    ++i;
                }
                int infosSize = infos.size();
                if (infosSize > 0) {
                    genericTypes = new IGenericType[infosSize];
                    infos.toArray(genericTypes);
                } else {
                    genericTypes = new IGenericType[]{};
                }
                int unitsSize = units.size();
                if (unitsSize > 0) {
                    compilationUnits = new ICompilationUnit[unitsSize];
                    units.toArray(compilationUnits);
                } else {
                    compilationUnits = new ICompilationUnit[]{};
                }
                try {
                    if (monitor != null) {
                        monitor.beginTask("", (infosSize + unitsSize) * 2);
                    }
                    if (infosSize <= 0 && unitsSize <= 0) break block19;
                    IType focusType = this.getType();
                    CompilationUnit unitToLookInside = null;
                    if (focusType != null) {
                        unitToLookInside = (CompilationUnit)focusType.getCompilationUnit();
                    }
                    if (this.nameLookup != null && unitToLookInside != null) {
                        NameLookup nameLookup = this.nameLookup;
                        synchronized (nameLookup) {
                            try {
                                this.nameLookup.setUnitsToLookInside(new IWorkingCopy[]{unitToLookInside});
                                this.hierarchyResolver.resolve(genericTypes, compilationUnits, monitor);
                            }
                            catch (Throwable throwable) {
                                Object var14_18 = null;
                                this.nameLookup.setUnitsToLookInside(null);
                                throw throwable;
                            }
                            Object var14_19 = null;
                            this.nameLookup.setUnitsToLookInside(null);
                            break block19;
                        }
                    }
                    this.hierarchyResolver.resolve(genericTypes, compilationUnits, monitor);
                }
                catch (Throwable throwable) {
                    Object var16_21 = null;
                    if (monitor != null) {
                        monitor.done();
                    }
                    throw throwable;
                }
            }
            Object var16_22 = null;
            if (monitor == null) break block20;
            monitor.done();
        }
    }

    private ArrayList determineTypesInRegion(IProgressMonitor monitor) {
        try {
            ArrayList<IJavaElement> types = new ArrayList<IJavaElement>();
            IJavaElement[] roots = ((RegionBasedTypeHierarchy)this.hierarchy).fRegion.getElements();
            int length = roots.length;
            if (monitor != null) {
                monitor.beginTask("", length);
            }
            int i = 0;
            while (i < length) {
                try {
                    IJavaElement root = roots[i];
                    switch (root.getElementType()) {
                        case 2: {
                            this.injectAllTypesForJavaProject((IJavaProject)root, types);
                            break;
                        }
                        case 3: {
                            this.injectAllTypesForPackageFragmentRoot((IPackageFragmentRoot)root, types);
                            break;
                        }
                        case 4: {
                            this.injectAllTypesForPackageFragment((IPackageFragment)root, types);
                            break;
                        }
                        case 6: {
                            types.add(((IClassFile)root).getType());
                            break;
                        }
                        case 5: {
                            IType[] cuTypes = ((org.eclipse.jdt.core.ICompilationUnit)root).getAllTypes();
                            int j = 0;
                            while (j < cuTypes.length) {
                                types.add(cuTypes[j]);
                                ++j;
                            }
                            break;
                        }
                        case 7: {
                            types.add(root);
                            break;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                this.worked(monitor, 1);
                ++i;
            }
            ArrayList<IJavaElement> arrayList = types;
            Object var9_11 = null;
            if (monitor != null) {
                monitor.done();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            block17: {
                Object var9_12 = null;
                if (monitor == null) break block17;
                monitor.done();
            }
            throw throwable;
        }
    }

    private void injectAllTypesForJavaProject(IJavaProject project, ArrayList types) {
        try {
            IPackageFragmentRoot[] devPathRoots = ((JavaProject)project).getPackageFragmentRoots();
            if (devPathRoots == null) {
                return;
            }
            int j = 0;
            while (j < devPathRoots.length) {
                IPackageFragmentRoot root = devPathRoots[j];
                this.injectAllTypesForPackageFragmentRoot(root, types);
                ++j;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void injectAllTypesForPackageFragment(IPackageFragment packFrag, ArrayList types) {
        try {
            IPackageFragmentRoot root = (IPackageFragmentRoot)packFrag.getParent();
            int kind = root.getKind();
            if (kind != 0) {
                boolean isSourcePackageFragment;
                boolean bl = isSourcePackageFragment = kind == 1;
                if (isSourcePackageFragment) {
                    org.eclipse.jdt.core.ICompilationUnit[] typeContainers = packFrag.getCompilationUnits();
                    this.injectAllTypesForTypeContainers(typeContainers, types);
                } else {
                    IClassFile[] typeContainers = packFrag.getClassFiles();
                    this.injectAllTypesForTypeContainers(typeContainers, types);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void injectAllTypesForPackageFragmentRoot(IPackageFragmentRoot root, ArrayList types) {
        try {
            IJavaElement[] packFrags = root.getChildren();
            int k = 0;
            while (k < packFrags.length) {
                IPackageFragment packFrag = (IPackageFragment)packFrags[k];
                this.injectAllTypesForPackageFragment(packFrag, types);
                ++k;
            }
        }
        catch (JavaModelException e) {
            return;
        }
    }

    private void injectAllTypesForTypeContainers(IClassFile[] containers, ArrayList types) {
        try {
            int i = 0;
            while (i < containers.length) {
                IClassFile cf = containers[i];
                types.add(cf.getType());
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void injectAllTypesForTypeContainers(org.eclipse.jdt.core.ICompilationUnit[] containers, ArrayList types) {
        try {
            int i = 0;
            while (i < containers.length) {
                org.eclipse.jdt.core.ICompilationUnit cu = containers[i];
                IType[] cuTypes = cu.getAllTypes();
                int j = 0;
                while (j < cuTypes.length) {
                    types.add(cuTypes[j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }
}

